﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GraphicModule.UserControls
{

    public partial class ctablePatient : UserControl
    {
        public DatabaseModule.DatabaseModuleClass DatabaseUnit = new DatabaseModule.DatabaseModuleClass(); // empty connection

        static CLASS_COLS_ID COLS_ALL = new CLASS_COLS_ID();
        static CLASS_COLS_ID COLS_DELETED = new CLASS_COLS_ID();
        static CLASS_COLS_ID COLS_VISIBLE = new CLASS_COLS_ID();

        Boolean gridUpdate = false;

        public int actual_P_ID = -1;

        public CommonBridge.Patient actual_patient = null;

        public List<CommonBridge.Patient> patlist;

        Int32 cnt_all = 0;
        Int32 cnt_visible = 0;
        Int32 cnt_delete = 0;
        
        public ctablePatient()
        {
            InitializeComponent();
        }


        public void Init()
        {             
            actual_P_ID = -1;
            actual_patient = null;

            GUI_CreateHeader_All(); 
        }


        /// <summary>
        /// 
        /// </summary>
        public void GUI_CreateHeader_All()
        {
            DataGridView dg = datagridAll;
            CLASS_COLS_ID ID = COLS_ALL;
            dg.Rows.Clear();

            int cols = 10;
            dg.ColumnCount = cols;

            int j = 0;

            ID.id_id = j++;

            dg.Columns[ID.id_id].Name = "#A";
            dg.Columns[ID.id_id].Width = 20;

            ID.id_pid = j++;
            dg.Columns[ID.id_pid].Name = "PID";
            dg.Columns[ID.id_pid].Width = 30;

            ID.id_pin = j++;
            dg.Columns[ID.id_pin].Name = "PIN";
            dg.Columns[ID.id_pin].Width = 100;

            ID.id_name = j++;
            dg.Columns[ID.id_name].Name = "Name";
            dg.Columns[ID.id_name].Width = 100;

            ID.id_surname = j++;
            dg.Columns[ID.id_surname].Name = "Surname";
            dg.Columns[ID.id_surname].Width = 100;

            ID.id_register = j++;
            dg.Columns[ID.id_register].Name = "Register";
            dg.Columns[ID.id_register].Width = 120;

            /*
            id_update = j++;
            datagrid.Columns[id_update].Name = "Update";
            datagrid.Columns[id_update].Width = 120;
            */

            ID.id_count = j++;
            dg.Columns[ID.id_count].Name = "Exams.";
            dg.Columns[ID.id_count].Width = 50;

            ID.id_state = j++;
            dg.Columns[ID.id_state].Name = "State";
            dg.Columns[ID.id_state].Width = 50;

            ID.id_comment = j++;
            dg.Columns[ID.id_comment].Name = "Comment";
            dg.Columns[ID.id_comment].Width = 100;

            cols = j;
            dg.ColumnCount = cols;
        }
        
        /// <summary>
        /// 
        /// </summary>
        public void GUI_CreateHeader_Visible()
        {
            DataGridView dg = datagridAll;
            CLASS_COLS_ID ID = COLS_VISIBLE;
            dg.Rows.Clear();

            int cols = 10;
            dg.ColumnCount = cols;

            int j = 0;

            ID.id_id = j++;

            dg.Columns[ID.id_id].Name = "#V";
            dg.Columns[ID.id_id].Width = 20;

            ID.id_pid = j++;
            dg.Columns[ID.id_pid].Name = "PID";
            dg.Columns[ID.id_pid].Width = 30;

            ID.id_pin = j++;
            dg.Columns[ID.id_pin].Name = "PIN";
            dg.Columns[ID.id_pin].Width = 100;

            ID.id_name = j++;
            dg.Columns[ID.id_name].Name = "Name";
            dg.Columns[ID.id_name].Width = 100;

            ID.id_surname = j++;
            dg.Columns[ID.id_surname].Name = "Surname";
            dg.Columns[ID.id_surname].Width = 100;

            ID.id_register = j++;
            dg.Columns[ID.id_register].Name = "Register";
            dg.Columns[ID.id_register].Width = 120;

            /*
            id_update = j++;
            datagrid.Columns[id_update].Name = "Update";
            datagrid.Columns[id_update].Width = 120;
            */

            ID.id_count = j++;
            dg.Columns[ID.id_count].Name = "Exams.";
            dg.Columns[ID.id_count].Width = 50;

            ID.id_state = j++;
            dg.Columns[ID.id_state].Name = "State";
            dg.Columns[ID.id_state].Width = 50;

            ID.id_comment = j++;
            dg.Columns[ID.id_comment].Name = "Comment";
            dg.Columns[ID.id_comment].Width = 100;

            cols = j;
            dg.ColumnCount = cols;
        }


        /// <summary>
        /// 
        /// </summary>
        public void GUI_Show_All()
        {
            // create header
            GUI_CreateHeader_All();

            
            if (patlist != null && patlist.Count > 0)
            {
                gridUpdate = true;
                // for every patient in lit
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    // and show item
                    GUI_ShowOne_All(item, i);
                }
                gridUpdate = false;
            }

            if (patlist != null)
            {
                labCount.Text = String.Format("({0} pacientů)", patlist.Count);
            }
            else
            {
                labCount.Text = String.Format("(N/A pacientů)");
            }
            actual_P_ID = -1;

            // and selected row
            //GUI_SelectedActualPatient();

            FindActualPatient(actual_P_ID);
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="item"></param>
        /// <param name="ID_ID"></param>
        public void GUI_ShowOne_All(CommonBridge.Patient item, int ID_ID)
        {
            // check if item exist
            if (item != null)
            {
                DataGridView dg = datagridAll;
                CLASS_COLS_ID ID = COLS_ALL;
                
                // count columns of table
                int cols = dg.ColumnCount;

                // create row string
                string[] row = new string[cols];

                // fill row string 
                if (ID.id_id > -1) row[ID.id_id] = ID_ID.ToString();
                if (ID.id_pid > -1) row[ID.id_pid] = item.P_ID.ToString();
                if (ID.id_pin > -1) row[ID.id_pin] = item.PIN;
                if (ID.id_name > -1) row[ID.id_name] = item.name;
                if (ID.id_surname > -1) row[ID.id_surname] = item.surname;
                if (ID.id_register > -1) row[ID.id_register] = item.time_insert.ToString();
                if (ID.id_update > -1) row[ID.id_update] = item.time_update.ToString();
                if (ID.id_state > -1) row[ID.id_state] = item.state.ToString();

                if (ID.id_count > -1) row[ID.id_count] = item.count_exams.ToString();

                if (ID.id_comment > -1 && item.comment != null)
                {
                    if (item.comment.Length > 10)
                        row[ID.id_comment] = item.comment.Substring(0, 10) + "...";
                    else
                        row[ID.id_comment] = item.comment;
                }

                // insert row
                int row_index = dg.Rows.Add(row);
                dg.Rows[row_index].Tag = (Object)item.P_ID;

                if (ID.id_comment > -1) dg.Rows[row_index].Cells[ID.id_comment].ToolTipText = item.comment;//item.comment.Replace("\n", Environment.NewLine);

            }
        }

        /// <summary>
        /// 
        /// </summary>
        public void GUI_Show_Visible()
        {
            // create header
            GUI_CreateHeader_Visible(); 

            if (patlist != null && patlist.Count > 0)
            {
                gridUpdate = true;
                // for every patient in lit
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    if (item.state == 0) 
                    {            
                        // and show item
                        GUI_ShowOne_All(item, i);
                    }
                }
                gridUpdate = false;
            }

            if (patlist != null)
            {
                labCount.Text = String.Format("({0} pacientů)", patlist.Count);
            }
            else
            {
                labCount.Text = String.Format("(N/A pacientů)");
            }
            actual_P_ID = -1;

            // and selected row
            //GUI_SelectedActualPatient();

            FindActualPatient(actual_P_ID);
        }


        /// <summary>
        /// 
        /// </summary>
        public void GUI_Show_Deleted()
        {
            // create header
            GUI_CreateHeader_Visible();

            if (patlist != null && patlist.Count > 0)
            {
                gridUpdate = true;
                // for every patient in lit
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    if (item.state != 0)
                    {
                        // and show item
                        GUI_ShowOne_All(item, i);
                    }
                }
                gridUpdate = false;
            }

            if (patlist != null)
            {
                labCount.Text = String.Format("({0} pacientů)", patlist.Count);
            }
            else
            {
                labCount.Text = String.Format("(N/A pacientů)");
            }
            actual_P_ID = -1;

            // and selected row
            //GUI_SelectedActualPatient();

            FindActualPatient(actual_P_ID);
        }

        public void GUI_ActualizeCounters() 
        {
            cnt_all = 0;
            cnt_delete = 0;
            cnt_visible = 0;

            if (patlist != null && patlist.Count > 0)
            {  
                // for every patient in lit
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];
                    if (item != null) 
                    {  
                        cnt_all++;
                        if (item.state == 0) 
                        {
                            cnt_visible++;
                        }
                        else
                        {
                            cnt_delete++;
                        }
                    }
                }
                gridUpdate = false;
            }

            rbAll.Text = "show all (" + cnt_all.ToString() + ")";
            rbVisible.Text = "show visible (" +cnt_visible.ToString() +")";
            rbVisible.Location = new Point(rbAll.Location.X + rbAll.Width + 10, rbAll.Location.Y);

            rbDeleted.Text = "show delete (" + cnt_delete.ToString() + ")";
            rbDeleted.Location = new Point(rbVisible.Location.X + rbVisible.Width + 10, rbAll.Location.Y);

            if (patlist != null)
            {
                labCount.Text = String.Format("({0} pacientů)", cnt_all);
            }
            else
            {
                labCount.Text = String.Format("(N/A pacientů)");
            }
        }

        public void GUI_Repaint() 
        {
            GUI_ActualizeCounters();

            if (rbAll.Checked == true) 
            {
                GUI_Show_All();
            }
            else if (rbVisible.Checked == true)
            {
                GUI_Show_Visible();
            }
            else if (rbDeleted.Checked == true)
            {
                GUI_Show_Deleted();
            }
        }


        public void RegisterData(List<CommonBridge.Patient> data) 
        {
            patlist = data;
            GUI_ActualizeCounters();
        }

        private void btnAddNewExam_Click(object sender, EventArgs e)
        {

        }

        private void datagridAll_CellMouseDown(object sender, DataGridViewCellMouseEventArgs e)
        {

        }

        private void datagridAll_SelectionChanged(object sender, EventArgs e)
        {
            DataGridView dg = datagridAll;
            if (dg.SelectedRows != null && dg.SelectedRows.Count > 0)
            {
                DataGridViewRow selected_row = dg.SelectedRows[0];
                if (selected_row.Index >= 0 && selected_row.Index < dg.Rows.Count)
                {
                    try
                    {
                        if (selected_row.Tag == null) return;
                        int new_actual_P_ID = System.Convert.ToInt32(selected_row.Tag);


                        // change P_ID?
                        if (new_actual_P_ID != actual_P_ID)
                        {
                            actual_P_ID = new_actual_P_ID;
                            FindActualPatient(actual_P_ID);
                        }

                    }
                    catch
                    {
                        actual_P_ID = -1;
                    }
                    labID.Text = actual_P_ID.ToString();
                }
                else
                {
                    int b;
                }
            }
        }

        public CommonBridge.Patient FindActualPatient(Int32 selected_P_ID)
        {
            CommonBridge.Patient selected_patient = null;
            bool tf = false;
            if (selected_P_ID > -1 && patlist != null)
            {
                // find actual patient in list
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    if (selected_P_ID == item.P_ID)
                    {
                        selected_patient = item;
                        tf = true;
                        break;
                    }
                }
            }

            return selected_patient;
        }

        private void datagridAll_MouseDown(object sender, MouseEventArgs e)
        {
            // mousedown
            var hti = datagridAll.HitTest(e.X, e.Y);
            //datagrid.ClearSelection();
            if (hti.RowIndex >= 0 && hti.RowIndex < datagridAll.Rows.Count)
            {
                datagridAll.Rows[hti.RowIndex].Selected = true;
                datagridAll.ContextMenuStrip = contextAll;
            }
            else
            {
                datagridAll.ContextMenuStrip = null; 
            }
        }

        private void rbAll_CheckedChanged(object sender, EventArgs e)
        {
            GUI_Show_All();
        }

        private void rbVisible_CheckedChanged(object sender, EventArgs e)
        {
            GUI_Show_Visible();
        }

        private void rbDeleted_CheckedChanged(object sender, EventArgs e)
        {
            GUI_Show_Deleted();
        }

        private void contextAll_Opening(object sender, CancelEventArgs e)
        {

        }


    }

    internal class CLASS_COLS_ID
    {
        public int id_id = -1;
        public int id_pid = -1;
        public int id_pin = -1;
        public int id_name = -1;
        public int id_surname = -1;
        public int id_register = -1;
        public int id_update = -1;
        public int id_count = -1;
        public int id_state = -1;
        public int id_comment = -1;
    }
}
