﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GraphicModule
{
    public partial class ControlExaminationTable : UserControl
    {

        public DatabaseModule.DatabaseModuleClass DatabaseUnit = new DatabaseModule.DatabaseModuleClass(); // empty connection

        int eid_id;
        int eid_pid;
        int eid_eid;
        int eid_date;
        int eid_slide;
        int eid_count;
        int eid_color1;
        int eid_color2;
        int eid_color3;
        int eid_result;
        int eid_comment;
        int eid_state;

        int eid_surname;

        public int actual_P_ID = -1;
        public int actual_E_ID = -1;

        //public CommonBridge.Patient actual_patient = null;
        public CommonBridge.Examination actual_examination = null;

        public List<CommonBridge.Patient> patlist;
        public List<CommonBridge.Examination> examlist; 
        
        // EXAMINATION
        public delegate void ExaminationSelected_CallbackHandle(Int32 selected_E_ID);
        public event ExaminationSelected_CallbackHandle ExaminationSelected_Callback = null;

        public delegate void ExaminationSelectedEdit_CallbackHandle(Int32 selected_E_ID);
        public event ExaminationSelectedEdit_CallbackHandle ExaminationSelectedEdit_Callback = null;

        public delegate void ExaminationAddNew_CallbackHandle(Int32 selected_P_ID);
        public event ExaminationAddNew_CallbackHandle ExaminationAddNew_Callback = null;


        public ControlExaminationTable()
        {
            InitializeComponent();

            actual_E_ID = -1;
            GUI_CreateExaminationHeader(); 
        }

        public void GUI_CreateExaminationHeader()
        {
            datagridex.Rows.Clear();

            int cols = 15;
            datagridex.ColumnCount = cols;

            int j = 0;

            eid_id = j++;
            datagridex.Columns[eid_id].Name = "#";
            datagridex.Columns[eid_id].Width = 20;

            eid_eid = j++;
            datagridex.Columns[eid_eid].Name = "EID";
            datagridex.Columns[eid_eid].Width = 30;

            eid_pid = j++;
            datagridex.Columns[eid_pid].Name = "PID";
            datagridex.Columns[eid_pid].Width = 30;

            eid_surname = j++;
            datagridex.Columns[eid_surname].Name = "Surname";
            datagridex.Columns[eid_surname].Width = 100;

            eid_date = j++;
            datagridex.Columns[eid_date].Name = "Date";
            datagridex.Columns[eid_date].Width = 120;

            eid_slide = j++;
            datagridex.Columns[eid_slide].Name = "Slide";
            datagridex.Columns[eid_slide].Width = 100;
             
            eid_color3 = j++;
            datagridex.Columns[eid_color3].Name = "ColorB";
            datagridex.Columns[eid_color3].Width = 50;

            eid_color2 = j++;
            datagridex.Columns[eid_color2].Name = "ColorG";
            datagridex.Columns[eid_color2].Width = 50;

            eid_color1 = j++;
            datagridex.Columns[eid_color1].Name = "ColorR";
            datagridex.Columns[eid_color1].Width = 50;
          

            eid_count = j++;
            datagridex.Columns[eid_count].Name = "Images";
            datagridex.Columns[eid_count].Width = 50;

            eid_result = j++;
            datagridex.Columns[eid_result].Name = "ResultID";
            datagridex.Columns[eid_result].Width = 50;

            eid_state = j++;
            datagridex.Columns[eid_state].Name = "State";
            datagridex.Columns[eid_state].Width = 50;

            eid_comment = j++;
            datagridex.Columns[eid_comment].Name = "Comment";
            datagridex.Columns[eid_comment].Width = 100;

            cols = j;
            datagridex.ColumnCount = cols;
        }


         private void OnExaminationSelected()
        {

            if (ExaminationSelected_Callback != null)
            {
                ExaminationSelected_Callback(actual_E_ID);
            }
        }
         public void GUI_ShowAllExamination()
         {
             GUI_ShowAllExamination(0);
         }

        public void GUI_ShowAllExamination(Int32 P_ID)
        {
            actual_P_ID = P_ID;

            // create header
            GUI_CreateExaminationHeader();

            // Get list of all examination                                                                          
            examlist = DatabaseUnit.GetExaminationList(DatabaseUnit.GetTableViewName_Examination(), 0, P_ID, "E_ID");
            patlist = DatabaseUnit.GetPatientList(DatabaseUnit.GetTableViewName_Patient(), 0, "P_ID");

            if (examlist != null && examlist.Count > 0)
            {
                // for every examination in list
                for (int i = 0; i < examlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Examination item = examlist[i]; 

                    // and show item
                    GUI_ShowOneExamination(item, i);
                }
            }

            if (examlist != null)
            {
                //String format = TranslateUnit.i18n("");
                labCountExam.Text = String.Format("({0} vyšetření)", examlist.Count);
            }
            else
            {
                //String format = TranslateUnit.i18n("");
                labCountExam.Text = String.Format("(N/A vyšetření)");
            }


            // and selected row
            GUI_SelectedActualExamination();

            FindActualExamination();
        }

        public void GUI_ShowOneExamination(CommonBridge.Examination item, Int32 ID_ID)
        {
            // check if item exist
            if (item != null)
            {
                // count columns of table
                int cols = datagridex.ColumnCount;

                // create row string
                string[] row = new string[cols];                   

                // fill row string 
                row[eid_id] = ID_ID.ToString();
                row[eid_eid] = item.E_ID.ToString();
                row[eid_pid] = item.P_ID.ToString();
                row[eid_slide] = item.slide;
                row[eid_color1] = item.fluorophore1_key;
                row[eid_color2] = item.fluorophore2_key;
                row[eid_color3] = item.fluorophore3_key;
                row[eid_result] = item.result.ToString();
                row[eid_state] = item.state.ToString();
                row[eid_count] = item.count_images.ToString();
                row[eid_date] = item.time_insert.ToString();

                if (item.comment != null)
                    if (item.comment.Length > 10)
                        row[eid_comment] = item.comment.Substring(0, 10) + "...";
                    else
                        row[eid_comment] = item.comment;
                else
                    row[eid_comment] = "-";

                // get patient info
                CommonBridge.Patient one_patient = FindActualPatient(item.P_ID);
                if (one_patient != null) 
                {
                    row[eid_surname] = one_patient.surname + " " + one_patient.name;
                }

                // insert row
                int row_index = datagridex.Rows.Add(row);
                datagridex.Rows[row_index].Tag = (Object)item.E_ID;
                datagridex.Rows[row_index].Cells[eid_comment].ToolTipText = item.comment;//item.comment.Replace("\n", Environment.NewLine);
            }
        }

        public void GUI_SelectedActualExamination()
        {
            datagridex.ClearSelection();

            if (actual_E_ID > -1)
            {

                try
                {
                    // find in rows E_ID
                    foreach (DataGridViewRow row in datagridex.Rows)
                    {
                        // compare E_ID with actual_E_ID
                        if (Convert.ToInt32(row.Tag) == actual_E_ID)
                        {
                            row.Selected = true;
                            break;
                        }
                    }
                }
                catch
                {
                    //
                }
            }
        }

        public bool FindActualExamination()
        {
            bool tf = false;
            actual_examination = null;
            if (actual_E_ID > -1 && examlist != null)
            {
                // find actual exam in list
                for (int i = 0; i < examlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Examination item = examlist[i];

                    if (actual_E_ID == item.E_ID)
                    {
                        actual_examination = item;
                        tf = true;
                    }
                }
            }

            if (actual_examination != null) label6.Text = actual_examination.slide + "-->" + actual_examination.count_images.ToString();
            else label6.Text = "ouuu";

            return tf;
        }


        public CommonBridge.Patient FindActualPatient(Int32 selected_P_ID)
        {
            CommonBridge.Patient selected_patient = null;
            bool tf = false; 
            if (selected_P_ID > -1 && patlist != null)
            {
                // find actual patient in list
                for (int i = 0; i < patlist.Count; i++)
                {
                    // get one patient
                    CommonBridge.Patient item = patlist[i];

                    if (selected_P_ID == item.P_ID)
                    {
                        selected_patient = item;
                        tf = true;
                        break;
                    }
                }
            }

            return selected_patient;
        }

        private void datagridex_MouseDown(object sender, MouseEventArgs e)
        {
            // mousedown
            var hti = datagridex.HitTest(e.X, e.Y);
            //datagrid.ClearSelection();
            if (hti.RowIndex >= 0 && hti.RowIndex < datagridex.Rows.Count)
            {
                datagridex.Rows[hti.RowIndex].Selected = true;
            }  
        }



        private void selectToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (actual_E_ID > -1) 
            {
                if (ExaminationSelected_Callback != null)
                {
                    ExaminationSelected_Callback(actual_E_ID);
                }
            }             
        }

        private void editToolStripMenuItem_Click(object sender, EventArgs e)
        {
            if (actual_E_ID > -1)
            {
                if (ExaminationSelectedEdit_Callback != null)
                {
                    ExaminationSelectedEdit_Callback(actual_E_ID);
                }
            } 
        }

        private void btnNewExamination_Click(object sender, EventArgs e)
        {

        }

        private void btnLoadAllExamination_Click(object sender, EventArgs e)
        {
            GUI_ShowAllExamination();
        }

        private void btnEditExamination_Click(object sender, EventArgs e)
        {
            if (actual_E_ID > -1)
            {
                if (ExaminationSelectedEdit_Callback != null)
                {
                    ExaminationSelectedEdit_Callback(actual_E_ID);
                }
            }
        }

        private void datagridex_DoubleClick(object sender, EventArgs e)
        {
            if (datagridex.SelectedRows.Count > 0)
            {
                OnExaminationSelected();
            } 
        }

        private void exdeleteToolStripMenuItem_Click(object sender, EventArgs e)
        {
            //CommonBridge.Patient item = DatabaseUnit.GetOnePatient(P_ID);

            if (actual_examination != null)
            {
                // set valid = 1 ... deleted
                actual_examination.state = 1;
                int items = DatabaseUnit.UpdateOne(actual_examination);

                // if successfuly forget selected patient
                if (items > 0)
                {
                    actual_E_ID = -1;    
                    GUI_ShowAllExamination(); 
                }
            }
        }

        private void datagridex_RowEnter(object sender, DataGridViewCellEventArgs e)
        {


        }

        private void datagridex_SelectionChanged(object sender, EventArgs e)
        {
            if (datagridex.SelectedRows != null && datagridex.SelectedRows.Count > 0)
            {
                DataGridViewRow selected_row = datagridex.SelectedRows[0];
                if (selected_row.Index >= 0 && selected_row.Index < datagridex.Rows.Count)
                {
                    try
                    {
                        if (selected_row.Tag == null) return;
                        int new_actual_E_ID = System.Convert.ToInt32(selected_row.Tag);


                        labEID.Text = new_actual_E_ID.ToString();

                        // change P_ID?
                        if (new_actual_E_ID != actual_E_ID)
                        {
                            actual_E_ID = new_actual_E_ID;
                            FindActualExamination();
                        }

                    }
                    catch
                    {
                        actual_E_ID = -1;
                    }
                    labEID.Text = actual_E_ID.ToString();
                }
                else
                {
                    int b;
                }
            }
        }

        private void btnAddNewExam_Click(object sender, EventArgs e)
        {
            if (actual_P_ID > -1)
            {
                if (ExaminationAddNew_Callback != null)
                {
                    ExaminationAddNew_Callback(actual_P_ID);
                }
            }
        }    
    }
}
