﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GraphicModule
{    
    public partial class Slider : UserControl
    {
        private String name = "ValueName"; /* The name of the node. */

        private int _value_max = 1000000;
        private int _value_min = 10000;
        private int _value_inc = 1;
        private int _value = 1;

        public delegate void CallbackHandler_SliderChange();
        public CallbackHandler_SliderChange Callback_SliderChange = null;

        public Slider()
        {
            InitializeComponent();
            Reset();
        }
        [Description("Maximal value of slider.")]
        public int ValueMax
        {
            get { return _value_max; }
            set { _value_max = value;  }
        }

        [Description("Minimal value of slider.")]
        public int ValueMin
        {
            get { return _value_min; }
            set { _value_min = value;  }
        }

        [Description("Incremental step of slider.")]
        public int ValueIncrement
        {
            get { return _value_inc; }
            set { _value_inc = value;  }
        }

        [Description("Actual value of slider.")]
        public int ValueActual
        {
            get { return _value; }
            set { _value = value; UpdateValues(); }
        }


        [Description("The name.")]
        public string NodeName
        {
            get { return name; }
            set  { name = value; UpdateValues();  }
        }

        /* Deactivate the control and deregister the callback. */
        private void Reset()
        {
            tbSlider.Enabled = false;
            lblSliderName.Enabled = false;
            lblSliderMinMax.Enabled = false;
            lblSliderValue.Enabled = false;
        }

        /* Get the current values from the node and display them. */
        public void UpdateValues()
        {

            int min = _value_min /*checked((int)GenApi.FloatGetMin(m_hNode))*/;
            int max = _value_max /*checked((int)GenApi.FloatGetMax(m_hNode))*/;
            int val = _value;
            int inc = _value_inc;

            /* check limits */
            if (val > max) val = max;
            if (val < min) val = min;

            /* Update the slider. */
            tbSlider.Minimum = min;
            tbSlider.Maximum = max;
            tbSlider.Value = val;
            tbSlider.SmallChange = inc;
            tbSlider.TickFrequency = (max - min + 5) / 10;

            /* Update the values. */
            lblSliderMinMax.Text = "(" + min.ToString() + "-" + max.ToString() + ")";
            lblSliderValue.Text = "" + val;

            tbSlider.Enabled = true;
            lblSliderName.Enabled = true;
            lblSliderMinMax.Enabled = true;
            lblSliderValue.Enabled = true;

            lblSliderName.Text = NodeName;

        }

        private void tbSlider_Scroll(object sender, EventArgs e)
        {
            int value = tbSlider.Value - ((tbSlider.Value - tbSlider.Minimum) % tbSlider.SmallChange);
            _value = value;
            UpdateValues();

            if (Callback_SliderChange != null)
                Callback_SliderChange();
        }

        private void Slider_Load(object sender, EventArgs e)
        {
            UpdateValues();
        }
    }
}
