﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

using CommonBridge;

namespace GraphicModule
{
    public partial class RangeSelector : UserControl
    {   
        public RangeSelector()
        {
            InitializeComponent();
            cell_area_TB.setToolTip("Nucleu Area");
            cell_intensity_TB.setToolTip("Nucleu Intensity");
            eccentricity_TB.setToolTip("Nucleu Eccentricity");
            signal_border_dist_TB.setToolTip("Signal Distance to Border");
            signal_signal_dist_TB.setToolTip("Signals Mutual Distance");
            signal_intensity_TB.setToolTip("Signal Intensity");
            signal_area_TB.setToolTip("Signal Area");
        }

        public void InitRangeSelector(AxesRange axesData, float[] eccentricity_hist, float[] cell_area_hist, float[] cell_intensity_hist,
            float[] signal_border_dist_hist, float[] signal_signal_dist_hist, float[] signal_intensity_hist, float[] signal_area_hist, DoubleTrackBar.CallbackHandler refreshEvent)
        {
            eccentricity_TB.CallbackTB += refreshEvent;
            cell_area_TB.CallbackTB += refreshEvent;
            cell_intensity_TB.CallbackTB += refreshEvent;
            signal_border_dist_TB.CallbackTB += refreshEvent;
            signal_signal_dist_TB.CallbackTB += refreshEvent;
            signal_intensity_TB.CallbackTB += refreshEvent;
            signal_area_TB.CallbackTB += refreshEvent;

            eccentricity_TB.InitTrackBar(axesData.min_nucleu_eccentricity, axesData.max_nucleu_eccentricity, "0", eccentricity_hist);
            cell_area_TB.InitTrackBar(axesData.min_nucleu_area, axesData.max_nucleu_area, "0", cell_area_hist);
            cell_intensity_TB.InitTrackBar(axesData.min_nucleu_intensity, axesData.max_nucleu_intensity, "0", cell_intensity_hist);

            signal_border_dist_TB.InitTrackBar(axesData.min_signal_border_dist, axesData.max_signal_border_dist, "0", signal_border_dist_hist);
            signal_signal_dist_TB.InitTrackBar(axesData.min_signal_signal_dist, axesData.max_signal_signal_dist, "0", signal_signal_dist_hist);
            signal_intensity_TB.InitTrackBar(axesData.min_signal_intensity, axesData.max_signal_intensity, "0", signal_intensity_hist);
            signal_area_TB.InitTrackBar(axesData.min_signal_area, axesData.max_signal_area, "0", signal_area_hist);
        }

        public AxesRange GetRanges()
        {
            return new AxesRange(cell_area_TB.actualMinVal - 0.001f, cell_area_TB.actualMaxVal + 0.001f,
                                 cell_intensity_TB.actualMinVal - 0.001f, cell_intensity_TB.actualMaxVal + 0.001f,
                                 eccentricity_TB.actualMinVal - 0.001f, eccentricity_TB.actualMaxVal + 0.001f,
                                 signal_area_TB.actualMinVal - 0.001f, signal_area_TB.actualMaxVal + 0.001f,
                                 signal_intensity_TB.actualMinVal - 0.001f, signal_intensity_TB.actualMaxVal + 0.001f,
                                 signal_border_dist_TB.actualMinVal - 0.001f, signal_border_dist_TB.actualMaxVal + 0.001f,
                                 signal_signal_dist_TB.actualMinVal - 0.001f, signal_signal_dist_TB.actualMaxVal + 0.001f);
        }

    }
}
