﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.IO;
using CommonBridge;

namespace GraphicModule
{
    public partial class GalleryPage : UserControl
    {
        private int min_column_width = 120;
        private int active_columns = 8;
        private int max_active_columns = 8;
        private int active_rows = 1;
        private int actual_img_count = 0;
        private int[] actual_ids;
        private int actual_column_width = 120;
        private ExpertType[] movers = new ExpertType[3];

        
        public GalleryPage()
        {
            InitializeComponent();
        }

        public void saveGallery(ref List<Nucleus> nucleus, int nucleu_style, string path)
        {
            new FileInfo(@path).Directory.Create();
            for (int row = 0; row < dataGrid.RowCount; row++)
                for (int col = 0; col < dataGrid.ColumnCount; col++)
                {
                    if (dataGrid.Rows[row].Cells[col].Selected)
                    {
                        int id = getID(row, col);
                        if (id != -1)
                            nucleus[id].images[nucleu_style].Save(@path + id.ToString() + ".png", System.Drawing.Imaging.ImageFormat.Png);
                    }
                }   
        }

        public void DrawImages(int[] ids, ref List<Nucleus> nucleus, int nucleu_style)
        {
            actual_img_count = ids.Length;
            actual_ids = ids;

            changeRowCount(actual_img_count);
            showImages(ref nucleus, nucleu_style);
        }

        public void RedrawImages(ref List<Nucleus> nucleus, int nucleu_style)
        {
            changeRowCount(actual_img_count);
            showImages(ref nucleus, nucleu_style);
        }

        private void showImages(ref List<Nucleus> nucleus, int nucleu_style)
        {
            
            int count = 0;
            for (int row = 0; row < active_rows; row++)
            {
                dataGrid.Rows[row].Height = actual_column_width;
  
                for (int col = 0; col < active_columns; col++, count++)
                {
                    if (count < actual_img_count)
                    {
                        dataGrid.Rows[row].Cells[col].Value = nucleus[actual_ids[count]].images[nucleu_style];
                        if (nucleus[actual_ids[count]].expert != ExpertType.no)
                            dataGrid.Rows[row].Cells[col].Style.BackColor = Color.Red;
                        else
                            dataGrid.Rows[row].Cells[col].Style.BackColor = System.Drawing.SystemColors.Control;
                    }
                    else
                    {
                        dataGrid.Rows[row].Cells[col].Value = null;
                        dataGrid.Rows[row].Cells[col].Style.BackColor = System.Drawing.SystemColors.Control;
                    }
                }
            }
        
        }

         private void changeRowCount(int img_count)
        {
            active_rows = (int)(Math.Ceiling((float)img_count / active_columns));

            //add rows if needed
            if (dataGrid.RowCount < active_rows)
            {
                while (active_rows != dataGrid.RowCount)
                    dataGrid.Rows.Add(null, null, null, null, null, null, null, null);
            }

            for (int i = 0; i < active_rows; i++)
                dataGrid.Rows[i].Visible = true;
           
            for (int i = active_rows; i < dataGrid.RowCount; i++)
                dataGrid.Rows[i].Visible = false;
        }

         public void ChangeColumnCount(int table_width, ref List<Nucleus> nucleus, int nucleu_style)
        {
            active_columns = Math.Min(table_width / min_column_width, max_active_columns);
            
            //enable / disable columns
            for (int i = 0; i < active_columns; i++)
                dataGrid.Columns[i].Visible = true;
            for (int i = active_columns; i < dataGrid.ColumnCount; i++)
                dataGrid.Columns[i].Visible = false;


            RedrawImages(ref nucleus, nucleu_style);
            actual_column_width = table_width / active_columns;        
        }

         public int GetFirstSelected()
         {
             for (int row = 0; row < dataGrid.RowCount; row++)
                 for (int col = 0; col < dataGrid.ColumnCount; col++)
                 {
                     if (dataGrid.Rows[row].Cells[col].Selected)
                         return getID(row, col);
                 }
             return -1;
         }

         public ExpertType GetContextMenuMover(ToolStripItem item) 
         {
             if (item == moveTo1ToolStripMenuItem) return movers[0];
             else if (item == moveTo2ToolStripMenuItem) return movers[1];
             else if (item == moveTo3ToolStripMenuItem) return movers[2];
             else if (item == resetToolStripMenuItem) return ExpertType.no;
             return ExpertType.no;
         }

         private int getID(int rows, int cols)
         {
             int index = rows * active_columns + cols;
             return (index >= actual_ids.Length) ? -1 : actual_ids[index];
         }


         public void InitGalleryPage(EventHandler doubleClick, ToolStripItemClickedEventHandler moveNucleu, String menu1, String menu2, String menu3, ExpertType[] _movers)
         {
             this.dataGrid.DoubleClick += doubleClick;
             this.contextMenuStrip1.ItemClicked += moveNucleu;

            this.moveTo1ToolStripMenuItem.Text = menu1;
            this.moveTo2ToolStripMenuItem.Text = menu2;
            this.moveTo3ToolStripMenuItem.Text = menu3;

             movers = _movers;
         }

         private void dataGrid_CellMouseDown(object sender, DataGridViewCellMouseEventArgs e)
         {
             if (e.Button == MouseButtons.Right)
             {
                 dataGrid.ClearSelection();
                 dataGrid.Rows[e.RowIndex].Cells[e.ColumnIndex].Selected = true;
             }
         }

    }
}
