﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using MySql.Data.MySqlClient;
using CommonBridge;

using System.IO;

namespace GraphicModule
{
    public partial class Gallery : UserControl
    {
        private List<Nucleus> nucleus;
        private List<int>[] nucleus_IDs;
        //private Cell[] nucleus;
        private CellImage[] images;
        private IDictionary<int, int> images_bijection = new Dictionary<int, int>();

        private string path = @"";

        private bool show_contours = false;

        private int all_images_count;
        private int all_nucleus_count;
        
        public Gallery()
        {
            InitializeComponent();
        }


        public void InitGallery(List<CommonBridge.CapturedImage> image_data, ref List<CommonBridge.Nucleus> _nucleus, ref List<int>[] _nucleus_IDs, String _path)
        {

            //if (images == null || images.Count() == 0) return; 
            path = _path;
            nucleus = _nucleus;   
            nucleus_IDs = _nucleus_IDs;
           

            all_images_count = image_data.Count();
            all_nucleus_count = nucleus.Count();
                      
            initImages(image_data);
            initNucleus();
                
            rearrangeGalleries();
            UpdateGalleries(nucleus_IDs);

            pictureScroll.Minimum = 0;
            pictureScroll.Maximum = images.Length - 1 + pictureScroll.LargeChange - 1;
            pictureBox.Image = Image.FromFile(images[pictureScroll.Value].filename);    // FIT
            IMGpath.Text = images[pictureScroll.Value].filename + "   (" + (pictureScroll.Value + 1) + "/" + images.Length + ")";         // FIT

            XXgallery.InitGalleryPage(this.galleryDoubleClick, this.galleryMoveNucleu, "Move to BAD", "Move to XY", "Move to X", new ExpertType[3] { ExpertType.bad, ExpertType.XY, ExpertType.X});
            Xgallery.InitGalleryPage(this.galleryDoubleClick, this.galleryMoveNucleu, "Move to BAD", "Move to XY", "Move to XX", new ExpertType[3] { ExpertType.bad, ExpertType.XY, ExpertType.XX });
            XYgallery.InitGalleryPage(this.galleryDoubleClick, this.galleryMoveNucleu, "Move to BAD", "Move to XX", "Move to X", new ExpertType[3] { ExpertType.bad, ExpertType.XX, ExpertType.X });
            BADgallery.InitGalleryPage(this.galleryDoubleClick, this.galleryMoveNucleu, "Move to XX", "Move to XY", "Move to X", new ExpertType[3] { ExpertType.XX, ExpertType.XY, ExpertType.X });
        }


        private void initImages(List<CommonBridge.CapturedImage> image_data)
        {
            images = null;
            images = new CellImage[all_images_count];

            for (int i = 0; i < all_images_count; i++)
            {
                images[i] = new CellImage(new List<int>(), new List<int>(), path + image_data[i].filename);
                images_bijection.Add(Convert.ToInt32(image_data[i].I_ID), i);
                //Console.WriteLine(path + myReader[1]);
            }
            
             
        }
        
        private void initNucleus()//List<CommonBridge.Nucleu> nucleu_data)
        {
            if (images == null || images.Count() == 0) return;

            String last_image = "";
            Bitmap source = new Bitmap(images[0].filename);
            Bitmap source_contour = new Bitmap(source);

            for (int i = 0; i < this.nucleus.Count(); i++)
            {
                Rectangle section = new Rectangle(Convert.ToInt32(nucleus[i].x), Convert.ToInt32(nucleus[i].y), Convert.ToInt32(nucleus[i].width), Convert.ToInt32(nucleus[i].height));

                int img_id = images_bijection[Convert.ToInt32(nucleus[i].I_ID)];

                //Console.WriteLine(images[img_id].filename);

                if (!String.Equals(images[img_id].filename, last_image))
                {
                    source = new Bitmap(images[img_id].filename);
                    source_contour = new Bitmap(source);

                    List<Point[]> nucleus_contour = readContours(path + Path.GetFileNameWithoutExtension(images[img_id].filename) + "-dapi-roi.csv");
                    List<Point[]> signal_contour = readContours(path + Path.GetFileNameWithoutExtension(images[img_id].filename) + "-sig-roi.csv");

                    draw_contours(new Pen(Color.Yellow, 1), nucleus_contour, Graphics.FromImage(source_contour));
                    draw_contours(new Pen(Color.Red, 1), signal_contour, Graphics.FromImage(source_contour));

                    last_image = images[img_id].filename;
                }

                Rectangle newBB = squareBB(section, source.Size);

                nucleus[i].Set_Images(source.Clone(newBB, System.Drawing.Imaging.PixelFormat.Format24bppRgb), source_contour.Clone(newBB, System.Drawing.Imaging.PixelFormat.Format24bppRgb), img_id);
                images[img_id].cells.Add(i);
            }


        }

        public List<Point[]> readContours(string filename)
        {
            List<Point[]> contours = new List<Point[]>();

            var reader = new StreamReader(File.OpenRead(filename));

            while (!reader.EndOfStream)
            {

                var line = reader.ReadLine();
                var values = line.Split(',');
                Point[] c = new Point[(values.Length - 6) / 2];
                for (int i = 5; i < values.Length - 1; i = i + 2) //od 5 lebo na zaciatku su blbosti a do L-1 lebo na konci je ciarka a za tym prazdny retazec
                {
                    c[(i - 5) / 2] = new Point(Convert.ToInt32(values[i]), Convert.ToInt32(values[i + 1]));

                }
                contours.Add(c);
            }

            return contours;
        }

        private void draw_contours(Pen p, List<Point[]> contours, Graphics gr)
        {
            foreach (Point[] c in contours)
            {
                gr.DrawPolygon(p, c);
            }
        }
                   

        private Rectangle squareBB(Rectangle originalRect, Size imgSize)
        {
            Point middle = new Point(originalRect.X + originalRect.Width / 2, originalRect.Y + originalRect.Height / 2);
            int radius = Math.Max(originalRect.Width, originalRect.Height) / 2;

            Point newLocation = new Point(Math.Max(0, middle.X - radius), Math.Max(0, middle.Y - radius));
            Point newOppositeCorner = new Point(Math.Min(imgSize.Width, middle.X + radius), Math.Min(imgSize.Height, middle.Y + radius));

            Size newSize = new Size(newOppositeCorner.X - newLocation.X, newOppositeCorner.Y - newLocation.Y);

            return new Rectangle(newLocation, newSize);
        }

        private void redrawGalleries()
        {
            XXgallery.RedrawImages(ref nucleus, Convert.ToInt16(show_contours));
            XYgallery.RedrawImages(ref nucleus, Convert.ToInt16(show_contours));
            Xgallery.RedrawImages(ref nucleus, Convert.ToInt16(show_contours));
            BADgallery.RedrawImages(ref nucleus, Convert.ToInt16(show_contours));
        }

        public void UpdateGalleries(List<int>[] ids)
        {
            BADgallery.DrawImages(ids[0].ToArray(), ref nucleus, Convert.ToInt16(show_contours));
            Xgallery.DrawImages(ids[1].ToArray(), ref nucleus, Convert.ToInt16(show_contours));
            XXgallery.DrawImages(ids[2].ToArray(), ref nucleus, Convert.ToInt16(show_contours));
            XYgallery.DrawImages(ids[3].ToArray(), ref nucleus, Convert.ToInt16(show_contours));
            

            BADpage.Text = "Bad (" + ids[0].Count.ToString() + ")";
            Xpage.Text = "X (" + ids[1].Count.ToString() + ")";
            XXpage.Text = "XX (" + ids[2].Count.ToString() + ")";
            XYpage.Text = "XY (" + ids[3].Count.ToString() + ")";            
        }

       
        private void rearrangeGalleries()
        {
            XXgallery.ChangeColumnCount(tabControl1.Width, ref nucleus, Convert.ToInt16(show_contours));
            Xgallery.ChangeColumnCount(tabControl1.Width, ref nucleus, Convert.ToInt16(show_contours));
            XYgallery.ChangeColumnCount(tabControl1.Width, ref nucleus, Convert.ToInt16(show_contours));
            BADgallery.ChangeColumnCount(tabControl1.Width, ref nucleus, Convert.ToInt16(show_contours));
        }

        /*
        private int[] remapCellsIDs(ref List<int> selected)
        {
            int[] returnIDs = new int[selected.Count()];

            for (int i = 0; i < selected.Count(); i++)
                returnIDs[i] = nucleus_bijection[selected[i]];

            return returnIDs;
        }*/

        private void Gallery_Resize(object sender, EventArgs e)
        {
            rearrangeGalleries();
        }

        private void pictureScroll_Scroll(object sender, ScrollEventArgs e)
        {
            scrollBarChanged();
        }

        private void pictureScroll_Scroll(object sender, EventArgs e)
        {
            scrollBarChanged();
        }

        private void scrollBarChanged()
        {
            pictureBox.Image = Image.FromFile(images[pictureScroll.Value].filename);
            IMGpath.Text = images[pictureScroll.Value].filename + "   (" + (pictureScroll.Value + 1) + "/" + images.Length + ")";

            if (show_contours)
            {
                Graphics gr = Graphics.FromImage(pictureBox.Image);
                Color col_signal = Color.Orange;
                Color col_nucleus = Color.Yellow;
                
                List<Point[]> nucleus_contour = readContours(path + Path.GetFileNameWithoutExtension(images[pictureScroll.Value].filename) + "-dapi-roi.csv");
                draw_contours(new Pen(col_nucleus), nucleus_contour, gr);

                List<Point[]> signal_contour = readContours(path + Path.GetFileNameWithoutExtension(images[pictureScroll.Value].filename) + "-sig-roi.csv");
                draw_contours(new Pen(col_signal), signal_contour, gr);
            }
        }

        private void pictureStaff_MouseEnter(object sender, EventArgs e)
        {
            pictureBox.Focus();
        }

        private void scrollBar_MouseWheel(object sender, MouseEventArgs e)
        {
           
            if (e.Delta > 0)
            {
                pictureScroll.Value = Math.Max(0, pictureScroll.Value - 1);
            }
            else
            { 
                if(images != null)
                    pictureScroll.Value = Math.Min(images.Length - 1, pictureScroll.Value + 1);
            }
        }

        private void galleryDoubleClick(object sender, EventArgs e)
        {

            int showID = -1;

            if (tabControl1.SelectedTab == XXpage)
                showID = XXgallery.GetFirstSelected();
            else if (tabControl1.SelectedTab == Xpage)
                showID = Xgallery.GetFirstSelected();
            else if (tabControl1.SelectedTab == XYpage)
                showID = XYgallery.GetFirstSelected();
            else if (tabControl1.SelectedTab == BADpage)
                showID = BADgallery.GetFirstSelected();
                      
            try
            {
                pictureScroll.Value = nucleus[showID].src_img;
                tabControl1.SelectedTab = IMGpage;

                Graphics gr = Graphics.FromImage(pictureBox.Image);
                gr.DrawRectangle(new Pen(Color.OrangeRed, 4), nucleus[showID].x, nucleus[showID].y, nucleus[showID].width, nucleus[showID].height);
            }
            catch
            {
             //   resetStatusTimer("Selected cell invalid.");
            }
        }

        private void galleryMoveNucleu(object sender, ToolStripItemClickedEventArgs e)
        {

            int showID = -1;
            ExpertType expert = ExpertType.no;
            NucleusType galleryID = NucleusType.bad;

            if (tabControl1.SelectedTab == XXpage)
            {
                showID = XXgallery.GetFirstSelected();
                expert = XXgallery.GetContextMenuMover(e.ClickedItem);
                galleryID = NucleusType.XX;
            }
            else if (tabControl1.SelectedTab == Xpage)
                {
                showID = Xgallery.GetFirstSelected();
                expert = Xgallery.GetContextMenuMover(e.ClickedItem);
                galleryID = NucleusType.X;
            }
                
            else if (tabControl1.SelectedTab == XYpage)
            {
                showID = XYgallery.GetFirstSelected();
                expert = XYgallery.GetContextMenuMover(e.ClickedItem);
                galleryID = NucleusType.XY;
            }
            else if (tabControl1.SelectedTab == BADpage)
            {
                showID = BADgallery.GetFirstSelected();
                expert = BADgallery.GetContextMenuMover(e.ClickedItem);
                galleryID = NucleusType.bad;
            }


            if (showID != -1)
            {
                nucleus[showID].expert = expert;

                nucleus_IDs[(int)galleryID].Remove(showID);
                
                if (expert != ExpertType.no)
                    nucleus_IDs[(int)expert].Add(showID);
                else
                    nucleus_IDs[(int)nucleus[showID].type].Add(showID);

                UpdateGalleries(nucleus_IDs);
            }
            
        }

        public void ChangeCellStyle() 
        {
            show_contours = !show_contours;

            redrawGalleries();
            scrollBarChanged();
        }

        
        public void saveGallery(int id)
        {
            
        }

        private void saveButton_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog folderDialog = new FolderBrowserDialog();
            folderDialog.ShowDialog();

            if (folderDialog.SelectedPath != "")
            {
                Console.WriteLine(folderDialog.SelectedPath);
                if (tabControl1.SelectedTab == XXpage)
                    XXgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\");
                else if (tabControl1.SelectedTab == Xpage)
                    Xgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\");
                else if (tabControl1.SelectedTab == XYpage)
                    XYgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\");
                else if (tabControl1.SelectedTab == BADpage)
                    BADgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\");
            }           
        }

        private void saveAllButton_Click(object sender, EventArgs e)
        {

            FolderBrowserDialog folderDialog = new FolderBrowserDialog();
            folderDialog.ShowDialog();

            if (folderDialog.SelectedPath != "")
            {
                Console.WriteLine(folderDialog.SelectedPath);
                XXgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\XX\\");
                Xgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\X\\");
                XYgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\XY\\");
                BADgallery.saveGallery(ref nucleus, Convert.ToInt16(show_contours), folderDialog.SelectedPath + "\\Bad\\");
            }            
        }

        private void pictureBox_MouseDown(object sender, MouseEventArgs e)
        {   
            updatePictureZoom(e);
            pictureBoxZoom.Visible = true;            
        }

        private void pictureBox_MouseUp(object sender, MouseEventArgs e)
        {
            pictureBoxZoom.Visible = false;
        }

        private void pictureBox_MouseMove(object sender, MouseEventArgs e)
        {
            if (pictureBoxZoom.Visible) 
            {
                updatePictureZoom(e);
            }
        }

        private void pictureBox_MouseLeave(object sender, EventArgs e)
        {
            pictureBoxZoom.Visible = false;
        }

        private void updatePictureZoom(MouseEventArgs e) 
        {
            Size imageSize = pictureBox.Image.Size;
            Size boxSize = pictureBox.Size;

            float scale_width = (Convert.ToSingle(imageSize.Width) / boxSize.Width);
            float scale_height = (Convert.ToSingle(imageSize.Height) / boxSize.Height);
            float max_scale = Math.Max(scale_width, scale_height);

            int v_offset = 0;
            int h_offset = 0;

            if (scale_height < scale_width)
            {
                v_offset = Convert.ToInt32( (boxSize.Height - imageSize.Height / scale_width) / 2);
            }
            else {
                h_offset = Convert.ToInt32((boxSize.Width - imageSize.Width / scale_height) / 2);
            }

            //Console.WriteLine("event: " + e.X + " " + e.Y);

            Point mousePosition = new Point(Convert.ToInt32(max_scale * (e.X - h_offset)), Convert.ToInt32(max_scale * (e.Y - v_offset)));

            //Console.WriteLine("mouse: " + mousePosition.X + " " + mousePosition.Y);

            Bitmap original = new Bitmap(pictureBox.Image);
            Rectangle section = new Rectangle(Math.Max(0, Math.Min(mousePosition.X - 100, imageSize.Width - 200)), Math.Max(0, Math.Min(mousePosition.Y - 100, imageSize.Height - 200)), 200, 200);
            pictureBoxZoom.Size = section.Size;
            pictureBoxZoom.Image = original.Clone(section, original.PixelFormat);

            if(e.X > boxSize.Width - 200)
                pictureBoxZoom.Location = new System.Drawing.Point(e.X-200, e.Y);
            else
                pictureBoxZoom.Location = new System.Drawing.Point(e.X, e.Y);
            
        }
    }
}
