﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Linq;
using System.Text;
using System.Windows.Forms;

namespace GraphicModule
{
    public partial class DoubleTrackBar : UserControl
    {
        private bool activeMin = false;
        private bool activeMax = false;
        private bool activeRange = false;
        
        private int rangeMoveInit;
        private int mouseDownLocation;
        
        private int margin;

        private float globalMinVal = 0;
        private float globalMaxVal = 100;

        public float actualMinVal = 20;
        public float actualMaxVal = 80;

        private string labFormat = "0.0";

        public delegate void CallbackHandler();
        public CallbackHandler CallbackTB = null;

        private bool valid = false;

        public DoubleTrackBar()
        {
            InitializeComponent();
            chart1.Series[0]["PixelPointWidth"] = "2";
            chart1.Series[0].Color = Color.Orange;
            margin = mainRect.Location.X;
        }

        public void InitTrackBar(float minVal, float maxVal, string newFormat, float[] hist_data)//, EventHandler refreshEvent)
        {
            globalMinVal = minVal;
            globalMaxVal = maxVal;

            actualMinVal = minVal;
            actualMaxVal = maxVal;

            labFormat = newFormat;

            labelMin.Text = minVal.ToString(labFormat);
            labelMax.Text = maxVal.ToString(labFormat);

            setRange(valueToRect(actualMinVal), valueToRect(actualMaxVal));
            
           // this.rangeRect.LocationChanged += refreshEvent;
           // this.rangeRect.SizeChanged += refreshEvent;


            chart1.Series[0].Points.DataBindY(createHist(hist_data));
        }

        private int[] createHist(float[] hist_data)
        {
            int[] hist = new int[125];

            try
            {
                foreach (float v in hist_data)
                {
                    float scaled = (v - globalMinVal) / (globalMaxVal - globalMinVal) * 124;
                    int id = Convert.ToInt32(scaled);
                    hist[id]++;
                }
                valid = true;
            }
            catch (Exception e)
            {
                Console.WriteLine(e.ToString());                
            }
                        
            return hist;
        }
                
        private void setRange(int min_val, int max_val)
        {
            
            minRect.SetBounds(min_val, minRect.Location.Y, minRect.Width, minRect.Height);
            maxRect.SetBounds(max_val, maxRect.Location.Y, maxRect.Width, maxRect.Height);

            rangeRect.SetBounds(minRect.Location.X + minRect.Width, rangeRect.Location.Y, maxRect.Location.X - minRect.Location.X - minRect.Width, rangeRect.Height);

            labelMin.Text = actualMinVal.ToString(labFormat);
            labelMax.Text = actualMaxVal.ToString(labFormat);
        }

        public void setToolTip(string name)
        {
            toolTip1.Active = true;
            toolTip1.SetToolTip(this.shapeContainer1, name);        
        }

        // PRIVATE FUNCTIONS TO CHANGE RANGE

        private float rectToValue(int rectVal)
        {
            return ((float)(rectVal - mainRect.Location.X - minRect.Width/2) / (mainRect.Width - maxRect.Width)) * (globalMaxVal - globalMinVal) + globalMinVal;            
        }
        
        private int valueToRect(float valueVal)
        {
            return (int)((valueVal - globalMinVal) / (globalMaxVal - globalMinVal) * (mainRect.Width - maxRect.Width) + mainRect.Location.X);
        }

        // ENTER >>>>>
        private void minRec_MouseEnter(object sender, EventArgs e)
        {
            minRect.FillColor = Color.Maroon;
        }
        
        private void maxRect_MouseEnter(object sender, EventArgs e)
        {
            maxRect.FillColor = Color.Maroon;
        }

        private void rangeRect_MouseEnter(object sender, EventArgs e)
        {
            rangeRect.FillColor = Color.LightSalmon;
        }
        // <<<<<<

        // LEAVE >>>>>
        private void minRec_MouseLeave(object sender, EventArgs e)
        {
            minRect.FillColor = Color.Black;
            activeMin = false;
        }

        private void maxRect_MouseLeave(object sender, EventArgs e)
        {
            maxRect.FillColor = Color.Black;
            activeMax = false;
        }

        private void rangeRect_MouseLeave(object sender, EventArgs e)
        {
            rangeRect.FillColor = Color.DarkSalmon;
            activeRange = false;
        }
        // <<<<<<

        // MOUSE DOWN >>>>>
        private void minRec_MouseDown(object sender, MouseEventArgs e)
        {
            activeMin = true;
            minRect.FillColor = Color.IndianRed;
            updateMin(minRect.Location.X - minRect.Width / 2 + e.X);
        }

        private void maxRect_MouseDown(object sender, MouseEventArgs e)
        {
            activeMax = true;
            maxRect.FillColor = Color.IndianRed;
            updateMax(maxRect.Location.X - maxRect.Width / 2 + e.X);          
        }

        private void rangeRect_MouseDown(object sender, MouseEventArgs e)
        {
            mouseDownLocation = Cursor.Position.X;

            activeRange = true;
            rangeRect.FillColor = Color.Coral;
            rangeMoveInit = e.X;
        }
        // <<<<<<

        // MOUSE UP >>>>>
        private void minRect_MouseUp(object sender, MouseEventArgs e)
        {
            minRect.FillColor = Color.Black;
            activeMin = false;
        }

        private void maxRect_MouseUp(object sender, MouseEventArgs e)
        {
            maxRect.FillColor = Color.Black;
            activeMax = false;            
        }

        private void rangeRect_MouseUp(object sender, MouseEventArgs e)
        {
            rangeRect.FillColor = Color.DarkSalmon;
            activeRange = false;
        }
        // <<<<<<

        // MOUSE MOVE >>>>>
        private void minRect_MouseMove(object sender, MouseEventArgs e)
        {
            if(activeMin)
                updateMin(minRect.Location.X - minRect.Width/2 + e.X);
        }

        private void maxRect_MouseMove(object sender, MouseEventArgs e)
        {
            if(activeMax)
                updateMax(maxRect.Location.X - maxRect.Width / 2 + e.X);                
        }

        private void rangeRect_MouseMove(object sender, MouseEventArgs e)
        {
            if (activeRange)
                updateRange(e.X - rangeMoveInit);
        }

        // <<<<<<

        private void updateMin(int X)
        {
            
            X = Math.Min(Math.Max(X, margin), maxRect.Location.X - minRect.Width - 4);

            minRect.SetBounds(X, minRect.Location.Y, minRect.Width, minRect.Height);
            rangeRect.SetBounds(minRect.Location.X + minRect.Width, rangeRect.Location.Y, maxRect.Location.X - minRect.Location.X - minRect.Width, rangeRect.Height);
            
            actualMinVal = rectToValue(minRect.Location.X + minRect.Width/2);
            //Console.WriteLine(actualMinVal);
            labelMin.Text = actualMinVal.ToString(labFormat);
        }

        private void updateMax(int X)
        {
            X = Math.Max(Math.Min(X, mainRect.Width - maxRect.Width + margin), minRect.Location.X + minRect.Width + 4);

            maxRect.SetBounds(X, maxRect.Location.Y, maxRect.Width, maxRect.Height);
            rangeRect.SetBounds(minRect.Location.X + minRect.Width, rangeRect.Location.Y, maxRect.Location.X - minRect.Location.X - minRect.Width, rangeRect.Height);
            
            actualMaxVal = rectToValue(maxRect.Location.X + maxRect.Width / 2);
            //Console.WriteLine(actualMaxVal);
            labelMax.Text = actualMaxVal.ToString(labFormat);
        }

        private void updateRange(int X)
        {
            X = Math.Max(-minRect.Location.X + margin, X);
            X = Math.Min(mainRect.Width - maxRect.Location.X - maxRect.Width + margin, X);
            minRect.SetBounds(minRect.Location.X + X, minRect.Location.Y, minRect.Width, minRect.Height);
            maxRect.SetBounds(maxRect.Location.X + X, maxRect.Location.Y, maxRect.Width, maxRect.Height);

            rangeRect.SetBounds(minRect.Location.X + minRect.Width, rangeRect.Location.Y, maxRect.Location.X - minRect.Location.X - minRect.Width, rangeRect.Height);

            actualMinVal = rectToValue(minRect.Location.X + minRect.Width / 2);
            actualMaxVal = rectToValue(maxRect.Location.X + maxRect.Width / 2);

            labelMin.Text = actualMinVal.ToString(labFormat);
            labelMax.Text = actualMaxVal.ToString(labFormat);
        }

        private void mainRect_MouseClick(object sender, MouseEventArgs e)
        {
            if (!valid) return;

            if (Math.Abs(e.X - minRect.Location.X) < Math.Abs(e.X - maxRect.Location.X))
            {
                updateMin(e.X + margin - minRect.Width / 2);
            }
            else
            {
                updateMax(e.X + margin - maxRect.Width / 2);
            }
        }

        private void rangeRect_MouseClick(object sender, MouseEventArgs e)
        {
            if (!valid) return;

            if (mouseDownLocation - Cursor.Position.X != 0) return;

            if (e.X < rangeRect.Width - e.X)
            {
                updateMin(minRect.Location.X + e.X + minRect.Width / 2);
            }
            else
            {
                updateMax(minRect.Location.X + e.X + minRect.Width / 2);
            }
        }

        private void MyTrackBar_MouseLeave(object sender, EventArgs e)
        {
            minRect.FillColor = Color.Black;            
            maxRect.FillColor = Color.Black;
            activeMin = false;
            activeMax = false;
        }

        private void rangeRect_SizeChanged(object sender, EventArgs e)
        {
            // check if reference to function exist
            if (CallbackTB != null)
            {
                CallbackTB();
            }
        }

        private void rangeRect_LocationChanged(object sender, EventArgs e)
        {
            // check if reference to function exist
            if (CallbackTB != null)
            {
                CallbackTB();
            }
        }      
    }
}
