﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;   

using MySql.Data.MySqlClient;
using System.Data;
using CommonBridge;

namespace DatabaseModule
{
    // this class is a children of DatabaseModuleBaseClass
    // extended class for GeneAnalyser use

    public class DatabaseModuleClass : DatabaseModuleBaseClass
    {

        // ------------------------------------------------------------------------------
        //
        //     TRANSLATOR MODULE
        //
        // ------------------------------------------------------------------------------
        // in parent class 


        // ------------------------------------------------------------------------------
        //
        //      VARIABLES
        //
        // -----------------------------------------------------------------------------





        private String _prefix_tablename = "";

        private String tablename_patient = "patient";
        public  String mainkey_patient = "P_ID";

        private String tablename_examination = "examination";
        public String mainkey_examination = "E_ID";

        private String tablename_images = "images";
        public String mainkey_images = "I_ID";

        private String tablename_subimages = "subimages";
        public String mainkey_subimages = "SI_ID";

        private String tablename_nucleus = "nucleus";
        public String mainkey_nucleus = "N_ID";

        private String tablename_signals = "signals";
        public String mainkey_signals = "S_ID";  

        private String tablename_fluorophore = "fluorophore";
        public String mainkey_fluorophore = "F_KEY";

        private String tablename_demo = "table_demo";
        public String mainkey_demo = "ID";


        // ------------------------------------------------------------------------------
        //
        //      DELEGATES
        //
        // -----------------------------------------------------------------------------
        

        // ------------------------------------------------------------------------------
        //
        //      FUNCTIONS
        //
        // -----------------------------------------------------------------------------
        public void Clear()
        {

        }

        public override void Init()
        {   
            LogUnit.LogDebug(ModuleName, "Init");
        }

        public DatabaseModuleClass()
        {
            ModuleName = this.ToString();   
        }

        ~DatabaseModuleClass()
        {
            if (LogUnit != null)
            {
                LogUnit.LogDebug(ModuleName, "Destructor");
                LogUnit = null;
            }
        }

        #region TABLE NAME

        /// <summary>
        /// Create basename of table - content database name and symbol "." 
        /// </summary>
        /// <returns>Example "genedtb."</returns>        
        public String GetTableName_Base()
        {   
            return dbsetup_database + ".";
        }

        /// <summary>
        /// Get name of patient's table
        /// </summary>
        /// <returns>Name of patient's table </returns>
        public String GetTableName_Patient()
        {
            return _prefix_tablename + tablename_patient;
        }

        /// <summary>
        /// Get name of patient's table with database prefix name.
        /// </summary>
        /// <returns>Name of patient's table with database prefix name.</returns>
        public String GetTableFullName_Patient()
        {
            return GetTableName_Base() + GetTableName_Patient();
        }

        /// <summary>
        /// Get name of examination's table
        /// </summary>
        /// <returns>Name of examination's table </returns>
        public String GetTableName_Examination()
        {
            return _prefix_tablename + tablename_examination;
        }

        /// <summary>
        /// Get name of examination's table with database prefix name.
        /// </summary>
        /// <returns>Name of examination's table with database prefix name.</returns>
        public String GetTableFullName_Examination()
        {
            return GetTableName_Base() + GetTableName_Examination();
        }

        /// <summary>
        /// Get name of images's table
        /// </summary>
        /// <returns>Name of images's table </returns>
        public String GetTableName_Images()
        {
            return _prefix_tablename + tablename_images;
        }

        /// <summary>
        /// Get name of images's table with database prefix name.
        /// </summary>
        /// <returns>Name of images's table with database prefix name.</returns>
        public String GetTableFullName_Images()
        {
            return GetTableName_Base() + GetTableName_Images();
        }

        /// <summary>
        /// Get name of subimage's table
        /// </summary>
        /// <returns>Name of subimage's table </returns>
        public String GetTableName_SubImages()
        {
            return _prefix_tablename + tablename_subimages;
        }

        /// <summary>
        /// Get name of subimages's table with database prefix name.
        /// </summary>
        /// <returns>Name of subimages's table with database prefix name.</returns>
        public String GetTableFullName_SubImages()
        {
            return GetTableName_Base() + GetTableName_SubImages();
        }

        /// <summary>
        /// Get name of nucleus table
        /// </summary>
        /// <returns>Name of nucleu table </returns>
        public String GetTableName_Nucleus()
        {
            return _prefix_tablename + tablename_nucleus;
        }

        /// <summary>
        /// Get name of nucleus's table with database prefix name.
        /// </summary>
        /// <returns>Name of nucleus's table with database prefix name.</returns>
        public String GetTableFullName_Nucleus()
        {
            return GetTableName_Base() + GetTableName_Nucleus();
        }

        /// <summary>
        /// Get name of signal's table
        /// </summary>
        /// <returns>Name of signal's table </returns>
        public String GetTableName_Signals()
        {
            return _prefix_tablename + tablename_signals;
        }

        /// <summary>
        /// Get name of signal's table with database prefix name.
        /// </summary>
        /// <returns>Name of signal's table with database prefix name.</returns>
        public String GetTableFullName_Signals()
        {
            return GetTableName_Base() + GetTableName_Signals();
        }

        /// <summary>
        /// Get name of fluorophore's table
        /// </summary>
        /// <returns>Name of fluorophore's table </returns>
        public String GetTableName_Fluorophore()
        {
            return _prefix_tablename + tablename_fluorophore;
        }

        /// <summary>
        /// Get name of fluorophore's table with database prefix name.
        /// </summary>
        /// <returns>Name of fluorophore's table with database prefix name.</returns>
        public String GetTableFullName_Fluorophore()
        {
            return GetTableName_Base() + GetTableName_Fluorophore();
        }

        /// <summary>
        /// Get name of demo table
        /// </summary>
        /// <returns>Name of demo table </returns>
        public String GetTableName_Demo()
        {
            return _prefix_tablename + tablename_demo;
        }

        /// <summary>
        /// Get name of demo table with database prefix name.
        /// </summary>
        /// <returns>Name of demo table with database prefix name.</returns>
        public String GetTableFullName_Demo()
        {
            return GetTableName_Base() + GetTableName_Demo();
        }

        #endregion TABLE NAME

        #region TABLE NAME - VIEWS

        public String GetTableViewName_Patient()
        {
            return _prefix_tablename + tablename_patient + "_view";
        }

        public String GetTableViewName_Examination()
        {
            return _prefix_tablename + tablename_examination + "_view";
        }

        public String GetTableViewName_Images()
        {
            return _prefix_tablename + tablename_images + "_view";
        }
                
        public String GetTableViewName_Nucleus()
        {
            return _prefix_tablename + tablename_nucleus + "_view";
        }

        public String GetTableViewName_Signals()
        {
            return _prefix_tablename + tablename_signals + "_view";
        }
        
        public enum TableEnum { TABLE_PATIENT, TABLE_EXAMINATION, TABLE_IMAGES, TABLE_SUBIMAGES, TABLE_NUCLEUS, TABLE_SIGNALS, TABLE_FLUOROPHORE, TABLE_DEMO };

        public String GetTableName(TableEnum table_enum)
        {
            String table_name = null;
            switch (table_enum)
            {
                case TableEnum.TABLE_PATIENT:
                    table_name = GetTableName_Patient();
                    break;
                case TableEnum.TABLE_EXAMINATION:
                    table_name = GetTableName_Examination();
                    break;
                case TableEnum.TABLE_IMAGES:
                    table_name = GetTableName_Images();
                    break;
                case TableEnum.TABLE_SUBIMAGES:
                    table_name = GetTableName_SubImages();
                    break;
                case TableEnum.TABLE_NUCLEUS:
                    table_name = GetTableName_Nucleus();
                    break;
                case TableEnum.TABLE_SIGNALS:
                    table_name = GetTableName_Signals();
                    break;
                case TableEnum.TABLE_FLUOROPHORE:
                    table_name = GetTableName_Fluorophore();
                    break;
                case TableEnum.TABLE_DEMO:
                    table_name = GetTableName_Demo();
                    break;
            }
            return table_name;
        }

        public String GetTableFullName(TableEnum table_enum)
        {
            String table_name = null;
            switch (table_enum)
            {
                case TableEnum.TABLE_PATIENT:
                    table_name = GetTableFullName_Patient();
                    break;
                case TableEnum.TABLE_EXAMINATION:
                    table_name = GetTableFullName_Examination();
                    break;
                case TableEnum.TABLE_IMAGES:
                    table_name = GetTableFullName_Images();
                    break;
                case TableEnum.TABLE_SUBIMAGES:
                    table_name = GetTableFullName_SubImages();
                    break;
                case TableEnum.TABLE_NUCLEUS:
                    table_name = GetTableFullName_Nucleus();
                    break;
                case TableEnum.TABLE_SIGNALS:
                    table_name = GetTableFullName_Signals();
                    break;
                case TableEnum.TABLE_FLUOROPHORE:
                    table_name = GetTableFullName_Fluorophore();
                    break;
                case TableEnum.TABLE_DEMO:
                    table_name = GetTableFullName_Demo();
                    break;
            }
            return table_name;
        }
        #endregion

        #region REGION PATIENT

        public CommonBridge.Patient GetOnePatient(Int32 P_ID = 0)
        {
            return GetOnePatient(GetTableViewName_Patient(), P_ID);
        }

        public CommonBridge.Patient GetOnePatient(String from = null, Int32 P_ID = 0)
        {
            // one patient
            CommonBridge.Patient one_patient = null;

            // get list o patients with this P_ID
            List<CommonBridge.Patient> patlist = GetPatientList(from, P_ID);

            // if item exist, just remember first one (copycontructor)
            if (patlist != null && patlist.Count > 0)
                one_patient = new CommonBridge.Patient(patlist[0]);

            return one_patient;
        }

        /// <summary>
        /// Get all patients or get only one specific patients and return them in list
        /// </summary>
        /// <param name="P_ID">Get only one specific patients</param>
        /// <returns>List of Patients class</returns>
        public List<CommonBridge.Patient> GetPatientList(String from = "", Int32 P_ID = 0, String order_by = null, Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC) 
        {  
            // Create query
            String query = "SELECT * FROM ";

            if (from != null && from.Length > 0)
            {
                query += from;
            }
            else
            {
                query += GetTableFullName_Patient();
            } 


            if (P_ID > 0)
                query += " WHERE P_ID = " + P_ID.ToString();

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {
                query += " LIMIT " + offset.ToString() + "," + limit.ToString();
            }

            List<CommonBridge.Patient> patients = null;

            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                // check if reader get data
                if (reader == null)
                    return null;

                // create list of patients
                patients = new List<CommonBridge.Patient>();

                try
                {
                    // get data from reader
                    while (reader.Read())
                    {
                        // has reader more than X items?
                        if (reader.FieldCount >= 6)
                        {
                            try
                            {
                                // create new patient
                                CommonBridge.Patient one_patient = new CommonBridge.Patient();

                                // fill with info 

                                try { one_patient.Set_P_ID(reader["P_ID"]); }
                                catch (Exception) { }
                                try { one_patient.Set_PIN(reader["PIN"]); }
                                catch (Exception) { }
                                try { one_patient.Set_Name(reader["name"]); }
                                catch (Exception) { }
                                try { one_patient.Set_Surname(reader["surname"]); }
                                catch (Exception) { }
                                try { one_patient.Set_Comment(reader["comment"]); }
                                catch (Exception) { }
                                try { one_patient.Set_State(reader["state"]); }
                                catch (Exception) { }

                                try
                                {
                                    one_patient.Set_CountExams(reader["count_exams"]);
                                }
                                catch
                                {
                                    one_patient.Set_CountExams(0);
                                }

                                try
                                {
                                    MySql.Data.Types.MySqlDateTime dt;
                                    if ((reader["datetime_insert"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_insert"]);
                                        one_patient.Set_Inserttime(dt.Value);
                                    }

                                    if ((reader["datetime_update"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_update"]);
                                        one_patient.Set_Updatetime(dt.Value);
                                    }
                                }
                                catch
                                {

                                }

                                // insert into list
                                patients.Add(one_patient);
                            }
                            catch (Exception exc)
                            {
                                //throw exc;
                                // continue
                            }
                        }
                    }
                }
                catch (Exception exc)
                {
                    // some exception
                    Console.WriteLine("Error: {0}", exc.Message);
                    return null;
                }
                finally
                {
                    // dont forget close the reader!!!
                    reader.Close();
                }
            }
            return patients;
        }

        #endregion PATIENT

        #region REGION EXAMINATION 
        /// <summary>
        /// Get one Examination from database
        /// </summary>
        /// <param name="E_ID">Examination ID</param>
        /// <returns></returns>
        public CommonBridge.Examination GetOneExamination(Int32 E_ID)
        {
            return GetOneExamination(GetTableViewName_Examination(), E_ID);
        }

        /// <summary>
        /// Get one Examination from database
        /// </summary>
        /// <param name="from"></param>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        public CommonBridge.Examination GetOneExamination(String from = null, Int32 E_ID = 0)
        {
            CommonBridge.Examination one_exam = null;

            // get examination with this ID
            List<CommonBridge.Examination> examlist = GetExaminationList(from,E_ID);

            // if item exist, just remember first one (copycontructor)
            if (examlist != null && examlist.Count > 0)
                one_exam = new CommonBridge.Examination(examlist[0]);                     

            return one_exam;
        }
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="E_ID">Examination ID</param>
        /// <param name="P_ID">Patient ID, get all examination of this patient</param>
        /// <returns></returns>
        public List<CommonBridge.Examination> GetExaminationList(String from = "", Int32 E_ID = 0, Int32 P_ID = 0, String order_by = null, Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC)
        {
            // make a query
            String query = "SELECT * FROM ";

            if (from != null && from.Length > 0)
            {
                query += from;
            }
            else
            {
                query += GetTableFullName_Examination();
            } 


            if (E_ID > 0 || P_ID > 0)
            {
                query += " WHERE ";

                if (P_ID > 0)
                    query += "P_ID = " + P_ID.ToString() + " AND ";
                if (E_ID > 0)
                    query += "E_ID = " + E_ID.ToString() + " AND ";

                query += " 1";
            }

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {
                query += " LIMIT " + offset.ToString() + "," + limit.ToString();
            }

            List<CommonBridge.Examination> exams = null;


            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                exams = new List<CommonBridge.Examination>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 4)
                        {
                            // create new
                            CommonBridge.Examination one_exam = new CommonBridge.Examination();

                            // fill with info
                            try { one_exam.Set_E_ID(reader["E_ID"]); }
                            catch (Exception) { }
                            try { one_exam.Set_P_ID(reader["P_ID"]); }
                            catch (Exception) { }
                            try { one_exam.Set_Slide(reader["slide"]); }
                            catch (Exception) { }

                            try { one_exam.Set_Comment(reader["comment"]); }
                            catch (Exception) { }
                            try { one_exam.Set_Subdir(reader["subdir"]); }
                            catch (Exception) { }
                            try { one_exam.Set_State(reader["state"]); }
                            catch (Exception) { }
                            try { one_exam.Set_Result(reader["result"]); }
                            catch (Exception) { }
                            try { one_exam.Set_ResultString(reader["result_string"]); }
                            catch (Exception) { }       

                            try { one_exam.Set_Fluorophore1Key(reader["fluorophore1"]); }
                            catch (Exception) { }
                            try { one_exam.Set_Fluorophore2Key(reader["fluorophore2"]); }
                            catch (Exception) { }
                            try { one_exam.Set_Fluorophore3Key(reader["fluorophore3"]); }
                            catch (Exception) { }

                            try
                            {
                                one_exam.Set_CountImages(reader["count_images"]);
                            }
                            catch
                            {
                                one_exam.Set_CountImages(0);
                            }

                            try
                            {
                                MySql.Data.Types.MySqlDateTime dt;

                                if ((reader["datetime_insert"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                {
                                    dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_insert"]);
                                    one_exam.Set_Inserttime(dt.Value);
                                }

                                if ((reader["datetime_update"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                {
                                    dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_update"]);
                                    one_exam.Set_Updatetime(dt.Value);
                                }
                            }
                            catch
                            {

                            }


                            // insert into list
                            exams.Add(one_exam);
                        }
                    }
                }
                catch (Exception exc)
                {
                    Console.WriteLine("Error: {0}", exc.Message);
                    return null;
                }
                finally
                {
                    reader.Close();
                }
            } // end lock

            return exams;
        }

        #endregion REGION EXAMINATION

        #region REGION IMAGES
        
        /// <summary>
        /// 
        /// </summary>
        /// <param name="I_ID"></param>
        /// <returns></returns>
        public CommonBridge.CapturedImage GetOneImage(Int32 I_ID)
        {
            CommonBridge.CapturedImage one_image = null;

            List<CommonBridge.CapturedImage> imglist = GetImagesList(null,I_ID);

            // if item exist, just remember pointer (better will be copy!!!)
            if (imglist != null && imglist.Count > 0)
                one_image = new CommonBridge.CapturedImage(imglist[0]);

            return one_image;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="I_ID"></param>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        public List<CommonBridge.CapturedImage> GetImagesList(String from = "", Int32 I_ID = 0, Int32 E_ID = 0, String order_by = null, Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC)
        {
            // query
            String query = "SELECT * FROM ";

            if (from != null && from.Length > 0)
            {
                query += from;
            }
            else
            {
                query += GetTableFullName_Images();
            }    
                

            if (I_ID > 0 || E_ID > 0) 
            {
                query += " WHERE ";

                if (I_ID > 0)
                    query += "I_ID = " + I_ID.ToString() + " AND ";
                if (E_ID > 0)
                    query += "E_ID = " + E_ID.ToString() + " AND ";

                query += " 1";
            }

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {
                query += " LIMIT " + offset.ToString() + "," + limit.ToString();
            }

            List<CommonBridge.CapturedImage> images = null;

            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                images = new List<CommonBridge.CapturedImage>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 4)
                        {
                            // create new
                            CommonBridge.CapturedImage item = new CommonBridge.CapturedImage();

                            try
                            {
                                // fill with info
                                try { item.Set_I_ID(reader["I_ID"]); }
                                catch (Exception) { }
                                try { item.Set_E_ID(reader["E_ID"]); }
                                catch (Exception) { }
                                try { item.Set_Filename(reader["filename"]); }
                                catch (Exception) { }
                                try { item.Set_Done(reader["done"]); }
                                catch (Exception) { }
                                try { item.Set_StageX(reader["stage_position_x"]); }
                                catch (Exception) { }
                                try { item.Set_StageY(reader["stage_position_y"]); }
                                catch (Exception) { }
                                try { item.Set_StageZ(reader["stage_position_z"]); }
                                catch (Exception) { }

                                try { item.Set_State(reader["state"]); }
                                catch (Exception) { }

                                try { item.Set_CountSubImages(reader["count_subimages"]); }
                                catch (Exception) { item.Set_CountSubImages(0); }

                                try
                                {
                                    MySql.Data.Types.MySqlDateTime dt;

                                    if ((reader["datetime_insert"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_insert"]);
                                        item.Set_Inserttime(dt.Value);
                                    }

                                    if ((reader["datetime_update"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_update"]);
                                        item.Set_Updatetime(dt.Value);
                                    }
                                }
                                catch
                                {

                                }




                                /* TODO: dalsi prvky*/
                                //item.Set_Done(reader[10]);
                            }
                            catch
                            {

                            }

                            // insert into list
                            images.Add(item);
                        }
                    }
                }
                catch (Exception exc)
                {
                    Console.WriteLine("Error: {0}", exc.Message);
                    return null;
                }  
                finally
                {
                    reader.Close();
                }
            }
            return images;
        }
        
        #endregion REGION SUBIMAGES

        #region REGION SUBIMAGES

        public CommonBridge.CapturedSubImage GetOneSubImage(Int32 SI_ID)
        {
            CommonBridge.CapturedSubImage one_subimage = null;

            List<CommonBridge.CapturedSubImage> imglist = GetSubImagesList(null, SI_ID);

            // if item exist, just remember pointer (better will be copy!!!)
            if (imglist != null && imglist.Count > 0)
                one_subimage = new CommonBridge.CapturedSubImage(imglist[0]);

            return one_subimage;
        }


        public List<CommonBridge.CapturedSubImage> GetSubImagesList(String from = "", Int32 SI_ID = 0, Int32 I_ID = 0, String order_by = "SI_ID", Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC)
        {
            // query
            String query = "SELECT * FROM ";

            if (from != null && from.Length > 0)
            {
                query += from;
            }
            else
            {
                query += GetTableFullName_SubImages();
            }


            if (SI_ID > 0 || I_ID > 0)
            {
                query += " WHERE ";

                if (SI_ID > 0)
                    query += "SI_ID = " + SI_ID.ToString() + " AND ";
                if (I_ID > 0)
                    query += "I_ID = " + I_ID.ToString() + " AND ";

                query += " 1";
            }

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {
                query += " LIMIT " + offset.ToString() + "," + limit.ToString();
            }

            List<CommonBridge.CapturedSubImage> subimages = null;

            lock (mLockReader)
            {

                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                subimages = new List<CommonBridge.CapturedSubImage>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 4)
                        {
                            // create new
                            CommonBridge.CapturedSubImage item = new CommonBridge.CapturedSubImage();

  
                                // fill with info
                                try { item.Set_SI_ID(reader["SI_ID"]); }
                                catch (Exception) { }
                                try { item.Set_I_ID(reader["I_ID"]); }
                                catch (Exception) { }
                                try { item.Set_Filename(reader["filename"]); }
                                catch (Exception) { }

                                try { item.Set_Exposure(reader["exposure"]); }
                                catch (Exception) { }
                                try { item.Set_Gain(reader["gain"]); }
                                catch (Exception) { }
                                try { item.Set_Zoom(reader["zoom"]); }
                                catch (Exception) { }
                                try { item.Set_LightID(reader["light_ID"]); }
                                catch (Exception) { }

                                try { item.Set_Done(reader["done"]); }
                                catch (Exception) { }
                                try { item.Set_State(reader["state"]); }
                                catch (Exception) { }

                                try
                                {
                                    MySql.Data.Types.MySqlDateTime dt;

                                    if ((reader["datetime_insert"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_insert"]);
                                        item.Set_Inserttime(dt.Value);
                                    }

                                    if ((reader["datetime_update"]).GetType() == typeof(MySql.Data.Types.MySqlDateTime))
                                    {
                                        dt = (MySql.Data.Types.MySqlDateTime)(reader["datetime_update"]);
                                        item.Set_Updatetime(dt.Value);
                                    }
                                }
                                catch
                                {

                                }
                    

                            // insert into list
                            subimages.Add(item);
                        }
                    }
                
                }
                catch (Exception exc)
                {
                    Console.WriteLine("Error: {0}", exc.Message);
                    return null;
                }
                finally
                {
                    reader.Close();
                }

            }
            return subimages;
        }
        
        #endregion REGION SUBIMAGES 

        #region REGION NUCLEI
        
        public CommonBridge.Nucleus GetOneNucleus(Int32 N_ID)
        {
            CommonBridge.Nucleus one_nucleus = null;

            // get list of cell
            List<CommonBridge.Nucleus> nucleulist = GetNucleiList(null,N_ID);

            // if item exist, just remember first one (copycontructor)
            if (nucleulist != null && nucleulist.Count > 0)
                one_nucleus = new CommonBridge.Nucleus(nucleulist[0]);

            return one_nucleus;
        }
               
        public List<CommonBridge.Nucleus> GetNucleiList(String from = "", Int32 N_ID = 0, Int32 SI_ID = 0, String order_by = "N_ID", Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC)
        {
            // query
            String query = "SELECT N_ID, SI_ID, I_ID, E_ID, area, intensity, eccentricity, width, height, x, y, S_X, S_Y, min_sig_area, max_sig_area, min_sig_inten, max_sig_inten, min_sig_dist, max_sig_dist, dist, expert FROM ";

            if (from != null && from.Length > 0)
            {
                query += from;
            }
            else
            {
                query += GetTableFullName_Nucleus();
            }    

            if (SI_ID > 0 || N_ID > 0)
            {
                query += " WHERE ";

                if (N_ID > 0)
                    query += "N_ID = " + N_ID.ToString() + " AND ";
                if (SI_ID > 0)
                    query += "SI_ID = " + SI_ID.ToString() + " AND ";
                query += " 1";
            }

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {
                query += " LIMIT " + offset.ToString() + "," + limit.ToString();
            }

            List<CommonBridge.Nucleus> nuclist = null;

            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                nuclist = new List<CommonBridge.Nucleus>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 4)
                        {
                            // create new
                            CommonBridge.Nucleus item = new CommonBridge.Nucleus();

                            // fill with info

                            try { item.Set_N_ID(reader["N_ID"]); }
                            catch (Exception) { }
                            try { item.Set_SI_ID(reader["SI_ID"]); }
                            catch (Exception) { }
                            try { item.Set_I_ID(reader["I_ID"]); }
                            catch (Exception) { }
                            try { item.Set_E_ID(reader["E_ID"]); }
                            catch (Exception) { }

                            try { item.Set_Area(reader["area"]); }
                            catch (Exception) { }
                            try { item.Set_Intesity(reader["intensity"]); }
                            catch (Exception) { }
                            try { item.Set_Eccentricity(reader["eccentricity"]); }
                            catch (Exception) { }
                            try { item.Set_Width(reader["width"]); }
                            catch (Exception) { }
                            try { item.Set_Height(reader["height"]); }
                            catch (Exception) { }
                            try { item.Set_X(reader["X"]); }
                            catch (Exception) { }
                            try { item.Set_Y(reader["Y"]); }
                            catch (Exception) { }
                            try { item.Set_SX(reader["S_X"]); }
                            catch (Exception) { }
                            try { item.Set_SY(reader["S_Y"]); }
                            catch (Exception) { }

                            try { item.Set_Sig_Area(reader["min_sig_area"], reader["max_sig_area"]); }
                            catch (Exception) { }
                            try { item.Set_Sig_Intensity(reader["min_sig_inten"], reader["max_sig_inten"]); }
                            catch (Exception) { }
                            try { item.Set_Sig_Dist(reader["min_sig_dist"], reader["max_sig_dist"]); }
                            catch (Exception) { }

                            item.Set_Type();

                            try { item.Set_Dist(reader["dist"]); }
                            catch (Exception) { }
                            try { item.Set_Expert(reader["expert"]); }
                            catch (Exception) { }



                            // insert into list
                            nuclist.Add(item);
                        }
                    }

                }
                catch (MySqlException ex)
                {
                    Console.WriteLine("Error: {0}", ex.ToString());
                    return null;
                }
                finally
                {
                    reader.Close();
                }
            }
            return nuclist;
        }
#endregion NUCLEI

        #region REGION SIGNAL

        /// <summary>
        /// 
        /// </summary>
        /// <param name="S_ID"></param>
        /// <returns></returns>
        public CommonBridge.Signal GetOneSignal(Int32 S_ID)
        {
            CommonBridge.Signal one_signal = null;

            // get list of cell
            List<CommonBridge.Signal> siglist = GetSignalsList(S_ID);

            // if item exist, just remember first one (copycontructor)
            if (siglist != null && siglist.Count > 0)
                one_signal = new CommonBridge.Signal(siglist[0]);

            return one_signal;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="S_ID"></param>
        /// <param name="N_ID">nucleus ID</param>
        /// <returns></returns>
        public List<CommonBridge.Signal> GetSignalsList(Int32 S_ID = 0, Int32 N_ID = 0, String order_by = "S_ID", Int32 offset = 0, Int32 limit = 0, EnumOrderByDirection order_by_direction = EnumOrderByDirection.ASC)
        {
            // query
            String query = "SELECT S_ID, N_ID, I_ID, SI_ID, area, x, y  FROM " + GetTableFullName_Signals();

            if (S_ID > 0 || N_ID > 0)
            {
                query += " WHERE ";

                if (N_ID > 0)
                    query += "N_ID = " + N_ID.ToString() + " AND ";
                if (S_ID > 0)
                    query += "S_ID = " + S_ID.ToString() + " AND ";
                query += " 1";
            }

            if (order_by != null && order_by.Length > 0)
            {
                query += " ORDER BY " + order_by;
                if (order_by_direction != EnumOrderByDirection.NONE)
                {
                    query += " " + order_by_direction.ToString();
                }
            }

            if (limit > 0)
            {  
                query += " LIMIT " + offset.ToString() +"," + limit.ToString();
            }
            List<CommonBridge.Signal> signals = null;

            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                signals = new List<CommonBridge.Signal>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 4)
                        {
                            // create new
                            CommonBridge.Signal item = new CommonBridge.Signal();

                            // fill with info
                            // S_ID, N_ID, area, x, y 
                            try { item.Set_S_ID(reader["S_ID"]); }
                            catch (Exception) { }
                            try { item.Set_N_ID(reader["N_ID"]); }
                            catch (Exception) { }
                            try { item.Set_I_ID(reader["I_ID"]); }
                            catch (Exception) { }
                            try { item.Set_SI_ID(reader["SI_ID"]); }
                            catch (Exception) { }
                            try { item.Set_Area(reader["area"]); }
                            catch (Exception) { }
                            try { item.Set_X(reader["x"]); }
                            catch (Exception) { }
                            try { item.Set_Y(reader["y"]); }
                            catch (Exception) { }

                            /* TODO: dalsi prvky*/

                            // insert into list
                            signals.Add(item);
                        }
                    }
                    
                }
                catch (MySqlException ex)
                {
                    Console.WriteLine("Error: {0}", ex.ToString());
                    return null;
                }
                finally
                { 
                    reader.Close(); 
                }
            }
            return signals;
        }

        #endregion SIGNAL

        #region REGION FLUOROPHORE

        public CommonBridge.Fluorophore GetOneFluorophore(String F_KEY)
        {
            CommonBridge.Fluorophore one_color = null;

            // get list of cell
            List<CommonBridge.Fluorophore> flist = GetFluorophoreList(F_KEY);

            // if item exist, just remember first one (copycontructor)
            if (flist != null && flist.Count > 0)
                one_color = new CommonBridge.Fluorophore(flist[0]);

            return one_color;
        }

        public List<CommonBridge.Fluorophore> GetFluorophoreList(String F_KEY = null)
        {
            // query
            String query = "SELECT F_Key, name  FROM ";
            query += GetTableFullName_Fluorophore();

            if (F_KEY != null && F_KEY.Length > 0)
            {
                query += " WHERE N_ID = " + F_KEY + "";
            }

            List<CommonBridge.Fluorophore> fluorlist = null;

            lock (mLockReader)
            {
                // get data
                MySqlDataReader reader = GetQueryReader(query);

                if (reader == null)
                    return null;

                // create list
                fluorlist = new List<CommonBridge.Fluorophore>();

                try
                {
                    // fill list
                    while (reader.Read())
                    {
                        if (reader.FieldCount >= 2)
                        {
                            // create new
                            CommonBridge.Fluorophore item = new CommonBridge.Fluorophore();

                            // fill with info
                            item.Set_F_KEY(reader[0]);
                            item.Set_Name(reader[1]);

                            // insert into list
                            fluorlist.Add(item);
                        }
                    }
                    reader.Close();
                }
                catch (MySqlException ex)
                {
                    Console.WriteLine("Error: {0}", ex.ToString());
                    return null;
                }
                finally
                {
                    reader.Close();
                }
            }
            return fluorlist;
        }

        #endregion REGION FLUOROPHORE

        #region COUNTING
        
        public Int32 CountAllPatients(String where = null)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(" + GetTableName_Patient() + ".P_ID) FROM " + GetTableFullName_Patient();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllExaminations(Int32 P_ID = 0)
        {
            Int32 count = 0;
            // query
            String where = null;
            if(P_ID > 0) 
                where = "P_ID = " + P_ID;

            // get count
            return count = CountAllExaminations(where);
        }

        public Int32 CountAllExaminations(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(" + GetTableName_Examination() + ".E_ID) FROM " + GetTableFullName_Examination();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllImages(Int32 E_ID = 0)
        {
            Int32 count = 0;
            // query
            String where = null;
            if (E_ID > 0)
                where = "E_ID = " + E_ID;

            // get count
            return count = CountAllImages(where);
        }

        public Int32 CountAllImages(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(" + GetTableName_Images() + ".E_ID) FROM " + GetTableFullName_Images();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllNucleus(Int32 I_ID = 0)
        {
            Int32 count = 0;
            // query
            String where = null;
            if (I_ID > 0)
                where = "I_ID = " + I_ID;

            // get count
            return count = CountAllNucleus(where);
        }

        public Int32 CountAllNucleus(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(" + GetTableName_Nucleus() + ".I_ID) FROM " + GetTableFullName_Nucleus();
            
            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllSignals(Int32 I_ID = 0)
        {
            Int32 count = 0;
            // query
            String where = null;
            if (I_ID > 0)
                where = "I_ID = " + I_ID;

            // get count
            return count = CountAllSignals(where);
        }

        public Int32 CountAllSignals(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(" + GetTableName_Signals() + ".I_ID) FROM " + GetTableFullName_Signals();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllDemo(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableFullName_Demo();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }
        
        #endregion

        #region INSERT ONE, UPDATE ONE

        private enum ListProcessType { TYPE_UPDATE, TYPE_INSERT };
        
        /// <summary>
        /// Insert into database data of one patient
        /// </summary>
        /// <param name="one_patient">Input data of one patient</param>
        /// <returns>Return last inserted ID</returns>
        public Int32 InsertOne(CommonBridge.Patient one_patient)
        {
            Int32 retID = -1;
            
            if (!CheckConnection()) return retID; 
            if (one_patient == null) return retID;

            try
            {
                String query = "";
                query += "INSERT INTO " + GetTableFullName_Patient();
                query += " (PIN, name, surname, comment, datetime_insert)";
                query += " VALUES(@PIN, @name, @surname, @comment, NOW())";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare(); 

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@PIN", one_patient.PIN);
                db_insert_cmd.Parameters.AddWithValue("@name", one_patient.name);
                db_insert_cmd.Parameters.AddWithValue("@surname", one_patient.surname);
                db_insert_cmd.Parameters.AddWithValue("@comment", one_patient.comment);

                lock (mLockReader)
                {                 
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            } 
        }

        /// <summary>
        /// Update rows in database of one patient (may affected more rows)
        /// </summary>
        /// <param name="one_patient">Input data of one patient</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.Patient one_patient)
        {
            if (!CheckConnection()) return 0;
            if (one_patient == null || one_patient.P_ID <= 0) return 0;                           
            
            String values = "";
            values += "PIN='" + one_patient.PIN + "',";
            values += "name='" + one_patient.name + "',";
            values += "surname='" + one_patient.surname + "',";
            values += "comment='" + one_patient.comment + "',";
            values += "state='" + one_patient.state.ToString() + "',";
            values += "datetime_update=NOW()";

            String where = "P_ID = '" + one_patient.P_ID + "'";
            String table_name = GetTableFullName_Patient();

            Int32 rows_count = UpdateRows(table_name, where, values);

            return rows_count;
        }
        
        /// <summary>
        /// Insert into database data of one examination
        /// </summary>
        /// <param name="one_exam">Input data of one examination</param>
        /// <returns>Return last inserted ID</returns>              
        public Int32 InsertOne(CommonBridge.Examination one_exam)
        {
            Int32 retID = -1;
            if (!CheckConnection()) return retID;
            if (one_exam == null) return retID;

            try
            {
                String query = "";
                query += "INSERT INTO " + GetTableFullName_Examination();
                query += " (P_ID, slide, comment, subdir, result, result_string, fluorophore1,fluorophore2,fluorophore3, datetime_insert)";
                query += " VALUES (@P_ID, @slide, @comment, @subdir, @result,@result_string, @fluorophore1,@fluorophore2,@fluorophore3, NOW())";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare();

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@P_ID", one_exam.P_ID);
                db_insert_cmd.Parameters.AddWithValue("@slide", one_exam.slide);
                db_insert_cmd.Parameters.AddWithValue("@comment", one_exam.comment);
                db_insert_cmd.Parameters.AddWithValue("@subdir", one_exam.subdir);
                db_insert_cmd.Parameters.AddWithValue("@result", one_exam.result);
                db_insert_cmd.Parameters.AddWithValue("@result_string", one_exam.result);
                db_insert_cmd.Parameters.AddWithValue("@fluorophore1", one_exam.fluorophore1_key);
                db_insert_cmd.Parameters.AddWithValue("@fluorophore2", one_exam.fluorophore2_key);
                db_insert_cmd.Parameters.AddWithValue("@fluorophore3", one_exam.fluorophore3_key);

                lock (mLockReader)
                {
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            }
        }
        
        /// <summary>
        /// Update rows in database of one examination (may affected more rows)
        /// </summary>
        /// <param name="one_exam">Input data of one examination</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.Examination one_exam)
        {
            if (!CheckConnection()) return 0;
            if (one_exam == null || one_exam.E_ID <= 0) return 0;

            String table_name = GetTableFullName_Examination();
            String values = "";
            values += "P_ID='" + one_exam.P_ID + "',";
            values += "slide='" + one_exam.slide + "',";
            values += "comment='" + one_exam.comment + "',";
            values += "state='" + one_exam.state + "',";
                
            String subdir = one_exam.subdir.Replace('\\', '/');
            values += "subdir='" + subdir + "',";

            values += "result='" + one_exam.result + "',";
            values += "result_string='" + one_exam.result_string + "',";
            values += "fluorophore1='" + one_exam.fluorophore1_key + "',";
            values += "fluorophore2='" + one_exam.fluorophore2_key + "',";
            values += "fluorophore3='" + one_exam.fluorophore3_key + "',";
            values += "datetime_update=NOW()";

            String where = "E_ID = '" + one_exam.E_ID + "'"; 

            Int32 rows_count = UpdateRows(table_name, where, values); 
            return rows_count;
        }

        /// <summary>
        /// Insert into database data of one image
        /// </summary>
        /// <param name="one_image">Input data of one image</param>
        /// <returns>Return last inserted ID</returns>  
        public Int32 InsertOne(CommonBridge.CapturedImage one_image)
        {
            Int32 retID = -1;
            if (!CheckConnection()) return retID;
            if (one_image == null) return retID;

            try
            {
                String query = "";

                query += "INSERT INTO " + GetTableName_Images();
                query += "(E_ID, filename,  stage_position_x, stage_position_y, stage_position_z, done, datetime_insert) ";
                query += "VALUES(@E_ID, @filename, @stage_position_x, @stage_position_y, @stage_position_z, @done, NOW())";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare();

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@E_ID", one_image.E_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@filename", one_image.filename);
                db_insert_cmd.Parameters.AddWithValue("@stage_position_x", one_image.stage_position_x.ToString());
                db_insert_cmd.Parameters.AddWithValue("@stage_position_y", one_image.stage_position_y.ToString());
                db_insert_cmd.Parameters.AddWithValue("@stage_position_z", one_image.stage_position_z.ToString());
                db_insert_cmd.Parameters.AddWithValue("@done", one_image.done.ToString());

                lock (mLockReader)
                {
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId);
                        one_image.Set_I_ID(retID);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            }
        }
        
        /// <summary>
        /// Update rows in database of one image (may affected more rows)
        /// </summary>
        /// <param name="one_image">Input data of one image</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.CapturedImage one_image)
        {
            if (!CheckConnection()) return 0;
            if (one_image == null || one_image.I_ID <= 0) return 0;

                String table_name = GetTableFullName_Images();
                String values = "";
                values += "E_ID='" + one_image.E_ID + "',";
                values += "filename='" + one_image.filename + "',";
                values += "stage_position_x='" + one_image.stage_position_x.ToString() + "',";
                values += "stage_position_y='" + one_image.stage_position_y.ToString() + "',";
                values += "stage_position_z='" + one_image.stage_position_z.ToString() + "',";
                values += "done='" + one_image.done.ToString() + "',";
                values += "state='" + one_image.state.ToString() + "',";
                values += "datetime_update=NOW()";

                String where ="I_ID = '" + one_image.I_ID + "'";

                Int32 rows_count = UpdateRows(table_name, where, values);
                return rows_count;
        }

        /// <summary>
        /// Insert into database data of one subimage
        /// </summary>
        /// <param name="one_subimage">Input data of one subimage</param>
        /// <returns>Return last inserted ID</returns>  
        public Int32 InsertOne(CommonBridge.CapturedSubImage one_subimage)
        {
            Int32 retID = -1;
            if (!CheckConnection()) return retID;
            if (one_subimage == null) return retID;

            try
            {
                String query = "";

                query += "INSERT INTO " + GetTableName_SubImages();
                query += "(I_ID, filename, light_ID, exposure, gain, zoom, done, datetime_insert) ";
                query += "VALUES(@I_ID, @filename, @light_ID, @exposure, @gain, @zoom, @done, NOW())";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare();

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@I_ID", one_subimage.I_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@filename", one_subimage.filename);
                db_insert_cmd.Parameters.AddWithValue("@light_ID", one_subimage.light_ID);
                db_insert_cmd.Parameters.AddWithValue("@exposure", one_subimage.exposure_ms.ToString());
                db_insert_cmd.Parameters.AddWithValue("@gain", one_subimage.gain.ToString());
                db_insert_cmd.Parameters.AddWithValue("@zoom", one_subimage.zoom.ToString());
                db_insert_cmd.Parameters.AddWithValue("@done", one_subimage.done.ToString());

                lock (mLockReader)
                {
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId); 
                        one_subimage.Set_SI_ID(retID);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            }
        }
         
        /// <summary>
        /// Update rows in database of one subimage (may affected more rows)
        /// </summary>
        /// <param name="one_subimage">Input data of one subimage</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.CapturedSubImage one_subimage)
        {
            if (!CheckConnection()) return 0;
            if (one_subimage == null || one_subimage.SI_ID <= 0) return 0;
            
            // create query
            String table_name = GetTableFullName_SubImages();
            String values = "";
            values += "I_ID='" + one_subimage.I_ID + "',";
            values += "filename='" + one_subimage.filename + "',";
            values += "light_ID='" + one_subimage.light_ID + "',";
            values += "exposure='" + one_subimage.exposure_ms.ToString() + "',";
            values += "gain='" + one_subimage.gain.ToString() + "',";
            values += "zoom='" + one_subimage.zoom.ToString() + "',";
            values += "done='" + one_subimage.done.ToString() + "',";
            values += "state='" + one_subimage.state.ToString() + "',";
            values += "datetime_update=NOW()";
            String where = "SI_ID = '" + one_subimage.SI_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, values);
            return rows_count;
        }


        /// <summary>
        /// Insert into database data of one nucleus
        /// </summary>
        /// <param name="one_nucleus">Input data of one nucleus</param>
        /// <returns>Return last inserted ID</returns>  
        public Int32 InsertOne(CommonBridge.Nucleus one_nucleus)
        {
            Int32 retID = -1;
            if (!CheckConnection()) return retID;
            if (one_nucleus == null) return retID;

            try
            {
                String query = "";

                query += "INSERT INTO " + GetTableName_Nucleus();
                query += "(E_ID, I_ID, SI_ID, area, intensity, eccentricity, x, y, width, height, S_X, S_Y, expert, dist, min_sig_area, max_sig_area, min_sig_inten, max_sig_inten, min_sig_dist, max_sig_dist ) ";
                query += "VALUES(@E_ID, @I_ID, @SI_ID, @area, @intensity, @eccentricity, @x, @y, @width, @height, @S_X, @S_Y, @expert, @dist, @min_sig_area, @max_sig_area, @min_sig_inten, @max_sig_inten, @min_sig_dist, @max_sig_dist)";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare();

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@E_ID", one_nucleus.E_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@I_ID", one_nucleus.I_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@SI_ID", one_nucleus.SI_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@area", one_nucleus.area.ToString());
                db_insert_cmd.Parameters.AddWithValue("@intensity", one_nucleus.intensity.ToString());
                db_insert_cmd.Parameters.AddWithValue("@eccentricity", one_nucleus.eccentricity.ToString());
                db_insert_cmd.Parameters.AddWithValue("@x", one_nucleus.x.ToString());
                db_insert_cmd.Parameters.AddWithValue("@y", one_nucleus.y.ToString());
                db_insert_cmd.Parameters.AddWithValue("@width", one_nucleus.width.ToString());
                db_insert_cmd.Parameters.AddWithValue("@height", one_nucleus.height.ToString());
                db_insert_cmd.Parameters.AddWithValue("@S_X", one_nucleus.S_X.ToString());
                db_insert_cmd.Parameters.AddWithValue("@S_Y", one_nucleus.S_Y.ToString());
                db_insert_cmd.Parameters.AddWithValue("@expert", ((int)one_nucleus.expert).ToString());
                db_insert_cmd.Parameters.AddWithValue("@dist", one_nucleus.dist.ToString());

                db_insert_cmd.Parameters.AddWithValue("@min_sig_area", one_nucleus.min_sig_area.ToString());
                db_insert_cmd.Parameters.AddWithValue("@max_sig_area", one_nucleus.max_sig_area.ToString());
                db_insert_cmd.Parameters.AddWithValue("@min_sig_inten", one_nucleus.min_sig_inten.ToString());
                db_insert_cmd.Parameters.AddWithValue("@max_sig_inten", one_nucleus.max_sig_inten.ToString());
                db_insert_cmd.Parameters.AddWithValue("@min_sig_dist", one_nucleus.min_sig_dist.ToString());
                db_insert_cmd.Parameters.AddWithValue("@max_sig_dist", one_nucleus.max_sig_dist.ToString());

                lock (mLockReader)
                {
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId);
                        one_nucleus.Set_N_ID(retID);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            }
        }
        
        /// <summary>
        /// Update rows in database of one nucleus (may affected more rows)
        /// </summary>
        /// <param name="one_nucleus">Input data of one nucleus</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.Nucleus one_nucleus)
        {
            if (!CheckConnection()) return 0;
            if (one_nucleus == null || one_nucleus.N_ID <= 0) return 0;
            
            // create query
            String table_name = GetTableFullName_Nucleus();
            String query = "";
            query += "E_ID='" + one_nucleus.E_ID + "',";
            query += "I_ID='" + one_nucleus.I_ID + "',";
            query += "area='" + one_nucleus.area + "',";
            query += "intensity='" + one_nucleus.intensity + "',";
            query += "eccentricity='" + one_nucleus.eccentricity + "',";
            query += "x='" + one_nucleus.x + "',";
            query += "y='" + one_nucleus.y + "',";
            query += "width='" + one_nucleus.width + "',";
            query += "height='" + one_nucleus.height + "',";
            query += "S_X='" + one_nucleus.S_X + "',";
            query += "S_Y='" + one_nucleus.S_Y + "',";
            query += "state='" + one_nucleus.state + "',";
            query += "expert='" + one_nucleus.expert + "',";
            query += "dist='" + one_nucleus.dist + "',";
            query += "min_sig_area='" + one_nucleus.min_sig_area + "',";
            query += "max_sig_area='" + one_nucleus.max_sig_area + "',";
            query += "min_sig_inten='" + one_nucleus.min_sig_inten + "',";
            query += "max_sig_inten='" + one_nucleus.max_sig_inten + "',";
            query += "min_sig_dist='" + one_nucleus.min_sig_dist + "',";
            query += "max_sig_dist='" + one_nucleus.max_sig_dist + "'";

            String where  = "N_ID = '" + one_nucleus.N_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, query);
            return rows_count;
        }

        /// <summary>
        /// Insert into database data of one signal
        /// </summary>
        /// <param name="one_signal">Input data of one signal</param>
        /// <returns>Return last inserted ID</returns>  
        public Int32 InsertOne(CommonBridge.Signal one_signal)
        {
            Int32 retID = -1;
            if (!CheckConnection()) return -1;
            if (one_signal == null) return -1;

            try
            {
                String query = ""; 
                query += "INSERT INTO " + GetTableName_Signals();
                query += "(N_ID, I_ID, SI_ID, area, intensity, dist_border, x, y, width, height, type) ";
                query += "VALUES(@N_ID, @I_ID, @SI_ID, @area, @intensity, @dist_border, @x, @y, @width, @height, @type)";

                MySqlCommand db_insert_cmd = new MySqlCommand();
                db_insert_cmd.Connection = db_connection;
                db_insert_cmd.CommandText = query;
                db_insert_cmd.Prepare();

                db_insert_cmd.Parameters.Clear();
                db_insert_cmd.Parameters.AddWithValue("@N_ID", one_signal.N_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@I_ID", one_signal.I_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@SI_ID", one_signal.SI_ID.ToString());
                db_insert_cmd.Parameters.AddWithValue("@area", one_signal.area.ToString());
                db_insert_cmd.Parameters.AddWithValue("@intensity", one_signal.intensity.ToString());
                db_insert_cmd.Parameters.AddWithValue("@dist_border", one_signal.dist_border.ToString());
                db_insert_cmd.Parameters.AddWithValue("@x", one_signal.x.ToString());
                db_insert_cmd.Parameters.AddWithValue("@y", one_signal.y.ToString());
                db_insert_cmd.Parameters.AddWithValue("@width", one_signal.width.ToString());
                db_insert_cmd.Parameters.AddWithValue("@height", one_signal.height.ToString());
                db_insert_cmd.Parameters.AddWithValue("@type", one_signal.type.ToString());

                lock (mLockReader)
                {
                    int a = db_insert_cmd.ExecuteNonQuery();
                    if (a > 0)
                    {
                        // get last ID
                        retID = System.Convert.ToInt32(db_insert_cmd.LastInsertedId);
                        one_signal.Set_S_ID(retID);
                    }
                }
                return retID;
            }
            catch (MySqlException ex)
            {
                Console.WriteLine("Error: {0}", ex.ToString());
                return -1;
            }
        }
        
        /// <summary>
        /// Update rows in database of one signal (may affected more rows)
        /// </summary>
        /// <param name="one_signal">Input data of one signal</param>
        /// <returns>Count of affected rows.</returns>
        public Int32 UpdateOne(CommonBridge.Signal one_signal)
        {
            if (!CheckConnection()) return 0;
            if (one_signal == null || one_signal.S_ID <= 0) return 0;

            String table_name = GetTableFullName_Signals();
            String query = "";
            query += "N_ID='" + one_signal.N_ID.ToString() + "',";
            query += "I_ID='" + one_signal.I_ID.ToString() + "',";
            query += "SI_ID='" + one_signal.SI_ID.ToString() + "',";
            query += "area='" + one_signal.area.ToString() + "',";
            query += "intensity='" + one_signal.intensity.ToString() + "',";
            query += "dist_border='" + one_signal.dist_border.ToString() + "',";
            query += "x='" + one_signal.x.ToString() + "',";
            query += "y='" + one_signal.y.ToString() + "',";
            query += "width='" + one_signal.width.ToString() + "',";
            query += "height='" + one_signal.height.ToString() + "',";
            query += "type='" + one_signal.type.ToString() + "'";

            String where = "S_ID = '" + one_signal.S_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, query);
            return rows_count;
        }

        #endregion

        #region INSERT UPDATE LIST
        
        public Int32 InsertList<T>(ref List<T> reflist)
        {
            return ProcessList(ref reflist, ListProcessType.TYPE_INSERT);
        }

        public Int32 UpdateList<T>(ref List<T> reflist)
        {
            return ProcessList(ref reflist, ListProcessType.TYPE_UPDATE);
        }              
       
        private Int32 ProcessList<T>(ref List<T> reflist, ListProcessType ProcessType)
        {
            if (!CheckConnection()) return -1;                        // check connection
            if (reflist == null || reflist.Count <= 0) return -1;     // check list

            int ok = 0;

            try
            {
                int i = 0;
                Int32 items = 0;
                List<CommonBridge.Patient> patlist = null;
                List<CommonBridge.Examination> examlist = null;
                List<CommonBridge.CapturedImage> imagelist = null;
                List<CommonBridge.CapturedSubImage> subimagelist = null;
                List<CommonBridge.Signal> siglist = null;
                List<CommonBridge.Nucleus> nucleulist = null;

                if (reflist.GetType() == typeof(List<CommonBridge.Patient>))
                {
                    patlist = (List<CommonBridge.Patient>)Convert.ChangeType(reflist, typeof(List<CommonBridge.Patient>));
                    items = patlist.Count;
                }
                else if (reflist.GetType() == typeof(List<CommonBridge.Examination>))
                {
                    examlist = (List<CommonBridge.Examination>)Convert.ChangeType(reflist, typeof(List<CommonBridge.Examination>));
                    items = examlist.Count;
                }
                else if (reflist.GetType() == typeof(List<CommonBridge.CapturedImage>))
                {
                    imagelist = (List<CommonBridge.CapturedImage>)Convert.ChangeType(reflist, typeof(List<CommonBridge.CapturedImage>));
                    items = imagelist.Count;
                }
                else if (reflist.GetType() == typeof(List<CommonBridge.CapturedSubImage>))
                {
                    subimagelist = (List<CommonBridge.CapturedSubImage>)Convert.ChangeType(reflist, typeof(List<CommonBridge.CapturedSubImage>));
                    items = subimagelist.Count;
                }
                else if (reflist.GetType() == typeof(List<CommonBridge.Signal>))
                {
                    siglist = (List<CommonBridge.Signal>)Convert.ChangeType(reflist, typeof(List<CommonBridge.Signal>));
                    items = siglist.Count;
                }
                else if (reflist.GetType() == typeof(List<CommonBridge.Nucleus>))
                {
                    nucleulist = (List<CommonBridge.Nucleus>)Convert.ChangeType(reflist, typeof(List<CommonBridge.Nucleus>));
                    items = nucleulist.Count;
                }
                else 
                {
                    throw new Exception("ProcessList - not supported type");
                }

                if (items <= 0) return -1;
                
                for (i = 0; i < items; i++)
                {
                    if (ProcessType == ListProcessType.TYPE_INSERT)
                    {                        

                        if (patlist != null)
                        {
                            // try to insert
                            if (InsertOne(patlist[i]) > -1)
                                ok++;
                        }
                        else if (examlist != null)
                        {
                            // try to insert
                            if (InsertOne(examlist[i]) > -1)
                                ok++;
                        }
                        else if (imagelist != null)
                        {
                            // try to insert
                            if (InsertOne(imagelist[i]) > -1)
                                ok++;
                        }
                        else if (subimagelist != null)
                        {
                            // try to insert
                            if (InsertOne(subimagelist[i]) > -1)
                                ok++;
                        }
                        else if (siglist != null)
                        {
                            // try to insert
                            if (InsertOne(siglist[i]) > -1)
                                ok++;
                        }
                        else if (nucleulist != null)
                        {
                            // try to insert
                            if (InsertOne(nucleulist[i]) >-1)
                                ok++;
                        }  
                    }
                        
                    else if (ProcessType == ListProcessType.TYPE_UPDATE)
                    {
                        if (patlist != null)
                        {
                            // try to update
                            if (UpdateOne(patlist[i])>0)
                                ok++;
                        }
                        else if (examlist != null)
                        {
                            // try to update
                            if (UpdateOne(examlist[i])>0)
                                ok++;
                        }

                        else if (imagelist != null)
                        {
                            // try to update
                            if (UpdateOne(imagelist[i]) > 0)
                                ok++;
                        }
                        else if (subimagelist != null)
                        {
                            // try to update
                            if (UpdateOne(subimagelist[i]) > 0)
                                ok++;
                        }
                        else if (siglist != null)
                        {
                            // try to update
                            if (UpdateOne(siglist[i])>0)
                                ok++;
                        }
                        else if (nucleulist != null)
                        {
                            // try to update
                            if (UpdateOne(nucleulist[i]) > 0)
                                ok++;
                        }  
                    }
                }                 
            }
            catch (Exception ex)
            {
                Console.WriteLine("Error: {0}", ex.Message);
                return -1;
            }

            return ok;
        }

        #endregion
        
        #region CREATE TABLES

        public Boolean CreateTable(TableEnum table_enum)
        {
            Boolean tf = false;
            String query = null;

            if (table_enum == TableEnum.TABLE_PATIENT)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `P_ID` int(11) NOT NULL AUTO_INCREMENT,
  `PIN` varchar(12) COLLATE cp1250_bin NOT NULL,
  `name` varchar(20) COLLATE cp1250_bin NOT NULL,
  `surname` varchar(20) COLLATE cp1250_bin NOT NULL,
  `datetime_insert` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `datetime_update` timestamp NULL DEFAULT NULL,
  `comment` text COLLATE cp1250_bin,
  `state` tinyint(4) NOT NULL DEFAULT '0' COMMENT '0 - visible, 1 - deleted, 2 - absolute deleted',
  PRIMARY KEY (`P_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=15 DEFAULT CHARSET=cp1250 COLLATE=cp1250_bin;

";
            }

            else if (table_enum == TableEnum.TABLE_EXAMINATION)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `E_ID` int(11) NOT NULL AUTO_INCREMENT,
  `P_ID` int(11) NOT NULL,
  `slide` varchar(20) COLLATE cp1250_bin NOT NULL,
  `datetime_insert` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `datetime_update` timestamp NULL DEFAULT NULL,
  `subdir` varchar(45) COLLATE cp1250_bin DEFAULT NULL,
  `fluorophore1` varchar(16) COLLATE cp1250_bin DEFAULT NULL,
  `fluorophore2` varchar(16) COLLATE cp1250_bin DEFAULT NULL,
  `fluorophore3` varchar(16) COLLATE cp1250_bin DEFAULT NULL,
  `comment` text COLLATE cp1250_bin,
  `result` tinyint(4) NOT NULL DEFAULT '0',
  `result_string` varchar(150) COLLATE cp1250_bin DEFAULT NULL,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`E_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=12 DEFAULT CHARSET=cp1250 COLLATE=cp1250_bin;
";
            }

            else if (table_enum == TableEnum.TABLE_IMAGES)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `I_ID` int(11) NOT NULL AUTO_INCREMENT,
  `E_ID` int(11) NOT NULL,
  `filename` varchar(32) COLLATE cp1250_bin NOT NULL,
  `stage_position_x` int(11) NOT NULL,
  `stage_position_y` int(11) NOT NULL,
  `stage_position_z` int(11) NOT NULL,
  `datetime_insert` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `datetime_update` timestamp NULL DEFAULT NULL,
  `done` smallint(6) NOT NULL,
  `state` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`I_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=325 DEFAULT CHARSET=cp1250 COLLATE=cp1250_bin;

";
            }
            else if (table_enum == TableEnum.TABLE_SUBIMAGES)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `SI_ID` int(11) NOT NULL AUTO_INCREMENT,
  `I_ID` int(11) NOT NULL,
  `filename` varchar(45) DEFAULT NULL,
  `fluoro_KEY_OLD` varchar(45) DEFAULT NULL,
  `light_ID` tinyint(4) NOT NULL DEFAULT '0',
  `gain` int(11) DEFAULT '0',
  `exposure` int(11) DEFAULT '0',
  `zoom` int(11) DEFAULT NULL,
  `datetime_insert` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `datetime_update` timestamp NULL DEFAULT NULL,
  `done` int(11) DEFAULT '0',
  `state` tinyint(4) NOT NULL DEFAULT '0',
  PRIMARY KEY (`SI_ID`),
  UNIQUE KEY `SI_ID_UNIQUE` (`SI_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=1082 DEFAULT CHARSET=utf8 COMMENT='subimages for images';

";
            }

            else if (table_enum == TableEnum.TABLE_NUCLEUS)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `N_ID` int(11) NOT NULL AUTO_INCREMENT,
  `E_ID` int(11) NOT NULL DEFAULT '1',
  `I_ID` int(11) NOT NULL,
  `SI_ID` int(11) NOT NULL,
  `area` int(11) NOT NULL,
  `intensity` int(11) NOT NULL,
  `eccentricity` int(11) NOT NULL,
  `x` int(11) NOT NULL,
  `y` int(11) NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `S_X` int(11) NOT NULL,
  `S_Y` int(11) NOT NULL,
  `expert` int(11) DEFAULT '4',
  `dist` int(11) NOT NULL DEFAULT '-1',
  `min_sig_area` int(11) NOT NULL DEFAULT '0',
  `max_sig_area` int(11) NOT NULL DEFAULT '0',
  `min_sig_inten` int(11) NOT NULL DEFAULT '0',
  `max_sig_inten` int(11) NOT NULL DEFAULT '0',
  `min_sig_dist` int(11) NOT NULL DEFAULT '0',
  `max_sig_dist` int(11) NOT NULL DEFAULT '0',
  `nucleuscol` varchar(45) COLLATE cp1250_bin DEFAULT NULL,
  `state` int(11) NOT NULL,
  PRIMARY KEY (`N_ID`),
  UNIQUE KEY `N_ID_UNIQUE` (`N_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=213 DEFAULT CHARSET=cp1250 COLLATE=cp1250_bin;

";
            }
            else if (table_enum == TableEnum.TABLE_SIGNALS)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `S_ID` int(11) NOT NULL AUTO_INCREMENT,
  `N_ID` int(11) NOT NULL COMMENT 'nucleu ID',
  `I_ID` int(11) NOT NULL,
  `SI_ID` int(11) NOT NULL DEFAULT '0',
  `area` int(11) NOT NULL,
  `intensity` int(11) NOT NULL,
  `dist_border` int(11) NOT NULL,
  `x` int(11) NOT NULL,
  `y` int(11) NOT NULL,
  `width` int(11) NOT NULL,
  `height` int(11) NOT NULL,
  `type` varchar(1) COLLATE cp1250_bin NOT NULL,
  PRIMARY KEY (`S_ID`)
) ENGINE=MyISAM AUTO_INCREMENT=233 DEFAULT CHARSET=cp1250 COLLATE=cp1250_bin;


";
            }
            else if (table_enum == TableEnum.TABLE_DEMO)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `ID` int(11) NOT NULL AUTO_INCREMENT,
  `col1` int(11) DEFAULT NULL,
  `col2` int(11) DEFAULT NULL,
  `table_democol` varchar(45) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='jen demo tabulka - pro testovani create, exist apod.';

";
            }
            else if (table_enum == TableEnum.TABLE_FLUOROPHORE)
            {
                query = @"
CREATE TABLE " + GetTableFullName(table_enum) + @" (
  `F_KEY` varchar(16) NOT NULL,
  `name` varchar(45) NOT NULL,
  PRIMARY KEY (`F_KEY`),
  UNIQUE KEY `KEY_UNIQUE` (`F_KEY`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8 COMMENT='database of fluorophores';

";
            }

            if (query != null)
            {
                tf = CreateTable(query);
                return tf;
            }
            else
            {
                System.Windows.Forms.MessageBox.Show("insert query neni definovan");
                tf = false;
            }
            return tf;
        }
        #endregion

        #region CREATE VIEWS

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public bool CreateViews_Examination()
        {
            // GetTableViewName_Patient
            String query = @"
DROP VIEW IF EXISTS " + GetTableViewName_Examination() + @";             
CREATE VIEW " + GetTableViewName_Examination() + @" AS
SELECT
	e.*,
	count(i.E_ID) AS count_images
FROM 
	examination AS e
LEFT JOIN  images AS i ON i.E_ID = e.E_ID
GROUP BY e.E_ID
;
            ";
            Int32 count = ExecuteNonQuery(query);
            return (count >= 0) ? true : false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <returns></returns>
        public bool CreateViews_Patient()
        {
            String query = @"
DROP VIEW IF EXISTS " + GetTableViewName_Patient() + @";             
CREATE VIEW " + GetTableViewName_Patient() + @" AS
SELECT
	p.*,
	count(e.P_ID) AS count_exams
FROM 
	patient AS p
LEFT JOIN  examination AS e ON e.P_ID = p.P_ID 
GROUP BY p.P_ID;
            ";
            Int32 count = ExecuteNonQuery(query);
            return (count >= 0) ? true : false;
        }

        /// <summary>
        /// 
        /// </summary>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        public bool CreateViews(int E_ID)
        {
            String query = "DROP VIEW IF EXISTS images_view; DROP VIEW IF EXISTS signals_view;  DROP VIEW IF EXISTS nucleus_view; CREATE VIEW nucleus_view AS SELECT * FROM nucleus WHERE nucleus.E_ID = " + E_ID.ToString() + "; CREATE VIEW images_view AS SELECT * FROM images WHERE images.E_ID = " + E_ID.ToString() + "; CREATE VIEW signals_view AS SELECT signals.* FROM signals JOIN nucleus ON nucleus.N_ID=signals.N_ID WHERE nucleus.E_ID = " + E_ID.ToString();
            Int32 count = ExecuteNonQuery(query);
            return (count >= 0) ? true : false;
        }

        #endregion CREATE VIEWS
        
        #region DELETE ROWS


        /// <summary>
        /// Delete rows of signals with this signal S_ID.
        /// </summary>
        /// <param name="S_ID">Signal ID</param>
        /// <returns></returns>
        public Int32 HardDeleteOneSignal(Int32 S_ID)
        { 
            int rows = DeleteRows(GetTableFullName_Signals(), "S_ID = "+S_ID.ToString());
            return rows;               
        }

        /// <summary>
        /// Delete rows of signals with nucleus N_ID.
        /// </summary>
        /// <param name="N_ID"></param>
        /// <returns></returns>
        public Int32 HardDeleteSignalsOfNucleus(Int32 N_ID)
        {
            int rows = DeleteRows(GetTableFullName_Signals(), "N_ID = "+N_ID.ToString());
            return rows;
        }

        public Int32 HardDeleteSignalsOfImage(Int32 I_ID)
        {
            int rows = DeleteRows(GetTableFullName_Signals(), "I_ID = " + I_ID.ToString());
            return rows;
        }

        public Int32 HardDeleteOneNucleus(Int32 N_ID)
        {
            int rows = DeleteRows(GetTableFullName_Nucleus(), "N_ID = " + N_ID.ToString());
            return rows;
        }

        public Int32 HardDeleteNucleusOfImage(Int32 I_ID)
        {
            int rows = DeleteRows(GetTableFullName_Nucleus(), "I_ID = " + I_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="SI_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteOneSubimage(Int32 SI_ID)
        {
            int rows = DeleteRows(GetTableFullName_SubImages(), "SI_ID = " + SI_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="I_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteSubImagesOfImage(Int32 I_ID)
        {
            int rows = DeleteRows(GetTableFullName_SubImages(), "I_ID = " + I_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="I_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteOneImage(Int32 I_ID)
        {
            int rows = DeleteRows(GetTableFullName_Images(), "I_ID = " + I_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteImagesOfExamination(Int32 E_ID)
        {
            int rows = DeleteRows(GetTableFullName_Images(), "E_ID = " + E_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteOneExamination(Int32 E_ID)
        {
            int rows = DeleteRows(GetTableFullName_Examination(), "E_ID = " + E_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="P_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteExaminationOfPatient(Int32 P_ID)
        {
            int rows = DeleteRows(GetTableFullName_Examination(), "P_ID = " + P_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="P_ID"></param>
        /// <returns></returns>
        private Int32 HardDeleteOnePatient(Int32 P_ID)
        {
            int rows = DeleteRows(GetTableFullName_Patient(), "P_ID = " + P_ID.ToString());
            return rows;
        }

        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="I_ID"></param>
        /// <returns></returns>
        private Int32 CompleteHardDeleteOneImage(Int32 I_ID) 
        {
            Int32 sum = 0;
            sum += HardDeleteOneImage(I_ID);
            sum += HardDeleteSubImagesOfImage(I_ID);
            sum += HardDeleteNucleusOfImage(I_ID);
            sum += HardDeleteSignalsOfImage(I_ID);
            return sum;
        }
                
        /// <summary>
        /// DONT USE HARD DELETE
        /// </summary>
        /// <param name="E_ID"></param>
        /// <returns></returns>
        private Int32 CompleteHardDeleteOneExamination(Int32 E_ID)
        {
            Int32 sum = 0;
            List<int> retlist = GetImagesID(E_ID);

            for (int i = 0; i < retlist.Count; i++) 
            {
                sum += CompleteHardDeleteOneImage(retlist[i]);
            }

            sum += HardDeleteOneExamination(E_ID);
            LogUnit.LogDebug(ModuleName, "CompleteHardDeleteOneExamination: deleted " + sum + " items of examination ID " + E_ID.ToString());
            return sum;
        }
        

        public Int32 SoftDeleteOneSubimage(Int32 SI_ID) 
        {
            int rows = SetStateSubImage(SI_ID, 1);
            return rows;
        }

        public Int32 SoftDeleteSubImagesOfImage(Int32 I_ID)
        {
            int rows = UpdateRows(GetTableFullName_SubImages(), "I_ID = " + I_ID.ToString(), "valid='1'");
            return rows;
        }

        public Int32 SoftDeleteOneImage(Int32 I_ID)
        {
            int rows = SetStateImage(I_ID, 1);
            return rows;
        }

        public Int32 SoftDeleteImagesOfExamination(Int32 E_ID)
        {
            int rows = UpdateRows(GetTableFullName_Images(), "E_ID = " + E_ID.ToString(), "valid='1'");
            return rows;
        }

        public Int32 SoftDeleteOneExamination(Int32 E_ID)
        {
            int rows = SetStateExamination(E_ID, 1);
            return rows;
        }

        public Int32 SoftDeleteExaminationsOfPatient(Int32 P_ID)
        {
            int rows = UpdateRows(GetTableFullName_Examination(), "P_ID = " + P_ID.ToString(), "valid='1'");
            return rows;
        }

        public Int32 SoftDeleteOnePatient(Int32 P_ID)
        {
            int rows = SetStatePatient(P_ID, 1);
            return rows;
        }
         
        public Int32 CompleteSoftDeleteOnePatient(Int32 P_ID)
        {
            Int32 sum = 0;
            List<int> retlist = GetExaminationsID(P_ID);

            for (int i = 0; i < retlist.Count; i++)
            {
                sum += CompleteSoftDeleteOneExamination(retlist[i]);
            }

            sum += SoftDeleteOnePatient(P_ID);

            LogUnit.LogDebug(ModuleName, "CompleteSoftDeleteOnePatient: deleted " + sum + " items of patient ID " + P_ID.ToString());
            return sum;
        }

        public Int32 CompleteSoftDeleteOneExamination(Int32 E_ID)
        {
            Int32 sum = 0;
            List<int> retlist = GetImagesID(E_ID);

            for (int i = 0; i < retlist.Count; i++)
            {
                sum += CompleteSoftDeleteOneImage(retlist[i]);
            }
            
            sum += SoftDeleteOneExamination(E_ID);

            LogUnit.LogDebug(ModuleName, "CompleteSoftDeleteOneExamination: deleted " + sum + " items of examination ID " + E_ID.ToString());
            return sum;
        }

        public Int32 CompleteSoftDeleteOneImage(Int32 I_ID)
        {
            Int32 sum = 0;
            // soft delete of this image
            sum += SoftDeleteOneImage(I_ID);

            // soft delete of subimages
            sum += SoftDeleteSubImagesOfImage(I_ID);

            // hard delete nucleus
            sum += HardDeleteNucleusOfImage(I_ID);

            // hard delete signals
            sum += HardDeleteSignalsOfImage(I_ID);
            return sum;
        }
        

        #endregion

        #region SET STATE

        public Int32 SetStateSubImage(Int32 SI_ID, Int32 state)
        {
            if (!CheckConnection()) return 0;
            if (SI_ID <= 0) return 0;

            String table_name = GetTableFullName_SubImages();
            String values = "";              
            values += "state='" + state.ToString() + "',";
            values += "datetime_update=NOW()";
            String where = "SI_ID = '" + SI_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, values);
            return rows_count;
        }

        public Int32 SetStateImage(Int32 I_ID, Int32 state)
        {
            if (!CheckConnection()) return 0;
            if (I_ID <= 0) return 0;

            String table_name = GetTableFullName_Images();
            String values = "";
            values += "state='" + state.ToString() + "',";
            values += "datetime_update=NOW()";
            String where = "I_ID = '" + I_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, values);
            return rows_count;
        }

        public Int32 SetStateExamination(Int32 E_ID, Int32 state)
        {
            if (!CheckConnection()) return 0;
            if (E_ID <= 0) return 0;

            String table_name = GetTableFullName_Examination();
            String values = "";
            values += "state='" + state.ToString() + "',";
            values += "datetime_update=NOW()";
            String where = "E_ID = '" + E_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, values);
            return rows_count;
        }

        public Int32 SetStatePatient(Int32 P_ID, Int32 state)
        {
            if (!CheckConnection()) return 0;
            if (P_ID <= 0) return 0;

            String table_name = GetTableFullName_Patient();
            String values = "";
            values += "state='" + state.ToString() + "',";
            values += "datetime_update=NOW()";
            String where = "P_ID = '" + P_ID + "'";

            Int32 rows_count = UpdateRows(table_name, where, values);
            return rows_count;
        }
         
        #endregion


        /// <summary>
        /// Select all images ID from one examination with PE_ID.
        /// </summary>
        /// <param name="E_ID">Examination ID</param>
        /// <returns>List with images ID.</returns>
        public List<int> GetImagesID(Int32 E_ID)
        {
            List<int> retlist = null;
            String query = "SELECT I_ID FROM " + GetTableFullName_Images() + " WHERE E_ID = " + E_ID;
            retlist = GetQueryIntValues(query);
            return retlist;
        }

        /// <summary>
        /// Select all examinations ID from one patient with P_ID.
        /// </summary>
        /// <param name="P_ID">Patient ID</param>
        /// <returns>List with examinations ID.</returns>
        public List<int> GetExaminationsID(Int32 P_ID)
        {
            List<int> retlist = null;
            String query = "SELECT E_ID FROM " + GetTableFullName_Examination() + " WHERE P_ID = '" + P_ID + "'";
            retlist = GetQueryIntValues(query);
            return retlist;
        }

        /// <summary>
        /// Select all subimages ID from one image with I_ID.
        /// </summary>
        /// <param name="O_ID">Image ID</param>
        /// <returns>List with subimages ID.</returns>
        public List<int> GetSubimagesID(Int32 I_ID)
        {
            List<int> retlist = null;
            String query = "SELECT E_ID FROM " + GetTableFullName_SubImages() + " WHERE I_ID = '" + I_ID + "'";
            retlist = GetQueryIntValues(query);
            return retlist;
        }


        public Boolean ExistTable(TableEnum table_enum)
        {
            String table_name = "";
            table_name = GetTableName(table_enum);           
            return ExistTable(table_name);
        }

        public Boolean DropTable(TableEnum table_enum)
        {
            String table_name = "";
            table_name = GetTableFullName(table_enum);
            return DropTable(table_name);
        }

        public Boolean ClearTable(TableEnum table_enum)
        {
            String table_name = "";
            table_name = GetTableFullName(table_enum);
            return ClearTable(table_name);
        }


        // MARKETA ?????

        public AxesRange GetAxesRange()
        {
            String command = "SELECT MIN(nucleus_view.area), MAX(nucleus_view.area), MIN(nucleus_view.intensity), MAX(nucleus_view.intensity), MIN(nucleus_view.eccentricity), MAX(nucleus_view.eccentricity), " +
                             "MIN(signals_view.area), MAX(signals_view.area), MIN(signals_view.intensity), MAX(signals_view.intensity), MIN(signals_view.dist_border), MAX(signals_view.dist_border), MIN(nucleus_view.dist), MAX(nucleus_view.dist) " +
                             "FROM nucleus_view JOIN signals_view ON nucleus_view.N_ID = signals_view.N_ID WHERE nucleus_view.valid = 1";

            AxesRange returnRange = new AxesRange(-1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1, -1);

            lock (mLockReader)
            {             
                MySqlDataReader db_reader = GetQueryReader(command);

                if (db_reader == null) 
                { 
                    return returnRange; 
                }
                try
                {


                    db_reader.Read();

                    // FIT
                    returnRange = new AxesRange(Convert.ToSingle(db_reader[0]), Convert.ToSingle(db_reader[1]),
                                                Convert.ToSingle(db_reader[2]), Convert.ToSingle(db_reader[3]),
                                                Convert.ToSingle(db_reader[4]), Convert.ToSingle(db_reader[5]),
                                                          Convert.ToSingle(db_reader[6]), Convert.ToSingle(db_reader[7]),
                                                          Convert.ToSingle(db_reader[8]), Convert.ToSingle(db_reader[9]),
                                                          Convert.ToSingle(db_reader[10]), Convert.ToSingle(db_reader[11]),
                                                          Convert.ToSingle(db_reader[12]), Convert.ToSingle(db_reader[13]));
                }
                catch
                {
                }
                finally 
                {
                    db_reader.Close();
                }
                
            }
            return returnRange;
        }

        public float[] GetHistogram(String what)
        {

            String command = "SELECT " + what + " FROM nucleus_view JOIN signals_view ON nucleus_view.N_ID = signals_view.N_ID WHERE nucleus_view.valid = 1";
            
            if (what.Equals("nucleus_view.dist"))
                command = command + " && nucleus_view.dist <> 0";

            List<float> values = new List<float>();
            int size = 0;

            lock(mLockReader)
            {
            
                MySqlDataReader db_reader = GetQueryReader(command);

                if (db_reader == null) 
                { 
                    return null; 
                }

                try
                {                    

                    while (db_reader.Read())
                    {
                        values.Add(Convert.ToSingle(db_reader[0]));
                        size++;
                    }
                }
                catch 
                { 
                }
                finally
                {            
                    db_reader.Close();
                }
            }

            // copy to array
            float[] return_values = new float[size];
            for (int i = 0; i < size; i++)
            {
                return_values[i] = values[i];
            }
            
            return return_values;
        }


        /*
         private static string GetRangeQuery(AxesRange range)
        {
            return "nucleus_view.area >= " + (range.min_nucleu_area - 0.001).ToString() + " AND nucleus_view.area <= " + (range.max_nucleu_area + 0.001).ToString() +
                     " AND nucleus_view.intensity >= " + (range.min_nucleu_intensity - 0.001).ToString() + " AND nucleus_view.intensity <= " + (range.max_nucleu_intensity + 0.001).ToString() +
                     " AND nucleus_view.eccentricity >= " + (range.min_nucleu_eccentricity - 0.001).ToString("F") + " AND nucleus_view.eccentricity <= " + (range.max_nucleu_eccentricity + 0.001).ToString("F") +
                     " AND ((nucleus_view.dist >= " + (range.min_signal_signal_dist - 0.001).ToString() + " AND nucleus_view.dist <= " + (range.max_signal_signal_dist + 0.001).ToString() + ") OR nucleus_view.dist = 0)" +
                     " AND nucleus_view.min_sig_area >= " + (range.min_signal_area - 0.001).ToString() + " AND nucleus_view.max_sig_area <= " + (range.max_signal_area + 0.001).ToString() +
                     " AND nucleus_view.min_sig_inten >= " + (range.min_signal_intensity - 0.001).ToString() + " AND nucleus_view.max_sig_inten <= " + (range.max_signal_intensity + 0.001).ToString() +
                     " AND nucleus_view.min_sig_dist >= " + (range.min_signal_border_dist - 0.001).ToString() + " AND nucleus_view.max_sig_dist <= " + (range.max_signal_border_dist + 0.001).ToString();

        
        }

        public List<int>[] GetCellsIDs(AxesRange range)
        {
            String XXids = "SELECT nucleus_view.N_ID FROM nucleus_view WHERE nucleus_view.S_X = 2 AND nucleus_view.S_Y = 0 AND " + GetRangeQuery(range);
            String XYids = "SELECT nucleus_view.N_ID FROM nucleus_view WHERE nucleus_view.S_X = 1 AND nucleus_view.S_Y = 1 AND " + GetRangeQuery(range);
            String Xids = "SELECT nucleus_view.N_ID FROM nucleus_view WHERE nucleus_view.S_X = 1 AND nucleus_view.S_Y = 0 AND " + GetRangeQuery(range);
            String BADids = "SELECT nucleus_view.N_ID FROM nucleus_view WHERE (NOT (" + GetRangeQuery(range) + ") OR nucleus_view.valid = 0)";

            List<int>[] ret_lists = new List<int>[4];

            ret_lists[0] = GetQueryIntValues(BADids);
            ret_lists[1] = GetQueryIntValues(Xids);
            ret_lists[2] = GetQueryIntValues(XXids);
            ret_lists[3] = GetQueryIntValues(XYids);

            return ret_lists;
        }
        */
        public Int32 CountAllPatientOnView(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableViewName_Patient();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllExaminationOnView(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableViewName_Examination();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }

        public Int32 CountAllImagesOnView(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableViewName_Images();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }
      
        public Int32 CountAllNucleusOnView(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableViewName_Nucleus();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }
        
        public Int32 CountAllSignalsOnView(String where)
        {
            Int32 count = 0;
            // query
            String query = "SELECT COUNT(*) FROM " + GetTableViewName_Signals();

            if (where != null && where.Length > 0)
                query += " WHERE " + where;

            // get count
            return count = GetQueryIntValue(query);
        }


        //UPDATE nucleus_view
        //SET expert = CASE N_ID
        //                 WHEN 151 THEN 4
        //                 WHEN 152 THEN 4                     
        //               END
        //WHERE N_ID BETWEEN 151 AND 153
        public Int32 UpdateNucleusByExpert(List<Nucleus> nucleus)
        {
            // query

            String query = "UPDATE " + GetTableViewName_Nucleus() + " SET expert = CASE N_ID";


            foreach (Nucleus n in nucleus)
            {
                query += " WHEN " + n.N_ID + " THEN " + (int)n.expert;
            }

            String inSet = "(" + string.Join(",", nucleus.Select(x => x.N_ID).ToArray()) + ")";

            query += " END WHERE N_ID IN " + inSet;

            Console.WriteLine(query);

            return ExecuteNonQuery(query);

        }

    }
}
