/****************************************************************************
 * FileName:		protocol.h
 * Author:              David Danaj
 * Project:             IOT sensors at FIT
 ***************************************************************************/
#ifndef PROTOCOL_H
#define	PROTOCOL_H

/**
 * Default sleep time set before receiving msg from server
 */
#define DEFAULT_SLEEP           10

/**
 * pocet bytu ktere zabira komunikacni protokol ve zprave
 * Payload[0] - init value
 * Payload[1] - protocol version (upper Byte)
 * Payload[2] - protocol version (lower Byte)
 * Payload[3] - battery (upper Byte)
 * Payload[4] - battery (lower Byte)
 * Payload[5] - pairs
 * Payload[6] - reserved (padding Byte)
 *
 * Payload[7+] - data
 */
#define IHA_PROTOCOL_HEADER_SIZE 7



/**
 * Version of used protocol
 */
#define VERSION       0x0001
/**
 * PAN coordinator address in a network
 */
#define PAN           0x0000

#define TEMP          0x00
#define HUMIDITY      0x01
#define PRESSURE      0x02
#define SWITCH_SENSOR 0x03
#define SWITCH_ACTOR  0x04
#define LIGHT         0x05
#define NOISE         0x06
#define EMISSIONS     0x07
#define ACCELEROMETER 0x08

#define TEST          0x21
#define CHANGE_TO_WORK 0x3B
#define CHANGE_TO_JOIN 0x3C
/**
 * value representing message from server
 */
#define SERVER_MSG    0x3D
#define INDIRECT_REQUEST 0x3E
#define PING          0x3F

#define HAVE_MSG      0x04
#define ADDR_INDEX    2

// zprava/odpoved pro uvedeni senzoru do tovarniho nastaveni
#define FACTORY_RESET 0x30
#define FACTORY_RESET_RESPONSE 0x31


//debug request
#define DEBUG_REQUEST_TREE  0x51
#define DEBUG_REQUEST_ROUTING  0x52
#define DEBUG_REQUEST_CONNECTION  0x53
#define DEBUG_REQUEST_ADDRESSES  0x54
#define DEBUG_REQUEST_NEIGHBOR  0x55
#define DEBUG_REQUEST_FAILURE  0x56
//debug response
#define DEBUG_RESPONSE_TREE  0x41
#define DEBUG_RESPONSE_ROUTING  0x42
#define DEBUG_RESPONSE_CONNECTION 0x43
#define DEBUG_RESPONSE_ADDRESSES  0x44
#define DEBUG_RESPONSE_NEIGHBOR  0x45
#define DEBUG_RESPONSE_FAILURE  0x46

#define CALIBRATE_PACKET 0x60

/**
 * constant for multiplying float numbers before converting to float
 */
#define FLOAT_TO_LONG 100

/**
 * index in a packet informing about number of values in the packet
 */
#if defined(NWK_ROLE_COORDINATOR) && (MY_PAN_ID != 0xFFFF)
    #define COUNT_INDEX   4 + PAYLOAD_START
#else
    #define COUNT_INDEX   5 + PAYLOAD_START
#endif
/**
 * write data to packet at specified index
 */
#define MiApp_WriteDataIndex(i, a) TxBuffer[i] = a


void HandleMessage (BYTE code);
void HandleMessagePepa (BYTE code);
void HandleMessageDavid(BYTE code);
void HandleMessagePalo (BYTE code);
void HandleMessageTomas(BYTE code);
void HandleMessageMatej(BYTE code);
void HandleMessageOther(BYTE code);
BOOL isDebugMessage(BYTE code);
void HandleMessageDebug(BYTE code);

// recieve msg if available
BYTE GetMsg(void);
// Create new packet from sensor to PAN-coord.
void CreatePacketSensor(BYTE code, WORD_VAL *battery);
// Create packet from PAN-coord. to sensor
void CreatePacketAdapter(BYTE code, BOOL ok, WORD time); // byte code for msg from server - SERVER_MSG
// add combination of "type:value" to packet
BOOL AddValueToPacket (BYTE type, LONG value);
// Function to verify if device is connected to correct network
BOOL Ping(BOOL pan);
// Answer for PING request
BOOL Pong(void);

#if defined(NWK_ROLE_COORDINATOR) && (MY_PAN_ID != 0xFFFF)  // only non PAN coordinators has PANID 0xFFFF
void PrintPacket(void);
#endif
BYTE findSender(void);

#endif	/* PROTOCOL_H */

