/****************************************************************************
 * FileName:		    protocol.c
 * Project:         IOT sensors at FIT
 ***************************************************************************/

#include "WirelessProtocols/MCHP_API.h"
#include "WirelessProtocols/MiWiPRO/MiWiPRO.h"
#include "ConfigApp.h"
#include "iot/Protocol.h"
#include "iot/SleepLib.h"
#include "iot/Join.h"
#include "iot/signal_calibrate.h"
#include "WirelessProtocols/NVM.h"
#include "iot/Utils.h"
#include "Transceivers/Security.h"
#include "debug.h"

extern char printBuf[32];
#if MY_PAN_ID == 0xFFFF			// coordinatory nepouzivaji tuto promennou pro uspani ale pro zaslani dat (pokud obsahuji senzory)
extern WORD_VAL seconds;
#endif

#if MY_PAN_ID == 0xFFFF && defined(NWK_ROLE_COORDINATOR)
extern BOOL newSleepTime;
#endif

extern BYTE lastChannel;
extern WORD_VAL lastPANID;
//extern BOOL timeout;		// presunuto do hlavickoveho souboru utils.h
extern INDIRECT_MESSAGE indirectMessages[INDIRECT_MESSAGE_SIZE];

//pre debug
extern BYTE myLongAddress[];
extern BYTE ConnMode;
#ifdef NWK_ROLE_COORDINATOR
    extern BYTE RoutingTable[NUM_COORDINATOR / 8];
    extern BYTE FamilyTree[NUM_COORDINATOR];
    extern BYTE RouterFailures[NUM_COORDINATOR];
    extern BYTE NeighborRoutingTable[NUM_COORDINATOR][NUM_COORDINATOR/8];
#endif

/**
 * reading position in data payload
 * starts at 7
 */
//BYTE position = 7;

extern BOOL timeout;

/**
 * number of values transfered
 */
BYTE counter = 0;

/**
 * get LONG value from received packet payload
 */
LONG getValue(BYTE *payloadPos);

/**
 * function for handling incoming messages and do releated actions
 */
void HandleMessage(BYTE code)
{
    // save seconds here instead of HandleMessageOther() for visibility
#if MY_PAN_ID == 0xFFFF
    if (code == SERVER_MSG)
    {
        WORD_VAL new_seconds;
#ifdef NWK_ROLE_COORDINATOR
		newSleepTime = TRUE;
#endif

        new_seconds.v[1] = rxMessage.Payload[2]; // HB
		new_seconds.v[0] = rxMessage.Payload[3]; // LB

		PRINT("Sleep PRE: %u\n", seconds.Val);
		if(seconds.Val == 0)
			seconds.Val = 60;
        if (new_seconds.Val != seconds.Val)
        {
            seconds.Val = new_seconds.Val;
            nvmPutSleepSeconds( seconds.v );
            PRINT("New sleep time: %u\n", seconds.Val);
        }
    }
#endif

    if (code < 0x20)
        HandleMessagePepa(code);
    else if (code < 0x40)
        HandleMessageDavid(code);
    else if (code < 0x60) {
        HandleMessageDebug(code);
    }
    else if (code < 0x80)
        HandleMessageTomas(code);
    else if (code < 0x60)
        HandleMessageMatej(code);
    else
        HandleMessageOther(code);

    return;
}

void HandleMessagePepa (BYTE code)
{}

/**
 * functions for handling SERVER_MSG, PING, INDIRECT_REQUEST
 * printing information on LCD/terminal
 */
void HandleMessageDavid(BYTE code)
{
    extern MAC_RECEIVED_PACKET MACRxPacket;
    extern volatile RX_PACKET RxPacket[BANK_SIZE];
    int bank = 0;
    // if PAN-coord
    #if MY_PAN_ID != 0xFFFF
    LONG value = 0;
    BYTE i, count;
    WORD_VAL batt;
    BYTE position = IHA_PROTOCOL_HEADER_SIZE; // reset position with every new packet

    if (code == CHANGE_TO_WORK)
        PRINT("Change to work packet \n");
    if (code == CHANGE_TO_JOIN)
        PRINT("Change to join packet \n");
    #endif
    if(code == TEST)
    {
        #if MY_PAN_ID == 0xFFFF
            PRINT("It works :)", 0);
        #endif
    }
#ifdef NWK_ROLE_COORDINATOR
    else if (code == PING)
    {
        #if MY_PAN_ID != 0xFFFF
            PRINT("Pingujem...");

        #else
            PRINT("Pingujem...", 0);
        #endif
        if (Pong())
        {
            #if MY_PAN_ID != 0xFFFF
                PRINT("Pinged");
            #else
               PRINT("Pinged", 0);
            #endif
        }
        else
        {
            #if MY_PAN_ID != 0xFFFF
                PRINT("NOT pinged");
            #else
                PRINT("NOT pinged!!", 0);
            #endif
        }
    }
#endif
    #if MY_PAN_ID != 0xFFFF
    else if (code == INDIRECT_REQUEST)
    {
        for (i = 0; i < 250; i++)
        {
            MiApp_DiscardMessage();
            MiWiPROTasks();
            DelayMs(1);
        }
        if (MiApp_EstablishConnection(0xFF, CONN_MODE_INDIRECT) == 0xFF)
            PRINT("Indirect connection FAILED");
        else
            PRINT("Indirect connection ESTABLISHED");
    }

    #endif
    #if MY_PAN_ID == 0xFFFF
        if (code == CHANGE_TO_JOIN)
        {
            // remember current settings
            lastChannel = currentChannel;
            lastPANID.Val = myPANID.Val;

            // change to join network settings
            myPANID.Val = JOINING_PANID;
            MiApp_SetChannel(JOINING_CHANNEL);
            ChangePANIDs(myPANID.Val);
            setDefaultKey();
            LED0 = 1;
            LED1 = 0;

            PRINT("Channel: %d", currentChannel);

        }
        if (code == CHANGE_TO_WORK)
        {
            BYTE i;
            // need to remove device?
            if (rxMessage.Payload[1] == 1)
            {
                BYTE device_index = 0xFF;
                device_index = findInTable();
                if (device_index != 0xFF)
                    MiApp_RemoveConnection(device_index);
            }
            
            myPANID.Val = lastPANID.Val;         
            MiApp_SetChannel(lastChannel);
            ChangePANIDs(myPANID.Val);
            nvmGetSecurityKey( securityKey );
            LED0 = 0;
            LED1 = 1;

            PRINT("Channel: %d", currentChannel);
        }


    #endif
}
void HandleMessagePalo (BYTE code)
{}
/**
 * Handles calibrating radio power
 */
void HandleMessageTomas(BYTE code)
{
    if (code == CALIBRATE_PACKET)
        signal_calibrate_response(TRUE);
}
void HandleMessageMatej(BYTE code)
{}
void HandleMessageOther(BYTE code)
{

}

/**
 * receive msg if available
 */
BYTE GetMsg()
{
    BYTE status = 0;
#ifdef ENABLE_SLEEP
    status = MiApp_TransceiverPowerState(POWER_STATE_WAKEUP_DR);
    if (status != SUCCESS)
        return status;
#endif
    if (MiApp_MessageAvailable())
        status = HAVE_MSG;

    return status;
}

/**
 * Create new packet from sensor to PAN-coord.
 * @param[in] code  Application first for identifying messages
 */
void CreatePacketSensor(BYTE code, WORD_VAL *battery)
{
    MiApp_FlushTx();
    counter = 0;

    // 1B - application code Byte
    MiApp_WriteData(code);

    // 2B - protocol version
    // 1. version - 0x0001
    MiApp_WriteData(VERSION >> 8);
    MiApp_WriteData(VERSION & 0x00FF);

    // 2B - battery state
    MiApp_WriteData(battery->byte.HB);
    MiApp_WriteData(battery->byte.LB);

    // 1B - number of transfering data values - index 5
    MiApp_WriteData(0x00); // will be changed in next function if needed

    // 1B - reserved
    MiApp_WriteData(0x00);
}

/**
 * Create packet from PAN-coord. to sensor
 * @param[in] code  Application first for identifying messages
 * @param[in] time  Time in seconds to next data send
 */
void CreatePacketAdapter(BYTE code, BOOL ok, WORD time) // code for msg from server - SERVER_MSG
{
    MiApp_FlushTx();
    counter = 0;

    // 1B - application code Byte
    MiApp_WriteData(code);
    
    // 1B - is OK
    if (ok == TRUE)
        MiApp_WriteData(0xFF);
    else
        MiApp_WriteData(0xFE);

    MiApp_WriteData((time & 0xFF00)>>8);
    MiApp_WriteData(time & 0xFF);

}

BOOL isShortValue(BYTE type)
{
	if(type == SWITCH_SENSOR ||
		type == SWITCH_ACTOR ||
		type == ACCELEROMETER)
		return TRUE;

	return FALSE;
}



/**
 * add combination of "type:value" to packet
 */
BOOL AddValueToPacket(BYTE type, LONG value)
{
    BYTE i = 0;
    //BYTE val[4];

	unsigned int size = sizeof(BYTE);

	if(isShortValue(type))
		size += sizeof(BYTE);
	else
		size += sizeof(LONG);

    // check if we have enough space in packet to add more data
    if ((TxData + size) > (TX_BUFFER_SIZE+MIWI_PRO_HEADER_LEN))
        return FALSE;

    MiApp_WriteData(type);

    if (isShortValue(type))
    {
        MiApp_WriteData(value);
    }
    else
    {

		MiApp_WriteData(value>>24);
        MiApp_WriteData(value>>16);
        MiApp_WriteData(value>>8);
        MiApp_WriteData(value);

    }

    // modify counter of added data
    counter++;
    // change value in packet
    MiApp_WriteDataIndex(COUNT_INDEX, counter);
    return TRUE;
}

/**
 * get value from incoming packet
 * @param[in/out] payloadPos	pointer to variable containing position in Payload of rxMessage
 * @return Value of received data (still multiplied by 100)
 */
LONG getValue(BYTE *payloadPos)
{
	LONG value = 0;

	if (isShortValue(rxMessage.Payload[*payloadPos]))
    {
        (*payloadPos)++;
		return (rxMessage.Payload[(*payloadPos)++]);
    }
    (*payloadPos)++;

    value = rxMessage.Payload[(*payloadPos)++];
    value <<= 8;
    value |= rxMessage.Payload[(*payloadPos)++];
    value <<= 8;
    value |= rxMessage.Payload[(*payloadPos)++];
    value <<= 8;
    value |= rxMessage.Payload[(*payloadPos)++];

    return value;
}


#define PING_PONG_RETRY 3
/**
 * Function to verify if device is connected to correct network
 */
BOOL Ping(BOOL pan)
{
    BOOL result = FALSE;
    BYTE PAN_addr[2] = {0x00, 0x00};
    int i;
    BYTE try = 0;
	PRINT("Pinging\n");
    // send request only if entry in connection table is valid (do not send it after programming device)
    if (ConnectionTable[myParent].status.bits.isValid)
    {

			try++;
			MiApp_FlushTx();
			MiApp_WriteData(PING);

			MiApp_DiscardMessage();
			if (pan)
			{
				if(MiApp_UnicastAddress(PAN_addr, FALSE, TRUE) == TRUE)
             PRINT("Unicast ok\n");
			}
			else
			{
				if(MiApp_UnicastConnection(myParent, TRUE) == TRUE)
             PRINT("Unicast ok\n");
			}

            printKey();
		#ifdef NWK_ROLE_END_DEVICE
            StartTimer(3);
			

		WaitForMessage(PING);
		if (MiApp_MessageAvailable())

		#else

			for (i = 0; i < 1000; i++)
			{
				if (MiApp_MessageAvailable())
				{
					break;
				}
				DelayMs(2);
			}
			if (i != 1000)
		#endif

			{
				if (rxMessage.Payload[0] == PING)
                {
                    PRINT("Prisiel PONG\n");
					result = TRUE;
                }
				else
                {
                    PRINT("Prislo cosi ine\n");
					result = FALSE;
                }
				MiApp_DiscardMessage();
			}

		}
//	}
    return result;
}


#ifdef NWK_ROLE_COORDINATOR
/**
 * Answer for PING
 */
BOOL Pong(void)
{
    BOOL result = FALSE;
    BYTE srcAddr[2];
    BYTE i;

	srcAddr[0] = rxMessage.SourceAddress[0];
	srcAddr[1] = rxMessage.SourceAddress[1];

    for (i = 0; i < CONNECTION_SIZE; i++)
    {
        if (ConnectionTable[i].status.bits.isValid)
        {
            if ((ConnectionTable[i].AltAddress.v[0] == srcAddr[0]) && (ConnectionTable[i].AltAddress.v[1] == srcAddr[1]))
                break;
        }
    }

    // answer only to devices in conn. table
    if (i != CONNECTION_SIZE)
    {
        MiApp_FlushTx();
        MiApp_WriteData(PING);
		i = 0;
		
		while(i < PING_PONG_RETRY)
		{
			//if((result = MiApp_UnicastAddress(srcAddr, FALSE, TRUE)) == TRUE)
			if((result = MiApp_UnicastConnection(i, TRUE)) == TRUE)
            {
              //  PRINT("Unicast sent");
                break;
            }
            PRINT("Resending unicast: %d\n", i);
			DelayMs(10);
			i++;
		}

	}
    else
        result = FALSE;


    return result;
}
#endif
/**
 * check first byte of msg
 */
BOOL isDebugMessage(BYTE code) {
    if (code == DEBUG_RESPONSE_ADDRESSES ||
            code == DEBUG_RESPONSE_CONNECTION ||
            code == DEBUG_RESPONSE_FAILURE ||
            code == DEBUG_RESPONSE_NEIGHBOR ||
            code == DEBUG_RESPONSE_ROUTING ||
            code == DEBUG_RESPONSE_TREE)
        return TRUE;
    else
        return FALSE;
}

void HandleMessageDebug(BYTE code) {
    BYTE j,i;

    if(code == DEBUG_REQUEST_ADDRESSES) {
        MiApp_FlushTx();
        MiApp_WriteData(DEBUG_RESPONSE_ADDRESSES);
        MiApp_WriteData(currentChannel);
        MiApp_WriteData(ConnMode);
        MiApp_WriteData(myShortAddress.v[0]);
        MiApp_WriteData(myShortAddress.v[1]);
        MiApp_WriteData(myPANID.v[0]);
        MiApp_WriteData(myPANID.v[1]);
        MiApp_WriteData(myParent);
        MiApp_WriteData(rxMessage.PacketLQI);
        MiApp_WriteData(rxMessage.PacketRSSI);
        MiApp_UnicastConnection(findSender(), TRUE);
    }

    #ifdef NWK_ROLE_COORDINATOR

        if(code == DEBUG_REQUEST_CONNECTION) {

            if( NUM_COORDINATOR * NUM_COORDINATOR/8 > TX_BUFFER_SIZE) {
                // TODO error
            }

            for(j = 0; j < CONNECTION_SIZE; j++) {

                if(j == 0 || j%2 == 1 ) {
                    MiApp_FlushTx();
                    MiApp_WriteData(DEBUG_RESPONSE_CONNECTION);
                }


                MiApp_WriteData(ConnectionTable[j].PANID.v[0]);
                MiApp_WriteData(ConnectionTable[j].PANID.v[1]);
                MiApp_WriteData(ConnectionTable[j].AltAddress.v[0]);
                MiApp_WriteData(ConnectionTable[j].AltAddress.v[1]);
                MiApp_WriteData(ConnectionTable[j].Address[0]);
                MiApp_WriteData(ConnectionTable[j].Address[1]);
                MiApp_WriteData(ConnectionTable[j].Address[2]);
                MiApp_WriteData(ConnectionTable[j].Address[3]);
                MiApp_WriteData(ConnectionTable[j].status.Val);
                MiApp_WriteData(j);

                if( j+1 ==CONNECTION_SIZE || j%2 == 0)
                    MiApp_UnicastConnection(findSender(), TRUE);
            }
        }


        if(code == DEBUG_REQUEST_ROUTING) {
            MiApp_FlushTx();
            MiApp_WriteData(DEBUG_RESPONSE_ROUTING);
            for(j = 0; j < NUM_COORDINATOR/8; j++)
            {
                MiApp_WriteData(RoutingTable[j]);
            }
            MiApp_UnicastConnection(findSender(), TRUE);
        }

        if(code == DEBUG_REQUEST_TREE) {
            MiApp_FlushTx();
            MiApp_WriteData(DEBUG_RESPONSE_TREE);
            for(j = 0; j < NUM_COORDINATOR; j++)
            {
                MiApp_WriteData(FamilyTree[j]);
            }
            MiApp_UnicastConnection(findSender(), TRUE);
        }

        if(code == DEBUG_REQUEST_FAILURE) {
            MiApp_FlushTx();
            MiApp_WriteData(DEBUG_RESPONSE_FAILURE);
            for(j = 0; j < NUM_COORDINATOR; j++)
            {
                MiApp_WriteData(RouterFailures[j]);
            }
            MiApp_UnicastConnection(findSender(), TRUE);
        }

        if(code == DEBUG_REQUEST_NEIGHBOR) {

            if( NUM_COORDINATOR * NUM_COORDINATOR/8 > TX_BUFFER_SIZE) {
                // TODO error
            }

            MiApp_FlushTx();
            MiApp_WriteData(DEBUG_RESPONSE_NEIGHBOR);
            for(j = 0; j < NUM_COORDINATOR; j++)
            {
                for(i = 0; i < NUM_COORDINATOR/8; i++) {
                    MiApp_WriteData(NeighborRoutingTable[j][i]);
                }
            }
            MiApp_UnicastConnection(findSender(), TRUE);
        }

    #endif
}
//#endif

#if defined(NWK_ROLE_COORDINATOR) && (MY_PAN_ID != 0xFFFF)  // only non PAN coordinators has PANID 0xFFFF
void PrintPacket()
{
    BYTE i = 0;
    BYTE size = TxData;//sizeof(TxBuffer);

    PRINT("\nSize of TxBuffer: %d\nTxData value: %d\n", sizeof(TxBuffer), TxData);

    for (i = PAYLOAD_START; i < size; i++)
    {
       PRINT("\nData[%d]: 0x%02X\n", i-PAYLOAD_START, TxBuffer[i]);
    }
    PRINT("\n END OF DATA!\n");
}
#endif

/**
 * vrati index do ConnectionTable zariadenia ktory odoslal poslednu spravu
 * @return 
 */
BYTE findSender()
{
    BYTE i=0;
    for(i = 0 ; i< CONNECTION_SIZE ; i++)
    {
        if(ConnectionTable[i].status.bits.isValid)
        {
            if((ConnectionTable[i].AltAddress.v[1] == rxMessage.SourceAddress[1]) && (ConnectionTable[i].AltAddress.v[0] == rxMessage.SourceAddress[0]))
            {
                return i;
            }
        }
    }
}