#ifndef __UMF_UTIL_MASK_TRACKER_H_
#define __UMF_UTIL_MASK_TRACKER_H_

#include <Eigen/Core>
#include <vector>

namespace umf {

class MaskTracker
{
public:
	MaskTracker();

	void update(std::vector<Eigen::Vector2f> &corners);
	inline void disable() { this->enabled = false; }

	bool filterPoints(std::vector<Eigen::Vector2i> &points);

	void show();

private:
	Eigen::Vector2f prevPos[4];
	bool enabled;
};




}//end of namespace


#endif