#ifndef __UMF_IMAGE_H_
#define __UMF_IMAGE_H_


#include <Eigen/Core>

namespace umf {


struct Edgel
{
    Eigen::Vector3f line;
    Eigen::Vector2f endPoints[2];
    float score;
};

template<class T, int N>
class Image
{
public:
    Image(int width, int height, bool allocate = true, int widthstep = -1);
    ~Image();

    inline T *get2D(int x, int y, int channel=0);
    Eigen::Matrix<T, N, 1> get2De(int x, int y);
	void get2Der(Eigen::Matrix<T, N, 1> &res, int x, int y);


    char *data;
    int width;
    int height;
    int channels;
    int widthstep;

private:
    bool allocated;

};

template<class T, int NCHAN>
T *Image<T, NCHAN>::get2D(int x, int y, int channel)
{
    return (T*) &(this->data[this->widthstep*y + x*NCHAN*sizeof(T) + channel*sizeof(T)]);
}



typedef Image<unsigned char, 3> ImageRGB;
typedef Image<unsigned char, 1> ImageGray;

void convertToGrayscale(ImageRGB *rgb, ImageGray* gray);

}

#endif
