#include "calibration.h"

namespace umf
{

Calibration::Calibration(int width, int height)
{
    this->imgSize(0) = width;
    this->imgSize(1) = height;
}

void Calibration::addImage(CorrespondenceSet &myset)
{
    this->images.push_back(myset);
}

//todo fix aspect ration, fix principal point etc.
bool Calibration::calibrate(bool distort)
{
    //first compute for each image homography

    //estimate using homography calculations all the parameters

    //use levenberg marquardt to improve
}


void Calibration::projectPoints(std::vector<Eigen::Vector3f> &modelPoints,
                                std::vector<Eigen::Vector2f> &imagePoints,
                                bool distort)
{
    std::vector<Eigen::Vector2f> points;
    Eigen::Matrix4d &mv = this->pnp->getWorldTransformMatrix();
    Eigen::Matrix3d &camera = this->pnp->getCameraMatrix();
    Eigen::Vector4d currentPos;
    Eigen::Vector3d projected;
    double k = 1;
    for(unsigned int i = 0; i < modelPoints.size(); i++)
    {
        //switch x and y, cos we do that
        Eigen::Vector4d pos3d(modelPoints[i][0], modelPoints[i][1], modelPoints[i][2], 1.0);

        currentPos = mv*pos3d;

        if(distort) //the distortion will compute the multiplication with the camer matrix, so we only need the transformed point
        {
            //the current position probably is still going to be normalized, since we don't do any projection in the model view matrix
            //but just in case:
            currentPos *= 1.0/currentPos[3];

            //now that we have this if i get this right we just do 1/z in projection, so (the camera matrix has 1 at the diagonal for the z point
            k = currentPos[2] ? 1./currentPos[2] : 1;
            points.push_back(Eigen::Vector2f(currentPos[0]*k, currentPos[1]*k));
        } else {
            //if we are going to just project it move everything to the imagePoints at once
            projected = camera*Eigen::Vector3d(currentPos[0], currentPos[1], currentPos[2]);

            k = projected[2] ? 1./projected[2] : 1;

            imagePoints.push_back(Eigen::Vector2f(projected[0]*k, projected[1]*k));

        }
    }

    //now we do some kind of distorting based on opencl. It will also scale the points based on camera matrix
    if(distort)
    {
        distortPoints(points, imagePoints, camera.template cast<float>(), this->pnp->getDistortionCoeffs().template cast<float>());
    }

}


}//end of namespace
