#ifndef _UMF_DETECTOR_API_
#define _UMF_DETECTOR_API_

#ifndef UMF
#define UMF 
#endif

#define UMF_DETECTOR_CHANNELS 1
#define UMF_API_DEBUG 0

typedef struct 
{
    float positionX;
    float positionY;
    float positionZ;

	float quatX;
	float quatY;
	float quatZ;
	float quatW;
} DetectorResult;

   
typedef struct
{
    int textureWidth;
    int textureHeight;
	int cameraIndex;
    int bufferSize;
    int currentFrame;
	void *capture;
	void *detector;
	void *camImage; //buffer of images for the camera
	void *nextImage; //copy of the pointer for the detector
	void *nextDebug; //copy for detector with debug stuff
	void *currentResult;
} DetectorProperties;

#ifdef __cplusplus
extern "C" {
#endif

/*****************THREAD 1******************************************************************************/
//Thread for camera grabber

//conflicts with umf_swap_frame
UMF int __stdcall umf_grab_frame(DetectorProperties* detector);

//should be locked when accessing same variables
UMF void __stdcall umf_get_frame(DetectorProperties* detector, unsigned char* image, int debug = 0);
/*****************THREAD 1 END**************************************************************************/


/*****************THREAD 2******************************************************************************/
//Thread for the detector

//conflicts with umf_grab_frame
UMF void __stdcall umf_set_frame(DetectorProperties* detector); 

//detection
UMF int __stdcall umf_detect(DetectorProperties *detector, float timeout = 0.0);

//get detection result - should be locked to sync the camera matrix
UMF void __stdcall umf_get_result(DetectorProperties *detector, DetectorResult *result);

/*****************THREAD 2 END**************************************************************************/

/******** OUTSIDE THREADING ****************************************************************************/

UMF int __stdcall umf_create_detector(int width, int height, float near, float far, float fov, DetectorProperties *props);

UMF int __stdcall umf_set_marker_str(DetectorProperties *props, char *str);

UMF void __stdcall umf_free_detector(DetectorProperties *detector);


#ifdef __cplusplus
}
#endif

#endif
