#ifndef __UMF_UMFDEBUG_H
#define __UMF_UMFDEBUG_H

#include "singleton.h"
#include "image.h"
#include "../defines.h"

#include <vector>
#include <map>
#include <string>

#if defined(__WIN32__) || defined(_WIN32) || defined(__CYGWIN__)
#include <Windows.h>
#else
#include <sys/time.h>
#endif

#include <assert.h>

namespace umf
{

class Timer {
private:

#if defined(__WIN32__) || defined(_WIN32) || defined(__CYGWIN__)
    LARGE_INTEGER startTime;
    LARGE_INTEGER frequency;
    int initialized;
#else
    timeval startTime;
#endif

public:

    Timer(){
#if defined(__WIN32__) || defined(_WIN32) || defined(__CYGWIN__)
        this->initialized = 0;
#endif

    }
    ~Timer(){}

    void start(){
#if defined(__WIN32__) || defined(_WIN32) || defined(__CYGWIN__)
        BOOL r;

        if (!initialized) {                           /* prvni volani */
            initialized = 1;
            r = QueryPerformanceFrequency(&frequency);  /* vezmi frekvenci pocitadla */
            if (r == 0) {                               /* pokud hi-res pocitadlo neni podporovano */
                assert(0 && "HiRes timer is not available.");
                exit(-1);
            }
        }

        r = QueryPerformanceCounter(&(this->startTime));          /* vezmi hodnotu pocitadla */
        assert(r != 0 && "This should never happen."); /* osetreni chyby */
#else
        gettimeofday(&startTime, NULL);
#endif
    }

    double stop(){
        double duration;
#if defined(__WIN32__) || defined(_WIN32) || defined(__CYGWIN__)
        BOOL r;
        LARGE_INTEGER value;
        r = QueryPerformanceCounter(&value);          /* vezmi hodnotu pocitadla */
        assert(r != 0 && "This should never happen."); /* osetreni chyby */
        return (double)(value.QuadPart - startTime.QuadPart)*1000.0 / (double)frequency.QuadPart; /* vrat hodnotu v milisekundach */
#else
        timeval endTime;
        long seconds, useconds;

        gettimeofday(&endTime, NULL);

        seconds  = endTime.tv_sec  - startTime.tv_sec;
        useconds = endTime.tv_usec - startTime.tv_usec;

        duration = seconds*1000 + useconds/1000.0;

#endif
        return duration;
    }
};




class UMFDebug
{
public:
    UMFDebug();

    void setImage(ImageRGB *img){ this->img = img; }
    ImageRGB *getImage(){ return this->img; }

    //PIXEL counter
#ifdef UMF_DEBUG_COUNT_PIXELS
    void addPixels(int count) { this->pixelCount += count; }
    long long getPixels() { return this->pixelCount; }
#endif

#ifdef UMF_DEBUG_TIMING
    //TIMING stuff
    int logEventStart();
    void logEventEnd(int id, std::string message);
    void logEvent(double time, std::string name);
    std::vector< std::pair<double, std::string> > &getEvents(){return this->timeEvents;}
    void getTimeLog(std::vector< std::pair<double, std::string> > &events);

    void getUniqLog(std::vector< std::pair<double, std::string> > &events);

    void clearEvents();
#endif


private:
    ImageRGB *img;
    long long pixelCount;

    //timing stuff
    std::vector< std::pair<double, std::string> > timeEvents;
    std::map<int, Timer> startTick;
    std::map< std::string, std::pair<int, double> > eventMap;
    int prevID;
    //timing stuff ent
};


typedef Singleton<UMFDebug> UMFDSingleton;

}

#endif // UMFDEBUG_H
