#ifndef __UMF_SINGLETON_H
#define __UMF_SINGLETON_H

namespace umf
{

template <class T>
class Singleton
{
public:
    static T* Instance() {
        if(!m_pInstance) m_pInstance = new T;
        assert(m_pInstance !=nullptr);
        return m_pInstance;
    }

	static void Release() {
		if(m_pInstance) delete m_pInstance;
		m_pInstance = nullptr;
	}
protected:
    Singleton();
    ~Singleton();
private:
    Singleton(Singleton const&);
    Singleton& operator=(Singleton const&);
    static T* m_pInstance;
};

template <class T> T* Singleton<T>::m_pInstance = nullptr;

}

#endif // SINGLETON_H
