#ifndef __UMF_CORNER_DETECTOR_H
#define __UMF_CORNER_DETECTOR_H

#include <Eigen/Core>
#include <vector>
#include "image.h"

namespace umf {

template<class T, int NCHAN>
bool binSearchEdge(Image<T, NCHAN> *image,
                   Eigen::Vector2i &edge,
                   Eigen::Vector2i left,
                   Eigen::Vector2i right,
                   const int searchThreshold = -1);

template<class T, int NCHAN>
Eigen::Vector2f findMarkerCorner(Image<T, NCHAN> *srcImg, std::vector<Eigen::Vector2f> &points, int cornerType);

template<class T, int NCHAN>
int findCornersSubpixel(Image<T, NCHAN> *srcImg, std::vector<Eigen::Vector2f> &points);

}
#endif // CORNER_DETECTOR_H
