#include "image.h"
#include "../defines.h"

#ifdef UMF_USE_OPENCV

#include <opencv/cv.h>
#include <highgui.h>

#endif

namespace umf {


static inline float clamp(float x, float a, float b)
{
    return x < a ? a : (x > b ? b : x);
}

template <class T, int NCHAN>
void getChromeMask(Image<T, NCHAN> */*img*/, ImageGray *mask)
{
    if(mask)
    {
        memset(mask->data, 255, mask->height*mask->widthstep);
    }
}

template <>
void getChromeMask(ImageRGB *srcRGB, ImageGray *mask)
{
    if(srcRGB == NULL || mask == NULL || srcRGB->width != mask->width || srcRGB->height != mask->height)
    {
        return;
    }

    for(int xi = 0; xi < srcRGB->width; xi++)
    {
        for(int yi = 0; yi < srcRGB->height; yi++)
        {
            unsigned char* pB = srcRGB->get2D(xi, yi);
            short R = *pB;
            short G = *(pB + 1);
            short B = *(pB + 2);

            float maskVal = (G - std::max(B, R) - 10); //discard last 3 bits

            //first create the mask than convert the pixels
            *(mask->get2D(xi,yi)) = (maskVal > 0) ? 255 : 0;
            //((uchar *)(mask->data + yi*mask->widthstep))[xi*mask->channels] = (uchar) clamp(maskVal*1e5, 0, 255);
        }
    }

    //TODO implement this for ours, too
#ifdef UMF_USE_OPENCV
    IplImage *maskCV = cvCreateImageHeader(cvSize(mask->width, mask->height), IPL_DEPTH_8U, 1);
    maskCV->widthStep = mask->widthstep;
    maskCV->imageData = maskCV->imageDataOrigin = mask->data;

    cvErode(maskCV, maskCV);
    cvErode(maskCV, maskCV);
    cvErode(maskCV, maskCV);
    cvReleaseImageHeader(&maskCV);
#endif
}

//SPECIALIZATION INSTANCES

template void getChromeMask(ImageGray*, ImageGray*);

}
