#ifndef _UMF_CALIBRATION_H_
#define _UMF_CALIBRATION_H_

#include "pnp_solver.h"

namespace umf
{

class Calibration
{
public:
    Calibration(int width, int height);

    void addImage(CorrespondenceSet &myset);

    bool calibrate(bool distort = true);

private:

    void projectPoints(std::vector<Eigen::Vector3f> &modelPoints,
                       std::vector<Eigen::Vector2f> &imagePoints,
                       bool distort = true);

    std::vector<CorrespondenceSet> images;

    Eigen::Vector2i imgSize;
    Eigen::Matrix3d cameraMatrix;
    Eigen::Matrix<double, 8, 1> distCoeffs;
};

}
#endif // CALIBRATION_H
