#ifndef __UMF_EDGE_DIR_DETECTOR_H
#define __UMF_EDGE_DIR_DETECTOR_H

#include <Eigen/Core>
#include <vector>
#include "util/image.h"
#include "marker.h"

namespace umf {


enum EDGE_DIR_SAMPLE_COUNTS
{
    EDGE_DIR_SAMPLE_COUNT_SIMPLE = 8,
    EDGE_DIR_SAMPLE_COUNT_CENTERED = 16
};

enum EDGE_DIR_SCORE_DECIDERS
{
    EDGE_DIR_SCORE_DECIDER_SIMPLE = 5,
    EDGE_DIR_SCORE_DECIDER_CENTERED = 11
};

template<int NCHAN>
class EdgeDirDetector
{
public:
    EdgeDirDetector();

    template<class T>
    void extract(Image<T, NCHAN> *img, std::vector<Eigen::Vector3f> &pencil1, std::vector<Eigen::Vector3f> &pencil2, ImageGray* mask = NULL, bool show = false);

    void setFieldDiffThreshold(Eigen::Array<int, NCHAN, 1> threshold) { this->fieldDiffThreshold = threshold; }
    Eigen::Array<int, NCHAN, 1> getFieldDiffThreshold() { return this->fieldDiffThreshold; }

    std::vector< Eigen::Vector2f > &getExtractionPoints(){ return this->extractionPoints; }

    std::vector< typename Marker<NCHAN>::DirectionType > &getEdgeDirections() { return this->edgeDirections; }
    unsigned int getRows(){ return this->rows; }
    unsigned int getCols(){ return this->cols; }

private:

    void showFieldCenters(ImageGray* mask = NULL);
    void showEdgeDirections(ImageGray* mask = NULL);

    void getSamplingPoints(Eigen::Vector2f p1,
                           Eigen::Vector2f p2,
                           Eigen::Vector2f otherDirection,
                           std::vector<Eigen::Vector2f> &samples1,
                           std::vector<Eigen::Vector2f> &samples2);

    template<class T>
    Eigen::Matrix<int, NCHAN, 1> getScore(Image<T, NCHAN> *img, std::vector<Eigen::Vector2f> &samples1, std::vector<Eigen::Vector2f> &samples2);

    template<class T>
    Eigen::Matrix<int, NCHAN, 1> getScoreGauss(Image<T, NCHAN> *img, std::vector<Eigen::Vector2f> &samples1, std::vector<Eigen::Vector2f> &samples2);

    std::vector< Eigen::Vector2f > extractionPoints;

    //size is ((width - 1)*height + width*(height-1))*channels theoretically but for better indexing we use width*height*2*channels
    std::vector< typename Marker<NCHAN>::DirectionType > edgeDirections;
    unsigned int rows;
    unsigned int cols;

    Eigen::Array<int, NCHAN, 1> fieldDiffThreshold;
    unsigned int sampleCount;
    int scoreDecider;
};

}

#endif // EDGE_DIR_DETECTOR_H
