package org.fit.graph.umfdetector;

import org.fit.graph.umfdetector.R;

import android.hardware.Camera;
import android.os.Bundle;
import android.app.Activity;
import android.view.Menu;
import android.view.Window;
import android.view.WindowManager;
import android.widget.FrameLayout;
import android.widget.TextView;


public class MainActivity extends Activity implements UMFCameraPreviewCallback.DetectionCallback {

	private CameraPreview mPreview;
	private UMFCameraPreviewCallback mUMF;
	Camera mCamera;

    int numberOfCameras;
    int cameraCurrentlyLocked;
	int defaultCameraId;
	
    @Override
    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        
		// Hide the window title.
		requestWindowFeature(Window.FEATURE_NO_TITLE);
		getWindow().addFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN);

        setContentView(R.layout.activity_main);
		
		mUMF = new UMFCameraPreviewCallback();
		mUMF.setCallback(this);
		
		mPreview = new CameraPreview(this);
		FrameLayout fl = (FrameLayout) findViewById(R.id.cameraPreview);
		fl.addView(mPreview);
        
		// Find the total number of cameras available
		/*
        numberOfCameras = Camera.getNumberOfCameras();
    
        // Find the ID of the default camera
        CameraInfo cameraInfo = new CameraInfo();
        for (int i = 0; i < numberOfCameras; i++) {
            Camera.getCameraInfo(i, cameraInfo);
            if (cameraInfo.facing == CameraInfo.CAMERA_FACING_BACK) {
                defaultCameraId = i;
            }
        }
        */
		numberOfCameras = 1;
		defaultCameraId = 0;
		
    }
    
    @Override
    protected void onResume() {
        super.onResume();

        // Open the default i.e. the first rear facing camera.
        mCamera = Camera.open();
        cameraCurrentlyLocked = defaultCameraId;
        mPreview.setCamera(mCamera);
        mUMF.startDetection(this, mCamera);
    }

    @Override
    protected void onPause() {
        super.onPause();

        // Because the Camera object is a shared resource, it's very
        // important to release it when the activity is paused.
        if (mCamera != null) {
        	mUMF.stopDetection();
            mPreview.setCamera(null);
            mCamera.release();
            mCamera = null;
        }
    }

    @Override
    public boolean onCreateOptionsMenu(Menu menu) {
        // Inflate the menu; this adds items to the action bar if it is present.
        getMenuInflater().inflate(R.menu.activity_main, menu);
        return true;
    }

	@Override
	public void onUMFDetected(int success) {
		
		if(mUMF != null)
		{
			float[] cposition = new float[2];
			mUMF.getImageCenter(cposition);
			
			TextView position = (TextView) this.findViewById(R.id.fpsHolder);
			if(position != null)
			{
				position.setText(String.format("%d - %.1f;%.1f", success, cposition[0], cposition[1]));
			}
		}
	}
    
}
