////////////////////////////////////////////////////////////////////////////
// TitleTip.cpp : implementation file

#include "stdafx.h"
#include "TitleTip.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif


HWND	g_titlehandle=NULL;
HHOOK	g_titlemousehookproc=NULL;
HHOOK	g_titlekeybhookproc=NULL;
/////////////////////////////////////////////////////////////////////////////
// CTitleTip
LRESULT CALLBACK MouseHookCallback(int code, WPARAM wParam, LPARAM lParam)
{
	if(code==HC_ACTION)
	{
		if((wParam==WM_MOUSEMOVE)&&(g_titlehandle!=NULL))
		{	//preda se informace o pozici mysi
			PostMessage(g_titlehandle,WM_CANCELMODE,((MOUSEHOOKSTRUCT*)lParam)->pt.x,((MOUSEHOOKSTRUCT*)lParam)->pt.y);
		}
		else
		{	//kliknuti mysi
			PostMessage(g_titlehandle,WM_CANCELMODE,0,0);
		}
	}
	return ::CallNextHookEx(g_titlemousehookproc, code, wParam, lParam);
}

LRESULT CALLBACK KeyboardHookCallback(int code, WPARAM wParam, LPARAM lParam)
{
	if(code==HC_ACTION)
	{
		if(g_titlehandle!=NULL) //stisknuti klavesy
			PostMessage(g_titlehandle,WM_CANCELMODE,0,0);
	}
	return ::CallNextHookEx(g_titlekeybhookproc, code, wParam, lParam);
}


CTitleTip::CTitleTip()
{
	// Register the window class if it has not already been registered.
	WNDCLASS wndcls;
	HINSTANCE hInst = AfxGetInstanceHandle();
	if(!(::GetClassInfo(hInst, TITLETIP_CLASSNAME, &wndcls)))
	{	// otherwise we need to register a new class
		wndcls.style			= CS_SAVEBITS;
		wndcls.lpfnWndProc		= ::DefWindowProc;
		wndcls.cbClsExtra		= wndcls.cbWndExtra = 0;
		wndcls.hInstance		= hInst;
		wndcls.hIcon			= NULL;
		wndcls.hCursor			= LoadCursor( hInst, IDC_ARROW );
		wndcls.hbrBackground	= (HBRUSH)(COLOR_INFOBK+1); 
		wndcls.lpszMenuName		= NULL;
		wndcls.lpszClassName	= TITLETIP_CLASSNAME;

		if (!AfxRegisterClass(&wndcls))AfxThrowResourceException();
	}
	m_infobkcolor=GetSysColor(COLOR_INFOBK);

	m_titlefont=NULL;
	m_titlefont=new CFont;
	m_titlefont->CreateFont(-11,0,0,0,400,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,"MS Sans Serif");

	m_canshow=false;
	m_delayhide=0;
}

CTitleTip::~CTitleTip()
{
	if(m_titlefont!=NULL)delete m_titlefont;
}

BEGIN_MESSAGE_MAP(CTitleTip, CWnd)
	//{{AFX_MSG_MAP(CTitleTip)
	ON_WM_PAINT()
	ON_WM_TIMER()
	ON_WM_MOUSEMOVE()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTitleTip message handlers
BOOL CTitleTip::Create(CWnd * pParentWnd)
{
	ASSERT_VALID(pParentWnd);

	DWORD dwStyle=WS_BORDER|WS_POPUP; 
	DWORD dwExStyle=WS_EX_TOOLWINDOW;
//	DWORD dwExStyle=WS_EX_TOOLWINDOW|WS_EX_TOPMOST;
	m_pParentWnd=pParentWnd;

	return CreateEx(dwExStyle, TITLETIP_CLASSNAME, NULL, dwStyle, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, CW_USEDEFAULT, NULL, NULL, NULL );
}

void CTitleTip::ShowDelay(CPoint pointTitle,const CString& lpszTitleText,CRect rectHover)
{
	KillTimer(1);
	KillTimer(2);
	if(IsWindowVisible())Hide();
	m_strTitle=lpszTitleText;
	m_rectHover=rectHover;
	m_rectTitle=CRect(pointTitle.x,pointTitle.y,pointTitle.x+10,pointTitle.y+10);
	m_canshow=true;
	SetTimer(1,500,NULL);
}

void CTitleTip::Show(CPoint pointTitle,const CString& lpszTitleText,CRect rectHover)
{
	ASSERT(::IsWindow(GetSafeHwnd()));
	if(GetFocus()==NULL)return; // Do not display the titletip is app does not have focus

	m_strTitle=lpszTitleText;
	m_rectHover=rectHover;

	m_pParentWnd->ClientToScreen(m_rectHover);
	m_pParentWnd->ClientToScreen(&pointTitle);

	CClientDC dc(this);
//	CFont font;	//vytvoreni fontu
//	font.CreateFont(-11,0,0,0,400,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,"MS Sans Serif");
//	pOldFont=dc.SelectObject(&font);
	if(m_titlefont==NULL)return;
	CFont* pOldFont=dc.SelectObject(m_titlefont);
//	pOldFont=(CFont*)dc.SelectStockObject(DEFAULT_GUI_FONT);

	//spocita se potrebna velikost okna
	CString pomstr;
	CSize size;
	int max_x,vyska;
	int oldf=-1;
	int f=m_strTitle.Find('\n');
	max_x=vyska=0;
	while(f!=-1)
	{	
		pomstr=m_strTitle.Mid(oldf+1,f-oldf-1);
		size=dc.GetTextExtent(pomstr);
		if(size.cx>max_x)max_x=size.cx;
		vyska+=size.cy;
		oldf=f;
		f=m_strTitle.Find('\n',f+1);
	}
	f=m_strTitle.GetLength(); //jeste je tam konec
	pomstr=m_strTitle.Mid(oldf+1,f-oldf-1);
	size=dc.GetTextExtent(pomstr);
	if(size.cx>max_x)max_x=size.cx;
	vyska+=size.cy;
	//nastaveni velikosti okna
	m_rectDisplay.left=pointTitle.x;
	m_rectDisplay.right=m_rectDisplay.left+max_x+7;
	m_rectDisplay.top=pointTitle.y;
	m_rectDisplay.bottom=m_rectDisplay.top+vyska+5;

	dc.SelectObject(pOldFont);
    
    //**********************************************************
    //Adjust the dimensions of the rect to fit within the client
    CRect rectClient;
    m_pParentWnd->GetClientRect( rectClient );
    m_pParentWnd->ClientToScreen( rectClient );
	// Use the screen's right edge as the right hand border, not the right edge of the client.
	// You can comment this out to use the right client as the border.
	CWindowDC wdc(NULL);
	rectClient.right=GetDeviceCaps(wdc,HORZRES)-5;
	rectClient.bottom=GetDeviceCaps(wdc,VERTRES)-5;
    //If the right edge exceeds the right edge of the client:
    //          see how much room there is to move the display to the left and adjust the
    //          rectangle that far to the left. If the rect still exceeds the right edge, clip
    //          the right edge to match the client right edge.
    //
    // Does the right display edge exceed the right client edge?
    if (m_rectDisplay.right > rectClient.right)
    {
        // establish what is available left shift wise and what is needed
        int nAvail = 0;
        int nNeeded = m_rectDisplay.right - rectClient.right;

        if (m_rectDisplay.left > rectClient.left)
            nAvail = m_rectDisplay.left - rectClient.left;

        // is there room to move left?
        if (nAvail >= nNeeded)
        {
            m_rectDisplay.OffsetRect(-nNeeded,0);  // yes, move all that is needed
            // increase the size of the window that will be inspected to see if the 
            // cursor has gone outside of the tooltip area by the number of units we
            // offset our display rect.
            m_rectTitle.right += nNeeded;
        }
        else
        {
            m_rectDisplay.OffsetRect(-nAvail,0);   // no, at least move to left edge of client
            // increase the size of the window that will be inspected to see if the 
            // cursor has gone outside of the tooltip area by the number of units we
            // offset our display rect.
            m_rectTitle.right += nAvail;
        }

        // Did we move enough? If not, clip right edge to match client right edge
        if (m_rectDisplay.right > rectClient.right)
            m_rectDisplay.right = rectClient.right;
    }
    //If the left edge exceeds the left edge of the client:
    //          see how much room there is to move the display to the right and adjust the
    //          rectangle that far to the right. If the rect still exceeds the left edge, clip
    //          the left edge to match the client left edge.
    //
    // Does the left display edge exceed the left client edge?
    if (m_rectDisplay.left < rectClient.left)
    {
        // establish what is available right shift wise and what is needed
        int nAvail = 0;
        int nNeeded = rectClient.left - m_rectDisplay.left;

        if (m_rectDisplay.right < rectClient.right)
            nAvail = rectClient.right - m_rectDisplay.right;

        // is there room to move left?
        if (nAvail >= nNeeded)
        {
            m_rectDisplay.OffsetRect(+nNeeded,0);  // yes, move all that is needed
            // increase the size of the window that will be inspected to see if the 
            // cursor has gone outside of the tooltip area by the number of units we
            // offset our display rect.
            m_rectTitle.left -= nNeeded;
        }
        else
        {
            m_rectDisplay.OffsetRect(+nAvail,0);   // no, at least move to left edge of client
            // increase the size of the window that will be inspected to see if the 
            // cursor has gone outside of the tooltip area by the number of units we
            // offset our display rect.
            m_rectTitle.left -= nAvail;
        }
        // Did we move enough? If not, clip left edge to match client left edge
        if (m_rectDisplay.left < rectClient.left)
            m_rectDisplay.left = rectClient.left;        
    }
	// ensure the tooltip does not exceed the bottom of the screen
	if (m_rectDisplay.bottom > rectClient.bottom)
    {
		int posun=m_rectDisplay.bottom-rectClient.bottom;
		m_rectDisplay.bottom = rectClient.bottom;
		m_rectDisplay.top-=posun;
    }

	if(m_delayhide!=0) //pro skryti
	{
		KillTimer(2);
		SetTimer(2,m_delayhide,NULL);
	}

	SetWindowPos(&wndTop,m_rectDisplay.left,m_rectDisplay.top,m_rectDisplay.Width(),m_rectDisplay.Height(),SWP_SHOWWINDOW|SWP_NOACTIVATE);
	Invalidate(FALSE);

    if(g_titlemousehookproc==NULL)
    {   // install the mouse hook procedure
		g_titlehandle=GetSafeHwnd();
        g_titlemousehookproc=::SetWindowsHookEx(WH_MOUSE,(HOOKPROC)MouseHookCallback,NULL,::GetCurrentThreadId());
    }
    if(g_titlekeybhookproc==NULL)
    {   // install the keyboard hook procedure
		g_titlehandle=GetSafeHwnd();
        g_titlekeybhookproc=::SetWindowsHookEx(WH_KEYBOARD,(HOOKPROC)KeyboardHookCallback,NULL,::GetCurrentThreadId());
    }
}

void CTitleTip::Hide()
{
	KillTimer(1);
	KillTimer(2);
	m_canshow=false;
  	if(!::IsWindow(GetSafeHwnd()))return;

	ShowWindow(SW_HIDE);

    if((g_titlemousehookproc!=NULL))
    {
		g_titlehandle=NULL;
        ::UnhookWindowsHookEx(g_titlemousehookproc);
        g_titlemousehookproc=NULL;
    }
    if((g_titlekeybhookproc!=NULL))
    {
		g_titlehandle=NULL;
        ::UnhookWindowsHookEx(g_titlekeybhookproc);
        g_titlekeybhookproc=NULL;
    }
}

void CTitleTip::OnPaint() 
{
	CPaintDC dc(this); 

//	CFont font;
//	font.CreateFont(-11,0,0,0,400,FALSE,FALSE,FALSE,DEFAULT_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_DONTCARE,"MS Sans Serif");
	if(m_titlefont!=NULL)
	{
		CFont *pFontDC=dc.SelectObject(m_titlefont);
	//	pFontDC=(CFont*)dc.SelectStockObject(DEFAULT_GUI_FONT);

		static CRect old_rect(0,0,0,0);
		dc.FillSolidRect(old_rect,m_infobkcolor);
		old_rect=m_rectDisplay;
		ScreenToClient(old_rect);
		old_rect.left+=3;
		old_rect.top+=3;
		dc.DrawText(m_strTitle,old_rect,DT_CALCRECT);

		dc.DrawText(m_strTitle,old_rect,0|DT_LEFT|DT_EDITCONTROL|DT_NOPREFIX|DT_WORDBREAK);

		dc.SelectObject(pFontDC);
	}
}

void CTitleTip::OnTimer(UINT nIDEvent) 
{
	switch(nIDEvent)
	{
	case 1:
		KillTimer(1); //delay show
		if(m_canshow)Show(CPoint(m_rectTitle.left,m_rectTitle.top),m_strTitle,m_rectHover);
		break;
	case 2:
		KillTimer(2);
		Hide(); //automaticke hide
		break;
	}

	CWnd::OnTimer(nIDEvent);
}

BOOL CTitleTip::PreTranslateMessage(MSG* pMsg) 
{
	switch (pMsg->message)
    {
	case WM_CANCELMODE: //zprava od hooku
		{
		POINT point;
		point.x=pMsg->wParam;
		point.y=pMsg->lParam;
		if((point.x==0)&&(point.x==point.y))
		{	//stisknuta klavesa nebo mys
			Hide();
			break;
		}
		if(!m_rectHover.PtInRect(point)) 
		{	//jsme mimo nasi oblast
			Hide();
			break;
		}
		HWND handle=::WindowFromPoint(point);
		if(handle!=m_pParentWnd->m_hWnd)
		{	//uz nejsme nad nasim oknem
			if(handle!=GetSafeHwnd())
			{	//nejsme ani nad sebou
				Hide();
			}
		}
		break;
		}
    }

/*	if(GetFocus()==NULL)
	{
		MessageBeep(0);
		Hide();
	}*/
	
	return CWnd::PreTranslateMessage(pMsg);
}

void CTitleTip::OnMouseMove(UINT nFlags, CPoint point) 
{
	// Forward the message
	ClientToScreen(&point);
	CWnd *pWnd=WindowFromPoint(point);
	if(pWnd==this)pWnd=m_pParentWnd;
	
	int hittest=(int)pWnd->SendMessage(WM_NCHITTEST,0,MAKELONG(point.x,point.y));
	if(hittest==HTCLIENT)
    {
		pWnd->ScreenToClient(&point);
		pWnd->PostMessage(WM_MOUSEMOVE,nFlags,MAKELONG(point.x,point.y));
	} 
    else 
		pWnd->PostMessage(WM_NCMOUSEMOVE,hittest,MAKELONG(point.x,point.y));
		
}