// ThemeButton.cpp : implementation file
//

#include "stdafx.h"
#include "CESim.h"
#include "ThemeButton.h"
#include "TmSchema.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CThemeButton
CThemeButton::CThemeButton()
{
	m_part_class=CLASS_UNKNOWN;
	m_hover=false;
	m_theme=NULL;
	m_use_theme=false;
	m_hThemeDll=LoadLibrary("UxTheme.dll");
	if(m_hThemeDll!=NULL)
	{
		m_pfnOpenThemeData=(PFNOPENTHEMEDATA)GetProcAddress(m_hThemeDll,"OpenThemeData");
		m_pfnCloseThemeData=(PFNCLOSETHEMEDATA)GetProcAddress(m_hThemeDll,"CloseThemeData");
		m_pfnIsAppThemed=(PFNISAPPTHEMED)GetProcAddress(m_hThemeDll,"IsAppThemed");
		m_pfnDrawThemeBackground=(PFNDRAWTHEMEBACKGROUND)GetProcAddress(m_hThemeDll,"DrawThemeBackground");
		if((m_pfnOpenThemeData!=NULL)&&(m_pfnCloseThemeData!=NULL)&&(m_pfnIsAppThemed!=NULL)&&(m_pfnDrawThemeBackground!=NULL))
		{
			if((*m_pfnIsAppThemed)())m_use_theme=true;
		}
	}
}

CThemeButton::~CThemeButton()
{
	if((m_use_theme)&&(m_theme!=NULL))(*m_pfnCloseThemeData)(m_theme);
//	if(m_hThemeDll!=NULL)FreeLibrary(m_hThemeDll);
}

BEGIN_MESSAGE_MAP(CThemeButton, CButton)
	//{{AFX_MSG_MAP(CThemeButton)
	ON_WM_MOUSEMOVE()
	ON_WM_TIMER()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CThemeButton message handlers
void CThemeButton::SetPart(int part_class)
{	// set theme part
	if(m_use_theme)
	{
		m_part_class=part_class;
		if(m_theme!=NULL)(*m_pfnCloseThemeData)(m_theme);
		if(m_part_class==CLASS_SPIN_UP)
		{
			m_theme=(*m_pfnOpenThemeData)(GetSafeHwnd(),L"Scrollbar");
			m_part=SBP_ARROWBTN;
		}
		if(m_part_class==CLASS_SPIN_DOWN)
		{
			m_theme=(*m_pfnOpenThemeData)(GetSafeHwnd(),L"Scrollbar");
			m_part=SBP_ARROWBTN;
		}
		if(m_part_class==CLASS_COMBOBOX)
		{
			m_theme=(*m_pfnOpenThemeData)(GetSafeHwnd(),L"ComboBox");
			m_part=CP_DROPDOWNBUTTON;
		}
	}
}

void CThemeButton::DrawItem(LPDRAWITEMSTRUCT lpDrawItemStruct) 
{
	if(m_use_theme)
	{
		int state=1;
		if(m_hover)state=2; // hot button
	    if(lpDrawItemStruct->itemState & ODS_SELECTED)state=3; // button pushed
		if(m_part_class==CLASS_SPIN_DOWN)state+=4;
		(*m_pfnDrawThemeBackground)(m_theme,lpDrawItemStruct->hDC,m_part,state,&lpDrawItemStruct->rcItem,NULL);
	}
	else
	{
		int state=DFCS_SCROLLCOMBOBOX;
		if(m_part_class==CLASS_SPIN_UP)state=DFCS_SCROLLUP;
		if(m_part_class==CLASS_SPIN_DOWN)state=DFCS_SCROLLDOWN;
		if(m_part_class==CLASS_COMBOBOX)state=DFCS_SCROLLCOMBOBOX;
		CDC* pDC=CDC::FromHandle(lpDrawItemStruct->hDC);
	    if(lpDrawItemStruct->itemState & ODS_SELECTED)state=state|DFCS_PUSHED;
		pDC->DrawFrameControl(&lpDrawItemStruct->rcItem,DFC_SCROLL,state);
	}
	
}

void CThemeButton::OnMouseMove(UINT nFlags, CPoint point) 
{
	if(!m_hover)
	{
		m_hover=true;
		SetTimer(TIMER_HOVER,HOVER_DELAY,NULL);
		Invalidate();
	}
	
	CButton::OnMouseMove(nFlags, point);
}

void CThemeButton::OnTimer(UINT nIDEvent) 
{
	POINT point;
	::GetCursorPos(&point);
	CRect winrect;
	GetWindowRect(&winrect);
	if(!winrect.PtInRect(point))
	{
		KillTimer(TIMER_HOVER);
		m_hover=false;
		Invalidate();
	}
	
	CButton::OnTimer(nIDEvent);
}
