// NetDesign.h - interface for CNetDesign
//

#ifndef __NETDESIGN_H__
#define __NETDESIGN_H__

#include "CEPNobj.h"

/////////////////////////////////////////////////////////////////////////////
// CNetDesign
class CNetDesign : public CObject
{
friend class CCESimDoc;

public:
	CNetDesign();
	virtual void Serialize(CArchive& ar);

	DECLARE_SERIAL(CNetDesign)

private:
	int				m_nEdges; // statistics
	int				m_nEvents;
	int				m_nConditions;
	CSize			m_window_size;
	CPNElementList	m_element_list; // list of elements in net
//	CSetConditions  m_net_conditions; // mnozina vsech podminek systemu

private:
	CPNLabel* GetSafeLabel(CPNElement* pElement);

public:
	void Draw(CDC* pDC);
	void DeleteContents();
	bool AddElement(CPNElement* pElement);
	void ReflectCase(CSetConditions& case_set);
	void UpdateEvents(CSetConditions& case_set);
	void ClearNet();
	int  DoNetComplement(CDC* pDC,bool onlycompute=false);
	int	 TestElementsNaming();
	int	 TestIsolatedElements();
	int	 TestEventsConcession(CTypedPtrArray<CObArray,CPNCase*>& case_graph_cases,int nCases);
	int	 TestDistinguishability();
	int	 TestEmptyNet();
	void ExportToXml(CString& filename);
	void SetWindowSize(CSize window_size);
	void UpdateTokensPath();
	CSize GetWindowSize()			{ return m_window_size; }
	CRect PlaceSelectedElements(bool place_back,CPNElementList& selected_elements);
	CRect RemoveSelectedElements(CPNElementList& selected_elements);
	CRect RecalculateEdges(const CPNElement* pDragged_element=NULL);
	CRect SelectElements(CRect& rect,bool simulation_mode,CPNElementList& selected_elements);
	CSetConditions ComputeElementsSets(); // vraci vychozi pripad
//	CSetConditions& GetNetConditions() { return m_net_conditions; }
	CPNElement* ElementAt(const CPoint& point,bool events=false,bool conditions=false);
};

#endif
