#if !defined(AFX_DLGSMOOTHCASEGRAPH_H__C6EC891F_7965_44ED_99C5_A34B6DBE4E0F__INCLUDED_)
#define AFX_DLGSMOOTHCASEGRAPH_H__C6EC891F_7965_44ED_99C5_A34B6DBE4E0F__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000
// DlgSmoothCaseGraph.h : header file
//

#include "resource.h"
#include "GenAlg.h"

/////////////////////////////////////////////////////////////////////////////
// CDlgSmoothCaseGraph dialog
class CDlgSmoothCaseGraph : public CDialog
{
private:
	CGenAlg	m_gen_alg;
	bool	m_running;
	bool	m_started;
	bool	m_best_exist;
	bool	m_population_prepared;
	int		m_min_grid_size;
	int		m_generations;
	int		m_intersections;
	DWORD	m_fitness;

	int	m_nCases; // number of cases in case graph
	int	m_nSteps; // number of steps in case graph
	CTypedPtrArray<CObArray,CPNCase*>*	m_pCase_graph_cases;
	CTypedPtrArray<CObArray,CPNStep*>*	m_pCase_graph_steps;

public:
	void DeleteContents();
	void SetInfo(int grid_size,int min_grid_size);
	void Init(CTypedPtrArray<CObArray,CPNStep*>& steps,int nSteps,CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases);
	void ApplyBestChromozome(CTypedPtrArray<CObArray,CPNCase*>& cases,int nCases)	{ m_gen_alg.ApplyBestChromozome(cases,nCases); }

	bool BestExist()	{ return m_best_exist; }
	int GetGridSize()	{ return m_gen_alg.GetGridSize(); }

public:
	CDlgSmoothCaseGraph(CWnd* pParent = NULL);   // standard constructor

	//{{AFX_DATA(CDlgSmoothCaseGraph)
	enum { IDD = IDD_SMOOTH_CASEGRAPH };
	CButton	m_btn_reset;
	CButton	m_btn_cancel;
	CButton	m_btn_ok;
	CButton	m_btn_stop;
	CButton	m_btn_start;
	CButton	m_btn_settings;
	//}}AFX_DATA

	// ClassWizard generated virtual function overrides
	//{{AFX_VIRTUAL(CDlgSmoothCaseGraph)
	protected:
	virtual void DoDataExchange(CDataExchange* pDX);    // DDX/DDV support
	//}}AFX_VIRTUAL

protected:
	// Generated message map functions
	//{{AFX_MSG(CDlgSmoothCaseGraph)
	afx_msg void OnBtnStart();
	virtual BOOL OnInitDialog();
	afx_msg void OnBtnSettings();
	afx_msg void OnBtnStop();
	afx_msg void OnBtnReset();
	//}}AFX_MSG
	DECLARE_MESSAGE_MAP()
};

//{{AFX_INSERT_LOCATION}}
// Microsoft Visual C++ will insert additional declarations immediately before the previous line.

#endif // !defined(AFX_DLGSMOOTHCASEGRAPH_H__C6EC891F_7965_44ED_99C5_A34B6DBE4E0F__INCLUDED_)
