// DlgPropertiesSimulationBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgPropertiesSimulationBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPropertiesSimulationBar
CDlgPropertiesSimulationBar::CDlgPropertiesSimulationBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgPropertiesSimulationBar)
	//}}AFX_DATA_INIT
}

void CDlgPropertiesSimulationBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPropertiesSimulationBar)
	DDX_Control(pDX, IDC_SIMULATION_SPEED, m_slider_ctrl);
	DDX_Control(pDX, IDC_BTN_SIM_START, m_btn_sim_start);
	DDX_Control(pDX, IDC_BTN_SIM_STOP, m_btn_sim_stop);
	DDX_Control(pDX, IDC_BTN_SIM_RESET, m_btn_sim_reset);
	DDX_Control(pDX, IDC_BTN_SIM_STEP, m_btn_sim_step);
	//}}AFX_DATA_MAP
}

CDlgPropertiesSimulationBar::~CDlgPropertiesSimulationBar()
{
}

BOOL CDlgPropertiesSimulationBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgPropertiesSimulationBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgPropertiesSimulationBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgPropertiesSimulationBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgPropertiesSimulationBar)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
	ON_MESSAGE(WM_HSCROLL,OnSimulationSpeed)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgPropertiesSimulationBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_slider_ctrl.SetRange(1,100);
	m_slider_ctrl.SetPos(25);
	m_slider_ctrl.SetLineSize(1);
	m_slider_ctrl.SetPageSize(10);

	m_btn_sim_reset.LoadBitmaps(IDB_SIMULATION_RESET_UP,IDB_SIMULATION_RESET_DOWN,0,IDB_SIMULATION_RESET_DISABLED);
	m_btn_sim_start.LoadBitmaps(IDB_SIMULATION_START_UP,IDB_SIMULATION_START_DOWN,0,IDB_SIMULATION_START_DISABLED);
	m_btn_sim_stop.LoadBitmaps(IDB_SIMULATION_STOP_UP,IDB_SIMULATION_STOP_DOWN,0,IDB_SIMULATION_STOP_DISABLED);
	m_btn_sim_step.LoadBitmaps(IDB_SIMULATION_STEP_UP,IDB_SIMULATION_STEP_DOWN,0,IDB_SIMULATION_STEP_DISABLED);
	return bRet;
}

LRESULT CDlgPropertiesSimulationBar::OnSimulationSpeed(WPARAM /*wparam*/,LPARAM lparam)
{
	if((HWND)lparam==m_slider_ctrl.GetSafeHwnd())
		::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_SIMULATION_SPEED,m_slider_ctrl.GetPos(),m_slider_ctrl.GetPos());
	return 0;
}

void CDlgPropertiesSimulationBar::EnableSimulationButtons(bool btn_reset,bool btn_start,bool btn_stop,bool btn_step)
{
	m_btn_sim_reset.EnableWindow(btn_reset);
	m_btn_sim_start.EnableWindow(btn_start);
	m_btn_sim_stop.EnableWindow(btn_stop);
	m_btn_sim_step.EnableWindow(btn_step);
}

void CDlgPropertiesSimulationBar::SetNetElement(CPNElement* pElement)
{
	CDlgPropertiesBar::SetNetElement(pElement);
}
