// DlgPropertiesPolygonBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgPropertiesPolygonBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPropertiesPolygonBar
CDlgPropertiesPolygonBar::CDlgPropertiesPolygonBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgPropertiesPolygonBar)
	m_line_width = 0;
	//}}AFX_DATA_INIT
}

void CDlgPropertiesPolygonBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPropertiesPolygonBar)
	DDX_Control(pDX, IDC_BTN_LINE_WIDTH_UP, m_btn_line_width_up);
	DDX_Control(pDX, IDC_BTN_LINE_WIDTH_DOWN, m_btn_line_width_down);
	DDX_Control(pDX, IDC_BTN_FILL_COLOR, m_btn_fill_color);
	DDX_Control(pDX, IDC_BTN_LINE_COLOR, m_btn_line_color);
	DDX_Control(pDX, IDC_CSTM_LINE_COLOR, m_st_line_color);
	DDX_Control(pDX, IDC_CSTM_FILL_COLOR, m_st_fill_color);
	DDX_Control(pDX, IDC_COMBO_FILL_MODE, m_fill_mode);
	DDX_Control(pDX, IDC_COMBO_LINE_STYLE, m_line_style);
	DDX_Text(pDX, IDC_EDIT_LINE_WIDTH, m_line_width);
	DDX_Control(pDX, IDC_EDIT_LINE_WIDTH, m_edit_line_width);
	//}}AFX_DATA_MAP
}

CDlgPropertiesPolygonBar::~CDlgPropertiesPolygonBar()
{
}

BOOL CDlgPropertiesPolygonBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgPropertiesPolygonBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgPropertiesPolygonBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgPropertiesPolygonBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgPropertiesPolygonBar)
	ON_BN_CLICKED(IDC_BTN_LINE_COLOR, OnBtnLineColor)
	ON_BN_CLICKED(IDC_BTN_FILL_COLOR, OnBtnFillColor)
	ON_BN_CLICKED(IDC_BTN_LINE_WIDTH_UP, OnBtnLineWidthUp)
	ON_BN_CLICKED(IDC_BTN_LINE_WIDTH_DOWN, OnBtnLineWidthDown)
	ON_EN_CHANGE(IDC_EDIT_LINE_WIDTH, OnChangeEditLineWidth)
	ON_CBN_SELENDOK(IDC_COMBO_LINE_STYLE, OnSelendokComboLineStyle)
	ON_CBN_SELENDOK(IDC_COMBO_FILL_MODE, OnSelendokComboFillMode)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
	ON_MESSAGE(CPN_SELENDOK,OnColorSelEndOK)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgPropertiesPolygonBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_pPolygon=NULL;
	m_ignore_change=false;
	m_btn_line_color.SetPart(CThemeButton::CLASS_COMBOBOX);
	m_btn_fill_color.SetPart(CThemeButton::CLASS_COMBOBOX);
	m_btn_line_width_up.SetPart(CThemeButton::CLASS_SPIN_UP);
	m_btn_line_width_down.SetPart(CThemeButton::CLASS_SPIN_DOWN);

	return bRet;
}

void CDlgPropertiesPolygonBar::SetNetElement(CPNElement* pElement)
{
	CDlgPropertiesBar::SetNetElement(pElement);

	m_pPolygon=dynamic_cast<CPNPolygon*>(pElement);
	if(m_pPolygon)
	{
		m_ignore_change=true;
		m_st_line_color.SetColor(m_pPolygon->GetLineColor());
		m_line_style.SetCurSel(m_pPolygon->GetLineStyle());
		SetDlgItemInt(IDC_EDIT_LINE_WIDTH,m_pPolygon->GetLineWidth(),FALSE);
		m_st_fill_color.SetColor(m_pPolygon->GetFillColor());
		m_fill_mode.SetCurSel(m_pPolygon->GetFillMode());
	}
}

void CDlgPropertiesPolygonBar::OnBtnLineColor() 
{
	CRect rect;
	m_st_line_color.GetWindowRect(&rect);
    new CColourPopup(CPoint(rect.left-2,rect.bottom),m_st_line_color.GetColor(),this,"Default color","Custom color",1);
}

void CDlgPropertiesPolygonBar::OnSelendokComboLineStyle() 
{
	if(m_pPolygon)
	{
		m_pPolygon->SetLineStyle(m_line_style.GetCurSel());
		UpdateElement();
	}
}

void CDlgPropertiesPolygonBar::OnBtnFillColor() 
{
	CRect rect;
	m_st_fill_color.GetWindowRect(&rect);
    new CColourPopup(CPoint(rect.left-2,rect.bottom),m_st_fill_color.GetColor(),this,"Default color","Custom color",2);
}

void CDlgPropertiesPolygonBar::OnBtnLineWidthUp() 
{
	UINT i=GetDlgItemInt(IDC_EDIT_LINE_WIDTH,NULL,FALSE);
	SetDlgItemInt(IDC_EDIT_LINE_WIDTH,i+1,FALSE);
}

void CDlgPropertiesPolygonBar::OnBtnLineWidthDown() 
{
	int i=GetDlgItemInt(IDC_EDIT_LINE_WIDTH,NULL,FALSE);
	i-=1;
	if(i<1)i=1;
	SetDlgItemInt(IDC_EDIT_LINE_WIDTH,i,FALSE);
}

void CDlgPropertiesPolygonBar::OnChangeEditLineWidth() 
{
	int i=GetDlgItemInt(IDC_EDIT_LINE_WIDTH,NULL,FALSE);
	GetDlgItem(IDC_COMBO_LINE_STYLE)->EnableWindow(i==1);
	if(m_ignore_change)
	{
		m_ignore_change=false;
		return;
	}
	if(m_pPolygon)
	{
		if(i==0)
		{
			i=1;
			m_ignore_change=true;
			SetDlgItemInt(IDC_EDIT_LINE_WIDTH,i,FALSE);
		}
		m_pPolygon->SetLineWidth(i);
		UpdateElement();
	}
}

LRESULT CDlgPropertiesPolygonBar::OnColorSelEndOK(WPARAM wparam,LPARAM lparam)
{
	if(lparam==1)
	{
		m_st_line_color.SetColor(wparam);
		if(m_pPolygon)
		{
			m_pPolygon->SetLineColor(wparam);
			UpdateElement();
		}
	}
	if(lparam==2)
	{
		m_st_fill_color.SetColor(wparam);
		if(m_pPolygon)
		{
			m_pPolygon->SetFillColor(wparam);
			UpdateElement();
		}
	}
    return TRUE;
}

void CDlgPropertiesPolygonBar::OnSelendokComboFillMode() 
{
	if(m_pPolygon)
	{
		m_pPolygon->SetFillMode(m_fill_mode.GetCurSel());
		UpdateElement();
	}
}

void CDlgPropertiesPolygonBar::UpdateElement()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_ELEMENT,0);
}
