// DlgPropertiesLabelBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgPropertiesLabelBar.h"
#include "DialogSetText.h"

#include <afxpriv.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPropertiesLabelBar
CDlgPropertiesLabelBar::CDlgPropertiesLabelBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgPropertiesLabelBar)
	//}}AFX_DATA_INIT
}

void CDlgPropertiesLabelBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPropertiesLabelBar)
	//}}AFX_DATA_MAP
}

CDlgPropertiesLabelBar::~CDlgPropertiesLabelBar()
{
}

BOOL CDlgPropertiesLabelBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgPropertiesLabelBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgPropertiesLabelBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgPropertiesLabelBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgPropertiesLabelBar)
	ON_BN_CLICKED(IDC_BTN_TEXT, OnBtnText)
	ON_BN_CLICKED(IDC_BTN_FONT, OnBtnFont)
	ON_EN_CHANGE(IDC_EDIT_TEXT, OnChangeEditText)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgPropertiesLabelBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_pLabel=NULL;
	m_color=RGB(0,0,0);
	m_ignore_change_text=false;

	return bRet;
}

void CDlgPropertiesLabelBar::SetNetElement(CPNElement* pElement)
{
	CDlgPropertiesBar::SetNetElement(pElement);

	m_pLabel=dynamic_cast<CPNLabel*>(pElement);
	if(m_pLabel)
	{
		m_ignore_change_text=true;
		m_logfont=m_pLabel->GetLogFont();
		m_color=m_pLabel->GetColor();
		m_text=m_pLabel->GetText();
		CString text;
		text=m_text;
		text.Replace(10,' ');
		text.Remove(13);
		SetDlgItemText(IDC_EDIT_TEXT,text);
		SetDlgItemText(IDC_EDIT_FONT,m_logfont.lfFaceName);
	}
}

void CDlgPropertiesLabelBar::OnChangeEditText() 
{
	if(m_ignore_change_text)
	{
		m_ignore_change_text=false;
		return;
	}
	if(m_pLabel)
	{
		GetDlgItemText(IDC_EDIT_TEXT,m_text);
		m_pLabel->SetText(m_text);
		UpdateText();
	}
}

void CDlgPropertiesLabelBar::OnBtnText() 
{
	CDialogSetText dlg;
	dlg.SetText(m_text);
	if(dlg.DoModal()==IDOK)
	{
		m_text=dlg.GetText();
		CString text;
		text=m_text;
		text.Replace(10,' ');
		text.Remove(13);
		m_ignore_change_text=true;
		SetDlgItemText(IDC_EDIT_TEXT,text);
		if(m_pLabel)
		{
			m_pLabel->SetText(m_text);
			UpdateText();
		}
	}
	((CButton*)GetDlgItem(IDC_BTN_TEXT))->SetButtonStyle(0);
}

void CDlgPropertiesLabelBar::OnBtnFont() 
{
	CFontDialog dlg;
	dlg.m_cf.Flags=dlg.m_cf.Flags|CF_INITTOLOGFONTSTRUCT|CF_EFFECTS;
	dlg.m_cf.lpLogFont=&m_logfont;
	dlg.m_cf.rgbColors=m_color;
	if(dlg.DoModal()==IDOK)
	{
		dlg.GetCurrentFont(&m_logfont);
		SetDlgItemText(IDC_EDIT_FONT,m_logfont.lfFaceName);
		m_color=dlg.GetColor();
		if(m_pLabel)
		{
			m_pLabel->SetColor(m_color);
			m_pLabel->SetLogFont(m_logfont);
			UpdateText();
		}
	}
	((CButton*)GetDlgItem(IDC_BTN_FONT))->SetButtonStyle(0);
}

void CDlgPropertiesLabelBar::UpdateText()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_TEXT,0);
}
