// DlgPropertiesConditionBar.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgPropertiesConditionBar.h"
#include "DialogSetText.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgPropertiesConditionBar
CDlgPropertiesConditionBar::CDlgPropertiesConditionBar()
{
	CDlgPropertiesBar();
	//{{AFX_DATA_INIT(CDlgPropertiesConditionBar)
	m_name = _T("");
	//}}AFX_DATA_INIT
}

void CDlgPropertiesConditionBar::DoDataExchange(CDataExchange* pDX)
{
	CDlgPropertiesBar::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgPropertiesConditionBar)
	DDX_Control(pDX, IDC_COMBO_INIT_TOKEN, m_combo_initial_token);
	DDX_Control(pDX, IDC_COMBO_SHOW_NAME, m_combo_show_name);
	//}}AFX_DATA_MAP
}

CDlgPropertiesConditionBar::~CDlgPropertiesConditionBar()
{
}

BOOL CDlgPropertiesConditionBar::Create(CWnd* pParentWnd,LPCTSTR lpszTemplateName,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,lpszTemplateName,nStyle,nID);
}

BOOL CDlgPropertiesConditionBar::Create(CWnd* pParentWnd,UINT nIDTemplate,UINT nStyle,UINT nID)
{
	return CDlgPropertiesBar::Create(pParentWnd,nIDTemplate,nStyle,nID);
}

IMPLEMENT_DYNAMIC(CDlgPropertiesConditionBar, CDlgPropertiesBar)

BEGIN_MESSAGE_MAP(CDlgPropertiesConditionBar, CDlgPropertiesBar)
	//{{AFX_MSG_MAP(CDlgPropertiesConditionBar)
	ON_BN_CLICKED(IDC_BTN_TEXT, OnBtnText)
	ON_EN_CHANGE(IDC_EDIT_NAME, OnChangeEditName)
	ON_CBN_SELENDOK(IDC_COMBO_SHOW_NAME, OnSelendokComboShowName)
	ON_CBN_SELENDOK(IDC_COMBO_INIT_TOKEN, OnSelendokComboInitToken)
	//}}AFX_MSG_MAP
	ON_MESSAGE(WM_INITDIALOG,OnInitDialog)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRollDlgBar message handlers
LONG CDlgPropertiesConditionBar::OnInitDialog(UINT wParam,LONG lParam)
{
	BOOL bRet=HandleInitDialog(wParam,lParam);
	UpdateData(FALSE);

	m_pCondition=NULL;
	m_pLabel=NULL;
	m_ignore_change_text=false;

	return bRet;
}

void CDlgPropertiesConditionBar::SetNetElement(CPNElement* pElement)
{
	CDlgPropertiesBar::SetNetElement(pElement);

	m_pCondition=NULL;
	m_pLabel=NULL;
	m_pCondition=dynamic_cast<CPNCondition*>(pElement);
	if(m_pCondition)
	{
		m_pLabel=m_pCondition->GetLabel();
		m_combo_initial_token.SetCurSel(m_pCondition->GetToken()? 1 : 0);
	}
	if(m_pLabel)
	{
		m_name=m_pLabel->GetText();
		CString text;
		text=m_name;
		text.Replace(10,' ');
		text.Remove(13);
		m_ignore_change_text=true;
		SetDlgItemText(IDC_EDIT_NAME,text);
		m_combo_show_name.SetCurSel(m_pLabel->IsVisible()? 0 : 1);
	}
}

void CDlgPropertiesConditionBar::Update()
{
	if(m_pCondition)
	{
		m_combo_initial_token.SetCurSel(m_pCondition->GetToken()? 1 : 0);
	}
}

void CDlgPropertiesConditionBar::OnChangeEditName() 
{
	if(m_ignore_change_text)
	{
		m_ignore_change_text=false;
		return;
	}
	if(m_pLabel)
	{
		GetDlgItemText(IDC_EDIT_NAME,m_name);
		m_pLabel->SetText(m_name);
		UpdateLabel();
	}
}

void CDlgPropertiesConditionBar::OnBtnText() 
{
	CDialogSetText dlg;
	dlg.SetText(m_name);
	if(dlg.DoModal()==IDOK)
	{
		m_name=dlg.GetText();
		CString text;
		text=m_name;
		text.Replace(10,' ');
		text.Remove(13);
		m_ignore_change_text=true;
		SetDlgItemText(IDC_EDIT_NAME,text);
		if(m_pLabel)
		{
			m_pLabel->SetText(m_name);
			UpdateLabel();
		}
	}
	((CButton*)GetDlgItem(IDC_BTN_TEXT))->SetButtonStyle(0);
}

void CDlgPropertiesConditionBar::OnSelendokComboShowName() 
{
	if(m_pLabel)
	{
		m_pLabel->SetVisible(m_combo_show_name.GetCurSel()==0);
		UpdateLabel();
	}
}

void CDlgPropertiesConditionBar::OnSelendokComboInitToken() 
{
	if(m_pCondition)
	{
		m_pCondition->SetToken(m_combo_initial_token.GetCurSel()==1);
		UpdateElement();
	}
}

void CDlgPropertiesConditionBar::UpdateElement()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_ELEMENT,0);
}

void CDlgPropertiesConditionBar::UpdateLabel()
{
	::PostMessage(AfxGetMainWnd()->GetSafeHwnd(),APP_MSG_UPDATE_VIEW,UPDATE_VIEW_LABEL_COND,0);
}
