// DlgCaseClassAnalysis.cpp : implementation file
//

#include "stdafx.h"
#include "cesim.h"
#include "DlgCaseClassAnalysis.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CDlgCaseClassAnalysis dialog
CDlgCaseClassAnalysis::CDlgCaseClassAnalysis(CWnd* pParent /*=NULL*/)
	: CDialog(CDlgCaseClassAnalysis::IDD, pParent)
{
	//{{AFX_DATA_INIT(CDlgCaseClassAnalysis)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT
}

void CDlgCaseClassAnalysis::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CDlgCaseClassAnalysis)
	DDX_Control(pDX, IDC_LIST_CONDITIONS_OUT, m_list_out);
	DDX_Control(pDX, IDC_LIST_CONDITIONS_IN, m_list_in);
	DDX_Control(pDX, IDC_BTN_DEL_OUT, m_btn_del_out);
	DDX_Control(pDX, IDC_BTN_DEL_IN, m_btn_del_in);
	DDX_Control(pDX, IDC_BTN_ADD_OUT, m_btn_add_out);
	DDX_Control(pDX, IDC_BTN_ADD_IN, m_btn_add_in);
	DDX_Control(pDX, IDC_CHECK_REACHABLE, m_check_reach);
	DDX_Control(pDX, IDC_BTN_FIND, m_btn_find);
	DDX_Control(pDX, IDC_BTN_CLEAR, m_btn_clear);
	DDX_Control(pDX, IDC_LIST_CONDITIONS, m_list_conditions);
	DDX_Control(pDX, IDC_LIST_CASES, m_list_cases);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CDlgCaseClassAnalysis, CDialog)
	//{{AFX_MSG_MAP(CDlgCaseClassAnalysis)
	ON_BN_CLICKED(IDC_BTN_CLEAR, OnBtnClear)
	ON_BN_CLICKED(IDC_BTN_FIND, OnBtnFind)
	ON_BN_CLICKED(IDC_BTN_ADD_IN, OnBtnAddIn)
	ON_BN_CLICKED(IDC_BTN_DEL_IN, OnBtnDelIn)
	ON_BN_CLICKED(IDC_BTN_ADD_OUT, OnBtnAddOut)
	ON_BN_CLICKED(IDC_BTN_DEL_OUT, OnBtnDelOut)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CDlgCaseClassAnalysis message handlers
BOOL CDlgCaseClassAnalysis::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	ShowSets();

	{
	int ext;
	int max_ext=0;
	CString str;
	CSetConditions case_set;
	CClientDC dc(&m_list_cases);
	for(int index_case=0;index_case<m_nCases;index_case++)
	{
		case_set=m_case_class.GetAt(index_case);
		str=case_set.Format();
		ext=dc.GetTextExtent(str).cx;
		if(ext>max_ext)max_ext=ext;
	}
	m_list_cases.SetHorizontalExtent(max_ext);
	}

	{
	int i,ext;
	int max_ext=0;
	int count=m_list_conditions.GetCount();
	CString str;
	CClientDC dc(&m_list_cases);
	for(i=0;i<count;i++)
	{
		m_list_conditions.GetText(i,str);
		ext=dc.GetTextExtent(str).cx;
		if(ext>max_ext)max_ext=ext;
	}
	m_list_conditions.SetHorizontalExtent(max_ext);
	m_list_out.SetHorizontalExtent(max_ext);
	m_list_in.SetHorizontalExtent(max_ext);
	}

	m_check_reach.SetCheck(1);

	return TRUE;
}

void CDlgCaseClassAnalysis::OnBtnAddIn() 
{
	int sel=m_list_conditions.GetCurSel();
	CString text;
	m_list_conditions.GetText(sel,text);
	DWORD data=m_list_conditions.GetItemData(sel);
	m_list_conditions.DeleteString(sel);
	m_list_conditions.SetCurSel(0);
	sel=m_list_in.AddString(text);
	m_list_in.SetItemData(sel,data);
	m_list_in.SetCurSel(sel);
	m_btn_add_in.EnableWindow(m_list_in.GetCount()!=0);
	m_btn_del_in.EnableWindow(TRUE);
	m_btn_clear.EnableWindow(TRUE);
	m_btn_find.EnableWindow(TRUE);
}

void CDlgCaseClassAnalysis::OnBtnDelIn() 
{
	int sel=m_list_in.GetCurSel();
	CString text;
	m_list_in.GetText(sel,text);
	DWORD data=m_list_in.GetItemData(sel);
	m_list_in.DeleteString(sel);
	m_list_in.SetCurSel(0);
	sel=m_list_conditions.AddString(text);
	m_list_conditions.SetItemData(sel,data);
	m_list_conditions.SetCurSel(sel);
	m_btn_add_in.EnableWindow(TRUE);
	m_btn_del_in.EnableWindow(m_list_in.GetCount()!=0);
	m_btn_clear.EnableWindow(m_list_in.GetCount()!=0);
	m_btn_find.EnableWindow(m_list_in.GetCount()!=0);
}

void CDlgCaseClassAnalysis::OnBtnAddOut() 
{
	int sel=m_list_conditions.GetCurSel();
	CString text;
	m_list_conditions.GetText(sel,text);
	DWORD data=m_list_conditions.GetItemData(sel);
	m_list_conditions.DeleteString(sel);
	m_list_conditions.SetCurSel(0);
	sel=m_list_out.AddString(text);
	m_list_out.SetItemData(sel,data);
	m_list_out.SetCurSel(sel);
	m_btn_add_out.EnableWindow(m_list_out.GetCount()!=0);
	m_btn_del_out.EnableWindow(TRUE);
	m_btn_clear.EnableWindow(TRUE);
	m_btn_find.EnableWindow(TRUE);
}

void CDlgCaseClassAnalysis::OnBtnDelOut() 
{
	int sel=m_list_out.GetCurSel();
	CString text;
	m_list_out.GetText(sel,text);
	DWORD data=m_list_out.GetItemData(sel);
	m_list_out.DeleteString(sel);
	m_list_out.SetCurSel(0);
	sel=m_list_conditions.AddString(text);
	m_list_conditions.SetItemData(sel,data);
	m_list_conditions.SetCurSel(sel);
	m_btn_add_out.EnableWindow(TRUE);
	m_btn_del_out.EnableWindow(m_list_out.GetCount()!=0);
	m_btn_clear.EnableWindow(m_list_out.GetCount()!=0);
	m_btn_find.EnableWindow(m_list_out.GetCount()!=0);
}

void CDlgCaseClassAnalysis::OnBtnClear() 
{
	m_list_conditions.ResetContent();
	m_list_out.ResetContent();
	m_list_in.ResetContent();
	m_list_cases.ResetContent();
	ShowSets();
}

void CDlgCaseClassAnalysis::OnBtnFind() 
{
	m_list_cases.ResetContent();
	bool onlyreachable;
	onlyreachable=(m_check_reach.GetCheck()!=0);
	CPNCondition* pCondition;
	CSetConditions case_set;
	int count_in,count_out;
	count_in=m_list_in.GetCount();
	count_out=m_list_out.GetCount();
	int index_case,index_list;
	for(index_case=0;index_case<m_nCases;index_case++)
	{	// prochazi pripady
		bool find=true;
		case_set=m_case_class.GetAt(index_case);
		if(onlyreachable)
			if(m_case_reach.GetAt(index_case)==0)continue;
		for(index_list=0;index_list<count_in;index_list++)
		{	// prochazi podminky, ktere maji byt obsazeny v pripadu
			pCondition=(CPNCondition*)m_list_in.GetItemData(index_list);
			if(!case_set.Includes(pCondition))
			{
				find=false;
				break;
			}
		}
		if(!find)continue;
		for(index_list=0;index_list<count_out;index_list++)
		{	// prochazi podminky, ktere nemaji byt obsazeny v pripadu
			pCondition=(CPNCondition*)m_list_out.GetItemData(index_list);
			if(case_set.Includes(pCondition))
			{
				find=false;
				break;
			}
		}
		if(find)m_list_cases.AddString(case_set.Format());
	}
	if(m_list_cases.GetCount()==0)m_list_cases.AddString("no such case");
}

void CDlgCaseClassAnalysis::ShowSets()
{
	int pos;
	CPNLabel* pLabel;
	CPNCondition* pCondition;
	for(int index=0;index<m_nConditions;index++)
	{
		pCondition=m_conditions.GetAt(index);
		pLabel=pCondition->GetLabel();
		if(pLabel)
		{
			pos=m_list_conditions.AddString(pLabel->GetText());
			m_list_conditions.SetItemData(pos,(DWORD)pCondition);
		}
	}
	m_list_conditions.SetCurSel(0);
	m_btn_add_in.EnableWindow(m_list_conditions.GetCount()!=0);
	m_btn_del_in.EnableWindow(FALSE);
	m_btn_add_out.EnableWindow(m_list_conditions.GetCount()!=0);
	m_btn_del_out.EnableWindow(FALSE);
	m_btn_clear.EnableWindow(FALSE);
	m_btn_find.EnableWindow(FALSE);
}
