// CaseGraph.h - interface for CCaseGraph
//

#ifndef __CASEGRAPH_H__
#define __CASEGRAPH_H__

#include "CEPNobj.h"
#include "DlgSmoothCaseGraph.h"

/////////////////////////////////////////////////////////////////////////////
// CCaseGraph
class CCaseGraph : public CObject
{
friend class CCESimDoc;

public:
	CCaseGraph();
	virtual void Serialize(CArchive& ar);

	DECLARE_SERIAL(CCaseGraph);

private:
	enum { DIRECTION_FWD=0, DIRECTION_BCKWD=1 };
	enum { CASE_GRID_SPAN=60 };

private:
	class CStepInfo
	{
	public:
		CStepInfo& operator = (CStepInfo& stepinfo);
		CStepInfo()	{}

		CSetEvents		m_step_set; // set of realizable detached events
		CSetConditions	m_step_preset;
		CSetConditions	m_step_postset;
	};

	class CFRCasesClass
	{	// trida dopredne dosazitelnych pripadu
	private:
		int			m_count; // pocet mnozin, ktere spadaji do teto tridy

	public:
		CFRCasesClass& operator = (CFRCasesClass& frcases);
		CFRCasesClass()	{ m_count=1; }

		void AddCase(CPNCase* pCase)	{ m_frcases_set.Add(pCase); }
		int GetCount()					{ return m_count; }
		void IncCount()					{ m_count++; }
		
		CSetCases	m_frcases_set; // set of forward reachable cases
	};

	bool m_smooth_initialized;
	CDlgSmoothCaseGraph	m_dlg_smooth;

	// data for computing case graph
	int	m_nCases; // number of cases in case graph
	int	m_nSteps; // number of steps in case graph
	int	m_nLabels; // number of labels in case graph
	int	m_nEvents; // number of events in original net
	int	m_grid_size;
	int	m_min_grid_size;
	int	m_nGenSteps;
	int	m_nRlzEvents;
	int	m_max_step_level;

	int	m_case_browse_index; // for enumeration cases

	BOOL	m_graph_placed; // graf byl zobrazen a mame si co zapamatovat
	int		m_nOldCases; // number of cases in old case graph
	CArray<CPoint,CPoint&>	m_oldcases_positions;

	CSize m_window_size;

	CArray<CStepInfo,CStepInfo&>		m_steps;
	CTypedPtrArray<CObArray,CPNCase*>	m_case_graph_cases;
	CTypedPtrArray<CObArray,CPNStep*>	m_case_graph_steps;
	CTypedPtrArray<CObArray,CPNLabel*>	m_case_graph_labels;
	CTypedPtrArray<CObArray,CPNEvent*>	m_net_events;
	CTypedPtrArray<CObArray,CPNEvent*>	m_realizable_events;
	CTypedPtrList<CObList,CPNElement*>	m_elements_list; // list of user added elements in case graph

	CList<CFRCasesClass,CFRCasesClass&>	m_frcases_classes_list;

private:
	BOOL IsContactFree();
	void PrepareCaseGraph(const CPNElementList& element_list);
	void ComputeCaseGraph(const CSetConditions& initial_case,const CPNElementList& element_list);
	void ComputeRealizableEvents(CSetConditions& act_case,int direction);
	void GenerateAllSteps();
	void ReachCase(CPNCase* pCase);
	void GenerateStepsCombinations(CStepInfo& step_info,int index,int level);
	bool GetNextStep(int& step_index,CStepInfo& step_info);
	void RealizeStep(CSetConditions& act_case,CStepInfo& step_info,int direction);
	CPNCase* FindCase(CSetConditions& act_case);
	bool FindStep(CPNCase* from_case,CPNCase* to_case,CSetEvents& step_set,int direction);
	CPoint GetRandomCasePosition(CArray<CPoint,CPoint&>& case_occupation, int nCaseCount);

public:
	void Place();
	void Draw(CDC* pDC);
	void PrintLegend(CDC* pDC,int textheight);
	void DeleteContents(bool newdoc=true);
	void Writeoutcaseclass();
	void ExportCaseClass(CString& filename);
	void ExportToXml(CString& filename);
	void WriteOutLegend();
	void LabelElements(CDC* pDC);
	void InitCaseBrowse();
	bool Smooth(CSize& window_size);
	void ComputeReach(const CSetConditions& initial_case); // compute forward reachable cases
	void Computeallreachablecases();
	void SetWindowSize(CSize window_size);
	void HighLightCase(CSetConditions& case_set,bool highlight=true);
	void SetMinGridSize(int grid_size);
	void HighlightReachableCases(bool highlight);
	int	 GetGridSize()					{ return m_grid_size; }
	CSize GetWindowSize()				{ return m_window_size; }
	CRect RecalculateSteps(const CPNElement* pDragged_element=NULL,bool first=false);
	CRect SelectElements(CRect& rect,CPNElementList& selected_elements);
	CRect PlaceSelectedElements(bool place_back,CPNElementList& selected_elements);

	CSetEvents	GetStep(CSetConditions& act_case,bool random=true);
	CPNCase*	GetNextCase();
	CPNElement* ElementAt(const CPoint& point);
};

#endif
