// CESimOccurrenceNetView.cpp : implementation file
//

#include "stdafx.h"
#include "CESim.h"
#include "CESimDoc.h"
#include "CESimOccurrenceNetView.h"
#include "MainFrm.h"
#include "DlgProperties.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CCESimOccurrenceNetView
IMPLEMENT_DYNCREATE(CCESimOccurrenceNetView, CScrollView)

CCESimOccurrenceNetView::CCESimOccurrenceNetView()
{
	m_export=false;
	m_tool_selected=TOOL_SELECT;
	m_mouse_capture=false;
	m_last_drag_pt=CPoint(-1,-1);
	m_capture_type=CT_NONE;
	m_hit_element=NULL;
	m_context_element=NULL;
	m_ignore_move=false;
	m_simulation_mode=false;

    m_TitleTip.Create(this);

	m_ruler_last_pt=false;
	::ZeroMemory(&m_ruler_logfont,sizeof(m_ruler_logfont));
	m_ruler_logfont.lfCharSet=1;
	m_ruler_logfont.lfHeight=-10;
	strcpy(m_ruler_logfont.lfFaceName,"Arial");
	m_ruler_font.CreateFontIndirect(&m_ruler_logfont);
}

CCESimOccurrenceNetView::~CCESimOccurrenceNetView()
{
}


BEGIN_MESSAGE_MAP(CCESimOccurrenceNetView, CScrollView)
	//{{AFX_MSG_MAP(CCESimOccurrenceNetView)
	ON_WM_ERASEBKGND()
	ON_WM_CONTEXTMENU()
	ON_COMMAND(ID_VIEW_GRID, OnViewGrid)
	ON_UPDATE_COMMAND_UI(ID_VIEW_GRID, OnUpdateViewGrid)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_COMMAND(ID_EDIT_DELETE, OnEditDelete)
	ON_UPDATE_COMMAND_UI(ID_EDIT_DELETE, OnUpdateEditDelete)
	ON_COMMAND(ID_EDGE_DELETEPOINT, OnEdgeDeletepoint)
	ON_UPDATE_COMMAND_UI(ID_EDGE_DELETEPOINT, OnUpdateEdgeDeletepoint)
	ON_COMMAND(ID_EDGE_DELETEALLPOINTS, OnEdgeDeleteallpoints)
	ON_UPDATE_COMMAND_UI(ID_EDGE_DELETEALLPOINTS, OnUpdateEdgeDeleteallpoints)
	ON_COMMAND(ID_POLYGON_DELETEPOINT, OnPolygonDeletepoint)
	ON_UPDATE_COMMAND_UI(ID_POLYGON_DELETEPOINT, OnUpdatePolygonDeletepoint)
	ON_COMMAND(ID_VIEW_PROPERTIES_OCCURRENCENET, OnViewPropertiesOccurrenceNet)
	ON_UPDATE_COMMAND_UI(ID_VIEW_PROPERTIES_OCCURRENCENET, OnUpdateViewPropertiesOccurrenceNet)
	ON_COMMAND(ID_EDIT_PLACETOFRONT, OnEditPlacetofront)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PLACETOFRONT, OnUpdateEditPlacetofront)
	ON_COMMAND(ID_EDIT_PLACETOBACK, OnEditPlacetoback)
	ON_UPDATE_COMMAND_UI(ID_EDIT_PLACETOBACK, OnUpdateEditPlacetoback)
	ON_COMMAND(ID_OCCURRENCENET_EXPORTTOEMF, OnOccurrenceNetExporttoemf)
	ON_WM_KEYUP()
	ON_COMMAND(ID_VIEW_RULER, OnViewRuler)
	ON_UPDATE_COMMAND_UI(ID_VIEW_RULER, OnUpdateViewRuler)
	ON_WM_MOUSEWHEEL()
	//}}AFX_MSG_MAP
	ON_COMMAND_RANGE(ID_TOOLS_SELECT,ID_TOOLS_TOKEN,OnToolChange)
	ON_UPDATE_COMMAND_UI_RANGE(ID_TOOLS_SELECT,ID_TOOLS_TOKEN,OnUpdateToolsChange)
	ON_MESSAGE(APP_MSG_UPDATE_VIEW,OnUpdateView)
	ON_COMMAND(ID_FILE_PRINT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CScrollView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CScrollView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCESimOccurrenceNetView drawing
void CCESimOccurrenceNetView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	m_tool_selected=TOOL_SELECT;
	m_mouse_capture=false;
	m_last_drag_pt=CPoint(-1,-1);
	m_capture_type=CT_NONE;
	m_hit_element=NULL;
	m_context_element=NULL;

	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	m_simulation_mode=pDoc->IsSimulationMode();

	CSize sizeTotal;
	// TODO: calculate the total size of this view
	sizeTotal.cx = sizeTotal.cy = 100;
	SetScrollSizes(MM_TEXT, sizeTotal);
}

void CCESimOccurrenceNetView::OnDraw(CDC* pDC)
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	if(m_export)
	{
		m_export=false;
		CMetaFileDC metafile;
		metafile.CreateEnhanced(pDC,pDoc->GetTitle(),NULL,"CESim\0CESim\0\0");
		metafile.SetAttribDC(pDC->m_hAttribDC);
		pDoc->OccurrenceNet_Draw(&metafile);
		HENHMETAFILE hmeta=metafile.CloseEnhanced();
		CopyEnhMetaFile(hmeta,m_export_path);
		DeleteEnhMetaFile(hmeta);
	}

	CDC memdc;
	CBitmap bitmap;
	CBitmap* oldbitmap=NULL;
	CRect cliprect;
	pDC->GetClipBox(&cliprect);

	CDC* pDrawDC=pDC;
	if(!pDC->IsPrinting())
	{	// draw to offscreen bitmap for flicker free repaints
		if(memdc.CreateCompatibleDC(pDC))
		{
			if(bitmap.CreateCompatibleBitmap(pDC,cliprect.Width(),cliprect.Height()))
			{
				OnPrepareDC(&memdc,NULL);
				oldbitmap=memdc.SelectObject(&bitmap);
				CRect devicerect=cliprect;
				pDC->LPtoDP(&devicerect);
				memdc.OffsetViewportOrg(-devicerect.left,-devicerect.top);
				memdc.IntersectClipRect(cliprect);
				memdc.FillSolidRect(cliprect,pDC->GetBkColor());
				pDrawDC=&memdc;
			}
		}
		CBrush* oldbrush=(CBrush*)pDrawDC->SelectStockObject(NULL_BRUSH);
		pDrawDC->Rectangle(0,0,GetTotalSize().cx,GetTotalSize().cy);
		pDrawDC->SelectObject(oldbrush);
		
		if(pDoc->IsGridVisible())
		{	// draw grid
			for(int x=pDoc->GetGridSpan();x<GetTotalSize().cx;x+=pDoc->GetGridSpan())
				for(int y=pDoc->GetGridSpan();y<GetTotalSize().cy;y+=pDoc->GetGridSpan())
					pDrawDC->SetPixel(x,y,RGB(128,128,128));
		}
		pDoc->OccurrenceNet_Draw(pDrawDC); // draw net elements

		CSize window_size=GetTotalSize();
		if(!m_simulation_mode && pDoc->IsRulerVisible())
		{	// draw ruler
			CPoint point;
			point=GetScrollPosition();
			int off_x=point.x;
			int off_y=point.y;

			// horizontal line
			pDrawDC->FillSolidRect(CRect(0,off_y,window_size.cx,off_y+RULER_THICK),RULER_CLR);
			pDrawDC->MoveTo(RULER_THICK,off_y+RULER_THICK);
			pDrawDC->LineTo(window_size.cx,off_y+RULER_THICK);
			// vertical line
			pDrawDC->FillSolidRect(CRect(off_x,0,off_x+RULER_THICK,window_size.cy),RULER_CLR);
			pDrawDC->MoveTo(off_x+RULER_THICK,RULER_THICK);
			pDrawDC->LineTo(off_x+RULER_THICK,window_size.cy);
			// draw mid-lines
			int x,y;
			for(x=RULER_SPAN/4;x<window_size.cx;x+=RULER_SPAN/4)
			{	// horizontal
				if((x % RULER_SPAN)==0)continue;
				if((x % (RULER_SPAN/2))==0)
					pDrawDC->MoveTo(x,off_y+RULER_THICK/2);
				else
					pDrawDC->MoveTo(x,off_y+RULER_THICK-RULER_THICK/3);
				pDrawDC->LineTo(x,off_y+RULER_THICK);
			}
			for(y=RULER_SPAN/4;y<window_size.cy;y+=RULER_SPAN/4)
			{	// vertical
				if((y % RULER_SPAN)==0)continue;
				if((y % (RULER_SPAN/2))==0)
					pDrawDC->MoveTo(off_x+RULER_THICK/2,y);
				else
					pDrawDC->MoveTo(off_x+RULER_THICK-RULER_THICK/3,y);
				pDrawDC->LineTo(off_x+RULER_THICK,y);
			}
			// draw numbers
			COLORREF old_clr=pDrawDC->SetBkColor(RULER_CLR);
			CFont* old_font=pDrawDC->SelectObject(&m_ruler_font);
			CString text;
			CSize text_size;
			for(x=RULER_SPAN;x<window_size.cx;x+=RULER_SPAN)
			{	// horizontal numbers
				text.Format("%d",x/RULER_SPAN);
				text_size=pDrawDC->GetTextExtent(text);
				pDrawDC->TextOut(x-text_size.cx/2,off_y,text);
			}
			for(y=RULER_SPAN;y<window_size.cy;y+=RULER_SPAN)
			{	// vertical numbers
				text.Format("%d",y/RULER_SPAN);
				text_size=pDrawDC->GetTextExtent(text);
				pDrawDC->TextOut(off_x+(RULER_THICK-text_size.cx)/2,y-text_size.cy/2,text);
			}
			// topleft
			pDrawDC->FillSolidRect(CRect(off_x,off_y,off_x+RULER_THICK+1,off_y+RULER_THICK),RULER_CLR);
			pDrawDC->TextOut(5,0,"0");
			pDrawDC->SelectObject(old_font);
			pDrawDC->SetBkColor(old_clr);
		}
	}
	else
		pDoc->OccurrenceNet_Draw(pDrawDC); // draw net elements
	if(pDrawDC!=pDC)
	{	// draw memory DC
		pDC->BitBlt(cliprect.left,cliprect.top,cliprect.Width(),cliprect.Height(),&memdc,cliprect.left,cliprect.top,SRCCOPY);
		memdc.SelectObject(oldbitmap);
	}
}

void CCESimOccurrenceNetView::InvertLine(CDC* pDC,const CPoint& from,const CPoint& to)
{	// draw inverted line
	int oldmode=pDC->SetROP2(R2_NOT);
	pDC->MoveTo(from);
	pDC->LineTo(to);
	pDC->SetROP2(oldmode);
}

void CCESimOccurrenceNetView::DrawRulerPos(CDC* pDC,CPoint& point,bool bClearOnly/*=false*/)
{	// draw ruler position
	CPoint scrollpos=GetScrollPosition();
	int off_x=scrollpos.x;
	int off_y=scrollpos.y;

	// horizontal
	if(m_ruler_last_pt)
	{
		InvertLine(pDC,CPoint(m_ruler_last_mouse_pt.x,off_y),CPoint(m_ruler_last_mouse_pt.x,off_y+RULER_THICK));
/*			InvertLine(pDC,CPoint(m_ruler_last_mouse_pt.x-RULER_ARROW_HEIGHT/2,off_y+(RULER_THICK-RULER_ARROW_WIDTH)),CPoint(m_ruler_last_mouse_pt.x+RULER_ARROW_HEIGHT/2+1,off_y+(RULER_THICK-RULER_ARROW_WIDTH)));
		InvertLine(pDC,CPoint(m_ruler_last_mouse_pt.x-1,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(m_ruler_last_mouse_pt.x-1,off_y+RULER_THICK-1));
		InvertLine(pDC,CPoint(m_ruler_last_mouse_pt.x,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(m_ruler_last_mouse_pt.x,off_y+RULER_THICK));
		InvertLine(pDC,CPoint(m_ruler_last_mouse_pt.x+1,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(m_ruler_last_mouse_pt.x+1,off_y+RULER_THICK-1));*/
	}
	if(!bClearOnly)
	{
		InvertLine(pDC,CPoint(point.x,off_y),CPoint(point.x,off_y+RULER_THICK));
/*			InvertLine(pDC,CPoint(point.x-RULER_ARROW_HEIGHT/2,off_y+(RULER_THICK-RULER_ARROW_WIDTH)),CPoint(point.x+RULER_ARROW_HEIGHT/2+1,off_y+(RULER_THICK-RULER_ARROW_WIDTH)));
		InvertLine(pDC,CPoint(point.x-1,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(point.x-1,off_y+RULER_THICK-1));
		InvertLine(pDC,CPoint(point.x,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(point.x,off_y+RULER_THICK));
		InvertLine(pDC,CPoint(point.x+1,off_y+(RULER_THICK-(RULER_ARROW_WIDTH-1))),CPoint(point.x+1,off_y+RULER_THICK-1));*/
	}
	// vertical
	if(m_ruler_last_pt)InvertLine(pDC,CPoint(off_x,m_ruler_last_mouse_pt.y),CPoint(off_x+RULER_THICK,m_ruler_last_mouse_pt.y));
	if(!bClearOnly)InvertLine(pDC,CPoint(off_x,point.y),CPoint(off_x+RULER_THICK,point.y));

	m_ruler_last_pt=true;
	m_ruler_last_mouse_pt=point;
}

/*
void CCESimOccurrenceNetView::OnInitialUpdate()
{
	CScrollView::OnInitialUpdate();

	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	m_tool_selected=TOOL_SELECT;
	m_mouse_capture=false;
	m_last_drag_pt=CPoint(-1,-1);
	m_capture_type=CT_NONE;
	m_hit_element=NULL;
	m_context_element=NULL;
	m_erase_background=false;
	m_simulation_mode=false;
	m_automatic_simulation=false;
	m_animating_token=false;

	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);

	SetScrollSizes(MM_TEXT,pDoc->NetDesign_GetWindowSize());
}*/

/////////////////////////////////////////////////////////////////////////////
// CCESimNetDesignView printing
BOOL CCESimOccurrenceNetView::OnPreparePrinting(CPrintInfo* pInfo)
{
	pInfo->SetMaxPage(2);
	return DoPreparePrinting(pInfo);
}

void CCESimOccurrenceNetView::OnPrint(CDC* pDC, CPrintInfo* pInfo) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	if(pInfo->m_nCurPage==1)
	{
		ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
		((CMainFrame*)AfxGetApp()->m_pMainWnd)->HideOutputBar();

		// calculate scale
		pDC->SetMapMode(MM_ISOTROPIC);
		int cx=pDoc->OccurrenceNet_GetWindowSize().cx;
	//	pDC->SetViewportOrg(cx,0);
		int horz=pDC->GetDeviceCaps(HORZRES);
		pDC->SetWindowExt(cx,cx);
		pDC->SetViewportExt(horz,horz);
		int vert=pDC->GetDeviceCaps(VERTRES);
		int cy=pDoc->OccurrenceNet_GetWindowSize().cy;
		CSize size;
		size.cx=0;
		size.cy=cy;
		size.cy+=70;
		pDC->LPtoDP(&size);
		while((size.cy>vert)&&(horz>0))
		{	// vertical paper position
			horz-=30;
			pDC->SetViewportExt(horz,horz);
			size.cy=cy;
			size.cy+=70;
			pDC->LPtoDP(&size);
		};

		// document information
		CRect rect;
		CFont font;
		LOGFONT lf;
		memset(&lf,0,sizeof(LOGFONT));
		lf.lfHeight=100;
		lf.lfWeight=400;
		::lstrcpy(lf.lfFaceName,"Arial CE");
		font.CreatePointFontIndirect(&lf);
		CFont* oldfont=pDC->SelectObject(&font);
		CString text;
		text=GetDocument()->GetTitle(); 
		rect=pInfo->m_rectDraw;
		pDC->DPtoLP(rect);
		rect.top=rect.bottom-pDC->GetTextExtent(text).cy-10;
		rect.left=10;
		rect.right-=20;
		pDC->FillSolidRect(rect.left,rect.top,rect.right,2,RGB(0,0,0)); // separator
		rect.top+=5;
		rect.left+=5;
		pDC->SetBkMode(TRANSPARENT);
		pDC->DrawText(text,rect,DT_SINGLELINE|DT_LEFT); // file name
		CTime cas=CTime::GetCurrentTime(); // date and time
		text.Format("%d/%d/%d  %.2u:%.2u:%.2u",cas.GetDay(),cas.GetMonth(),cas.GetYear(),cas.GetHour(),cas.GetMinute(),cas.GetSecond());
		rect.left=rect.right-pDC->GetTextExtent(text).cx-10;
		pDC->DrawText(text,rect,DT_SINGLELINE|DT_LEFT);
		pDC->SelectObject(oldfont);

		OnDraw(pDC); // draw view
	}
	if(pInfo->m_nCurPage==2)
	{
		pDC->SetMapMode(MM_TWIPS);
		CFont font;
		font.CreateFont(-200,0,0,0,500,FALSE,FALSE,0,ANSI_CHARSET,OUT_DEFAULT_PRECIS,CLIP_DEFAULT_PRECIS,DEFAULT_QUALITY,DEFAULT_PITCH|FF_MODERN,"Courier New");
		CFont* old_font=pDC->SelectObject(&font);
		TEXTMETRIC tm;
		pDC->GetTextMetrics(&tm);
		int nHeight=tm.tmHeight+tm.tmExternalLeading;
		pDoc->OccurrenceNet_PrintLegend(pDC,nHeight);
		pDC->SelectObject(old_font);
	}
}

void CCESimOccurrenceNetView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

void CCESimOccurrenceNetView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
}

/////////////////////////////////////////////////////////////////////////////
// CCESimOccurrenceNetView diagnostics
#ifdef _DEBUG
CCESimDoc* CCESimOccurrenceNetView::GetDocument() // non-debug version is inline
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCESimDoc)));
	return (CCESimDoc*)m_pDocument;
}

void CCESimOccurrenceNetView::AssertValid() const
{
	CScrollView::AssertValid();
}

void CCESimOccurrenceNetView::Dump(CDumpContext& dc) const
{
	CScrollView::Dump(dc);
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCESimOccurrenceNetView message handlers
BOOL CCESimOccurrenceNetView::OnEraseBkgnd(CDC* /*pDC*/) 
{
//	if(m_erase_background)
//		return CScrollView::OnEraseBkgnd(pDC);
//	else
		return TRUE;	
}

void CCESimOccurrenceNetView::SwitchedTo()
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->OccurrenceNet_WriteOutLegend();
	m_simulation_mode=pDoc->IsSimulationMode();
	if(m_simulation_mode)
	{
		CClientDC dc(this);
		OnPrepareDC(&dc);
		CSize size=pDoc->OccurrenceNet_PlaceNetElements(&dc);
		SetScrollSizes(MM_TEXT,size);
	}
	else
	{
		SetScrollSizes(MM_TEXT,pDoc->OccurrenceNet_GetWindowSize());
	}
	Invalidate(FALSE);
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
}

void CCESimOccurrenceNetView::OnToolChange(UINT nID)
{
	m_tool_selected=nID;
}

void CCESimOccurrenceNetView::OnUpdateToolsChange(CCmdUI* pCmdUI)
{
	pCmdUI->SetRadio(static_cast<unsigned int>(m_tool_selected)==pCmdUI->m_nID);
	if(m_simulation_mode)
		pCmdUI->Enable(pCmdUI->m_nID==TOOL_SELECT);
	else
		pCmdUI->Enable(pCmdUI->m_nID==TOOL_SELECT || pCmdUI->m_nID==TOOL_POLYGON || pCmdUI->m_nID==TOOL_LABEL);
}

void CCESimOccurrenceNetView::OnViewGrid()
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->SetModifiedFlag();
	pDoc->SetGridVisible(!pDoc->IsGridVisible());
	Invalidate(FALSE);
}

void CCESimOccurrenceNetView::OnUpdateViewGrid(CCmdUI* pCmdUI)
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pCmdUI->SetCheck(!m_simulation_mode && pDoc->IsGridVisible());
	pCmdUI->Enable(!m_simulation_mode);
}

void CCESimOccurrenceNetView::OnViewRuler() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	pDoc->SetRulerVisible(!pDoc->IsRulerVisible());
	Invalidate(FALSE);
}

void CCESimOccurrenceNetView::OnUpdateViewRuler(CCmdUI* pCmdUI) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pCmdUI->SetCheck(!m_simulation_mode && pDoc->IsRulerVisible());
	pCmdUI->Enable(!m_simulation_mode);
}

void CCESimOccurrenceNetView::OnUpdate(CView* /*pSender*/,LPARAM /*lHint*/,CObject* /*pHint*/)
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	m_simulation_mode=pDoc->IsSimulationMode();

	Invalidate(FALSE);
}

void CCESimOccurrenceNetView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	CClientDC dc(this);
	OnPrepareDC(&dc);
	dc.DPtoLP(&point);
	if(point.x>pDoc->OccurrenceNet_GetWindowSize().cx)return; // out of view
	if(point.y>pDoc->OccurrenceNet_GetWindowSize().cy)return;
	m_last_mouse_pt=point;
	m_ruler_last_pt=false;

	UINT tool_selected=m_tool_selected;
	// to bypass selected tool from drawing edge and polygon directly to dragging point
	if(pDoc->CanDragPoint(point))tool_selected=TOOL_SELECT;
	// multiselect is enabled for SHIFT or CONTROL key down
	bool modif_control=(nFlags & MK_CONTROL) || (nFlags & MK_SHIFT);

	switch(tool_selected)
	{
	case TOOL_SELECT:
		{
			m_capture_type=CT_NONE;
			m_hit_element=pDoc->OccurrenceNet_ElementAt(point);
			if(m_simulation_mode)m_hit_element=NULL; // v simulaci nelze oznacit nic
			if(m_hit_element)
			{	// element was selected
				if(pDoc->IsElementSelected(m_hit_element))
				{	
					if(modif_control)
					{	// flip selection
						InvalidateRect(pDoc->DeselectElement(m_hit_element),&dc);
						if((!pDoc->IsElementSelected()) && (!m_simulation_mode))
						{
							ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
							((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//							((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
						}
						break;
					}
					if(pDoc->IsMultiselect())m_capture_type=CT_DRAGGING_MULTI_SELECT;
				}
				else
				{	// new element was selected
					InvalidateRect(pDoc->SelectElement(m_hit_element,modif_control),&dc);
					if(pDoc->IsMultiselect())
					{
						m_capture_type=CT_DRAGGING_MULTI_SELECT;
						if(!m_simulation_mode)
						{
							ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
							((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//							((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
						}
					}
					else
					{
						if(!m_simulation_mode)
						{
							bool update=true;
							CPNLabel* pLabel;
							pLabel=dynamic_cast<CPNLabel*>(m_hit_element);
							if(pLabel!=NULL)
							{
								if(pLabel->GetOwner()!=NULL)update=false;
							}
							if(update)
							{	// zmena label je mozna jenom u samostaneho label
								m_hit_element->UpdatePropertiesDlg();
							}
							else
							{
								ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
								((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//								((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
							}
						}
					}
				}
				if(m_capture_type==CT_NONE)
				{	// 
					if(dynamic_cast<CPNPlace*>(m_hit_element))m_capture_type=CT_DRAGGING_PLACE;
					if(dynamic_cast<CPNOccurrence*>(m_hit_element))m_capture_type=CT_DRAGGING_OCR;
					if(dynamic_cast<CPNLabel*>(m_hit_element))m_capture_type=CT_DRAGGING_LBL;
					CPNEdge* pEdge=dynamic_cast<CPNEdge*>(m_hit_element);
					if(pEdge)
					{
						if(pEdge->IsDragging(point))m_capture_type=CT_DRAGGING_EDGE;
					}
					CPNPolygon* pPolygon=dynamic_cast<CPNPolygon*>(m_hit_element);
					if(pPolygon)
					{
						if(pPolygon->IsDragging(point))
							m_capture_type=CT_DRAGGING_POLYGON_POINT;
						else
							m_capture_type=CT_DRAGGING_POLYGON;
					}
				}
			}
			else
			{
				if(!modif_control)
				{	// deselect all elements
					CRect old_sel_rect=pDoc->DeselectAllElements();
					if(!old_sel_rect.IsRectNull())InvalidateRect(old_sel_rect,&dc);

					if(!m_simulation_mode)
					{
						ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
						((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//						((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
					}
				}
				if(!m_simulation_mode)
					m_capture_type=CT_DRAWING_SELECT_RECT;
				else
					m_capture_type=CT_NONE;
				m_mouse_moved=false;
				m_first_mouse_pt=point;
			}
			if(m_capture_type!=CT_NONE)
			{
				SetCapture();
				m_mouse_capture=true;
				m_ignore_move=true;
				m_last_drag_pt=CPoint(-1,-1);
				if(m_capture_type!=CT_DRAWING_SELECT_RECT)::SetCursor(::LoadCursor(NULL,IDC_SIZEALL));
			}
			break;
		}
	case TOOL_LABEL:
		{	// create label
			CPNLabel* pLabel=new CPNLabel(SnapOnGrid(point));
			pLabel->SetText(pDoc->GetAutomaticLabelText(CCESimDoc::LABEL_TEXT_CASE_GRAPH),&dc);
			pDoc->OccurrenceNet_AddElement(pLabel);
			CRect invalid_rect;
			InvalidateRect(pDoc->SelectElement(pLabel),&dc);
			pLabel->UpdatePropertiesDlg();
			break;
		}
		break;
	case TOOL_POLYGON:
		{
			CPNPolygon* pPolygon=new CPNPolygon(SnapOnGrid(point));
			pDoc->OccurrenceNet_AddElement(pPolygon);
			CRect invalid_rect;
			InvalidateRect(pDoc->SelectElement(pPolygon),&dc);
			pPolygon->UpdatePropertiesDlg();
			break;
		}
	case TOOL_CONDITION:
	case TOOL_EVENT:
	case TOOL_EDGE:
	case TOOL_TOKEN:
		break;
	default:
		ASSERT(FALSE);
		break;
	}

	CScrollView::OnLButtonDown(nFlags,point);
}

void CCESimOccurrenceNetView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CMainFrame* pFrame=(CMainFrame*)AfxGetApp()->m_pMainWnd;
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	CString status_text;
	CClientDC dc(this);
	OnPrepareDC(&dc);
	dc.DPtoLP(&point);
	if(point.x<0)point.x=0;
	if(point.y<0)point.y=0;
	CSize window_size=pDoc->OccurrenceNet_GetWindowSize();
	if(point.x>window_size.cx)point.x=window_size.cx;
	if(point.y>window_size.cy)point.y=window_size.cy;

	if((m_mouse_capture) && (!m_ignore_move))
	{	// mouse button is down
		switch(m_capture_type)
		{
		case CT_DRAWING_SELECT_RECT:
			if(!m_mouse_moved)::SetCursor(::LoadCursor(NULL,IDC_CROSS));
			m_mouse_moved=true;
			InvertRect(&dc,m_first_mouse_pt,m_last_mouse_pt);
			InvertRect(&dc,m_first_mouse_pt,point);
			m_last_mouse_pt=point;
			pFrame->ShowMousePos(point);
			break;
		case CT_DRAGGING_LBL:
		case CT_DRAGGING_PLACE:
		case CT_DRAGGING_OCR:
		case CT_DRAGGING_EDGE:
		case CT_DRAGGING_POLYGON:
		case CT_DRAGGING_POLYGON_POINT:
			{
			if(m_simulation_mode)break;
			CPoint move=point-m_last_mouse_pt;
			m_last_mouse_pt=point;
			CPoint position;
			if(m_last_drag_pt==CPoint(-1,-1))m_last_drag_pt=m_hit_element->GetPosition();
			position=m_last_drag_pt;
			position=position+move;
			m_last_drag_pt=position;
			position=SnapOnGrid(position);
			if(position!=m_hit_element->GetPosition())pDoc->SetModifiedFlag();
			if((m_capture_type==CT_DRAGGING_PLACE) || (m_capture_type==CT_DRAGGING_OCR))
			{
				CRect invalid_rect;
				invalid_rect.UnionRect(pDoc->OccurrenceNet_RecalculateEdges(m_hit_element),m_hit_element->MoveTo(position));
				InvalidateRect(invalid_rect,&dc);
			}
			else
				InvalidateRect(m_hit_element->MoveTo(position),&dc);
			pFrame->ShowMousePos(position);
			if(!m_simulation_mode && pDoc->IsRulerVisible())DrawRulerPos(&dc,position);
			break;
			}
		case CT_DRAGGING_MULTI_SELECT:
			{
			if(m_simulation_mode)break;
			CPoint move=point-m_last_mouse_pt;
			m_last_mouse_pt=point;
			CRect move_rect,edges_rect;
			move_rect=pDoc->MoveSelectedElementsByVector(move);
			edges_rect=pDoc->OccurrenceNet_RecalculateEdges();
			CRect invalid_rect;
			invalid_rect.UnionRect(move_rect,edges_rect);
			InvalidateRect(invalid_rect,&dc);
			pFrame->ShowMousePos(point);
			break;
			}
		case CT_NONE:
			break;
		default:
			ASSERT(FALSE);
			break;
		}
	}
	else
	{
		pFrame->ShowMousePos(point);
		if(m_simulation_mode)
		{
			bool tooltip=false;
			CRect tiprect;
			CString tipstr;
			CPNElement* pElement=pDoc->OccurrenceNet_ElementAt(point);
			CPNPlace* pPlace;
			CPNOccurrence* pOccurrence;
			pPlace=dynamic_cast<CPNPlace*>(pElement);
			if(pPlace!=NULL)
			{
				tipstr=pPlace->GetConditionName();
				tiprect=pPlace->GetRect();
				tooltip=true;
			}
			pOccurrence=dynamic_cast<CPNOccurrence*>(pElement);
			if(pOccurrence!=NULL)
			{
				tipstr=pOccurrence->GetEventName();
				tiprect=pOccurrence->GetRect();
				tooltip=true;
			}
			if(tooltip)
			{
				dc.LPtoDP(&point);
				dc.LPtoDP(&tiprect);
				m_TitleTip.Show(CPoint(point.x+15,point.y+5),tipstr,tiprect);
			}
		}
//		if(pDoc->CanDragPoint())
/*		m_guidepoint=point;
		Invalidate(FALSE);*/
	}
	m_ignore_move=false;

/*		m_guidepoint=point;
		Invalidate(FALSE);*/

	CScrollView::OnMouseMove(nFlags, point);
}

void CCESimOccurrenceNetView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	if(m_mouse_capture)
	{
		::ReleaseCapture();
	
		CCESimDoc* pDoc=GetDocument();
		ASSERT_VALID(pDoc);
		CClientDC dc(this);
		OnPrepareDC(&dc);
		dc.DPtoLP(&point);
		if(point.x<0)point.x=0;
		if(point.y<0)point.y=0;
		CSize window_size=pDoc->OccurrenceNet_GetWindowSize();
		if(point.x>window_size.cx)point.x=window_size.cx;
		if(point.y>window_size.cy)point.y=window_size.cy;
		
		switch(m_capture_type)
		{
		case CT_DRAWING_SELECT_RECT:
			{
			if(!m_mouse_moved)break;
			InvertRect(&dc,m_first_mouse_pt,point);
			CRect rect;
			rect.SetRect(m_first_mouse_pt,point);
			rect.NormalizeRect();
			if(((point.x-m_first_mouse_pt.x)*(point.x-m_first_mouse_pt.x)+(point.y-m_first_mouse_pt.y)*(point.y-m_first_mouse_pt.y))>200)
			{
				InvalidateRect(pDoc->OccurrenceNet_SelectElements(rect),&dc);
				if(!m_simulation_mode)
				{
					ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
					((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//					((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
				}
			}
			break;
			}
		case CT_DRAGGING_EDGE:
		case CT_DRAGGING_PLACE:
		case CT_DRAGGING_OCR:
		case CT_DRAGGING_LBL:
		case CT_DRAGGING_POLYGON:
		case CT_DRAGGING_POLYGON_POINT:
			if(!m_simulation_mode && pDoc->IsRulerVisible())DrawRulerPos(&dc,point,true);
			break;
		case CT_DRAGGING_MULTI_SELECT:
		case CT_NONE:
			break;
		default:
			ASSERT(FALSE);
			break;
		}

		m_capture_type=CT_NONE;
		m_mouse_capture=false;
		m_hit_element=NULL;
	}
	
	CScrollView::OnLButtonUp(nFlags, point);
}

void CCESimOccurrenceNetView::InvertRect(CDC* pDC,const CPoint& from,const CPoint& to)
{	// draw inverted rect
	pDC->SelectStockObject(NULL_BRUSH);
	int oldmode=pDC->SetROP2(R2_NOT);
	CRect rect;
	rect.SetRect(from,to);
	pDC->Rectangle(&rect);
	pDC->SetROP2(oldmode);
}

CPoint CCESimOccurrenceNetView::SnapOnGrid(CPoint point)
{	// modify point to snap on grid
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	if(pDoc->IsGridVisible())
	{
		point.x=((point.x+(pDoc->GetGridSpan()/2))/pDoc->GetGridSpan())*pDoc->GetGridSpan();
		point.y=((point.y+(pDoc->GetGridSpan()/2))/pDoc->GetGridSpan())*pDoc->GetGridSpan();
	}
	return point;
}

void CCESimOccurrenceNetView::InvalidateRect(CRect rect,CDC* pDC/*=NULL*/)
{
	if(pDC==NULL)
	{
		CClientDC dc(this);
		OnPrepareDC(&dc);
		dc.LPtoDP(&rect);
		CScrollView::InvalidateRect(rect,FALSE);
	}
	else
	{
		pDC->LPtoDP(&rect);
		CScrollView::InvalidateRect(rect,FALSE);
	}
}

void CCESimOccurrenceNetView::OnEditDelete() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	if(m_simulation_mode || !pDoc->OccurrenceNet_CanRemoveElements())return;
	InvalidateRect(pDoc->OccurrenceNet_RemoveSelectedElements());
	ASSERT((CMainFrame*)AfxGetApp()->m_pMainWnd);
	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_HIDE);
//	((CMainFrame*)AfxGetApp()->m_pMainWnd)->ShowPropertiesDlg(CMainFrame::PROPDLG_DESKTOP);
}

void CCESimOccurrenceNetView::OnUpdateEditDelete(CCmdUI* pCmdUI) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pCmdUI->Enable(!m_simulation_mode && pDoc->OccurrenceNet_CanRemoveElements());
}

void CCESimOccurrenceNetView::OnEdgeDeletepoint() 
{
	bool enable=false;
	CPNEdge* pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)
	{
		enable=(pEdge->IsDragging(m_last_mouse_pt) && pEdge->CanDeletePoint());
	}
	if(!enable)return;

	pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)
	{
		CRect prevrect=pEdge->GetRect();
		pEdge->DeletePoint();
		CRect invalid_rect;
		invalid_rect.UnionRect(prevrect,pEdge->GetRect());
		InvalidateRect(invalid_rect);
		CCESimDoc* pDoc=GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->SetModifiedFlag();
	}
}

void CCESimOccurrenceNetView::OnUpdateEdgeDeletepoint(CCmdUI* pCmdUI) 
{
	bool enable=false;
	CPNEdge* pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)
	{
		enable=(pEdge->IsDragging(m_last_mouse_pt) && pEdge->CanDeletePoint());
	}
	pCmdUI->Enable(enable);
}

void CCESimOccurrenceNetView::OnEdgeDeleteallpoints() 
{
	bool enable=false;
	CPNEdge* pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)enable=pEdge->IsMultipoint();
	if(!enable)return;

	pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)
	{
		CRect prevrect=pEdge->GetRect();
		pEdge->DeleteAllPoints();
		CRect invalid_rect;
		invalid_rect.UnionRect(prevrect,pEdge->GetRect());
		InvalidateRect(invalid_rect);
		CCESimDoc* pDoc=GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->SetModifiedFlag();
	}
}

void CCESimOccurrenceNetView::OnUpdateEdgeDeleteallpoints(CCmdUI* pCmdUI) 
{
	bool enable=false;
	CPNEdge* pEdge=dynamic_cast<CPNEdge*>(m_context_element);
	if(pEdge)enable=pEdge->IsMultipoint();
	pCmdUI->Enable(enable);
}

void CCESimOccurrenceNetView::OnPolygonDeletepoint() 
{
	bool enable=false;
	CPNPolygon* pPolygon=dynamic_cast<CPNPolygon*>(m_context_element);
	if(pPolygon)
	{
		enable=(pPolygon->IsDragging(m_last_mouse_pt) && pPolygon->CanDeletePoint());
	}
	if(!enable)return;

	pPolygon=dynamic_cast<CPNPolygon*>(m_context_element);
	if(pPolygon)
	{
		CRect prevrect=pPolygon->GetRect();
		pPolygon->DeletePoint();
		CRect invalid_rect;
		invalid_rect.UnionRect(prevrect,pPolygon->GetRect());
		InvalidateRect(invalid_rect);
		CCESimDoc* pDoc=GetDocument();
		ASSERT_VALID(pDoc);
		pDoc->SetModifiedFlag();
	}
}

void CCESimOccurrenceNetView::OnUpdatePolygonDeletepoint(CCmdUI* pCmdUI) 
{
	bool enable=false;
	CPNPolygon* pPolygon=dynamic_cast<CPNPolygon*>(m_context_element);
	if(pPolygon)
	{
		enable=(pPolygon->IsDragging(m_last_mouse_pt) && pPolygon->CanDeletePoint());
	}
	pCmdUI->Enable(enable);
}

void CCESimOccurrenceNetView::OnContextMenu(CWnd* /*pWnd*/, CPoint point) 
{
	CMenu menu;
	VERIFY(menu.LoadMenu(IDR_CONTEXTMENU));
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	CPoint menu_point=point;
	CClientDC dc(this);
	OnPrepareDC(&dc);
	dc.DPtoLP(&point);
	ScreenToClient(&point);
	if(point.x>pDoc->OccurrenceNet_GetWindowSize().cx)return; // out of view
	if(point.y>pDoc->OccurrenceNet_GetWindowSize().cy)return;
	m_last_mouse_pt=point;

	int menu_type=0;
	m_context_element=pDoc->CaseGraph_ElementAt(point);
	if(m_context_element)
	{	// 
		bool selected=pDoc->IsElementSelected(m_context_element);
		if(selected && m_context_element->IsKindOf(RUNTIME_CLASS(CPNStep)))menu_type=3;
		if(selected && m_context_element->IsKindOf(RUNTIME_CLASS(CPNPolygon)))menu_type=4;
	}
	if((!m_simulation_mode) || (menu_type!=0))
	{
		CMenu* pContextMenu=menu.GetSubMenu(menu_type);
		ASSERT(pContextMenu!=NULL);
		pContextMenu->TrackPopupMenu(TPM_LEFTALIGN|TPM_LEFTBUTTON|TPM_RIGHTBUTTON,menu_point.x,menu_point.y,AfxGetMainWnd());
	}
}

LRESULT CCESimOccurrenceNetView::OnUpdateView(WPARAM wparam,LPARAM /*lparam*/)
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pDoc->SetModifiedFlag();
	CClientDC dc(this);
	OnPrepareDC(&dc);
	CPNElement* pElement;
	pElement=pDoc->GetFirstSelectedElement();
	if(!pElement)return 0;
	switch(wparam)
	{
	case UPDATE_VIEW_ELEMENT:
		InvalidateRect(pElement->GetRect(),&dc);
		break;
	case UPDATE_VIEW_TEXT:
		{
		CRect prevrect=pElement->GetRect();
		CPNLabel* pLabel;
		pLabel=dynamic_cast<CPNLabel*>(pElement);
		if(pLabel)pLabel->UpdateText(&dc);
		CRect invalid_rect;
		invalid_rect.UnionRect(prevrect,pElement->GetRect());
		InvalidateRect(invalid_rect,&dc);
		break;
		}
	case UPDATE_VIEW_LABEL_EVNT:
	case UPDATE_VIEW_LABEL_COND:
	default:
		ASSERT(FALSE);
		break;
	}
	return 0;
}

void CCESimOccurrenceNetView::OnViewPropertiesOccurrenceNet() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	CDlgProperties dlg;
	dlg.SetWindowSize(pDoc->OccurrenceNet_GetWindowSize());
	if(dlg.DoModal()==IDOK)
	{
		pDoc->OccurrenceNet_SetWindowSize(dlg.GetWindowSize());
		SetScrollSizes(MM_TEXT,pDoc->OccurrenceNet_GetWindowSize());
		pDoc->SetModifiedFlag();
		Invalidate(FALSE);
	}
}

void CCESimOccurrenceNetView::OnUpdateViewPropertiesOccurrenceNet(CCmdUI* pCmdUI) 
{
	pCmdUI->Enable(!m_simulation_mode);
}

void CCESimOccurrenceNetView::OnEditPlacetofront() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	if(m_simulation_mode || !pDoc->IsElementSelected())return;
	InvalidateRect(pDoc->OccurrenceNet_PlaceSelectedElements(CCESimDoc::PLACE_FRONT));
}

void CCESimOccurrenceNetView::OnEditPlacetoback() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);

	if(m_simulation_mode || !pDoc->IsElementSelected())return;
	InvalidateRect(pDoc->OccurrenceNet_PlaceSelectedElements(CCESimDoc::PLACE_BACK));
}

void CCESimOccurrenceNetView::OnUpdateEditPlacetoback(CCmdUI* pCmdUI) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pCmdUI->Enable(!m_simulation_mode && pDoc->IsElementSelected());
}

void CCESimOccurrenceNetView::OnUpdateEditPlacetofront(CCmdUI* pCmdUI) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	pCmdUI->Enable(!m_simulation_mode && pDoc->IsElementSelected());
}

void CCESimOccurrenceNetView::OnOccurrenceNetExporttoemf() 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	char szFilter[]="Occurrence Net (*.emf)|*.emf|All files (*.*)|*.*||";
	CFileDialog filedlg(FALSE,"",pDoc->GetTitle(),OFN_HIDEREADONLY|OFN_OVERWRITEPROMPT|OFN_PATHMUSTEXIST,szFilter,NULL);
	if(filedlg.DoModal()==IDOK)
	{
		m_export=true;
		m_export_path=filedlg.GetPathName();
		Invalidate(FALSE);
	}
}

void CCESimOccurrenceNetView::OnKeyUp(UINT nChar, UINT nRepCnt, UINT nFlags) 
{
	if(nChar==VK_DELETE)OnEditDelete();
	
	CScrollView::OnKeyUp(nChar, nRepCnt, nFlags);
}


BOOL CCESimOccurrenceNetView::OnScroll(UINT nScrollCode, UINT nPos, BOOL bDoScroll) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	if(!m_simulation_mode && pDoc->IsRulerVisible())Invalidate(FALSE);

	return CScrollView::OnScroll(nScrollCode, nPos, bDoScroll);
}

BOOL CCESimOccurrenceNetView::OnMouseWheel(UINT nFlags, short zDelta, CPoint pt) 
{
	CCESimDoc* pDoc=GetDocument();
	ASSERT_VALID(pDoc);
	if(!m_simulation_mode && pDoc->IsRulerVisible())Invalidate(FALSE);
	
	return CScrollView::OnMouseWheel(nFlags, zDelta, pt);
}
