%% lbpDemo show how to use LBPDetector Toolbox
%
% Example of training and testing face detector. Here we use 10 random
% images from FDDB dataset which is VERY small set for practical use,
% however it is sufficient for instructional use.
%
% * Read 'help lbpdetector' to get the basic info.
% * Install Piotr's Image and Video Toolbox v 3.40+
% * Compile LBPDetector toolbox: lbpdetector.compile
% * Download some training data (e.g. INRIA Person dataset) with bbGt
%   annotations and train your own detectors. See acfDemoInria for details.

%% Prepare training of a model
% Before the training itself, structure with options must be created.

modelName='models/FaceExample';

opts=lbpTrain; % defaults
opts.name = modelName;
opts.pPyramid.pChns.pColor.colorSpace = 'Gray'; % When LUV is used, gradientMex causes segfaults which is open issue in ACF implementation.
opts.pPyramid.pChns.shrink = 4;
opts.posImgDir='data/images'; opts.posGtDir='data/labels'; opts.negImgDir='';
opts.pLoad={'lbls',{'face'},'squarify',{4,1}};
opts.nPos=inf; opts.nNeg=1000; opts.nPerNeg=100;
opts.modelDs = [40 40]; opts.modelDsPad=[56 56];
opts.nWeak = [32 64 128]; % better [32 128 512 2048] or similar
opts.pJitter.flip = 1;
opts.pJitter.nPhi = 5; opts.pJitter.mPhi = 20;
opts.pJitter.nTrn = 3; opts.pJitter.mTrn = 1;
% This is different from ACF - here we specify parameters of LBP features
% [14 14 8] is real size of scanning window [56 56]/4, and 8 channels L,
% Mag, and 6 HOG channels
opts.pBoost.pLBP.params = lbpdetector.feature_params([14 14 8], 0:13, 0:13, 1:2, 1:2, 0:7);
opts.pBoost.pLBP.fracFtrs = 1/32;
opts.pBoost.pLBP.nThreads = 4;

%% Training

detector = lbpTrain(opts);

% Now the detector is stored in file specified by opts.name

%% Testing
% This is just an example 'how' to test detectors. Note that hre we test it
% on very small set and moreower on images that were used for training
% previously.

pLoad = {'lbls',{'face'},'squarify',{4,1}};
pModify = {'cascCal',-0.005,'pNms',{'type','maxg','thr',-inf}};
[miss,roc] = lbpTest('name',modelName,...
    'imgDir', 'data/images', 'gtDir', 'data/labels',...
    'pLoad', pLoad,...
    'pModify', pModify,...
    'lims', [1e-2, 1e1, 0.05 1],...
    'show',1,'reapply',1);

% Detections are stored in [modelName 'Dets.txt'] and ROC curve is
% in [modelName 'Roc.fig'].

%% Detection on images

load([modelName 'Detector.mat']);
detector = lbpModify(detector, 'cascCal',-0.005,'pNms',{'type','max','thr',25});
imgs = bbGt('getFiles',{'data/images'}); % Enum files
for i=1:numel(imgs)
    im = feval(detector.opts.imreadf,imgs{i},detector.opts.imreadp{:});
    bb = lbpDetect(im,detector);
    imshow(im); bbApply('draw',bb); drawnow; pause;
end

%% End