#ifndef RESULTS_OUTPUT_H
#define RESULTS_OUTPUT_H

#include <vector>
#include <opencv2/opencv.hpp>

class ResultsOutput
{
public:
    ResultsOutput(){};
    virtual ~ResultsOutput(){};
    virtual void insert(const char *, int, unsigned int, unsigned int, double, const std::vector<cv::Rect> &, const std::vector<float> &) = 0;
};

class ResultsOutputDummy: public ResultsOutput
{
public:
    void insert(const char *, int, unsigned int, unsigned int, double, const std::vector<cv::Rect> &, const std::vector<float> &) {};
};

class ResultsOutputCSV: public ResultsOutput
{
public:
    ~ResultsOutputCSV();
    void insert(const char *, int, unsigned int, unsigned int, double, const std::vector<cv::Rect> &, const std::vector<float> &);
};

class ResultsOutputJSON: public ResultsOutput
{
public:
    ResultsOutputJSON();
    ~ResultsOutputJSON();
    void insert(const char *, int, unsigned int, unsigned int, double, const std::vector<cv::Rect> &, const std::vector<float> &);
};

#endif