#include <iostream>
#include "result_output.h"

using namespace std;
using namespace cv;

ResultsOutputCSV::~ResultsOutputCSV()
{
    cout << endl << flush;
}

void ResultsOutputCSV::insert(const char * file, int id, unsigned int, unsigned int, double, const vector<Rect> & rects, const vector<float> & hs)
{
    for (size_t j = 0; j < rects.size(); ++j)
    {
        auto & bb = rects[j];
        auto & h = hs[j];
        // cout << file << "," << id << ',';
        cout << id << ',';
        cout << bb.x << ',' << bb.y << ',' << bb.width << ',' << bb.height << ',' << h << endl;
    }
}

ResultsOutputJSON::ResultsOutputJSON()
{
    cout << '[' << endl << flush;
}

ResultsOutputJSON::~ResultsOutputJSON()
{
    cout << ']' << endl << flush;
}

void ResultsOutputJSON::insert(const char * file, int, unsigned int nf, unsigned int ns, double tm, const vector<Rect> & rects, const vector<float> & hs)
{
    cout << "{\"file\":\"" << file << "\",";
    cout << "\"nf\":" << nf << ",\"ns\":" << ns << ",\"t\":" << tm << ",";
    cout << "\"objects\":[";
    for (size_t j = 0; j < rects.size(); ++j)
    {
        auto & bb = rects[j];
        auto & h = hs[j];
        cout << "[" << bb.x << ',' << bb.y << ',' << bb.width << ',' << bb.height << ',' << h << "]";
        if (j < rects.size()-1) cout << ',';
    }
    cout << "]}" << endl << flush;
}