#include "mex.h"
#include <iostream>
#include <fstream>
#include <algorithm>
#include "detector.pb.h"
#include <google/protobuf/repeated_field.h>

using namespace std;
using namespace LBPDetector;

// mexBinWrite(detector.clf, shrink, fileName)
void mexFunction(int nlhs, mxArray ** lhs, int nrhs, const mxArray ** rhs)
{
    GOOGLE_PROTOBUF_VERIFY_VERSION;
    
    const mxArray * clf = rhs[0];
    const mxArray * mxsize = mxGetField(clf, 0, "size");
    const mxArray * mxftrs = mxGetField(clf, 0, "ftr");
    const mxArray * mxthrs = mxGetField(clf, 0, "thr");
    const mxArray * mxhs = mxGetField(clf, 0, "hs");
    const mxArray * mxshrink = rhs[1];
    const mxArray * mxColorSmooth = rhs[2];
    const mxArray * mxPyrSmooth = rhs[3];
    const mxArray * mxLabel = rhs[4];
    const mxArray * fileName = rhs[5];

    int * sz = (int*)mxGetData(mxsize);
    int T = mxGetN(mxftrs);

    DetectorProto D;
    D.set_dim0(sz[0]);
    D.set_dim1(sz[1]);
    D.set_t(T);
    D.set_shrink(mxGetScalar(mxshrink));
    if (!mxIsEmpty(mxLabel))
    {
        int len = mxGetN(mxLabel) * sizeof(mxChar) + 1;
        char * str = new char[len];
        mxGetString(mxLabel, str, len);
        D.set_label(string(str));
        delete [] str;
    }
    D.set_colorspace(LBPDetector::DetectorProto::GRAY);
    D.set_colorsmooth(mxGetScalar(mxColorSmooth));
    D.set_pyrsmooth(mxGetScalar(mxPyrSmooth));

    auto ftrs = D.mutable_ftrs(); ftrs->Resize(5*T, 0);
    int * ftrdata = ftrs->mutable_data();
    copy_n((unsigned char*)mxGetData(mxftrs), 5*T, ftrdata);

    auto hs = D.mutable_hs(); hs->Resize(256*T, 0);
    float * hsdata = hs->mutable_data();
    copy_n((float*)mxGetData(mxhs), 256*T, hsdata);

    auto thr = D.mutable_thr(); thr->Resize(T, 0);
    float * thrdata = thr->mutable_data();
    copy_n((float*)mxGetData(mxthrs), T, thrdata);

    int len = mxGetN(fileName) * sizeof(mxChar)+1;
    char * str = new char[len];
    mxGetString(fileName, str, (mwSize)len);
    
    ofstream out(str, ios::binary);
    D.SerializeToOstream(&out);

    delete [] str;

    google::protobuf::ShutdownProtobufLibrary();
}
