#ifndef LBP_DETECTOR_CV
#define LBP_DETECTOR_CV

#include <opencv2/opencv.hpp>
#include <vector>
#include "lbpdetector.h"
#include "nms.h"

struct Detections
{
    std::vector<cv::Rect> bbs;
    std::vector<float> hs;
    unsigned long long nf;
    unsigned long long ns;
    float cacheEffeciency;
};

Detections lbpDetectImage(
    cv::Mat & im,
    LBPDetector::Detector * detector, LBPDetector::ChnsParams & pChns, 
    float thr = 0, int stride = 1,
    int group = 1, float overlap = 0.5f, float scaleX = 1.0f, float scaleY = 1.0f,
    unsigned int nThreads = 1, int tile = 32, bool useCache = true);

#endif