/*

jsontool.cpp

Processing of JSON output of detect_lbp

jsontool reads objects from stdin and outputs results on stdout in CSV format
so it is easily readable by other tools like Matlab or Excel. The results can
be either detections or statistics.

Detections (jsontool):
    id, x, y, w, h, score

    Where id is connected to an entry in statistics output

Statistics (jsontool --stats)
    id, filename, w, h, time, nFtrs, nWins, cacheEffeciency

Typical workflow is:

    # Process your data
    ./detect_lbp [options] files > out.json
    # Get results in CSV
    ./jsontool < out.json > outDets.csv
    ./jsontool --stats < out.json > outStats.csv
    # Load CSVs elsewhere for further processing

*/

#include <iostream>
#include <json/json.h>
    
using namespace std;
int main(int argc, char ** argv)
{
    enum {
        MODE_DETS = 0,
        MODE_STATS = 1
    } mode = MODE_DETS;
    if (argc > 1 && string(argv[1]) == "--stats")
    {
        mode = MODE_STATS;
    }
    Json::Reader reader;
    string str;
    int id = 0;
    while (cin >> str) {
        id++;
        Json::Value object;
        if (!reader.parse(str, object)) {
            cerr << reader.getFormattedErrorMessages() << endl;
            break;
        }
        if (object.empty()) continue;
        switch (mode)
        {
            case MODE_DETS:
            if (object.isMember("bbs") && object["bbs"].isArray()) {
                Json::Value bbs = object["bbs"];
                for (Json::ArrayIndex i = 0; i < bbs.size(); ++i) {
                    Json::Value bb = bbs[i];
                    cout << id << ',' << bb[0] << ',' << bb[1] << ',' << bb[2] << ',' << bb[3] << ',' << bb[4] << endl;
                }
            }
            break;
            
            case MODE_STATS:
            cout << id << ',' <<
                    object["fileName"].asString() << ',' <<
                    object["width"].asInt() << ',' << object["height"].asInt() << ',' <<
                    object["time"].asFloat() << ',' <<
                    object["nFtrs"].asInt() << ',' <<
                    object["nWins"].asInt() << ',' <<
                    object["cacheEffeciency"].asFloat() << ',' <<
                    object["bbs"].size() << endl;
            break;
        }
    }
    return 0;
}