# LBP Detector

This is an implementation of a Soft Cascade detector with LBP image features. The training is derived from ACF detector (`acfTrain`) from [Piotr's Toolbox](https://github.com/pdollar/toolbox). Here are main features of the Toolbox.

Development of this software was funded by TA ČR.

![Teaser](doc/teaser.png)

* Fast detector evaluation (threads, feature caching, etc.)
* Feature channels, LDCF channels
* C++ API for stand-alone applications (for limited detector configurations)
* Pre-trained models for frontal face detection

See [change log](ChangeLog.md) for description of the current version.

## Requirements and Installation

If you want to run the detection under MATLAB only, the dependencies are:

* MATLAB (developed under 2014a)
* C++ 11 enabled compiler (developed with gcc 4.8.x)
* [Piotr's Toolbox](https://github.com/pdollar/toolbox) (version 3.40 or above)

Stand-alone applications additionaly require:

* [OpenCV](opencv.org) (version 2.4 or above)
* [Google Protocol buffers](https://github.com/google/protobuf) (also required in order to compile `mexBinWrite.cpp`)
* [libargtable2](http://argtable.sourceforge.net/)
* [jsoncpp](https://github.com/open-source-parsers/jsoncpp)

To use the toolbox, simply extract the archive anywhere and add path to MATLAB environment (`addpath [your path]`). Run `lbpdetector.compile` to compile internal functions. Then run `lbpDemo` to see if everything works. Run `help lbpdetector` for list of functions.

## Training models

Function `detector = lbpTrain(opts)` trains a new detector. `opts` specify source of training data, and model parameters. It shares most of the code with `acfTrain` function from Piotr's Toolbox, and so the options are almost the same. For details on `opts` structure see help page. The difference in the training procedure is that after extraction of *Feature Channels*, *Local Binary Patterns* are calculated and used as weak classifiers (instead of training the trees). So there are **no trees** in the final model. Each round of AdaBoost selects a single LBP weak classifier.

## Detection of objects

A detector predicts objects on new image using function `lbpDetect`. Example:

```matlab
% Load image, detect objects and show results
im = imread('image.jpg');
bb = lbpDetect(im, detector);
imshow(im);
bbApply('draw', bb);
```

## C++ API

There is a *low level* C++ API for the *core* detector in `cpp` directory. The application `detect_lbp` directory show how to use the API. Just run `make` to compile it, and the `./demo.sh` to see how it works.

Detector model (output from `lbpTrain`) can be saved to *.bin* format (`lbpdetector.binwrite`) and loaded by C++ API (`LBPDetector::loadDetector`) in order to use it. Only detectors trained with certain settings can be saved - see `lbpdetector.iscompatible` for the specific information.

For more detailed info see [API documentation](cpp/README.md);

## Licensing

Since the [`lbpTrain`](lbpTrain.m), [`lbpDetect`](lbpDetect.m), [`lbpTest`](lbpTest.m), and [`lbpModify`](lbpModify.m) functios share most of the code with the original functions from Piotr's Toolbox, they are licensed under the [Simplified BSD license](external/bsd.txt) as stated in the files.

ThreadPool library is distributed without any changes under its [original license](external/ThreadPool/COPYING).

Images in `data` directory were taken from [FDDB dataset](http://vis-www.cs.umass.edu/fddb/).

The rest of the code is licensed under [Simplified BSD license](LICENSE).

## Bugs

If you experience an unexpexted behaviour, you can contact me at [ijuranek-at-fit.vutbr.cz].

## TODOs

* Quantization and integer response
* Script for parameter sweeps and evaluation
* Calibration (direct backward prunning, waldboost, other?)
* ~~Update Contents.m and write help for functions~~
* Train basic models (faces, peds, cars, etc.)
* Compare to ACF, LDCF, ACF+DIFF, LDCF+DIFF
* ~~Convert existing models to correct .bin format~~
* Video app - add configuration
* Find better names for modules, and rename
* Minimal demo - hardcoded detector, image in array
* convert foo_bar identifiers to fooBar
* `lbpdetector.compile` has to generate `detector.pb.*` files for `mexBinWrite`
* ~~Optimize `lbp.m`~~
* `lbpTrainFeature` support for parallel toolbox
