% LBPDETECTOR is a MATLAB package implementing object detection with LBP image features
%
% Main functions
%   lbpDemo - Demo with training and detection
%   lbpDetect - Main detection function
%   lbpTest - Testing procedure
%   lbpTrain - Training procedure
%   loadDets - Load detection results (stored by lbpDetect) from file
%
% Utility functions
%   lbpdetector.binwrite - Write detector in BIN format
%   lbpdetector.check - Check detector structure
%   lbpdetector.compile - Compile internal functions
%   lbpdetector.coverage - Get matrix with detector attention visualized
%   lbpdetector.feature_params - Generate LBP parameters
%   lbpdetector.iscompatible - Check if a detector is compatible with OpenCV API.
%   lbpdetector.size - Scanning window size
%   lbpdetector.transpose - Transform Row-Column format to X-Y
%   lbpdetector.xmlread - Read legacy XML detector
%   lbpdetector.xmlwrite - Write legacy XML detector
%
% Notes:
% * To successfuly use lbpDetect and lbpTrain, Piotr's Image and Video
%   Toolbox is required (http://vision.ucsd.edu/~pdollar/). Version 3.40
%   was used, however new versions should work as well.
% * Training, testing and detection code was derived from Piotr's Toolbox and
%   it uses the same code base.
% * Image scanning in MEX function is parallelized with ThreadPool 
%   (https://github.com/progschj/ThreadPool) which is distributed without any
%   changes in directory external.
% * This toolbox was developed and tested on MATLAB R2014a on 64 bit Linux
%   system with gcc 4.8.2 compiler. In other versions of MATLAB on other
%   systems there may be differences and something may not work properly
%   (compile script for instance).
%
% If you experience troubles using this toolbox or have any suggestions for
% improvements, please contact me.
%
% Roman Juranek <ijuranek@fit.vutbr.cz>
