function D = xmlread(fileName)
% Read legacy XML format
%
%   detector = xmlread(fileNmae);
%
% Read XML files produced by FIT BUT WaldBoost Training Tool.

doc = xmlread(fileName);

%% Empty detector

D.clf.ftr = {};
D.clf.thr = {};
D.clf.hs = {};
D.clf.size = [0 0];

%% Get classifier element

cls = doc.getElementsByTagName('WaldBoostClassifier');
if cls.getLength ~= 1, D=[]; return; end;
cls = cls.item(0);

D.clf.size(1) = str2double(cls.getAttribute('imageSizeX'));
D.clf.size(2) = str2double(cls.getAttribute('imageSizeY'));

%% Parse stages

stages = cls.getElementsByTagName('stage');
for t = 0:stages.getLength-1
    stg = stages.item(t); t1 = t+1;
    D.clf.thr{t1} = str2double(stg.getAttribute('negT'));
    wh = stg.getElementsByTagName('HistogramWeakHypothesis'); wh = wh.item(0);
    D.clf.hs{t1} = str2num(wh.getAttribute('predictionValues'))'; %#ok<ST2NM>
    ftr = wh.getElementsByTagName('LBPFeature'); ftr = ftr.item(0);
    f = [0 0 0 0 0]';
    f(1) = str2double(ftr.getAttribute('positionX'))';
    f(2) = str2double(ftr.getAttribute('positionY'))';
    f(3) = str2double(ftr.getAttribute('blockWidth'))';
    f(4) = str2double(ftr.getAttribute('blockHeight'))';
    D.clf.ftr{t1} = f;
end

%% Output structure

D.clf.ftr = uint8(horzcat(D.clf.ftr{:}));
D.clf.thr = single(horzcat(D.clf.thr{:}));
D.clf.hs = single(horzcat(D.clf.hs{:}));
D.clf.size = uint32(D.clf.size);
D.opts = defaultOpts(D);

%% Shuffle params

D = transpose(D,1);

end
