#include "CannonCamera.h"

CannonCamera::CannonCamera()
{
	this->Init();
}

CannonCamera::~CannonCamera()
{
	delete _cameraControl;
}

bool CannonCamera::Init()
{
	this->_cameraControl = new CameraControl();
	this->imageName = "";
	return true;
}

IplImage* CannonCamera::GetImage()
{
	if(_cameraControl != NULL)
	{
		char* imageFileName = _cameraControl->getImageName();
		if(imageFileName == NULL || strcmp(imageFileName,this->imageName.c_str()) == 0)
			return NULL;
		else
		{
			this->imageName = imageFileName;
			return CALIB::Cvh::LoadImage(imageFileName);	
		}
	}
	return NULL;

}

void CannonCamera::TakePicture()
{
	if(_cameraControl != NULL)
	{
		_cameraControl->takePicture();
	}
}

