/*
 *
 *	FFMpeg codec for audio / video
 *
 *	Honza P.
 *
 */

#ifndef _CODEC_
#define _CODEC_ // proti vicenasobnymu #includu

#include "../UberLame_src/Integer.h" // uint8_t is here

extern int videoLoaded;
extern int videoWidth;
extern int videoHeight;
extern float videoFrameTime;
extern float videoLength;
extern float playTime;

/**
 *	opens video file filename and fills the above global variables
 *	with it's properties and returns true if successful
 */
int OpenVideoFile(const char *filename);


/**
 *	this structure holds decoded image
 */
typedef struct {
	const uint8_t *data;
	int xsize, ysize; // size of image in pixels
	int xoffset, yoffset; // size of pixel (in bytes) and size of scanline in bytes
} TImage;


/**
 *	decodes next video frame and returns it
 *	if there are no more frames, returns frames with NULL buffer and zero size
 */
TImage GetVideoFrame();


/**
 *	close video file (if opened)
 */
void CloseVideoFile();


/**
 *	seeks to seekTime (in seconds)
 *	relative is either 1 or 0 depending on how should be seekTime interpreted
 *	returns nonzero value upon success
 */
int Seek(float seekTime, int relative);

#endif
