/*
								+---------------------------------+
								|                                 |
								|      ***   OpenGL2.0   ***      |
								|                                 |
								|  Copyright   -tHE SWINe- 2005  |
								|                                 |
								|            OpenGL20.h           |
								|                                 |
								+---------------------------------+
*/

#pragma once
#ifndef __OPENGL20_TOOL_INCLUDED
#define __OPENGL20_TOOL_INCLUDED

/**
 *	@file gl2/OpenGL20.h
 *	@author -tHE SWINe-
 *	@date 2005
 *	@brief OpenGL 2.0 extensions
 *
 *	@note This is header allowing "traditional" deprecated OpenGL functionality.
 *		Newer "Core Profile" OpenGL 3.0 header is in gl3/OpenGL30.h.
 *
 *	@date 2006-05-16
 *
 *	passed code revision
 *
 *	integers, contanining just true or false were changed to bool
 *
 *	@date 2006-07-15
 *
 *	passed code revision
 *
 *	some more integers, contanining just true or false were changed to bool
 *
 *	@date 2007-02-05
 *
 *	added support for GL_NV_fence extension
 *
 *	@date 2007-02-20
 *
 *	added support for following new (geForce8800 (or DX10)) extensions:
 *		- GL_ARB_occlusion_query
 *		- OpenGL 2.1
 *		- GL_EXT_timer_query
 *		- GL_EXT_draw_buffers2
 *		- GL_EXT_texture_integer
 *		- GL_EXT_gpu_shader4
 *		- GL_EXT_gpu_program_parameters
 *		- GL_EXT_bindable_uniform
 *		- GL_EXT_geometry_shader4
 *		- GL_EXT_draw_instanced
 *		- GL_EXT_texture_array
 *		- GL_EXT_texture_object
 *	removed outdated GL_EXT_texture_object extension (from 1995/10/03, promoted to core
 *	extension in OpenGL 1.1)
 *	removed dllexport attribute
 *
 *	@date 2007-10-29
 *
 *	added some documentation comments, clarified OpenGL 1.3 multitexture / ARB multitexture
 *	distinction and improved linux compatibility
 *
 *	@date 2007-11-10
 *
 *	improved linux compatibility
 *
 *	@date 2008-03-04
 *
 *	now using Integer.h header, hidden __stdcall into GLApi instead
 *	of defining __stdcall blank in linux
 *
 *	@date 2008-08-08
 *
 *	added \#ifdef for windows 64
 *
 *	@date 2008-08-19
 *
 *	gl.h is now included in OpenGL20.h (convenience)
 *
 *	@date 2009-05-03
 *
 *	added GL_FRAMEBUFFER_INCOMPLETE_DUPLICATE_ATTACHMENT_EXT enumerant
 *	(not defined in GL_EXT_packed_depth_stencil, nor in GL_EXT_framebuffer_object)
 *
 *	added CGLExtensionHandler::n_GetAllSupportedExtensionsFuncPointers()
 *
 *	@date 2009-05-04
 *
 *	fixed mixed windows / linux line endings
 *
 *	@date 2009-10-20
 *
 *	fixed some warnings when compiling under VC 2005, implemented "Security
 *	Enhancements in the CRT" for VC 2008. compare against MyProjects_2009-10-19_
 *
 *	@date2009-12-15
 *
 *	added numerous extensions
 *
 *	renamed n_GetCompressedTextureARBFuncPointers() to n_GetTextureCompressionARBFuncPointers()
 *	removed n_GetCompiledArrayEXTFuncPointers() as it's obsolete
 *	renamed n_GetShaderObjectARBFuncPointers() to n_GetShaderObjectsARBFuncPointers()
 *
 *	added GLEH_extension_name boolean variables, containing trie in case
 *	extension extension_name is supported. for example, when checking for
 *	GL_ARB_fragment_shader, it is possible to use:
 *
 *	CGLExtensionHandler::n_GetAllSupportedExtensionsFuncPointers(); // initialize
 *
 *	if(GLEH_ARB_fragment_shader) { // it's safe to call GL_ARB_fragment_shader functions
 *
 *	note OpenGL 3.0 and above core functions weren't added, berLame will
 *	support OpenGL 3.0 and above in (clean) core profile only, use new header
 *	"UberLame_src/gl3/OpenGL30.h".
 *
 *	list with function entry count names for each extension was discontinued,
 *	old extensions will remain there for backward compatibility. did anyone ever
 *	use that?
 *
 *	@date 2010-10-29
 *
 *	Unified windows detection macro to "\#if defined(_WIN32) || defined(_WIN64)".
 *
 *	@date 2012-06-19
 *
 *	Moved multiple inclusion guard before file documentation comment.
 *
 */

/*
** License Applicability. Except to the extent portions of this file are
** made subject to an alternative license as permitted in the SGI Free
** Software License B, Version 1.1 (the "License"), the contents of this
** file are subject only to the provisions of the License. You may not use
** this file except in compliance with the License. You may obtain a copy
** of the License at Silicon Graphics, Inc., attn: Legal Services, 1600
** Amphitheatre Parkway, Mountain View, CA 94043-1351, or at:
** 
** http://oss.sgi.com/projects/FreeB
** 
** Note that, as provided in the License, the Software is distributed on an
** "AS IS" basis, with ALL EXPRESS AND IMPLIED WARRANTIES AND CONDITIONS
** DISCLAIMED, INCLUDING, WITHOUT LIMITATION, ANY IMPLIED WARRANTIES AND
** CONDITIONS OF MERCHANTABILITY, SATISFACTORY QUALITY, FITNESS FOR A
** PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
** 
** Original Code. The Original Code is: OpenGL Sample Implementation,
** Version 1.2.1, released January 26, 2000, developed by Silicon Graphics,
** Inc. The Original Code is Copyright (c) 1991-2004 Silicon Graphics, Inc.
** Copyright in any portions created by third parties is as indicated
** elsewhere herein. All Rights Reserved.
** 
** Additional Notice Provisions: This software was created using the
** OpenGL(R) version 1.2.1 Sample Implementation published by SGI, but has
** not been independently verified as being compliant with the OpenGL(R)
** version 1.2.1 Specification.
*/

/*
 *	makes life a little bit easier when including gl.h by mistake
 */
#if defined(__gl_h_) || defined(__GL_H__) || defined(GL_VERSION_1_1)
#pragma message("warning: gl.h doesn't have to be included in files using OpenGL20.h")
#endif

/*
 *	makes life a little bit easier when including glext.h by mistake
 */
#if defined(__glext_h_) || defined(GL_GLEXT_VERSION)
#error("glext.h must NOT be included in files using OpenGL20.h")
#endif

/**
 *	@def NULL_FUNCTION_POINTERS
 *
 *	@brief in case NULL_FUNCTION_POINTERS is defined (default), all extension function pointers
 *		are initialized to 0, but user never needs to compare individual function values
 *		so it's posible to save some space in executable file by skipping the initialization
 */
#define NULL_FUNCTION_POINTERS

/**
 *	@def FIX_GL_FUNCTION_LINKING_CONFLICTS
 *	@brief avoids function linking conflicts by renaming function pointers, and fixing
 *		names using \#define
 *
 *	Some compilers may contain newer OpenGL libraries than this header requires
 *		(OpenGL 1.1, as supported by Microsoft Visual studio family), so names of function
 *		pointers, such as <tt>glBlendColor</tt> are present in static library, as well as in this
 *		file, causing link-time error. This is fixed by renaming the function, here
 *		<tt>glBlendColor_ptr</tt> would be used, and fixing it by macro, such as <tt>\#define
 *		glBlendColor_ptr glBlendColor</tt>. The downside of this is, the Visual Studio edior
 *		will no longer show pop-up function parameters (intellisense), so this is best
 *		avoided if possible.
 */
#define FIX_GL_FUNCTION_LINKING_CONFLICTS

/**
 *	@brief class for handling OpenGL extensions
 *
 *	Functions with name n_Get*FuncPointers() returns number of function pointers that were
 *		not found (zero is success), and also set GLEH_* flags.
 */
class CGLExtensionHandler {
public:
	/**
	 *	@brief checks OpenGL version support
	 *
	 *	@param[in] n_min_major is minimal required version major
	 *	@param[in] n_min_minor is minimal required version minor
	 *
	 *	@return Returns true in case OpenGL version  is greater or equal to
	 *		n_min_major.n_min_minor. Might return false on malformed OpenGL version string.
	 */
	static bool b_Support_OpenGL(int n_min_major = 2, int n_min_minor = 0);

	/**
	 *	@brief gets OpenGL version
	 *
	 *	@return Returns OpenGL version as major * 10 + minor (ie. for OpenGL 2.1 returns 21).
	 */
	static int n_OpenGL_Version();

	/**
	 *	@brief checks OpenGL extension support
	 *
	 *	@param[in] p_s_extension_name is null-termianted string, containing extension name
	 *		(such as "GL_ARB_texture_non_power_of_two")
	 *
	 *	@return Returns true in case p_s_extension_name is supported, otherwise false.
	 *
	 *	@note This requires space in extension string before and after the extension name
	 *		(except on beginning / end of the string), so this correctly handles extensions
	 *		like "GL_ARB_texture" and "GL_ARB_texture_non_power_of_two".
	 */
	static bool b_SupportedExtension(const char *p_s_extension_name);

#if defined(_WIN32) || defined (_WIN64)
	/**
	 *	@brief checks window system extension support (WGL / GLX)
	 *
	 *	@param[in] p_s_extension_name is null-termianted string, containing extension name
	 *		(such as "WGL_ARB_swap_hint")
	 *
	 *	@return Returns true in case p_s_extension_name is supported, otherwise false.
	 *
	 *	@note This requires space in extension string before and after the extension name
	 *		(except on beginning / end of the string).
	 */
	static bool b_SupportedWGLExtension(const char *p_s_extension_name);
#endif

	/**
	 *	@brief gets function pointers for all supported extensions and OpenGL versions
	 *
	 *	This initializes GLEH_* variables, use them to check for extension support.
	 *
	 *	@return Returns number of missing functions (0 is success, but it is hardly ever achieved).
	 */
	static int n_GetAllSupportedExtensionsFuncPointers();

	/**
	 *	@brief gets OpenGL 1.2 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL12FuncPointers();

	/**
	 *	@brief gets OpenGL 1.3 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL13FuncPointers();

	/**
	 *	@brief gets OpenGL 1.3 multitexture function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetMultitextureFuncPointers();

	/**
	 *	@brief gets GL_ARB_multitexture function pointers
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note function names are ones of OpenGL 1.3 multitexture, no ARB suffix here
	 */
	static int n_GetMultitextureARBFuncPointers();

	/**
	 *	@brief gets OpenGL 1.4 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL14FuncPointers();

	/**
	 *	@brief gets OpenGL 1.5 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL15FuncPointers();

	/**
	 *	@brief gets OpenGL 2.0 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL20FuncPointers();

	/**
	 *	@brief gets OpenGL 2.1 core function pointers
	 *
	 *	@return Returns number of missing functions (0 is success).
	 */
	static int n_GetGL21FuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_compression function pointers, sets GLEH_ARB_texture_compression
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureCompressionARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_color_buffer_float function pointers, sets GLEH_ARB_color_buffer_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetColorBufferFloatARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_shader_object function pointers, sets GLEH_ARB_shader_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetShaderObjectsARBFuncPointers();

	/**
	 *	@brief gets GL_EXT_gpu_shader4 function pointers, sets GLEH_EXT_gpu_shader4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGPUShader4EXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_gpu_program_parameters function pointers,
	 *		sets GLEH_EXT_gpu_program_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGPUProgramParametersEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_blend_minmax function pointers, sets GLEH_EXT_blend_minmax
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetBlendMinMaxEXTFuncPointers();

	/**
	 *	@brief gets GL_ARB_copy_buffer function pointers, and sets GLEH_ARB_copy_buffer
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetCopyBufferARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_depth_buffer_float function pointers, and sets GLEH_ARB_depth_buffer_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetDepthBufferFloatARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_depth_clamp function pointers, and sets GLEH_ARB_depth_clamp
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetDepthClampARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_depth_texture function pointers, and sets GLEH_ARB_depth_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetDepthTextureARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_buffers function pointers, and sets GLEH_ARB_draw_buffers
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawBuffersARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_draw_elements_base_vertex function pointers, and sets GLEH_ARB_draw_elements_base_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawElementsBaseVertexARBFuncPointers();
	/**
	 *	@brief gets GL_ARB_draw_instanced function pointers, and sets GLEH_ARB_draw_instanced
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawInstancedARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_coord_conventions function pointers, and sets GLEH_ARB_fragment_coord_conventions
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFragmentCoordConventionsARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_program function pointers, and sets GLEH_ARB_fragment_program
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFragmentProgramARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_program_shadow function pointers, and sets GLEH_ARB_fragment_program_shadow
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFragmentProgramShadowARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_fragment_shader function pointers, and sets GLEH_ARB_fragment_shader
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFragmentShaderARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_framebuffer_object function pointers, and sets GLEH_ARB_framebuffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFramebufferObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_framebuffer_sRGB function pointers, and sets GLEH_ARB_framebuffer_sRGB
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFramebufferSRGBARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_geometry_shader4 function pointers, and sets GLEH_ARB_geometry_shader4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGeometryShader4ARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_half_float_pixel function pointers, and sets GLEH_ARB_half_float_pixel
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetHalfFloatPixelARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_half_float_vertex function pointers, and sets GLEH_ARB_half_float_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetHalfFloatVertexARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_map_buffer_range function pointers, and sets GLEH_ARB_map_buffer_range
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetMapBufferRangeARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_multisample function pointers, and sets GLEH_ARB_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetMultisampleARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_occlusion_query function pointers, and sets GLEH_ARB_occlusion_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetOcclusionQueryARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_pixel_buffer_object function pointers, and sets GLEH_ARB_pixel_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPixelBufferObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_point_parameters function pointers, and sets GLEH_ARB_point_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetPointParametersARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_point_sprite function pointers, and sets GLEH_ARB_point_sprite
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPointSpriteARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_provoking_vertex function pointers, and sets GLEH_ARB_provoking_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetProvokingVertexARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_seamless_cube_map function pointers, and sets GLEH_ARB_seamless_cube_map
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetSeamlessCubeMapARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_shading_language_100 function pointers, and sets GLEH_ARB_shading_language_100
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetShadingLanguage100ARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_shadow function pointers, and sets GLEH_ARB_shadow
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetShadowARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_sync function pointers, and sets GLEH_ARB_sync
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetSyncARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_border_clamp function pointers, and sets GLEH_ARB_texture_border_clamp
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureBorderClampARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_buffer_object function pointers, and sets GLEH_ARB_texture_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureBufferObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_compression_rgtc function pointers, and sets GLEH_ARB_texture_compression_rgtc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCompressionRgtcARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_cube_map function pointers, and sets GLEH_ARB_texture_cube_map
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCubeMapARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_env_add function pointers, and sets GLEH_ARB_texture_env_add
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvAddARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_env_combine function pointers, and sets GLEH_ARB_texture_env_combine
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvCombineARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_env_dot3 function pointers, and sets GLEH_ARB_texture_env_dot3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvDot3ARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_float function pointers, and sets GLEH_ARB_texture_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureFloatARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_mirrored_repeat function pointers, and sets GLEH_ARB_texture_mirrored_repeat
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureMirroredRepeatARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_multisample function pointers, and sets GLEH_ARB_texture_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureMultisampleARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_non_power_of_two function pointers, and sets GLEH_ARB_texture_non_power_of_two
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureNonPowerOfTwoARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_rectangle function pointers, and sets GLEH_ARB_texture_rectangle
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureRectangleARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_texture_rg function pointers, and sets GLEH_ARB_texture_rg
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureRgARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_transpose_matrix function pointers, and sets GLEH_ARB_transpose_matrix
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTransposeMatrixARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_uniform_buffer_object function pointers, and sets GLEH_ARB_uniform_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetUniformBufferObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_array_bgra function pointers, and sets GLEH_ARB_vertex_array_bgra
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexArrayBgraARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_array_object function pointers, and sets GLEH_ARB_vertex_array_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexArrayObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_buffer_object function pointers, and sets GLEH_ARB_vertex_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexBufferObjectARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_program function pointers, and sets GLEH_ARB_vertex_program
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexProgramARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_shader function pointers, and sets GLEH_ARB_vertex_shader
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexShaderARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_window_pos function pointers, and sets GLEH_ARB_window_pos
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetWindowPosARBFuncPointers();

	/**
	 *	@brief gets GL_ATI_draw_buffers function pointers, and sets GLEH_ATI_draw_buffers
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawBuffersATIFuncPointers();

	/**
	 *	@brief gets GL_ATI_texture_float function pointers, and sets GLEH_ATI_texture_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureFloatATIFuncPointers();

	/**
	 *	@brief gets GL_ATI_texture_mirror_once function pointers, and sets GLEH_ATI_texture_mirror_once
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureMirrorOnceATIFuncPointers();

	/**
	 *	@brief gets GL_S3_s3tc function pointers, and sets GLEH_S3_s3tc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetS3tcS3FuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_env_add function pointers, and sets GLEH_EXT_texture_env_add
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvAddEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_abgr function pointers, and sets GLEH_EXT_abgr
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetAbgrEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_bgra function pointers, and sets GLEH_EXT_bgra
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetBgraEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_bindable_uniform function pointers, and sets GLEH_EXT_bindable_uniform
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetBindableUniformEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_blend_color function pointers, and sets GLEH_EXT_blend_color
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetBlendColorEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_blend_equation_separate function pointers, and sets GLEH_EXT_blend_equation_separate
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetBlendEquationSeparateEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_blend_func_separate function pointers, and sets GLEH_EXT_blend_func_separate
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetBlendFuncSeparateEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_blend_subtract function pointers, and sets GLEH_EXT_blend_subtract
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetBlendSubtractEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_depth_bounds_test function pointers, and sets GLEH_EXT_depth_bounds_test
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDepthBoundsTestEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_direct_state_access function pointers, and sets GLEH_EXT_direct_state_access
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDirectStateAccessEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_draw_buffers2 function pointers, and sets GLEH_EXT_draw_buffers2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawBuffers2EXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_draw_instanced function pointers, and sets GLEH_EXT_draw_instanced
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDrawInstancedEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_fog_coord function pointers, and sets GLEH_EXT_fog_coord
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFogCoordEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_framebuffer_blit function pointers, and sets GLEH_EXT_framebuffer_blit
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFramebufferBlitEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_framebuffer_multisample function pointers, and sets GLEH_EXT_framebuffer_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFramebufferMultisampleEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_framebuffer_object function pointers, and sets GLEH_EXT_framebuffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFramebufferObjectEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_framebuffer_sRGB function pointers, and sets GLEH_EXT_framebuffer_sRGB
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFramebufferSRGBEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_geometry_shader4 function pointers, and sets GLEH_EXT_geometry_shader4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGeometryShader4EXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_multi_draw_arrays function pointers, and sets GLEH_EXT_multi_draw_arrays
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetMultiDrawArraysEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_packed_depth_stencil function pointers, and sets GLEH_EXT_packed_depth_stencil
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPackedDepthStencilEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_packed_float function pointers, and sets GLEH_EXT_packed_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPackedFloatEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_packed_pixels function pointers, and sets GLEH_EXT_packed_pixels
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPackedPixelsEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_pixel_buffer_object function pointers, and sets GLEH_EXT_pixel_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPixelBufferObjectEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_point_parameters function pointers, and sets GLEH_EXT_point_parameters
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetPointParametersEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_provoking_vertex function pointers, and sets GLEH_EXT_provoking_vertex
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetProvokingVertexEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_rescale_normal function pointers, and sets GLEH_EXT_rescale_normal
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetRescaleNormalEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_secondary_color function pointers, and sets GLEH_EXT_secondary_color
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetSecondaryColorEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_separate_shader_objects function pointers, and sets GLEH_EXT_separate_shader_objects
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetSeparateShaderObjectsEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_separate_specular_color function pointers, and sets GLEH_EXT_separate_specular_color
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetSeparateSpecularColorEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_shadow_funcs function pointers, and sets GLEH_EXT_shadow_funcs
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetShadowFuncsEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_stencil_two_side function pointers, and sets GLEH_EXT_stencil_two_side
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetStencilTwoSideEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_stencil_wrap function pointers, and sets GLEH_EXT_stencil_wrap
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetStencilWrapEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture3D function pointers, and sets GLEH_EXT_texture3D
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTexture3DEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_array function pointers, and sets GLEH_EXT_texture_array
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureArrayEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_buffer_object function pointers, and sets GLEH_EXT_texture_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureBufferObjectEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_compression_latc function pointers, and sets GLEH_EXT_texture_compression_latc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCompressionLatcEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_compression_rgtc function pointers, and sets GLEH_EXT_texture_compression_rgtc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCompressionRgtcEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_compression_s3tc function pointers, and sets GLEH_EXT_texture_compression_s3tc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCompressionS3tcEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_env_combine function pointers, and sets GLEH_EXT_texture_env_combine
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvCombineEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_env_dot3 function pointers, and sets GLEH_EXT_texture_env_dot3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvDot3EXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_filter_anisotropic function pointers, and sets GLEH_EXT_texture_filter_anisotropic
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureFilterAnisotropicEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_integer function pointers, and sets GLEH_EXT_texture_integer
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureIntegerEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_lod_bias function pointers, and sets GLEH_EXT_texture_lod_bias
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureLodBiasEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_mirror_clamp function pointers, and sets GLEH_EXT_texture_mirror_clamp
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureMirrorClampEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_object function pointers, and sets GLEH_EXT_texture_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureObjectEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_shared_exponent function pointers, and sets GLEH_EXT_texture_shared_exponent
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureSharedExponentEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_sRGB function pointers, and sets GLEH_EXT_texture_sRGB
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureSRGBEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_texture_swizzle function pointers, and sets GLEH_EXT_texture_swizzle
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureSwizzleEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_timer_query function pointers, and sets GLEH_EXT_timer_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTimerQueryEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_vertex_array function pointers, and sets GLEH_EXT_vertex_array
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexArrayEXTFuncPointers();

	/**
	 *	@brief gets GL_EXT_vertex_array_bgra function pointers, and sets GLEH_EXT_vertex_array_bgra
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexArrayBgraEXTFuncPointers();

	/**
	 *	@brief gets GL_IBM_rasterpos_clip function pointers, and sets GLEH_IBM_rasterpos_clip
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetRasterposClipIBMFuncPointers();

	/**
	 *	@brief gets GL_IBM_texture_mirrored_repeat function pointers, and sets GLEH_IBM_texture_mirrored_repeat
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureMirroredRepeatIBMFuncPointers();

	/**
	 *	@brief gets GL_NV_blend_square function pointers, and sets GLEH_NV_blend_square
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetBlendSquareNVFuncPointers();

	/**
	 *	@brief gets GL_NV_conditional_render function pointers, and sets GLEH_NV_conditional_render
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetConditionalRenderNVFuncPointers();

	/**
	 *	@brief gets GL_NV_copy_depth_to_color function pointers, and sets GLEH_NV_copy_depth_to_color
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetCopyDepthToColorNVFuncPointers();

	/**
	 *	@brief gets GL_NV_copy_image function pointers, and sets GLEH_NV_copy_image
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetCopyImageNVFuncPointers();

	/**
	 *	@brief gets GL_NV_depth_buffer_float function pointers, and sets GLEH_NV_depth_buffer_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetDepthBufferFloatNVFuncPointers();

	/**
	 *	@brief gets GL_NV_depth_clamp function pointers, and sets GLEH_NV_depth_clamp
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetDepthClampNVFuncPointers();

	/**
	 *	@brief gets GL_NV_explicit_multisample function pointers, and sets GLEH_NV_explicit_multisample
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetExplicitMultisampleNVFuncPointers();

	/**
	 *	@brief gets GL_NV_fence function pointers, and sets GLEH_NV_fence
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFenceNVFuncPointers();

	/**
	 *	@brief gets GL_NV_float_buffer function pointers, and sets GLEH_NV_float_buffer
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFloatBufferNVFuncPointers();

	/**
	 *	@brief gets GL_NV_fog_distance function pointers, and sets GLEH_NV_fog_distance
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFogDistanceNVFuncPointers();

	/**
	 *	@brief gets GL_NV_fragment_program function pointers, and sets GLEH_NV_fragment_program
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFragmentProgramNVFuncPointers();

	/**
	 *	@brief gets GL_NV_fragment_program_option function pointers, and sets GLEH_NV_fragment_program_option
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFragmentProgramOptionNVFuncPointers();

	/**
	 *	@brief gets GL_NV_fragment_program2 function pointers, and sets GLEH_NV_fragment_program2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetFragmentProgram2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_framebuffer_multisample_coverage function pointers, and sets GLEH_NV_framebuffer_multisample_coverage
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetFramebufferMultisampleCoverageNVFuncPointers();

	/**
	 *	@brief gets GL_NV_geometry_shader4 function pointers, and sets GLEH_NV_geometry_shader4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetGeometryShader4NVFuncPointers();

	/**
	 *	@brief gets GL_NV_gpu_program4 function pointers, and sets GLEH_NV_gpu_program4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetGpuProgram4NVFuncPointers();

	/**
	 *	@brief gets GL_NV_half_float function pointers, and sets GLEH_NV_half_float
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetHalfFloatNVFuncPointers();

	/**
	 *	@brief gets GL_NV_light_max_exponent function pointers, and sets GLEH_NV_light_max_exponent
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetLightMaxExponentNVFuncPointers();

	/**
	 *	@brief gets GL_NV_multisample_filter_hint function pointers, and sets GLEH_NV_multisample_filter_hint
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetMultisampleFilterHintNVFuncPointers();

	/**
	 *	@brief gets GL_NV_occlusion_query function pointers, and sets GLEH_NV_occlusion_query
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetOcclusionQueryNVFuncPointers();

	/**
	 *	@brief gets GL_NV_packed_depth_stencil function pointers, and sets GLEH_NV_packed_depth_stencil
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetPackedDepthStencilNVFuncPointers();

	/**
	 *	@brief gets GL_NV_parameter_buffer_object function pointers, and sets GLEH_NV_parameter_buffer_object
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetParameterBufferObjectNVFuncPointers();

	/**
	 *	@brief gets GL_NV_parameter_buffer_object2 function pointers, and sets GLEH_NV_parameter_buffer_object2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetParameterBufferObject2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_pixel_data_range function pointers, and sets GLEH_NV_pixel_data_range
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetPixelDataRangeNVFuncPointers();

	/**
	 *	@brief gets GL_NV_point_sprite function pointers, and sets GLEH_NV_point_sprite
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetPointSpriteNVFuncPointers();

	/**
	 *	@brief gets GL_NV_primitive_restart function pointers, and sets GLEH_NV_primitive_restart
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetPrimitiveRestartNVFuncPointers();

	/**
	 *	@brief gets GL_NV_register_combiners function pointers, and sets GLEH_NV_register_combiners
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetRegisterCombinersNVFuncPointers();

	/**
	 *	@brief gets GL_NV_register_combiners2 function pointers, and sets GLEH_NV_register_combiners2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetRegisterCombiners2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_shader_buffer_load function pointers, and sets GLEH_NV_shader_buffer_load
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetShaderBufferLoadNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texgen_reflection function pointers, and sets GLEH_NV_texgen_reflection
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTexgenReflectionNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_barrier function pointers, and sets GLEH_NV_texture_barrier
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTextureBarrierNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_compression_vtc function pointers, and sets GLEH_NV_texture_compression_vtc
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureCompressionVtcNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_env_combine4 function pointers, and sets GLEH_NV_texture_env_combine4
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureEnvCombine4NVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_expand_normal function pointers, and sets GLEH_NV_texture_expand_normal
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureExpandNormalNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_rectangle function pointers, and sets GLEH_NV_texture_rectangle
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureRectangleNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_shader function pointers, and sets GLEH_NV_texture_shader
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureShaderNVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_shader2 function pointers, and sets GLEH_NV_texture_shader2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureShader2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_texture_shader3 function pointers, and sets GLEH_NV_texture_shader3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureShader3NVFuncPointers();

	/**
	 *	@brief gets GL_NV_transform_feedback function pointers, and sets GLEH_NV_transform_feedback
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTransformFeedbackNVFuncPointers();

	/**
	 *	@brief gets GL_NV_transform_feedback2 function pointers, and sets GLEH_NV_transform_feedback2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetTransformFeedback2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_array_range function pointers, and sets GLEH_NV_vertex_array_range
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexArrayRangeNVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_array_range2 function pointers, and sets GLEH_NV_vertex_array_range2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexArrayRange2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_buffer_unified_memory function pointers, and sets GLEH_NV_vertex_buffer_unified_memory
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexBufferUnifiedMemoryNVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_program function pointers, and sets GLEH_NV_vertex_program
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexProgramNVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_program1_1 function pointers, and sets GLEH_NV_vertex_program1_1
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexProgram11NVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_program2 function pointers, and sets GLEH_NV_vertex_program2
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexProgram2NVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_program2_option function pointers, and sets GLEH_NV_vertex_program2_option
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexProgram2OptionNVFuncPointers();

	/**
	 *	@brief gets GL_NV_vertex_program3 function pointers, and sets GLEH_NV_vertex_program3
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetVertexProgram3NVFuncPointers();

	/**
	 *	@brief gets GL_SGIS_generate_mipmap function pointers, and sets GLEH_SGIS_generate_mipmap
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetGenerateMipmapSGISFuncPointers();

	/**
	 *	@brief gets GL_SGIS_texture_lod function pointers, and sets GLEH_SGIS_texture_lod
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetTextureLodSGISFuncPointers();

	/**
	 *	@brief gets GL_SGIX_depth_texture function pointers, and sets GLEH_SGIX_depth_texture
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetDepthTextureSGIXFuncPointers();

	/**
	 *	@brief gets GL_SGIX_shadow function pointers, and sets GLEH_SGIX_shadow
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetShadowSGIXFuncPointers();

	/**
	 *	@brief gets GL_SUN_slice_accum function pointers, and sets GLEH_SUN_slice_accum
	 *
	 *	@return Returns number of missing functions (zero means success).
	 *
	 *	@note this extension has no functions, so this always returns zero.
	 */
	static int n_GetSliceAccumSUNFuncPointers();

	/**
	 *	@brief gets GL_ARB_vertex_blend function pointers, and sets GLEH_ARB_vertex_blend
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetVertexBlendARBFuncPointers();

	/**
	 *	@brief gets GL_ARB_matrix_palette function pointers, and sets GLEH_ARB_matrix_palette
	 *
	 *	@return Returns number of missing functions (zero means success).
	 */
	static int n_GetMatrixPaletteARBFuncPointers();
};

/**
 *	@brief contains numers of functions for (some of) supported extensions
 */
enum {
	num_functions_gl12 = 38,
	num_functions_multitexture = 34,
	num_functions_gl13 = 12 + num_functions_multitexture,
	num_functions_arb_multitexture = num_functions_multitexture,
	num_functions_gl14 = 45,
	num_functions_gl15 = 19,
	num_functions_gl20 = 93,
	num_functions_compressed_texture_arb = 7,
	num_functions_vertex_blend_arb = 10,
	num_functions_matrix_palette_arb = 5,
	num_functions_framebuffer_object_ext = 17,
	num_functions_compiled_vertex_array_ext = 2,
	//num_functions_texture_object_ext = 6, (20. EXT from 1995/10/03; outdated)
	num_functions_polygon_offset_ext = 1,
	num_functions_color_buffer_float_arb = 1,
	num_functions_vertex_array_ext = 9,
	num_functions_vertex_program_arb = 62,
	num_functions_fragment_program_arb = 19,
	num_functions_vertex_shader_arb = 46,
	num_functions_fragment_shader_arb = 0,
	num_functions_shader_object_arb = 39,
	num_functions_vertex_buffer_object_arb = 11,
	num_functions_fence_nv = 7,
	num_functions_occlusion_query_ext = 8,
	num_functions_gl21 = 6,
	num_functions_timer_query_ext = 2,
	num_functions_draw_buffers2_ext = 6,
	num_functions_texture_integer_ext = 6,
	num_functions_gpu_shader4_ext = 34,
	num_functions_gpu_program_parameters_ext = 2,
	num_functions_bindable_uniform_ext = 3,
	num_functions_geometry_shader4_ext = 4,
	num_functions_draw_instanced_ext = 2,
	num_functions_texture_array_ext = 1,
	num_functions_texture_object_ext = 1,
	num_functions_blend_minmax_ext = 1
};

/**
 *	@def GLFuncPtrName
 *
 *	@brief used to fix linking conflicts by appending "_ptr"
 *		to OpenGL function pointer names; refer to FIX_GL_FUNCTION_LINKING_CONFLICTS
 *		for more details
 *
 *	@param f is function name
 */
#ifdef FIX_GL_FUNCTION_LINKING_CONFLICTS
#define __ConCat__(a,b) a##b
#define GLFuncPtrName(f) __ConCat__(f,_ptr)
#else // FIX_GL_FUNCTION_LINKING_CONFLICTS
#define GLFuncPtrName(f) f
#endif // FIX_GL_FUNCTION_LINKING_CONFLICTS

/**
 *	@def GLApi
 *
 *	@brief calling convention specifier for OpenGL functions
 */
#if defined(_WIN32) || defined (_WIN64)
#define GLApi __stdcall
#else
#define GLApi 
#endif // WIN32, _WIN64

#if defined(_WIN32) || defined (_WIN64)
#include <windows.h> // gl.h needs some typedefs
#endif
#define GL_GLEXT_LEGACY
#define __glext_h_
#include <GL/gl.h>
#undef __glext_h_
// include gl.h, make sure glext.h isn't included

#include <stddef.h>
#ifndef GL_VERSION_2_0
/* GL type for program/shader text */
typedef char GLchar;			/* native character */
#endif

#ifndef GL_VERSION_1_5
/* GL types for handling large vertex buffer objects */
typedef ptrdiff_t GLintptr;
typedef ptrdiff_t GLsizeiptr;
#endif

#ifndef GL_ARB_vertex_buffer_object
/* GL types for handling large vertex buffer objects */
typedef ptrdiff_t GLintptrARB;
typedef ptrdiff_t GLsizeiptrARB;
#endif

#ifndef GL_ARB_shader_objects
/* GL types for handling shader object handles and program/shader text */
typedef char GLcharARB;		/* native character */
typedef unsigned int GLhandleARB;	/* shader object handle */
#endif

/* GL types for "half" precision (s10e5) float data in host memory */
#ifndef GL_ARB_half_float_pixel
typedef unsigned short GLhalfARB;
#endif

#ifndef GL_NV_half_float
typedef unsigned short GLhalfNV;
#endif

#ifndef GLEXT_64_TYPES_DEFINED
/* This code block is duplicated in glext.h, so must be protected */
#define GLEXT_64_TYPES_DEFINED
#include "../Integer.h"
#endif

#ifndef GL_EXT_timer_query
typedef int64_t GLint64EXT;
typedef uint64_t GLuint64EXT;
#endif

typedef int64_t GLint64;
typedef uint64_t GLuint64;
typedef struct __GLsync *GLsync;
// GL_ARB_sync data types

typedef unsigned short GLhalf;
// GL_NV_half_float data types

//							    --- opengl 1.2 core functions ---

#ifndef GL_VERSION_1_2
#define GL_VERSION_1_2 1
#define __GENERATE_GL_12__

#define GL_UNSIGNED_BYTE_3_3_2            0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4         0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1         0x8034
#define GL_UNSIGNED_INT_8_8_8_8           0x8035
#define GL_UNSIGNED_INT_10_10_10_2        0x8036
#define GL_RESCALE_NORMAL                 0x803A
#define GL_TEXTURE_BINDING_3D             0x806A
#define GL_PACK_SKIP_IMAGES               0x806B
#define GL_PACK_IMAGE_HEIGHT              0x806C
#define GL_UNPACK_SKIP_IMAGES             0x806D
#define GL_UNPACK_IMAGE_HEIGHT            0x806E
#define GL_TEXTURE_3D                     0x806F
#define GL_PROXY_TEXTURE_3D               0x8070
#define GL_TEXTURE_DEPTH                  0x8071
#define GL_TEXTURE_WRAP_R                 0x8072
#define GL_MAX_3D_TEXTURE_SIZE            0x8073
#define GL_UNSIGNED_BYTE_2_3_3_REV        0x8362
#define GL_UNSIGNED_SHORT_5_6_5           0x8363
#define GL_UNSIGNED_SHORT_5_6_5_REV       0x8364
#define GL_UNSIGNED_SHORT_4_4_4_4_REV     0x8365
#define GL_UNSIGNED_SHORT_1_5_5_5_REV     0x8366
#define GL_UNSIGNED_INT_8_8_8_8_REV       0x8367
#define GL_UNSIGNED_INT_2_10_10_10_REV    0x8368
#define GL_BGR                            0x80E0
#define GL_BGRA                           0x80E1
#define GL_MAX_ELEMENTS_VERTICES          0x80E8
#define GL_MAX_ELEMENTS_INDICES           0x80E9
#define GL_CLAMP_TO_EDGE                  0x812F
#define GL_TEXTURE_MIN_LOD                0x813A
#define GL_TEXTURE_MAX_LOD                0x813B
#define GL_TEXTURE_BASE_LEVEL             0x813C
#define GL_TEXTURE_MAX_LEVEL              0x813D
#define GL_LIGHT_MODEL_COLOR_CONTROL      0x81F8
#define GL_SINGLE_COLOR                   0x81F9
#define GL_SEPARATE_SPECULAR_COLOR        0x81FA
#define GL_SMOOTH_POINT_SIZE_RANGE        0x0B12
#define GL_SMOOTH_POINT_SIZE_GRANULARITY  0x0B13
#define GL_SMOOTH_LINE_WIDTH_RANGE        0x0B22
#define GL_SMOOTH_LINE_WIDTH_GRANULARITY  0x0B23
#define GL_ALIASED_POINT_SIZE_RANGE       0x846D
#define GL_ALIASED_LINE_WIDTH_RANGE       0x846E

extern void (GLApi *GLFuncPtrName(glBlendColor))(GLclampf, GLclampf, GLclampf, GLclampf);
extern void (GLApi *GLFuncPtrName(glBlendEquation))(GLenum);
extern void (GLApi *GLFuncPtrName(glDrawRangeElements))(GLenum, GLuint, GLuint, GLsizei, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glColorTable))(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glColorTableParameterfv))(GLenum, GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glColorTableParameteriv))(GLenum, GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glCopyColorTable))(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetColorTable))(GLenum, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetColorTableParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetColorTableParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glColorSubTable))(GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCopyColorSubTable))(GLenum, GLsizei, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glConvolutionFilter1D))(GLenum, GLenum, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glConvolutionFilter2D))(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glConvolutionParameterf))(GLenum, GLenum, GLfloat);
extern void (GLApi *GLFuncPtrName(glConvolutionParameterfv))(GLenum, GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glConvolutionParameteri))(GLenum, GLenum, GLint);
extern void (GLApi *GLFuncPtrName(glConvolutionParameteriv))(GLenum, GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glCopyConvolutionFilter1D))(GLenum, GLenum, GLint, GLint, GLsizei);
extern void (GLApi *GLFuncPtrName(glCopyConvolutionFilter2D))(GLenum, GLenum, GLint, GLint, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetConvolutionFilter))(GLenum, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetConvolutionParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetConvolutionParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetSeparableFilter))(GLenum, GLenum, GLenum, GLvoid *, GLvoid *, GLvoid*);
extern void (GLApi *GLFuncPtrName(glSeparableFilter2D))(GLenum, GLenum, GLsizei, GLsizei, GLenum, GLenum, const GLvoid *, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetHistogram))(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetHistogramParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetHistogramParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetMinmax))(GLenum, GLboolean, GLenum, GLenum, GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetMinmaxParameterfv))(GLenum, GLenum, GLfloat*);
extern void (GLApi *GLFuncPtrName(glGetMinmaxParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glHistogram))(GLenum, GLsizei, GLenum, GLboolean);
extern void (GLApi *GLFuncPtrName(glMinmax))(GLenum, GLenum, GLboolean);
extern void (GLApi *GLFuncPtrName(glResetHistogram))(GLenum);
extern void (GLApi *GLFuncPtrName(glResetMinmax))(GLenum);
extern void (GLApi *GLFuncPtrName(glTexImage3D))(GLenum, GLint, GLint, GLsizei, GLsizei, GLsizei, GLint, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glTexSubImage3D))(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCopyTexSubImage3D))(GLenum, GLint, GLint, GLint, GLint, GLint, GLint, GLsizei, GLsizei);

#define glBlendColor GLFuncPtrName(glBlendColor)
#define glBlendEquation GLFuncPtrName(glBlendEquation)
#define glDrawRangeElements GLFuncPtrName(glDrawRangeElements)
#define glColorTable GLFuncPtrName(glColorTable)
#define glColorTableParameterfv GLFuncPtrName(glColorTableParameterfv)
#define glColorTableParameteriv GLFuncPtrName(glColorTableParameteriv)
#define glCopyColorTable GLFuncPtrName(glCopyColorTable)
#define glGetColorTable GLFuncPtrName(glGetColorTable)
#define glGetColorTableParameterfv GLFuncPtrName(glGetColorTableParameterfv)
#define glGetColorTableParameteriv GLFuncPtrName(glGetColorTableParameteriv)
#define glColorSubTable GLFuncPtrName(glColorSubTable)
#define glCopyColorSubTable GLFuncPtrName(glCopyColorSubTable)
#define glConvolutionFilter1D GLFuncPtrName(glConvolutionFilter1D)
#define glConvolutionFilter2D GLFuncPtrName(glConvolutionFilter2D)
#define glConvolutionParameterf GLFuncPtrName(glConvolutionParameterf)
#define glConvolutionParameterfv GLFuncPtrName(glConvolutionParameterfv)
#define glConvolutionParameteri GLFuncPtrName(glConvolutionParameteri)
#define glConvolutionParameteriv GLFuncPtrName(glConvolutionParameteriv)
#define glCopyConvolutionFilter1D GLFuncPtrName(glCopyConvolutionFilter1D)
#define glCopyConvolutionFilter2D GLFuncPtrName(glCopyConvolutionFilter2D)
#define glGetConvolutionFilter GLFuncPtrName(glGetConvolutionFilter)
#define glGetConvolutionParameterfv GLFuncPtrName(glGetConvolutionParameterfv)
#define glGetConvolutionParameteriv GLFuncPtrName(glGetConvolutionParameteriv)
#define glGetSeparableFilter GLFuncPtrName(glGetSeparableFilter)
#define glSeparableFilter2D GLFuncPtrName(glSeparableFilter2D)
#define glGetHistogram GLFuncPtrName(glGetHistogram)
#define glGetHistogramParameterfv GLFuncPtrName(glGetHistogramParameterfv)
#define glGetHistogramParameteriv GLFuncPtrName(glGetHistogramParameteriv)
#define glGetMinmax GLFuncPtrName(glGetMinmax)
#define glGetMinmaxParameterfv GLFuncPtrName(glGetMinmaxParameterfv)
#define glGetMinmaxParameteriv GLFuncPtrName(glGetMinmaxParameteriv)
#define glHistogram GLFuncPtrName(glHistogram)
#define glMinmax GLFuncPtrName(glMinmax)
#define glResetHistogram GLFuncPtrName(glResetHistogram)
#define glResetMinmax GLFuncPtrName(glResetMinmax)
#define glTexImage3D GLFuncPtrName(glTexImage3D)
#define glTexSubImage3D GLFuncPtrName(glTexSubImage3D)
#define glCopyTexSubImage3D GLFuncPtrName(glCopyTexSubImage3D)

#endif // GL_VERSION_1_2

//							    --- opengl 1.3 core functions ---

#ifndef GL_VERSION_1_3
#define GL_VERSION_1_3 1
#define __GENERATE_GL_13__

#define GL_TEXTURE0                       0x84C0
#define GL_TEXTURE1                       0x84C1
#define GL_TEXTURE2                       0x84C2
#define GL_TEXTURE3                       0x84C3
#define GL_TEXTURE4                       0x84C4
#define GL_TEXTURE5                       0x84C5
#define GL_TEXTURE6                       0x84C6
#define GL_TEXTURE7                       0x84C7
#define GL_TEXTURE8                       0x84C8
#define GL_TEXTURE9                       0x84C9
#define GL_TEXTURE10                      0x84CA
#define GL_TEXTURE11                      0x84CB
#define GL_TEXTURE12                      0x84CC
#define GL_TEXTURE13                      0x84CD
#define GL_TEXTURE14                      0x84CE
#define GL_TEXTURE15                      0x84CF
#define GL_TEXTURE16                      0x84D0
#define GL_TEXTURE17                      0x84D1
#define GL_TEXTURE18                      0x84D2
#define GL_TEXTURE19                      0x84D3
#define GL_TEXTURE20                      0x84D4
#define GL_TEXTURE21                      0x84D5
#define GL_TEXTURE22                      0x84D6
#define GL_TEXTURE23                      0x84D7
#define GL_TEXTURE24                      0x84D8
#define GL_TEXTURE25                      0x84D9
#define GL_TEXTURE26                      0x84DA
#define GL_TEXTURE27                      0x84DB
#define GL_TEXTURE28                      0x84DC
#define GL_TEXTURE29                      0x84DD
#define GL_TEXTURE30                      0x84DE
#define GL_TEXTURE31                      0x84DF
#define GL_ACTIVE_TEXTURE                 0x84E0
#define GL_CLIENT_ACTIVE_TEXTURE          0x84E1
#define GL_MAX_TEXTURE_UNITS              0x84E2
#define GL_TRANSPOSE_MODELVIEW_MATRIX     0x84E3
#define GL_TRANSPOSE_PROJECTION_MATRIX    0x84E4
#define GL_TRANSPOSE_TEXTURE_MATRIX       0x84E5
#define GL_TRANSPOSE_COLOR_MATRIX         0x84E6
#define GL_MULTISAMPLE                    0x809D
#define GL_SAMPLE_ALPHA_TO_COVERAGE       0x809E
#define GL_SAMPLE_ALPHA_TO_ONE            0x809F
#define GL_SAMPLE_COVERAGE                0x80A0
#define GL_SAMPLE_BUFFERS                 0x80A8
#define GL_SAMPLES                        0x80A9
#define GL_SAMPLE_COVERAGE_VALUE          0x80AA
#define GL_SAMPLE_COVERAGE_INVERT         0x80AB
#define GL_MULTISAMPLE_BIT                0x20000000
#define GL_NORMAL_MAP                     0x8511
#define GL_REFLECTION_MAP                 0x8512
#define GL_TEXTURE_CUBE_MAP               0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP       0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X    0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X    0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y    0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y    0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z    0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z    0x851A
#define GL_PROXY_TEXTURE_CUBE_MAP         0x851B
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE      0x851C
#define GL_COMPRESSED_ALPHA               0x84E9
#define GL_COMPRESSED_LUMINANCE           0x84EA
#define GL_COMPRESSED_LUMINANCE_ALPHA     0x84EB
#define GL_COMPRESSED_INTENSITY           0x84EC
#define GL_COMPRESSED_RGB                 0x84ED
#define GL_COMPRESSED_RGBA                0x84EE
#define GL_TEXTURE_COMPRESSION_HINT       0x84EF
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE  0x86A0
#define GL_TEXTURE_COMPRESSED             0x86A1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS 0x86A2
#define GL_COMPRESSED_TEXTURE_FORMATS     0x86A3
#define GL_CLAMP_TO_BORDER                0x812D
#define GL_COMBINE                        0x8570
#define GL_COMBINE_RGB                    0x8571
#define GL_COMBINE_ALPHA                  0x8572
#define GL_SOURCE0_RGB                    0x8580
#define GL_SOURCE1_RGB                    0x8581
#define GL_SOURCE2_RGB                    0x8582
#define GL_SOURCE0_ALPHA                  0x8588
#define GL_SOURCE1_ALPHA                  0x8589
#define GL_SOURCE2_ALPHA                  0x858A
#define GL_OPERAND0_RGB                   0x8590
#define GL_OPERAND1_RGB                   0x8591
#define GL_OPERAND2_RGB                   0x8592
#define GL_OPERAND0_ALPHA                 0x8598
#define GL_OPERAND1_ALPHA                 0x8599
#define GL_OPERAND2_ALPHA                 0x859A
#define GL_RGB_SCALE                      0x8573
#define GL_ADD_SIGNED                     0x8574
#define GL_INTERPOLATE                    0x8575
#define GL_SUBTRACT                       0x84E7
#define GL_CONSTANT                       0x8576
#define GL_PRIMARY_COLOR                  0x8577
#define GL_PREVIOUS                       0x8578
#define GL_DOT3_RGB                       0x86AE
#define GL_DOT3_RGBA                      0x86AF

extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixf))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixd))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixf))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixd))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glSampleCoverage))(GLclampf, GLboolean);
extern void (GLApi *GLFuncPtrName(glCompressedTexImage3D))(GLenum, GLint, GLenum, GLsizei, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCompressedTexImage2D))(GLenum, GLint, GLenum, GLsizei, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCompressedTexImage1D))(GLenum, GLint, GLenum, GLsizei, GLint, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage3D))(GLenum, GLint, GLint, GLint, GLint, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage2D))(GLenum, GLint, GLint, GLint, GLsizei, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage1D))(GLenum, GLint, GLint, GLsizei, GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetCompressedTexImage))(GLenum, GLint, GLvoid*);

#define glLoadTransposeMatrixf GLFuncPtrName(glLoadTransposeMatrixf)
#define glLoadTransposeMatrixd GLFuncPtrName(glLoadTransposeMatrixd)
#define glMultTransposeMatrixf GLFuncPtrName(glMultTransposeMatrixf)
#define glMultTransposeMatrixd GLFuncPtrName(glMultTransposeMatrixd)
#define glSampleCoverage GLFuncPtrName(glSampleCoverage)
#define glCompressedTexImage3D GLFuncPtrName(glCompressedTexImage3D)
#define glCompressedTexImage2D GLFuncPtrName(glCompressedTexImage2D)
#define glCompressedTexImage1D GLFuncPtrName(glCompressedTexImage1D)
#define glCompressedTexSubImage3D GLFuncPtrName(glCompressedTexSubImage3D)
#define glCompressedTexSubImage2D GLFuncPtrName(glCompressedTexSubImage2D)
#define glCompressedTexSubImage1D GLFuncPtrName(glCompressedTexSubImage1D)
#define glGetCompressedTexImage GLFuncPtrName(glGetCompressedTexImage)

//								  --- 1.3 multitexture functions ---

extern void (GLApi *GLFuncPtrName(glActiveTexture))(GLenum);
extern void (GLApi *GLFuncPtrName(glClientActiveTexture))(GLenum);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1d))(GLenum, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1f))(GLenum, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1i))(GLenum, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1s))(GLenum, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2d))(GLenum, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2f))(GLenum, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2i))(GLenum, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2s))(GLenum, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3d))(GLenum, GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3f))(GLenum, GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3i))(GLenum, GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3s))(GLenum, GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3sv))(GLenum, const GLshort*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4d))(GLenum, GLdouble, GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4dv))(GLenum, const GLdouble*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4f))(GLenum, GLfloat, GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4fv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4i))(GLenum, GLint, GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4iv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4s))(GLenum, GLshort, GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4sv))(GLenum, const GLshort*);

#define glActiveTexture GLFuncPtrName(glActiveTexture)
#define glClientActiveTexture GLFuncPtrName(glClientActiveTexture)
#define glMultiTexCoord1d GLFuncPtrName(glMultiTexCoord1d)
#define glMultiTexCoord1dv GLFuncPtrName(glMultiTexCoord1dv)
#define glMultiTexCoord1f GLFuncPtrName(glMultiTexCoord1f)
#define glMultiTexCoord1fv GLFuncPtrName(glMultiTexCoord1fv)
#define glMultiTexCoord1i GLFuncPtrName(glMultiTexCoord1i)
#define glMultiTexCoord1iv GLFuncPtrName(glMultiTexCoord1iv)
#define glMultiTexCoord1s GLFuncPtrName(glMultiTexCoord1s)
#define glMultiTexCoord1sv GLFuncPtrName(glMultiTexCoord1sv)
#define glMultiTexCoord2d GLFuncPtrName(glMultiTexCoord2d)
#define glMultiTexCoord2dv GLFuncPtrName(glMultiTexCoord2dv)
#define glMultiTexCoord2f GLFuncPtrName(glMultiTexCoord2f)
#define glMultiTexCoord2fv GLFuncPtrName(glMultiTexCoord2fv)
#define glMultiTexCoord2i GLFuncPtrName(glMultiTexCoord2i)
#define glMultiTexCoord2iv GLFuncPtrName(glMultiTexCoord2iv)
#define glMultiTexCoord2s GLFuncPtrName(glMultiTexCoord2s)
#define glMultiTexCoord2sv GLFuncPtrName(glMultiTexCoord2sv)
#define glMultiTexCoord3d GLFuncPtrName(glMultiTexCoord3d)
#define glMultiTexCoord3dv GLFuncPtrName(glMultiTexCoord3dv)
#define glMultiTexCoord3f GLFuncPtrName(glMultiTexCoord3f)
#define glMultiTexCoord3fv GLFuncPtrName(glMultiTexCoord3fv)
#define glMultiTexCoord3i GLFuncPtrName(glMultiTexCoord3i)
#define glMultiTexCoord3iv GLFuncPtrName(glMultiTexCoord3iv)
#define glMultiTexCoord3s GLFuncPtrName(glMultiTexCoord3s)
#define glMultiTexCoord3sv GLFuncPtrName(glMultiTexCoord3sv)
#define glMultiTexCoord4d GLFuncPtrName(glMultiTexCoord4d)
#define glMultiTexCoord4dv GLFuncPtrName(glMultiTexCoord4dv)
#define glMultiTexCoord4f GLFuncPtrName(glMultiTexCoord4f)
#define glMultiTexCoord4fv GLFuncPtrName(glMultiTexCoord4fv)
#define glMultiTexCoord4i GLFuncPtrName(glMultiTexCoord4i)
#define glMultiTexCoord4iv GLFuncPtrName(glMultiTexCoord4iv)
#define glMultiTexCoord4s GLFuncPtrName(glMultiTexCoord4s)
#define glMultiTexCoord4sv GLFuncPtrName(glMultiTexCoord4sv)

#endif // GL_VERSION_1_3

//							    --- opengl 1.4 core functions ---

#ifndef GL_VERSION_1_4
#define GL_VERSION_1_4 1
#define __GENERATE_GL_14__

#define GL_BLEND_DST_RGB                  0x80C8
#define GL_BLEND_SRC_RGB                  0x80C9
#define GL_BLEND_DST_ALPHA                0x80CA
#define GL_BLEND_SRC_ALPHA                0x80CB
#define GL_POINT_SIZE_MIN                 0x8126
#define GL_POINT_SIZE_MAX                 0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE      0x8128
#define GL_POINT_DISTANCE_ATTENUATION     0x8129
#define GL_GENERATE_MIPMAP                0x8191
#define GL_GENERATE_MIPMAP_HINT           0x8192
#define GL_DEPTH_COMPONENT16              0x81A5
#define GL_DEPTH_COMPONENT24              0x81A6
#define GL_DEPTH_COMPONENT32              0x81A7
#define GL_MIRRORED_REPEAT                0x8370
#define GL_FOG_COORDINATE_SOURCE          0x8450
#define GL_FOG_COORDINATE                 0x8451
#define GL_FRAGMENT_DEPTH                 0x8452
#define GL_CURRENT_FOG_COORDINATE         0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE      0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE    0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER   0x8456
#define GL_FOG_COORDINATE_ARRAY           0x8457
#define GL_COLOR_SUM                      0x8458
#define GL_CURRENT_SECONDARY_COLOR        0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE     0x845A
#define GL_SECONDARY_COLOR_ARRAY_TYPE     0x845B
#define GL_SECONDARY_COLOR_ARRAY_STRIDE   0x845C
#define GL_SECONDARY_COLOR_ARRAY_POINTER  0x845D
#define GL_SECONDARY_COLOR_ARRAY          0x845E
#define GL_MAX_TEXTURE_LOD_BIAS           0x84FD
#define GL_TEXTURE_FILTER_CONTROL         0x8500
#define GL_TEXTURE_LOD_BIAS               0x8501
#define GL_INCR_WRAP                      0x8507
#define GL_DECR_WRAP                      0x8508
#define GL_TEXTURE_DEPTH_SIZE             0x884A
#define GL_DEPTH_TEXTURE_MODE             0x884B
#define GL_TEXTURE_COMPARE_MODE           0x884C
#define GL_TEXTURE_COMPARE_FUNC           0x884D
#define GL_COMPARE_R_TO_TEXTURE           0x884E

extern void (GLApi *GLFuncPtrName(glBlendFuncSeparate))(GLenum, GLenum, GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glFogCoordf))(GLfloat);
extern void (GLApi *GLFuncPtrName(glFogCoordfv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glFogCoordd))(GLdouble);
extern void (GLApi *GLFuncPtrName(glFogCoorddv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glFogCoordPointer))(GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glMultiDrawArrays))(GLenum, GLint *, GLsizei *, GLsizei);
extern void (GLApi *GLFuncPtrName(glMultiDrawElements))(GLenum, const GLsizei *, GLenum, const GLvoid* *, GLsizei);
extern void (GLApi *GLFuncPtrName(glPointParameterf))(GLenum, GLfloat);
extern void (GLApi *GLFuncPtrName(glPointParameterfv))(GLenum, const GLfloat*);
extern void (GLApi *GLFuncPtrName(glPointParameteri))(GLenum, GLint);
extern void (GLApi *GLFuncPtrName(glPointParameteriv))(GLenum, const GLint*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3b))(GLbyte, GLbyte, GLbyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3bv))(const GLbyte*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3d))(GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3f))(GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3i))(GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3s))(GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3sv))(const GLshort*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ub))(GLubyte, GLubyte, GLubyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ubv))(const GLubyte*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ui))(GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3uiv))(const GLuint*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3us))(GLushort, GLushort, GLushort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3usv))(const GLushort*);
extern void (GLApi *GLFuncPtrName(glSecondaryColorPointer))(GLint, GLenum, GLsizei, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glWindowPos2d))(GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glWindowPos2dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glWindowPos2f))(GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glWindowPos2fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glWindowPos2i))(GLint, GLint);
extern void (GLApi *GLFuncPtrName(glWindowPos2iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glWindowPos2s))(GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glWindowPos2sv))(const GLshort*);
extern void (GLApi *GLFuncPtrName(glWindowPos3d))(GLdouble, GLdouble, GLdouble);
extern void (GLApi *GLFuncPtrName(glWindowPos3dv))(const GLdouble*);
extern void (GLApi *GLFuncPtrName(glWindowPos3f))(GLfloat, GLfloat, GLfloat);
extern void (GLApi *GLFuncPtrName(glWindowPos3fv))(const GLfloat*);
extern void (GLApi *GLFuncPtrName(glWindowPos3i))(GLint, GLint, GLint);
extern void (GLApi *GLFuncPtrName(glWindowPos3iv))(const GLint*);
extern void (GLApi *GLFuncPtrName(glWindowPos3s))(GLshort, GLshort, GLshort);
extern void (GLApi *GLFuncPtrName(glWindowPos3sv))(const GLshort*);

#define glBlendFuncSeparate GLFuncPtrName(glBlendFuncSeparate)
#define glFogCoordf GLFuncPtrName(glFogCoordf)
#define glFogCoordfv GLFuncPtrName(glFogCoordfv)
#define glFogCoordd GLFuncPtrName(glFogCoordd)
#define glFogCoorddv GLFuncPtrName(glFogCoorddv)
#define glFogCoordPointer GLFuncPtrName(glFogCoordPointer)
#define glMultiDrawArrays GLFuncPtrName(glMultiDrawArrays)
#define glMultiDrawElements GLFuncPtrName(glMultiDrawElements)
#define glPointParameterf GLFuncPtrName(glPointParameterf)
#define glPointParameterfv GLFuncPtrName(glPointParameterfv)
#define glPointParameteri GLFuncPtrName(glPointParameteri)
#define glPointParameteriv GLFuncPtrName(glPointParameteriv)
#define glSecondaryColor3b GLFuncPtrName(glSecondaryColor3b)
#define glSecondaryColor3bv GLFuncPtrName(glSecondaryColor3bv)
#define glSecondaryColor3d GLFuncPtrName(glSecondaryColor3d)
#define glSecondaryColor3dv GLFuncPtrName(glSecondaryColor3dv)
#define glSecondaryColor3f GLFuncPtrName(glSecondaryColor3f)
#define glSecondaryColor3fv GLFuncPtrName(glSecondaryColor3fv)
#define glSecondaryColor3i GLFuncPtrName(glSecondaryColor3i)
#define glSecondaryColor3iv GLFuncPtrName(glSecondaryColor3iv)
#define glSecondaryColor3s GLFuncPtrName(glSecondaryColor3s)
#define glSecondaryColor3sv GLFuncPtrName(glSecondaryColor3sv)
#define glSecondaryColor3ub GLFuncPtrName(glSecondaryColor3ub)
#define glSecondaryColor3ubv GLFuncPtrName(glSecondaryColor3ubv)
#define glSecondaryColor3ui GLFuncPtrName(glSecondaryColor3ui)
#define glSecondaryColor3uiv GLFuncPtrName(glSecondaryColor3uiv)
#define glSecondaryColor3us GLFuncPtrName(glSecondaryColor3us)
#define glSecondaryColor3usv GLFuncPtrName(glSecondaryColor3usv)
#define glSecondaryColorPointer GLFuncPtrName(glSecondaryColorPointer)
#define glWindowPos2d GLFuncPtrName(glWindowPos2d)
#define glWindowPos2dv GLFuncPtrName(glWindowPos2dv)
#define glWindowPos2f GLFuncPtrName(glWindowPos2f)
#define glWindowPos2fv GLFuncPtrName(glWindowPos2fv)
#define glWindowPos2i GLFuncPtrName(glWindowPos2i)
#define glWindowPos2iv GLFuncPtrName(glWindowPos2iv)
#define glWindowPos2s GLFuncPtrName(glWindowPos2s)
#define glWindowPos2sv GLFuncPtrName(glWindowPos2sv)
#define glWindowPos3d GLFuncPtrName(glWindowPos3d)
#define glWindowPos3dv GLFuncPtrName(glWindowPos3dv)
#define glWindowPos3f GLFuncPtrName(glWindowPos3f)
#define glWindowPos3fv GLFuncPtrName(glWindowPos3fv)
#define glWindowPos3i GLFuncPtrName(glWindowPos3i)
#define glWindowPos3iv GLFuncPtrName(glWindowPos3iv)
#define glWindowPos3s GLFuncPtrName(glWindowPos3s)
#define glWindowPos3sv GLFuncPtrName(glWindowPos3sv)

#endif // GL_VERSION_1_4

//							    --- opengl 1.5 core functions ---

#ifndef GL_VERSION_1_5
#define GL_VERSION_1_5 1
#define __GENERATE_GL_15__

#define GL_BUFFER_SIZE                    0x8764
#define GL_BUFFER_USAGE                   0x8765
#define GL_QUERY_COUNTER_BITS             0x8864
#define GL_CURRENT_QUERY                  0x8865
#define GL_QUERY_RESULT                   0x8866
#define GL_QUERY_RESULT_AVAILABLE         0x8867
#define GL_ARRAY_BUFFER                   0x8892
#define GL_ELEMENT_ARRAY_BUFFER           0x8893
#define GL_ARRAY_BUFFER_BINDING           0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING   0x8895
#define GL_VERTEX_ARRAY_BUFFER_BINDING    0x8896
#define GL_NORMAL_ARRAY_BUFFER_BINDING    0x8897
#define GL_COLOR_ARRAY_BUFFER_BINDING     0x8898
#define GL_INDEX_ARRAY_BUFFER_BINDING     0x8899
#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING 0x889A
#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING 0x889B
#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING 0x889C
#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING 0x889D
#define GL_WEIGHT_ARRAY_BUFFER_BINDING    0x889E
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING 0x889F
#define GL_READ_ONLY                      0x88B8
#define GL_WRITE_ONLY                     0x88B9
#define GL_READ_WRITE                     0x88BA
#define GL_BUFFER_ACCESS                  0x88BB
#define GL_BUFFER_MAPPED                  0x88BC
#define GL_BUFFER_MAP_POINTER             0x88BD
#define GL_STREAM_DRAW                    0x88E0
#define GL_STREAM_READ                    0x88E1
#define GL_STREAM_COPY                    0x88E2
#define GL_STATIC_DRAW                    0x88E4
#define GL_STATIC_READ                    0x88E5
#define GL_STATIC_COPY                    0x88E6
#define GL_DYNAMIC_DRAW                   0x88E8
#define GL_DYNAMIC_READ                   0x88E9
#define GL_DYNAMIC_COPY                   0x88EA
#define GL_SAMPLES_PASSED                 0x8914
#define GL_FOG_COORD_SRC                  GL_FOG_COORDINATE_SOURCE
#define GL_FOG_COORD                      GL_FOG_COORDINATE
#define GL_CURRENT_FOG_COORD              GL_CURRENT_FOG_COORDINATE
#define GL_FOG_COORD_ARRAY_TYPE           GL_FOG_COORDINATE_ARRAY_TYPE
#define GL_FOG_COORD_ARRAY_STRIDE         GL_FOG_COORDINATE_ARRAY_STRIDE
#define GL_FOG_COORD_ARRAY_POINTER        GL_FOG_COORDINATE_ARRAY_POINTER
#define GL_FOG_COORD_ARRAY                GL_FOG_COORDINATE_ARRAY
#define GL_FOG_COORD_ARRAY_BUFFER_BINDING GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING
#define GL_SRC0_RGB                       GL_SOURCE0_RGB
#define GL_SRC1_RGB                       GL_SOURCE1_RGB
#define GL_SRC2_RGB                       GL_SOURCE2_RGB
#define GL_SRC0_ALPHA                     GL_SOURCE0_ALPHA
#define GL_SRC1_ALPHA                     GL_SOURCE1_ALPHA
#define GL_SRC2_ALPHA                     GL_SOURCE2_ALPHA

extern void (GLApi *GLFuncPtrName(glGenQueries))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glDeleteQueries))(GLsizei, const GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsQuery))(GLuint);
extern void (GLApi *GLFuncPtrName(glBeginQuery))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glEndQuery))(GLenum);
extern void (GLApi *GLFuncPtrName(glGetQueryiv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetQueryObjectiv))(GLuint, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetQueryObjectuiv))(GLuint, GLenum, GLuint*);
extern void (GLApi *GLFuncPtrName(glBindBuffer))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteBuffers))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenBuffers))(GLsizei, GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsBuffer))(GLuint);
extern void (GLApi *GLFuncPtrName(glBufferData))(GLenum, GLsizeiptr, const GLvoid *, GLenum);
extern void (GLApi *GLFuncPtrName(glBufferSubData))(GLenum, GLintptr, GLsizeiptr, const GLvoid*);
extern void (GLApi *GLFuncPtrName(glGetBufferSubData))(GLenum, GLintptr, GLsizeiptr, GLvoid*);
extern GLvoid* (GLApi *GLFuncPtrName(glMapBuffer))(GLenum, GLenum);
extern GLboolean (GLApi *GLFuncPtrName(glUnmapBuffer))(GLenum);
extern void (GLApi *GLFuncPtrName(glGetBufferParameteriv))(GLenum, GLenum, GLint*);
extern void (GLApi *GLFuncPtrName(glGetBufferPointerv))(GLenum, GLenum, GLvoid**);

#define glGenQueries GLFuncPtrName(glGenQueries)
#define glDeleteQueries GLFuncPtrName(glDeleteQueries)
#define glIsQuery GLFuncPtrName(glIsQuery)
#define glBeginQuery GLFuncPtrName(glBeginQuery)
#define glEndQuery GLFuncPtrName(glEndQuery)
#define glGetQueryiv GLFuncPtrName(glGetQueryiv)
#define glGetQueryObjectiv GLFuncPtrName(glGetQueryObjectiv)
#define glGetQueryObjectuiv GLFuncPtrName(glGetQueryObjectuiv)
#define glBindBuffer GLFuncPtrName(glBindBuffer)
#define glDeleteBuffers GLFuncPtrName(glDeleteBuffers)
#define glGenBuffers GLFuncPtrName(glGenBuffers)
#define glIsBuffer GLFuncPtrName(glIsBuffer)
#define glBufferData GLFuncPtrName(glBufferData)
#define glBufferSubData GLFuncPtrName(glBufferSubData)
#define glGetBufferSubData GLFuncPtrName(glGetBufferSubData)
#define glMapBuffer GLFuncPtrName(glMapBuffer)
#define glUnmapBuffer GLFuncPtrName(glUnmapBuffer)
#define glGetBufferParameteriv GLFuncPtrName(glGetBufferParameteriv)
#define glGetBufferPointerv GLFuncPtrName(glGetBufferPointerv)

#endif // GL_VERSION_1_5

//							  --- opengl 2.0 functions and tokens ---

#ifndef GL_VERSION_2_0
#define GL_VERSION_2_0 1
#define __GENERATE_GL_20__

// shader tokens
#define GL_CURRENT_PROGRAM						0x8B8D
#define GL_SHADER_TYPE							0x8B4E
#define GL_DELETE_STATUS						0x8B80
#define GL_COMPILE_STATUS						0x8B81
#define GL_LINK_STATUS							0x8B82
#define GL_VALIDATE_STATUS						0x8B83
#define GL_INFO_LOG_LENGTH						0x8B84
#define GL_ATTACHED_SHADERS						0x8B85
#define GL_ACTIVE_UNIFORMS						0x8B86
#define GL_ACTIVE_UNIFORM_MAX_LENGTH			0x8B87
#define GL_SHADER_SOURCE_LENGTH					0x8B88
#define GL_VERTEX_SHADER						0x8B31
#define GL_ACTIVE_ATTRIBUTES					0x8B89
#define GL_ACTIVE_ATTRIBUTE_MAX_LENGTH			0x8B8A
#define GL_FRAGMENT_SHADER						0x8B30

// uniform types
#define GL_FLOAT_VEC2							0x8B50
#define GL_FLOAT_VEC3							0x8B51
#define GL_FLOAT_VEC4							0x8B52
#define GL_INT_VEC2								0x8B53
#define GL_INT_VEC3								0x8B54
#define GL_INT_VEC4								0x8B55
#define GL_BOOL									0x8B56
#define GL_BOOL_VEC2							0x8B57
#define GL_BOOL_VEC3							0x8B58
#define GL_BOOL_VEC4							0x8B59
#define GL_FLOAT_MAT2							0x8B5A
#define GL_FLOAT_MAT3							0x8B5B
#define GL_FLOAT_MAT4							0x8B5C
#define GL_SAMPLER_1D							0x8B5D
#define GL_SAMPLER_2D							0x8B5E
#define GL_SAMPLER_3D							0x8B5F
#define GL_SAMPLER_CUBE							0x8B60
#define GL_SAMPLER_1D_SHADOW					0x8B61
#define GL_SAMPLER_2D_SHADOW					0x8B62

// vertex attrib arrays
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED			0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE				0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE			0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE				0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED		0x886A
#define GL_CURRENT_VERTEX_ATTRIB				0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER			0x8645
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING	0x889F

// hints
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT		0x8B8B

// raster control
#define GL_VERTEX_PROGRAM_POINT_SIZE			0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE				0x8643

// implementation dependent strings and limits
#define GL_SHADING_LANGUAGE_VERSION				0x8B8C
#define GL_MAX_VERTEX_ATTRIBS					0x8869
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS		0x8B49
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS		0x8B4A
#define GL_MAX_VARYING_FLOATS					0x8B4B
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS		0x8B4C
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS		0x8B4D
#define GL_MAX_TEXTURE_COORDS					0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS				0x8872

// multiple render targets
#define GL_MAX_DRAW_BUFFERS						0x8824
#define GL_DRAW_BUFFER0							0x8825
#define GL_DRAW_BUFFER1							0x8826
#define GL_DRAW_BUFFER2							0x8827
#define GL_DRAW_BUFFER3							0x8828
#define GL_DRAW_BUFFER4							0x8829
#define GL_DRAW_BUFFER5							0x882A
#define GL_DRAW_BUFFER6							0x882B
#define GL_DRAW_BUFFER7							0x882C
#define GL_DRAW_BUFFER8							0x882D
#define GL_DRAW_BUFFER9							0x882E
#define GL_DRAW_BUFFER10						0x882F
#define GL_DRAW_BUFFER11						0x8830
#define GL_DRAW_BUFFER12						0x8831
#define GL_DRAW_BUFFER13						0x8832
#define GL_DRAW_BUFFER14						0x8833
#define GL_DRAW_BUFFER15						0x8834

// point sprite
#define GL_POINT_SPRITE 						0x8861
#define GL_COORD_REPLACE 						0x8862
#define GL_POINT_SPRITE_COORD_ORIGIN 			0x8CA0
#define GL_LOWER_LEFT 							0x8CA1
#define GL_UPPER_LEFT 							0x8CA2

// two-sided stencil
#define GL_STENCIL_BACK_FUNC					0x8800
#define GL_STENCIL_BACK_VALUE_MASK 				0x8CA4
#define GL_STENCIL_BACK_REF 					0x8CA3
#define GL_STENCIL_BACK_FAIL 					0x8801
#define GL_STENCIL_BACK_PASS_DEPTH_FAIL 		0x8802
#define GL_STENCIL_BACK_PASS_DEPTH_PASS 		0x8803
#define GL_STENCIL_BACK_WRITEMASK 				0x8CA5

// separate alpha blending
#define GL_BLEND_EQUATION_RGB					0x8009
#define GL_BLEND_EQUATION_ALPHA					0x883D

// shader objects api
extern void (GLApi *GLFuncPtrName(glDeleteShader))(GLuint shader);
extern void (GLApi *GLFuncPtrName(glDetachShader))(GLuint program, GLuint shader);
extern GLuint (GLApi *GLFuncPtrName(glCreateShader))(GLenum type);
extern void (GLApi *GLFuncPtrName(glShaderSource))(GLuint shader, GLsizei count, const GLchar **string, const GLint *length);
extern void (GLApi *GLFuncPtrName(glCompileShader))(GLuint shader);

// program objects
extern GLuint (GLApi *GLFuncPtrName(glCreateProgram))(void);
extern void (GLApi *GLFuncPtrName(glAttachShader))(GLuint program, GLuint shader);
extern void (GLApi *GLFuncPtrName(glLinkProgram))(GLuint program);
extern void (GLApi *GLFuncPtrName(glUseProgram))(GLuint program);
extern void (GLApi *GLFuncPtrName(glDeleteProgram))(GLuint program);
extern void (GLApi *GLFuncPtrName(glValidateProgram))(GLuint program);

// uniforms
extern void (GLApi *GLFuncPtrName(glUniform1f))(GLint location, GLfloat v0);
extern void (GLApi *GLFuncPtrName(glUniform2f))(GLint location, GLfloat v0, GLfloat v1);
extern void (GLApi *GLFuncPtrName(glUniform3f))(GLint location, GLfloat v0, GLfloat v1, GLfloat v2);
extern void (GLApi *GLFuncPtrName(glUniform4f))(GLint location, GLfloat v0, GLfloat v1, GLfloat v2, GLfloat v3);
extern void (GLApi *GLFuncPtrName(glUniform1i))(GLint location, GLint v0);
extern void (GLApi *GLFuncPtrName(glUniform2i))(GLint location, GLint v0, GLint v1);
extern void (GLApi *GLFuncPtrName(glUniform3i))(GLint location, GLint v0, GLint v1, GLint v2);
extern void (GLApi *GLFuncPtrName(glUniform4i))(GLint location, GLint v0, GLint v1, GLint v2, GLint v3);
extern void (GLApi *GLFuncPtrName(glUniform1fv))(GLint location, GLsizei count, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniform2fv))(GLint location, GLsizei count, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniform3fv))(GLint location, GLsizei count, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniform4fv))(GLint location, GLsizei count, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniform1iv))(GLint location, GLsizei count, const GLint *value);
extern void (GLApi *GLFuncPtrName(glUniform2iv))(GLint location, GLsizei count, const GLint *value);
extern void (GLApi *GLFuncPtrName(glUniform3iv))(GLint location, GLsizei count, const GLint *value);
extern void (GLApi *GLFuncPtrName(glUniform4iv))(GLint location, GLsizei count, const GLint *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix2fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix3fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix4fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

// attrib locations
extern void (GLApi *GLFuncPtrName(glBindAttribLocation))(GLuint program, GLuint index, const GLchar *name);
extern GLint (GLApi *GLFuncPtrName(glGetAttribLocation))(GLuint program, const GLchar *name);

// vertex attributes
extern void (GLApi *GLFuncPtrName(glVertexAttrib1d))(GLuint index, GLdouble x);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dv))(GLuint index, const GLdouble *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1f))(GLuint index, GLfloat x);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fv))(GLuint index, const GLfloat *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1s))(GLuint index, GLshort x);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1sv))(GLuint index, const GLshort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2d))(GLuint index, GLdouble x, GLdouble y);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dv))(GLuint index, const GLdouble *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2f))(GLuint index, GLfloat x, GLfloat y);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fv))(GLuint index, const GLfloat *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2s))(GLuint index, GLshort x, GLshort y);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2sv))(GLuint index, const GLshort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3d))(GLuint index, GLdouble x, GLdouble y, GLdouble z);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dv))(GLuint index, const GLdouble *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3f))(GLuint index, GLfloat x, GLfloat y, GLfloat z);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fv))(GLuint index, const GLfloat *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3s))(GLuint index, GLshort x, GLshort y, GLshort z);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3sv))(GLuint index, const GLshort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nbv))(GLuint index, const GLbyte *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Niv))(GLuint index, const GLint *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nsv))(GLuint index, const GLshort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nub))(GLuint index, GLubyte x, GLubyte y, GLubyte z, GLubyte w);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nubv))(GLuint index, const GLubyte *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nuiv))(GLuint index, const GLuint *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4Nusv))(GLuint index, const GLushort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4bv))(GLuint index, const GLbyte *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4d))(GLuint index, GLdouble x, GLdouble y, GLdouble z, GLdouble w);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dv))(GLuint index, const GLdouble *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4f))(GLuint index, GLfloat x, GLfloat y, GLfloat z, GLfloat w);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fv))(GLuint index, const GLfloat *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4iv))(GLuint index, const GLint *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4s))(GLuint index, GLshort x, GLshort y, GLshort z, GLshort w);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4sv))(GLuint index, const GLshort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubv))(GLuint index, const GLubyte *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4uiv))(GLuint index, const GLuint *v);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4usv))(GLuint index, const GLushort *v);
extern void (GLApi *GLFuncPtrName(glVertexAttribPointer))(GLuint index, GLint size, GLenum type, GLboolean normalized, GLsizei stride, const GLvoid *pointer);
extern void (GLApi *GLFuncPtrName(glEnableVertexAttribArray))(GLuint index);
extern void (GLApi *GLFuncPtrName(glDisableVertexAttribArray))(GLuint index);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribdv))(GLuint index, GLenum pname, GLdouble *params);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribfv))(GLuint index, GLenum pname, GLfloat *params);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribiv))(GLuint index, GLenum pname, GLint *params);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribPointerv))(GLuint index, GLenum pname, GLvoid* *pointer);

// queries
extern GLboolean (GLApi *GLFuncPtrName(glIsShader))(GLuint shader);
extern GLboolean (GLApi *GLFuncPtrName(glIsProgram))(GLuint program);
extern void (GLApi *GLFuncPtrName(glGetShaderiv))(GLuint program, GLenum pname, GLint *params);
extern void (GLApi *GLFuncPtrName(glGetProgramiv))(GLuint program, GLenum pname, GLint *params);
extern void (GLApi *GLFuncPtrName(glGetAttachedShaders))(GLuint program, GLsizei maxCount, GLsizei *count, GLuint *shaders);
extern void (GLApi *GLFuncPtrName(glGetShaderInfoLog))(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
extern void (GLApi *GLFuncPtrName(glGetProgramInfoLog))(GLuint program, GLsizei bufSize, GLsizei *length, GLchar *infoLog);
extern GLint (GLApi *GLFuncPtrName(glGetUniformLocation))(GLuint program, const GLchar *name);
extern void (GLApi *GLFuncPtrName(glGetActiveUniform))(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);
extern void (GLApi *GLFuncPtrName(glGetUniformfv))(GLuint program, GLint location, GLfloat *params);
extern void (GLApi *GLFuncPtrName(glGetUniformiv))(GLuint program, GLint location, GLint *params);
extern void (GLApi *GLFuncPtrName(glGetShaderSource))(GLuint shader, GLsizei bufSize, GLsizei *length, GLchar *source);
extern void (GLApi *GLFuncPtrName(glGetActiveAttrib))(GLuint program, GLuint index, GLsizei bufSize, GLsizei *length, GLsizei *size, GLenum *type, GLchar *name);

// multiple draw buffers
extern void (GLApi *GLFuncPtrName(glDrawBuffers))(GLsizei n, const GLenum *bufs);

// two-sided stencil
extern void (GLApi *GLFuncPtrName(glStencilFuncSeparate))(GLenum face, GLenum func, GLint ref, GLuint mask);
extern void (GLApi *GLFuncPtrName(glStencilOpSeparate))(GLenum face, GLenum fail, GLenum zfail, GLenum zpass);
extern void (GLApi *GLFuncPtrName(glStencilMaskSeparate))(GLenum face, GLuint mask);

// separate alpha blending
extern void (GLApi *GLFuncPtrName(glBlendEquationSeparate))(GLenum modeRGB, GLenum modeAlpha);

// shader objects api
#define glDeleteShader GLFuncPtrName(glDeleteShader)
#define glDetachShader GLFuncPtrName(glDetachShader)
#define glCreateShader GLFuncPtrName(glCreateShader)
#define glShaderSource GLFuncPtrName(glShaderSource)
#define glCompileShader GLFuncPtrName(glCompileShader)

// program objects
#define glCreateProgram GLFuncPtrName(glCreateProgram)
#define glAttachShader GLFuncPtrName(glAttachShader)
#define glLinkProgram GLFuncPtrName(glLinkProgram)
#define glUseProgram GLFuncPtrName(glUseProgram)
#define glDeleteProgram GLFuncPtrName(glDeleteProgram)
#define glValidateProgram GLFuncPtrName(glValidateProgram)

// uniforms
#define glUniform1f GLFuncPtrName(glUniform1f)
#define glUniform2f GLFuncPtrName(glUniform2f)
#define glUniform3f GLFuncPtrName(glUniform3f)
#define glUniform4f GLFuncPtrName(glUniform4f)
#define glUniform1i GLFuncPtrName(glUniform1i)
#define glUniform2i GLFuncPtrName(glUniform2i)
#define glUniform3i GLFuncPtrName(glUniform3i)
#define glUniform4i GLFuncPtrName(glUniform4i)
#define glUniform1fv GLFuncPtrName(glUniform1fv)
#define glUniform2fv GLFuncPtrName(glUniform2fv)
#define glUniform3fv GLFuncPtrName(glUniform3fv)
#define glUniform4fv GLFuncPtrName(glUniform4fv)
#define glUniform1iv GLFuncPtrName(glUniform1iv)
#define glUniform2iv GLFuncPtrName(glUniform2iv)
#define glUniform3iv GLFuncPtrName(glUniform3iv)
#define glUniform4iv GLFuncPtrName(glUniform4iv)
#define glUniformMatrix2fv GLFuncPtrName(glUniformMatrix2fv)
#define glUniformMatrix3fv GLFuncPtrName(glUniformMatrix3fv)
#define glUniformMatrix4fv GLFuncPtrName(glUniformMatrix4fv)

// attrib locations
#define glBindAttribLocation GLFuncPtrName(glBindAttribLocation)
#define glGetAttribLocation GLFuncPtrName(glGetAttribLocation)

// vertex attributes
#define glVertexAttrib1d GLFuncPtrName(glVertexAttrib1d)
#define glVertexAttrib1dv GLFuncPtrName(glVertexAttrib1dv)
#define glVertexAttrib1f GLFuncPtrName(glVertexAttrib1f)
#define glVertexAttrib1fv GLFuncPtrName(glVertexAttrib1fv)
#define glVertexAttrib1s GLFuncPtrName(glVertexAttrib1s)
#define glVertexAttrib1sv GLFuncPtrName(glVertexAttrib1sv)
#define glVertexAttrib2d GLFuncPtrName(glVertexAttrib2d)
#define glVertexAttrib2dv GLFuncPtrName(glVertexAttrib2dv)
#define glVertexAttrib2f GLFuncPtrName(glVertexAttrib2f)
#define glVertexAttrib2fv GLFuncPtrName(glVertexAttrib2fv)
#define glVertexAttrib2s GLFuncPtrName(glVertexAttrib2s)
#define glVertexAttrib2sv GLFuncPtrName(glVertexAttrib2sv)
#define glVertexAttrib3d GLFuncPtrName(glVertexAttrib3d)
#define glVertexAttrib3dv GLFuncPtrName(glVertexAttrib3dv)
#define glVertexAttrib3f GLFuncPtrName(glVertexAttrib3f)
#define glVertexAttrib3fv GLFuncPtrName(glVertexAttrib3fv)
#define glVertexAttrib3s GLFuncPtrName(glVertexAttrib3s)
#define glVertexAttrib3sv GLFuncPtrName(glVertexAttrib3sv)
#define glVertexAttrib4Nbv GLFuncPtrName(glVertexAttrib4Nbv)
#define glVertexAttrib4Niv GLFuncPtrName(glVertexAttrib4Niv)
#define glVertexAttrib4Nsv GLFuncPtrName(glVertexAttrib4Nsv)
#define glVertexAttrib4Nub GLFuncPtrName(glVertexAttrib4Nub)
#define glVertexAttrib4Nubv GLFuncPtrName(glVertexAttrib4Nubv)
#define glVertexAttrib4Nuiv GLFuncPtrName(glVertexAttrib4Nuiv)
#define glVertexAttrib4Nusv GLFuncPtrName(glVertexAttrib4Nusv)
#define glVertexAttrib4bv GLFuncPtrName(glVertexAttrib4bv)
#define glVertexAttrib4d GLFuncPtrName(glVertexAttrib4d)
#define glVertexAttrib4dv GLFuncPtrName(glVertexAttrib4dv)
#define glVertexAttrib4f GLFuncPtrName(glVertexAttrib4f)
#define glVertexAttrib4fv GLFuncPtrName(glVertexAttrib4fv)
#define glVertexAttrib4iv GLFuncPtrName(glVertexAttrib4iv)
#define glVertexAttrib4s GLFuncPtrName(glVertexAttrib4s)
#define glVertexAttrib4sv GLFuncPtrName(glVertexAttrib4sv)
#define glVertexAttrib4ubv GLFuncPtrName(glVertexAttrib4ubv)
#define glVertexAttrib4uiv GLFuncPtrName(glVertexAttrib4uiv)
#define glVertexAttrib4usv GLFuncPtrName(glVertexAttrib4usv)
#define glVertexAttribPointer GLFuncPtrName(glVertexAttribPointer)
#define glEnableVertexAttribArray GLFuncPtrName(glEnableVertexAttribArray)
#define glDisableVertexAttribArray GLFuncPtrName(glDisableVertexAttribArray)
#define glGetVertexAttribdv GLFuncPtrName(glGetVertexAttribdv)
#define glGetVertexAttribfv GLFuncPtrName(glGetVertexAttribfv)
#define glGetVertexAttribiv GLFuncPtrName(glGetVertexAttribiv)
#define glGetVertexAttribPointerv GLFuncPtrName(glGetVertexAttribPointerv)

// queries
#define glIsShader GLFuncPtrName(glIsShader)
#define glIsProgram GLFuncPtrName(glIsProgram)
#define glGetShaderiv GLFuncPtrName(glGetShaderiv)
#define glGetProgramiv GLFuncPtrName(glGetProgramiv)
#define glGetAttachedShaders GLFuncPtrName(glGetAttachedShaders)
#define glGetShaderInfoLog GLFuncPtrName(glGetShaderInfoLog)
#define glGetProgramInfoLog GLFuncPtrName(glGetProgramInfoLog)
#define glGetUniformLocation GLFuncPtrName(glGetUniformLocation)
#define glGetActiveUniform GLFuncPtrName(glGetActiveUniform)
#define glGetUniformfv GLFuncPtrName(glGetUniformfv)
#define glGetUniformiv GLFuncPtrName(glGetUniformiv)
#define glGetShaderSource GLFuncPtrName(glGetShaderSource)
#define glGetActiveAttrib GLFuncPtrName(glGetActiveAttrib)

// multiple draw buffers
#define glDrawBuffers GLFuncPtrName(glDrawBuffers)

// two-sided stencil
#define glStencilFuncSeparate GLFuncPtrName(glStencilFuncSeparate)
#define glStencilOpSeparate GLFuncPtrName(glStencilOpSeparate)
#define glStencilMaskSeparate GLFuncPtrName(glStencilMaskSeparate)

// separate alpha blending
#define glBlendEquationSeparate GLFuncPtrName(glBlendEquationSeparate)

#endif // GL_VERSION_2_0

/*
 *								--- OpenGL 2.1 ---
 */

#ifndef GL_VERSION_2_1
#define GL_VERSION_2_1 1
#define __GENERATE_GL_21__

#define GL_CURRENT_RASTER_SECONDARY_COLOR 0x845F
#define GL_PIXEL_PACK_BUFFER              0x88EB
#define GL_PIXEL_UNPACK_BUFFER            0x88EC
#define GL_PIXEL_PACK_BUFFER_BINDING      0x88ED
#define GL_PIXEL_UNPACK_BUFFER_BINDING    0x88EF
#define GL_FLOAT_MAT2x3                   0x8B65
#define GL_FLOAT_MAT2x4                   0x8B66
#define GL_FLOAT_MAT3x2                   0x8B67
#define GL_FLOAT_MAT3x4                   0x8B68
#define GL_FLOAT_MAT4x2                   0x8B69
#define GL_FLOAT_MAT4x3                   0x8B6A
#define GL_SRGB                           0x8C40
#define GL_SRGB8                          0x8C41
#define GL_SRGB_ALPHA                     0x8C42
#define GL_SRGB8_ALPHA8                   0x8C43
#define GL_SLUMINANCE_ALPHA               0x8C44
#define GL_SLUMINANCE8_ALPHA8             0x8C45
#define GL_SLUMINANCE                     0x8C46
#define GL_SLUMINANCE8                    0x8C47
#define GL_COMPRESSED_SRGB                0x8C48
#define GL_COMPRESSED_SRGB_ALPHA          0x8C49
#define GL_COMPRESSED_SLUMINANCE          0x8C4A
#define GL_COMPRESSED_SLUMINANCE_ALPHA    0x8C4B

extern void (GLApi *GLFuncPtrName(glUniformMatrix2x3fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x2fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix2x4fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x2fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix3x4fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);
extern void (GLApi *GLFuncPtrName(glUniformMatrix4x3fv))(GLint location, GLsizei count, GLboolean transpose, const GLfloat *value);

#define glUniformMatrix2x3fv GLFuncPtrName(glUniformMatrix2x3fv)
#define glUniformMatrix3x2fv GLFuncPtrName(glUniformMatrix3x2fv)
#define glUniformMatrix2x4fv GLFuncPtrName(glUniformMatrix2x4fv)
#define glUniformMatrix4x2fv GLFuncPtrName(glUniformMatrix4x2fv)
#define glUniformMatrix3x4fv GLFuncPtrName(glUniformMatrix3x4fv)
#define glUniformMatrix4x3fv GLFuncPtrName(glUniformMatrix4x3fv)

#endif // GL_VERSION_2_1

//								--- GL_ARB_color_buffer_float ---

#ifndef GL_ARB_color_buffer_float
#define GL_ARB_color_buffer_float 1
#define __GENERATE_GL_ARB_color_buffer_float

extern bool GLEH_ARB_color_buffer_float; /**< set if GL_ARB_color_buffer_float is supported */

#define GL_RGBA_FLOAT_MODE_ARB                                       0x8820
#define GL_CLAMP_VERTEX_COLOR_ARB                                    0x891a
#define GL_CLAMP_FRAGMENT_COLOR_ARB                                  0x891b
#define GL_CLAMP_READ_COLOR_ARB                                      0x891c
#define GL_FIXED_ONLY_ARB                                            0x891d
#define GL_WGL_TYPE_RGBA_FLOAT_ARB                                   0x21a0
#define GL_GLX_RGBA_FLOAT_TYPE                                       0x20b9
#define GL_GLX_RGBA_FLOAT_BIT                                        0x00000004

extern void (GLApi *GLFuncPtrName(glClampColorARB))(GLenum, GLenum);

#define glClampColorARB GLFuncPtrName(glClampColorARB)

#endif // GL_ARB_color_buffer_float

//								--- GL_ARB_copy_buffer ---

#ifndef GL_ARB_copy_buffer
#define GL_ARB_copy_buffer 1
#define __GENERATE_GL_ARB_copy_buffer

extern bool GLEH_ARB_copy_buffer; /**< set if GL_ARB_copy_buffer is supported */

#define GL_COPY_READ_BUFFER                                          0x8f36
#define GL_COPY_WRITE_BUFFER                                         0x8f37

extern void (GLApi *GLFuncPtrName(glCopyBufferSubData))(GLenum, GLenum, GLintptr, GLintptr, GLsizeiptr);

#define glCopyBufferSubData GLFuncPtrName(glCopyBufferSubData)

#endif // GL_ARB_copy_buffer

//								--- GL_ARB_depth_buffer_float ---

#ifndef GL_ARB_depth_buffer_float
#define GL_ARB_depth_buffer_float 1

extern bool GLEH_ARB_depth_buffer_float; /**< set if GL_ARB_depth_buffer_float is supported */

#define GL_DEPTH_COMPONENT32F                                        0x8cac
#define GL_DEPTH32F_STENCIL8                                         0x8cad
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV                            0x8dad

// no new procedures or functions

#endif // GL_ARB_depth_buffer_float

//								--- GL_ARB_depth_clamp ---

#ifndef GL_ARB_depth_clamp
#define GL_ARB_depth_clamp 1

extern bool GLEH_ARB_depth_clamp; /**< set if GL_ARB_depth_clamp is supported */

#define GL_DEPTH_CLAMP                                               0x864f

// no new procedures or functions

#endif // GL_ARB_depth_clamp

//								--- GL_ARB_depth_texture ---

#ifndef GL_ARB_depth_texture
#define GL_ARB_depth_texture 1

extern bool GLEH_ARB_depth_texture; /**< set if GL_ARB_depth_texture is supported */

#define GL_DEPTH_COMPONENT16_ARB                                     0x81a5
#define GL_DEPTH_COMPONENT24_ARB                                     0x81a6
#define GL_DEPTH_COMPONENT32_ARB                                     0x81a7
#define GL_TEXTURE_DEPTH_SIZE_ARB                                    0x884a
#define GL_DEPTH_TEXTURE_MODE_ARB                                    0x884b

// no new procedures or functions

#endif // GL_ARB_depth_texture

//								--- GL_ARB_draw_buffers ---

#ifndef GL_ARB_draw_buffers
#define GL_ARB_draw_buffers 1
#define __GENERATE_GL_ARB_draw_buffers

extern bool GLEH_ARB_draw_buffers; /**< set if GL_ARB_draw_buffers is supported */

#define GL_MAX_DRAW_BUFFERS_ARB                                      0x8824
#define GL_DRAW_BUFFER0_ARB                                          0x8825
#define GL_DRAW_BUFFER1_ARB                                          0x8826
#define GL_DRAW_BUFFER2_ARB                                          0x8827
#define GL_DRAW_BUFFER3_ARB                                          0x8828
#define GL_DRAW_BUFFER4_ARB                                          0x8829
#define GL_DRAW_BUFFER5_ARB                                          0x882a
#define GL_DRAW_BUFFER6_ARB                                          0x882b
#define GL_DRAW_BUFFER7_ARB                                          0x882c
#define GL_DRAW_BUFFER8_ARB                                          0x882d
#define GL_DRAW_BUFFER9_ARB                                          0x882e
#define GL_DRAW_BUFFER10_ARB                                         0x882f
#define GL_DRAW_BUFFER11_ARB                                         0x8830
#define GL_DRAW_BUFFER12_ARB                                         0x8831
#define GL_DRAW_BUFFER13_ARB                                         0x8832
#define GL_DRAW_BUFFER14_ARB                                         0x8833
#define GL_DRAW_BUFFER15_ARB                                         0x8834

extern void (GLApi *GLFuncPtrName(glDrawBuffersARB))(GLsizei, const GLenum*);

#define glDrawBuffersARB GLFuncPtrName(glDrawBuffersARB)

#endif // GL_ARB_draw_buffers

//								--- GL_ARB_draw_elements_base_vertex ---

#ifndef GL_ARB_draw_elements_base_vertex
#define GL_ARB_draw_elements_base_vertex 1
#define __GENERATE_GL_ARB_draw_elements_base_vertex

extern bool GLEH_ARB_draw_elements_base_vertex; /**< set if GL_ARB_draw_elements_base_vertex is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glDrawElementsBaseVertex))(GLenum, GLsizei, GLenum, void*, int);
extern void (GLApi *GLFuncPtrName(glDrawRangeElementsBaseVertex))(GLenum, GLuint, GLuint, GLsizei, GLenum, void*, int);
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedBaseVertex))(GLenum, GLsizei, GLenum, const void*, GLsizei, int);
extern void (GLApi *GLFuncPtrName(glMultiDrawElementsBaseVertex))(GLenum, GLsizei*, GLenum, void**, GLsizei, int*);

#define glDrawElementsBaseVertex GLFuncPtrName(glDrawElementsBaseVertex)
#define glDrawRangeElementsBaseVertex GLFuncPtrName(glDrawRangeElementsBaseVertex)
#define glDrawElementsInstancedBaseVertex GLFuncPtrName(glDrawElementsInstancedBaseVertex)
#define glMultiDrawElementsBaseVertex GLFuncPtrName(glMultiDrawElementsBaseVertex)

#endif // GL_ARB_draw_elements_base_vertex

//								--- GL_ARB_draw_instanced ---

#ifndef GL_ARB_draw_instanced
#define GL_ARB_draw_instanced 1
#define __GENERATE_GL_ARB_draw_instanced

extern bool GLEH_ARB_draw_instanced; /**< set if GL_ARB_draw_instanced is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glDrawArraysInstancedARB))(GLenum, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedARB))(GLenum, GLsizei, GLenum, const void*, GLsizei);

#define glDrawArraysInstancedARB GLFuncPtrName(glDrawArraysInstancedARB)
#define glDrawElementsInstancedARB GLFuncPtrName(glDrawElementsInstancedARB)

#endif // GL_ARB_draw_instanced

//								--- GL_ARB_fragment_coord_conventions ---

#ifndef GL_ARB_fragment_coord_conventions
#define GL_ARB_fragment_coord_conventions 1

extern bool GLEH_ARB_fragment_coord_conventions; /**< set if GL_ARB_fragment_coord_conventions is supported */

// no new tokens
// no new procedures or functions

#endif // GL_ARB_fragment_coord_conventions

//								--- GL_ARB_fragment_program ---

#ifndef GL_ARB_fragment_program
#define GL_ARB_fragment_program 1
#define __GENERATE_GL_ARB_fragment_program

extern bool GLEH_ARB_fragment_program; /**< set if GL_ARB_fragment_program is supported */

#define GL_FRAGMENT_PROGRAM_ARB                                      0x8804
#define GL_PROGRAM_FORMAT_ASCII_ARB                                  0x8875
#define GL_PROGRAM_LENGTH_ARB                                        0x8627
#define GL_PROGRAM_FORMAT_ARB                                        0x8876
#define GL_PROGRAM_BINDING_ARB                                       0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB                                  0x88a0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                              0x88a1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                           0x88a2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                       0x88a3
#define GL_PROGRAM_TEMPORARIES_ARB                                   0x88a4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                               0x88a5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                            0x88a6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                        0x88a7
#define GL_PROGRAM_PARAMETERS_ARB                                    0x88a8
#define GL_MAX_PROGRAM_PARAMETERS_ARB                                0x88a9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                             0x88aa
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                         0x88ab
#define GL_PROGRAM_ATTRIBS_ARB                                       0x88ac
#define GL_MAX_PROGRAM_ATTRIBS_ARB                                   0x88ad
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                                0x88ae
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                            0x88af
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                          0x88b4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                            0x88b5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                           0x88b6
#define GL_PROGRAM_ALU_INSTRUCTIONS_ARB                              0x8805
#define GL_PROGRAM_TEX_INSTRUCTIONS_ARB                              0x8806
#define GL_PROGRAM_TEX_INDIRECTIONS_ARB                              0x8807
#define GL_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                       0x8808
#define GL_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                       0x8809
#define GL_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                       0x880a
#define GL_MAX_PROGRAM_ALU_INSTRUCTIONS_ARB                          0x880b
#define GL_MAX_PROGRAM_TEX_INSTRUCTIONS_ARB                          0x880c
#define GL_MAX_PROGRAM_TEX_INDIRECTIONS_ARB                          0x880d
#define GL_MAX_PROGRAM_NATIVE_ALU_INSTRUCTIONS_ARB                   0x880e
#define GL_MAX_PROGRAM_NATIVE_TEX_INSTRUCTIONS_ARB                   0x880f
#define GL_MAX_PROGRAM_NATIVE_TEX_INDIRECTIONS_ARB                   0x8810
#define GL_PROGRAM_STRING_ARB                                        0x8628
#define GL_PROGRAM_ERROR_POSITION_ARB                                0x864b
#define GL_CURRENT_MATRIX_ARB                                        0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                              0x88b7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                            0x8640
#define GL_MAX_PROGRAM_MATRICES_ARB                                  0x862f
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                        0x862e
#define GL_MAX_TEXTURE_COORDS_ARB                                    0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                               0x8872
#define GL_PROGRAM_ERROR_STRING_ARB                                  0x8874
#define GL_MATRIX0_ARB                                               0x88c0
#define GL_MATRIX1_ARB                                               0x88c1
#define GL_MATRIX2_ARB                                               0x88c2
#define GL_MATRIX3_ARB                                               0x88c3
#define GL_MATRIX4_ARB                                               0x88c4
#define GL_MATRIX5_ARB                                               0x88c5
#define GL_MATRIX6_ARB                                               0x88c6
#define GL_MATRIX7_ARB                                               0x88c7
#define GL_MATRIX8_ARB                                               0x88c8
#define GL_MATRIX9_ARB                                               0x88c9
#define GL_MATRIX10_ARB                                              0x88ca
#define GL_MATRIX11_ARB                                              0x88cb
#define GL_MATRIX12_ARB                                              0x88cc
#define GL_MATRIX13_ARB                                              0x88cd
#define GL_MATRIX14_ARB                                              0x88ce
#define GL_MATRIX15_ARB                                              0x88cf
#define GL_MATRIX16_ARB                                              0x88d0
#define GL_MATRIX17_ARB                                              0x88d1
#define GL_MATRIX18_ARB                                              0x88d2
#define GL_MATRIX19_ARB                                              0x88d3
#define GL_MATRIX20_ARB                                              0x88d4
#define GL_MATRIX21_ARB                                              0x88d5
#define GL_MATRIX22_ARB                                              0x88d6
#define GL_MATRIX23_ARB                                              0x88d7
#define GL_MATRIX24_ARB                                              0x88d8
#define GL_MATRIX25_ARB                                              0x88d9
#define GL_MATRIX26_ARB                                              0x88da
#define GL_MATRIX27_ARB                                              0x88db
#define GL_MATRIX28_ARB                                              0x88dc
#define GL_MATRIX29_ARB                                              0x88dd
#define GL_MATRIX30_ARB                                              0x88de
#define GL_MATRIX31_ARB                                              0x88df

extern void (GLApi *GLFuncPtrName(glProgramStringARB))(GLenum, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glBindProgramARB))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteProgramsARB))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenProgramsARB))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4dARB))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4dvARB))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4fARB))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4fvARB))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dARB))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dvARB))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fARB))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fvARB))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterdvARB))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterfvARB))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterdvARB))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterfvARB))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramivARB))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetProgramStringARB))(GLenum, GLenum, void*);
extern GLboolean (GLApi *GLFuncPtrName(glIsProgramARB))(GLuint);

#define glProgramStringARB GLFuncPtrName(glProgramStringARB)
#define glBindProgramARB GLFuncPtrName(glBindProgramARB)
#define glDeleteProgramsARB GLFuncPtrName(glDeleteProgramsARB)
#define glGenProgramsARB GLFuncPtrName(glGenProgramsARB)
#define glProgramEnvParameter4dARB GLFuncPtrName(glProgramEnvParameter4dARB)
#define glProgramEnvParameter4dvARB GLFuncPtrName(glProgramEnvParameter4dvARB)
#define glProgramEnvParameter4fARB GLFuncPtrName(glProgramEnvParameter4fARB)
#define glProgramEnvParameter4fvARB GLFuncPtrName(glProgramEnvParameter4fvARB)
#define glProgramLocalParameter4dARB GLFuncPtrName(glProgramLocalParameter4dARB)
#define glProgramLocalParameter4dvARB GLFuncPtrName(glProgramLocalParameter4dvARB)
#define glProgramLocalParameter4fARB GLFuncPtrName(glProgramLocalParameter4fARB)
#define glProgramLocalParameter4fvARB GLFuncPtrName(glProgramLocalParameter4fvARB)
#define glGetProgramEnvParameterdvARB GLFuncPtrName(glGetProgramEnvParameterdvARB)
#define glGetProgramEnvParameterfvARB GLFuncPtrName(glGetProgramEnvParameterfvARB)
#define glGetProgramLocalParameterdvARB GLFuncPtrName(glGetProgramLocalParameterdvARB)
#define glGetProgramLocalParameterfvARB GLFuncPtrName(glGetProgramLocalParameterfvARB)
#define glGetProgramivARB GLFuncPtrName(glGetProgramivARB)
#define glGetProgramStringARB GLFuncPtrName(glGetProgramStringARB)
#define glIsProgramARB GLFuncPtrName(glIsProgramARB)

#endif // GL_ARB_fragment_program

//								--- GL_ARB_fragment_program_shadow ---

#ifndef GL_ARB_fragment_program_shadow
#define GL_ARB_fragment_program_shadow 1

extern bool GLEH_ARB_fragment_program_shadow; /**< set if GL_ARB_fragment_program_shadow is supported */

// no new tokens
// no new procedures or functions

#endif // GL_ARB_fragment_program_shadow

//								--- GL_ARB_fragment_shader ---

#ifndef GL_ARB_fragment_shader
#define GL_ARB_fragment_shader 1

extern bool GLEH_ARB_fragment_shader; /**< set if GL_ARB_fragment_shader is supported */

#define GL_FRAGMENT_SHADER_ARB                                       0x8b30
#define GL_MAX_FRAGMENT_UNIFORM_COMPONENTS_ARB                       0x8b49
#define GL_MAX_TEXTURE_COORDS_ARB                                    0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                               0x8872
#define GL_FRAGMENT_SHADER_DERIVATIVE_HINT_ARB                       0x8b8b

// no new procedures or functions

#endif // GL_ARB_fragment_shader

//								--- GL_ARB_framebuffer_object ---

#ifndef GL_ARB_framebuffer_object
#define GL_ARB_framebuffer_object 1
#define __GENERATE_GL_ARB_framebuffer_object

extern bool GLEH_ARB_framebuffer_object; /**< set if GL_ARB_framebuffer_object is supported */

#define GL_FRAMEBUFFER                                               0x8d40
#define GL_READ_FRAMEBUFFER                                          0x8ca8
#define GL_DRAW_FRAMEBUFFER                                          0x8ca9
#define GL_RENDERBUFFER                                              0x8d41
#define GL_STENCIL_INDEX1                                            0x8d46
#define GL_STENCIL_INDEX4                                            0x8d47
#define GL_STENCIL_INDEX8                                            0x8d48
#define GL_STENCIL_INDEX16                                           0x8d49
#define GL_RENDERBUFFER_WIDTH                                        0x8d42
#define GL_RENDERBUFFER_HEIGHT                                       0x8d43
#define GL_RENDERBUFFER_INTERNAL_FORMAT                              0x8d44
#define GL_RENDERBUFFER_RED_SIZE                                     0x8d50
#define GL_RENDERBUFFER_GREEN_SIZE                                   0x8d51
#define GL_RENDERBUFFER_BLUE_SIZE                                    0x8d52
#define GL_RENDERBUFFER_ALPHA_SIZE                                   0x8d53
#define GL_RENDERBUFFER_DEPTH_SIZE                                   0x8d54
#define GL_RENDERBUFFER_STENCIL_SIZE                                 0x8d55
#define GL_RENDERBUFFER_SAMPLES                                      0x8cab
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE                        0x8cd0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME                        0x8cd1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL                      0x8cd2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE              0x8cd3
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER                      0x8cd4
#define GL_FRAMEBUFFER_ATTACHMENT_COLOR_ENCODING                     0x8210
#define GL_FRAMEBUFFER_ATTACHMENT_COMPONENT_TYPE                     0x8211
#define GL_FRAMEBUFFER_ATTACHMENT_RED_SIZE                           0x8212
#define GL_FRAMEBUFFER_ATTACHMENT_GREEN_SIZE                         0x8213
#define GL_FRAMEBUFFER_ATTACHMENT_BLUE_SIZE                          0x8214
#define GL_FRAMEBUFFER_ATTACHMENT_ALPHA_SIZE                         0x8215
#define GL_FRAMEBUFFER_ATTACHMENT_DEPTH_SIZE                         0x8216
#define GL_FRAMEBUFFER_ATTACHMENT_STENCIL_SIZE                       0x8217
#ifndef GL_SRGB
#define GL_SRGB                                                      0x8c40
#endif // GL_SRGB
#define GL_UNSIGNED_NORMALIZED_ARB                                   0x8c17 // redefinition in OpenGL30 in glext.h
#define GL_FRAMEBUFFER_DEFAULT                                       0x8218
#define GL_INDEX                                                     0x8222
#define GL_COLOR_ATTACHMENT0                                         0x8ce0
#define GL_COLOR_ATTACHMENT1                                         0x8ce1
#define GL_COLOR_ATTACHMENT2                                         0x8ce2
#define GL_COLOR_ATTACHMENT3                                         0x8ce3
#define GL_COLOR_ATTACHMENT4                                         0x8ce4
#define GL_COLOR_ATTACHMENT5                                         0x8ce5
#define GL_COLOR_ATTACHMENT6                                         0x8ce6
#define GL_COLOR_ATTACHMENT7                                         0x8ce7
#define GL_COLOR_ATTACHMENT8                                         0x8ce8
#define GL_COLOR_ATTACHMENT9                                         0x8ce9
#define GL_COLOR_ATTACHMENT10                                        0x8cea
#define GL_COLOR_ATTACHMENT11                                        0x8ceb
#define GL_COLOR_ATTACHMENT12                                        0x8cec
#define GL_COLOR_ATTACHMENT13                                        0x8ced
#define GL_COLOR_ATTACHMENT14                                        0x8cee
#define GL_COLOR_ATTACHMENT15                                        0x8cef
#define GL_DEPTH_ATTACHMENT                                          0x8d00
#define GL_STENCIL_ATTACHMENT                                        0x8d20
#define GL_DEPTH_STENCIL_ATTACHMENT                                  0x821a
#define GL_MAX_SAMPLES                                               0x8d57
#define GL_FRAMEBUFFER_COMPLETE                                      0x8cd5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT                         0x8cd6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT                 0x8cd7
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER                        0x8cdb
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER                        0x8cdc
#define GL_FRAMEBUFFER_UNSUPPORTED                                   0x8cdd
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE                        0x8d56
#define GL_FRAMEBUFFER_UNDEFINED                                     0x8219
#define GL_FRAMEBUFFER_BINDING                                       0x8ca6
#define GL_DRAW_FRAMEBUFFER_BINDING                                  0x8ca6
#define GL_READ_FRAMEBUFFER_BINDING                                  0x8caa
#define GL_RENDERBUFFER_BINDING                                      0x8ca7
#define GL_MAX_COLOR_ATTACHMENTS                                     0x8cdf
#define GL_MAX_RENDERBUFFER_SIZE                                     0x84e8
#define GL_INVALID_FRAMEBUFFER_OPERATION                             0x0506
#define GL_DEPTH_STENCIL                                             0x84f9
#define GL_UNSIGNED_INT_24_8                                         0x84fa
#define GL_DEPTH24_STENCIL8                                          0x88f0
#define GL_TEXTURE_STENCIL_SIZE                                      0x88f1

extern GLboolean (GLApi *GLFuncPtrName(glIsRenderbuffer))(GLuint);
extern void (GLApi *GLFuncPtrName(glBindRenderbuffer))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteRenderbuffers))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenRenderbuffers))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glRenderbufferStorage))(GLenum, GLenum, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glRenderbufferStorageMultisample))(GLenum, GLsizei, GLenum, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetRenderbufferParameteriv))(GLenum, GLenum, int*);
extern GLboolean (GLApi *GLFuncPtrName(glIsFramebuffer))(GLuint);
extern void (GLApi *GLFuncPtrName(glBindFramebuffer))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteFramebuffers))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenFramebuffers))(GLsizei, GLuint*);
extern GLenum (GLApi *GLFuncPtrName(glCheckFramebufferStatus))(GLenum);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture1D))(GLenum, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture2D))(GLenum, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture3D))(GLenum, GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureLayer))(GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glFramebufferRenderbuffer))(GLenum, GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glGetFramebufferAttachmentParameteriv))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glBlitFramebuffer))(int, int, int, int, int, int, int, int, GLbitfield, GLenum);
extern void (GLApi *GLFuncPtrName(glGenerateMipmap))(GLenum);

#define glIsRenderbuffer GLFuncPtrName(glIsRenderbuffer)
#define glBindRenderbuffer GLFuncPtrName(glBindRenderbuffer)
#define glDeleteRenderbuffers GLFuncPtrName(glDeleteRenderbuffers)
#define glGenRenderbuffers GLFuncPtrName(glGenRenderbuffers)
#define glRenderbufferStorage GLFuncPtrName(glRenderbufferStorage)
#define glRenderbufferStorageMultisample GLFuncPtrName(glRenderbufferStorageMultisample)
#define glGetRenderbufferParameteriv GLFuncPtrName(glGetRenderbufferParameteriv)
#define glIsFramebuffer GLFuncPtrName(glIsFramebuffer)
#define glBindFramebuffer GLFuncPtrName(glBindFramebuffer)
#define glDeleteFramebuffers GLFuncPtrName(glDeleteFramebuffers)
#define glGenFramebuffers GLFuncPtrName(glGenFramebuffers)
#define glCheckFramebufferStatus GLFuncPtrName(glCheckFramebufferStatus)
#define glFramebufferTexture1D GLFuncPtrName(glFramebufferTexture1D)
#define glFramebufferTexture2D GLFuncPtrName(glFramebufferTexture2D)
#define glFramebufferTexture3D GLFuncPtrName(glFramebufferTexture3D)
#define glFramebufferTextureLayer GLFuncPtrName(glFramebufferTextureLayer)
#define glFramebufferRenderbuffer GLFuncPtrName(glFramebufferRenderbuffer)
#define glGetFramebufferAttachmentParameteriv GLFuncPtrName(glGetFramebufferAttachmentParameteriv)
#define glBlitFramebuffer GLFuncPtrName(glBlitFramebuffer)
#define glGenerateMipmap GLFuncPtrName(glGenerateMipmap)

#endif // GL_ARB_framebuffer_object

//								--- GL_ARB_framebuffer_sRGB ---

#ifndef GL_ARB_framebuffer_sRGB
#define GL_ARB_framebuffer_sRGB 1

extern bool GLEH_ARB_framebuffer_sRGB; /**< set if GL_ARB_framebuffer_sRGB is supported */

#define GL_GLX_FRAMEBUFFER_SRGB_CAPABLE_ARB                          0x20b2
#define GL_WGL_FRAMEBUFFER_SRGB_CAPABLE_ARB                          0x20a9
#define GL_FRAMEBUFFER_SRGB                                          0x8db9

// no new procedures or functions

#endif // GL_ARB_framebuffer_sRGB

//								--- GL_ARB_geometry_shader4 ---

#ifndef GL_ARB_geometry_shader4
#define GL_ARB_geometry_shader4 1
#define __GENERATE_GL_ARB_geometry_shader4

extern bool GLEH_ARB_geometry_shader4; /**< set if GL_ARB_geometry_shader4 is supported */

#define GL_GEOMETRY_SHADER_ARB                                       0x8dd9
#define GL_GEOMETRY_VERTICES_OUT_ARB                                 0x8dda
#define GL_GEOMETRY_INPUT_TYPE_ARB                                   0x8ddb
#define GL_GEOMETRY_OUTPUT_TYPE_ARB                                  0x8ddc
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_ARB                      0x8c29
#define GL_MAX_GEOMETRY_VARYING_COMPONENTS_ARB                       0x8ddd
#define GL_MAX_VERTEX_VARYING_COMPONENTS_ARB                         0x8dde
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_ARB                       0x8ddf
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES_ARB                          0x8de0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_ARB                  0x8de1
#define GL_LINES_ADJACENCY_ARB                                       0x000a
#define GL_LINE_STRIP_ADJACENCY_ARB                                  0x000b
#define GL_TRIANGLES_ADJACENCY_ARB                                   0x000c
#define GL_TRIANGLE_STRIP_ADJACENCY_ARB                              0x000d
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_ARB                  0x8da8
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_ARB                    0x8da9
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED_ARB                        0x8da7
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER                      0x8cd4
#define GL_PROGRAM_POINT_SIZE_ARB                                    0x8642

extern void (GLApi *GLFuncPtrName(glProgramParameteriARB))(GLuint, GLenum, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureARB))(GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureLayerARB))(GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureFaceARB))(GLenum, GLenum, GLuint, int, GLenum);

#define glProgramParameteriARB GLFuncPtrName(glProgramParameteriARB)
#define glFramebufferTextureARB GLFuncPtrName(glFramebufferTextureARB)
#define glFramebufferTextureLayerARB GLFuncPtrName(glFramebufferTextureLayerARB)
#define glFramebufferTextureFaceARB GLFuncPtrName(glFramebufferTextureFaceARB)

#endif // GL_ARB_geometry_shader4

//								--- GL_ARB_half_float_pixel ---

#ifndef GL_ARB_half_float_pixel
#define GL_ARB_half_float_pixel 1

extern bool GLEH_ARB_half_float_pixel; /**< set if GL_ARB_half_float_pixel is supported */

#define GL_HALF_FLOAT_ARB                                            0x140b

// no new procedures or functions

#endif // GL_ARB_half_float_pixel

//								--- GL_ARB_half_float_vertex ---

#ifndef GL_ARB_half_float_vertex
#define GL_ARB_half_float_vertex 1

extern bool GLEH_ARB_half_float_vertex; /**< set if GL_ARB_half_float_vertex is supported */

#define GL_HALF_FLOAT                                                0x140b

// no new procedures or functions

#endif // GL_ARB_half_float_vertex

//								--- GL_ARB_map_buffer_range ---

#ifndef GL_ARB_map_buffer_range
#define GL_ARB_map_buffer_range 1
#define __GENERATE_GL_ARB_map_buffer_range

extern bool GLEH_ARB_map_buffer_range; /**< set if GL_ARB_map_buffer_range is supported */

#define GL_MAP_READ_BIT                                              0x0001
#define GL_MAP_WRITE_BIT                                             0x0002
#define GL_MAP_INVALIDATE_RANGE_BIT                                  0x0004
#define GL_MAP_INVALIDATE_BUFFER_BIT                                 0x0008
#define GL_MAP_FLUSH_EXPLICIT_BIT                                    0x0010
#define GL_MAP_UNSYNCHRONIZED_BIT                                    0x0020

extern void* (GLApi *GLFuncPtrName(glMapBufferRange))(GLenum, GLintptr, GLsizeiptr, GLbitfield);
extern void (GLApi *GLFuncPtrName(glFlushMappedBufferRange))(GLenum, GLintptr, GLsizeiptr);

#define glMapBufferRange GLFuncPtrName(glMapBufferRange)
#define glFlushMappedBufferRange GLFuncPtrName(glFlushMappedBufferRange)

#endif // GL_ARB_map_buffer_range

//								--- GL_ARB_multisample ---

#ifndef GL_ARB_multisample
#define GL_ARB_multisample 1
#define __GENERATE_GL_ARB_multisample

extern bool GLEH_ARB_multisample; /**< set if GL_ARB_multisample is supported */

#define GL_GLX_SAMPLE_BUFFERS_ARB 100000
#define GL_GLX_SAMPLES_ARB 100001
#define GL_WGL_SAMPLE_BUFFERS_ARB                                    0x2041
#define GL_WGL_SAMPLES_ARB                                           0x2042
#define GL_MULTISAMPLE_ARB                                           0x809d
#define GL_SAMPLE_ALPHA_TO_COVERAGE_ARB                              0x809e
#define GL_SAMPLE_ALPHA_TO_ONE_ARB                                   0x809f
#define GL_SAMPLE_COVERAGE_ARB                                       0x80a0
#define GL_MULTISAMPLE_BIT_ARB                                       0x20000000
#define GL_SAMPLE_BUFFERS_ARB                                        0x80a8
#define GL_SAMPLES_ARB                                               0x80a9
#define GL_SAMPLE_COVERAGE_VALUE_ARB                                 0x80aa
#define GL_SAMPLE_COVERAGE_INVERT_ARB                                0x80ab

extern void (GLApi *GLFuncPtrName(glSampleCoverageARB))(GLclampf, GLboolean);

#define glSampleCoverageARB GLFuncPtrName(glSampleCoverageARB)

#endif // GL_ARB_multisample

//								--- GL_ARB_occlusion_query ---

#ifndef GL_ARB_occlusion_query
#define GL_ARB_occlusion_query 1
#define __GENERATE_GL_ARB_occlusion_query

extern bool GLEH_ARB_occlusion_query; /**< set if GL_ARB_occlusion_query is supported */

#define GL_SAMPLES_PASSED_ARB                                        0x8914
#define GL_QUERY_COUNTER_BITS_ARB                                    0x8864
#define GL_CURRENT_QUERY_ARB                                         0x8865
#define GL_QUERY_RESULT_ARB                                          0x8866
#define GL_QUERY_RESULT_AVAILABLE_ARB                                0x8867

extern void (GLApi *GLFuncPtrName(glGenQueriesARB))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glDeleteQueriesARB))(GLsizei, const GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsQueryARB))(GLuint);
extern void (GLApi *GLFuncPtrName(glBeginQueryARB))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glEndQueryARB))(GLenum);
extern void (GLApi *GLFuncPtrName(glGetQueryivARB))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetQueryObjectivARB))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetQueryObjectuivARB))(GLuint, GLenum, GLuint*);

#define glGenQueriesARB GLFuncPtrName(glGenQueriesARB)
#define glDeleteQueriesARB GLFuncPtrName(glDeleteQueriesARB)
#define glIsQueryARB GLFuncPtrName(glIsQueryARB)
#define glBeginQueryARB GLFuncPtrName(glBeginQueryARB)
#define glEndQueryARB GLFuncPtrName(glEndQueryARB)
#define glGetQueryivARB GLFuncPtrName(glGetQueryivARB)
#define glGetQueryObjectivARB GLFuncPtrName(glGetQueryObjectivARB)
#define glGetQueryObjectuivARB GLFuncPtrName(glGetQueryObjectuivARB)

#endif // GL_ARB_occlusion_query

//								--- GL_ARB_pixel_buffer_object ---

#ifndef GL_ARB_pixel_buffer_object
#define GL_ARB_pixel_buffer_object 1

extern bool GLEH_ARB_pixel_buffer_object; /**< set if GL_ARB_pixel_buffer_object is supported */

#define GL_PIXEL_PACK_BUFFER_ARB                                     0x88eb
#define GL_PIXEL_UNPACK_BUFFER_ARB                                   0x88ec
#define GL_PIXEL_PACK_BUFFER_BINDING_ARB                             0x88ed
#define GL_PIXEL_UNPACK_BUFFER_BINDING_ARB                           0x88ef

// no new procedures or functions

#endif // GL_ARB_pixel_buffer_object

//								--- GL_ARB_point_parameters ---

#ifndef GL_ARB_point_parameters
#define GL_ARB_point_parameters 1
#define __GENERATE_GL_ARB_point_parameters

extern bool GLEH_ARB_point_parameters; /**< set if GL_ARB_point_parameters is supported */

#define GL_POINT_SIZE_MIN_ARB                                        0x8126
#define GL_POINT_SIZE_MAX_ARB                                        0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE_ARB                             0x8128
#define GL_POINT_DISTANCE_ATTENUATION_ARB                            0x8129

extern void (GLApi *GLFuncPtrName(glPointParameterfARB))(GLenum, float);
extern void (GLApi *GLFuncPtrName(glPointParameterfvARB))(GLenum, float*);

#define glPointParameterfARB GLFuncPtrName(glPointParameterfARB)
#define glPointParameterfvARB GLFuncPtrName(glPointParameterfvARB)

#endif // GL_ARB_point_parameters

//								--- GL_ARB_point_sprite ---

#ifndef GL_ARB_point_sprite
#define GL_ARB_point_sprite 1

extern bool GLEH_ARB_point_sprite; /**< set if GL_ARB_point_sprite is supported */

#define GL_POINT_SPRITE_ARB                                          0x8861
#define GL_COORD_REPLACE_ARB                                         0x8862

// no new procedures or functions

#endif // GL_ARB_point_sprite

//								--- GL_ARB_provoking_vertex ---

#ifndef GL_ARB_provoking_vertex
#define GL_ARB_provoking_vertex 1
#define __GENERATE_GL_ARB_provoking_vertex

extern bool GLEH_ARB_provoking_vertex; /**< set if GL_ARB_provoking_vertex is supported */

#define GL_FIRST_VERTEX_CONVENTION                                   0x8e4d
#define GL_LAST_VERTEX_CONVENTION                                    0x8e4e
#define GL_PROVOKING_VERTEX                                          0x8e4f
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION                  0x8e4c

extern void (GLApi *GLFuncPtrName(glProvokingVertex))(GLenum);

#define glProvokingVertex GLFuncPtrName(glProvokingVertex)

#endif // GL_ARB_provoking_vertex

//								--- GL_ARB_seamless_cube_map ---

#ifndef GL_ARB_seamless_cube_map
#define GL_ARB_seamless_cube_map 1

extern bool GLEH_ARB_seamless_cube_map; /**< set if GL_ARB_seamless_cube_map is supported */

#define GL_TEXTURE_CUBE_MAP_SEAMLESS                                 0x884f

// no new procedures or functions

#endif // GL_ARB_seamless_cube_map

//								--- GL_ARB_shader_objects ---

#ifndef GL_ARB_shader_objects
#define GL_ARB_shader_objects 1
#define __GENERATE_GL_ARB_shader_objects

extern bool GLEH_ARB_shader_objects; /**< set if GL_ARB_shader_objects is supported */

#define GL_PROGRAM_OBJECT_ARB                                        0x8b40
#define GL_OBJECT_TYPE_ARB                                           0x8b4e
#define GL_OBJECT_SUBTYPE_ARB                                        0x8b4f
#define GL_OBJECT_DELETE_STATUS_ARB                                  0x8b80
#define GL_OBJECT_COMPILE_STATUS_ARB                                 0x8b81
#define GL_OBJECT_LINK_STATUS_ARB                                    0x8b82
#define GL_OBJECT_VALIDATE_STATUS_ARB                                0x8b83
#define GL_OBJECT_INFO_LOG_LENGTH_ARB                                0x8b84
#define GL_OBJECT_ATTACHED_OBJECTS_ARB                               0x8b85
#define GL_OBJECT_ACTIVE_UNIFORMS_ARB                                0x8b86
#define GL_OBJECT_ACTIVE_UNIFORM_MAX_LENGTH_ARB                      0x8b87
#define GL_OBJECT_SHADER_SOURCE_LENGTH_ARB                           0x8b88
#define GL_SHADER_OBJECT_ARB                                         0x8b48
#define GL_FLOAT                                                     0x1406
#define GL_FLOAT_VEC2_ARB                                            0x8b50
#define GL_FLOAT_VEC3_ARB                                            0x8b51
#define GL_FLOAT_VEC4_ARB                                            0x8b52
#define GL_INT                                                       0x1404
#define GL_INT_VEC2_ARB                                              0x8b53
#define GL_INT_VEC3_ARB                                              0x8b54
#define GL_INT_VEC4_ARB                                              0x8b55
#define GL_BOOL_ARB                                                  0x8b56
#define GL_BOOL_VEC2_ARB                                             0x8b57
#define GL_BOOL_VEC3_ARB                                             0x8b58
#define GL_BOOL_VEC4_ARB                                             0x8b59
#define GL_FLOAT_MAT2_ARB                                            0x8b5a
#define GL_FLOAT_MAT3_ARB                                            0x8b5b
#define GL_FLOAT_MAT4_ARB                                            0x8b5c
#define GL_SAMPLER_1D_ARB                                            0x8b5d
#define GL_SAMPLER_2D_ARB                                            0x8b5e
#define GL_SAMPLER_3D_ARB                                            0x8b5f
#define GL_SAMPLER_CUBE_ARB                                          0x8b60
#define GL_SAMPLER_1D_SHADOW_ARB                                     0x8b61
#define GL_SAMPLER_2D_SHADOW_ARB                                     0x8b62
#define GL_SAMPLER_2D_RECT_ARB                                       0x8b63
#define GL_SAMPLER_2D_RECT_SHADOW_ARB                                0x8b64

extern void (GLApi *GLFuncPtrName(glDeleteObjectARB))(GLhandleARB);
extern GLhandleARB (GLApi *GLFuncPtrName(glGetHandleARB))(GLenum);
extern void (GLApi *GLFuncPtrName(glDetachObjectARB))(GLhandleARB, GLhandleARB);
extern GLhandleARB (GLApi *GLFuncPtrName(glCreateShaderObjectARB))(GLenum);
extern void (GLApi *GLFuncPtrName(glShaderSourceARB))(GLhandleARB, GLsizei, const GLcharARB**, const int*);
extern void (GLApi *GLFuncPtrName(glCompileShaderARB))(GLhandleARB);
extern GLhandleARB (GLApi *GLFuncPtrName(glCreateProgramObjectARB))();
extern void (GLApi *GLFuncPtrName(glAttachObjectARB))(GLhandleARB, GLhandleARB);
extern void (GLApi *GLFuncPtrName(glLinkProgramARB))(GLhandleARB);
extern void (GLApi *GLFuncPtrName(glUseProgramObjectARB))(GLhandleARB);
extern void (GLApi *GLFuncPtrName(glValidateProgramARB))(GLhandleARB);
extern void (GLApi *GLFuncPtrName(glUniform1fARB))(int, float);
extern void (GLApi *GLFuncPtrName(glUniform2fARB))(int, float, float);
extern void (GLApi *GLFuncPtrName(glUniform3fARB))(int, float, float, float);
extern void (GLApi *GLFuncPtrName(glUniform4fARB))(int, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glUniform1iARB))(int, int);
extern void (GLApi *GLFuncPtrName(glUniform2iARB))(int, int, int);
extern void (GLApi *GLFuncPtrName(glUniform3iARB))(int, int, int, int);
extern void (GLApi *GLFuncPtrName(glUniform4iARB))(int, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glUniform1fvARB))(int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glUniform2fvARB))(int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glUniform3fvARB))(int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glUniform4fvARB))(int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glUniform1ivARB))(int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glUniform2ivARB))(int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glUniform3ivARB))(int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glUniform4ivARB))(int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glUniformMatrix2fvARB))(int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glUniformMatrix3fvARB))(int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glUniformMatrix4fvARB))(int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glGetObjectParameterfvARB))(GLhandleARB, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetObjectParameterivARB))(GLhandleARB, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetInfoLogARB))(GLhandleARB, GLsizei, GLsizei*, GLcharARB*);
extern void (GLApi *GLFuncPtrName(glGetAttachedObjectsARB))(GLhandleARB, GLsizei, GLsizei*, GLhandleARB*);
extern int (GLApi *GLFuncPtrName(glGetUniformLocationARB))(GLhandleARB, const GLcharARB*);
extern void (GLApi *GLFuncPtrName(glGetActiveUniformARB))(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*);
extern void (GLApi *GLFuncPtrName(glGetUniformfvARB))(GLhandleARB, int, float*);
extern void (GLApi *GLFuncPtrName(glGetUniformivARB))(GLhandleARB, int, int*);
extern void (GLApi *GLFuncPtrName(glGetShaderSourceARB))(GLhandleARB, GLsizei, GLsizei*, GLcharARB*);

#define glDeleteObjectARB GLFuncPtrName(glDeleteObjectARB)
#define glGetHandleARB GLFuncPtrName(glGetHandleARB)
#define glDetachObjectARB GLFuncPtrName(glDetachObjectARB)
#define glCreateShaderObjectARB GLFuncPtrName(glCreateShaderObjectARB)
#define glShaderSourceARB GLFuncPtrName(glShaderSourceARB)
#define glCompileShaderARB GLFuncPtrName(glCompileShaderARB)
#define glCreateProgramObjectARB GLFuncPtrName(glCreateProgramObjectARB)
#define glAttachObjectARB GLFuncPtrName(glAttachObjectARB)
#define glLinkProgramARB GLFuncPtrName(glLinkProgramARB)
#define glUseProgramObjectARB GLFuncPtrName(glUseProgramObjectARB)
#define glValidateProgramARB GLFuncPtrName(glValidateProgramARB)
#define glUniform1fARB GLFuncPtrName(glUniform1fARB)
#define glUniform2fARB GLFuncPtrName(glUniform2fARB)
#define glUniform3fARB GLFuncPtrName(glUniform3fARB)
#define glUniform4fARB GLFuncPtrName(glUniform4fARB)
#define glUniform1iARB GLFuncPtrName(glUniform1iARB)
#define glUniform2iARB GLFuncPtrName(glUniform2iARB)
#define glUniform3iARB GLFuncPtrName(glUniform3iARB)
#define glUniform4iARB GLFuncPtrName(glUniform4iARB)
#define glUniform1fvARB GLFuncPtrName(glUniform1fvARB)
#define glUniform2fvARB GLFuncPtrName(glUniform2fvARB)
#define glUniform3fvARB GLFuncPtrName(glUniform3fvARB)
#define glUniform4fvARB GLFuncPtrName(glUniform4fvARB)
#define glUniform1ivARB GLFuncPtrName(glUniform1ivARB)
#define glUniform2ivARB GLFuncPtrName(glUniform2ivARB)
#define glUniform3ivARB GLFuncPtrName(glUniform3ivARB)
#define glUniform4ivARB GLFuncPtrName(glUniform4ivARB)
#define glUniformMatrix2fvARB GLFuncPtrName(glUniformMatrix2fvARB)
#define glUniformMatrix3fvARB GLFuncPtrName(glUniformMatrix3fvARB)
#define glUniformMatrix4fvARB GLFuncPtrName(glUniformMatrix4fvARB)
#define glGetObjectParameterfvARB GLFuncPtrName(glGetObjectParameterfvARB)
#define glGetObjectParameterivARB GLFuncPtrName(glGetObjectParameterivARB)
#define glGetInfoLogARB GLFuncPtrName(glGetInfoLogARB)
#define glGetAttachedObjectsARB GLFuncPtrName(glGetAttachedObjectsARB)
#define glGetUniformLocationARB GLFuncPtrName(glGetUniformLocationARB)
#define glGetActiveUniformARB GLFuncPtrName(glGetActiveUniformARB)
#define glGetUniformfvARB GLFuncPtrName(glGetUniformfvARB)
#define glGetUniformivARB GLFuncPtrName(glGetUniformivARB)
#define glGetShaderSourceARB GLFuncPtrName(glGetShaderSourceARB)

#endif // GL_ARB_shader_objects

//								--- GL_ARB_shading_language_100 ---

#ifndef GL_ARB_shading_language_100
#define GL_ARB_shading_language_100 1

extern bool GLEH_ARB_shading_language_100; /**< set if GL_ARB_shading_language_100 is supported */

#define GL_SHADING_LANGUAGE_VERSION_ARB                              0x8b8c

// no new procedures or functions

#endif // GL_ARB_shading_language_100

//								--- GL_ARB_shadow ---

#ifndef GL_ARB_shadow
#define GL_ARB_shadow 1

extern bool GLEH_ARB_shadow; /**< set if GL_ARB_shadow is supported */

#define GL_TEXTURE_COMPARE_MODE_ARB                                  0x884c
#define GL_TEXTURE_COMPARE_FUNC_ARB                                  0x884d
#define GL_COMPARE_R_TO_TEXTURE_ARB                                  0x884e

// no new procedures or functions

#endif // GL_ARB_shadow

//								--- GL_ARB_sync ---

#ifndef GL_ARB_sync
#define GL_ARB_sync 1
#define __GENERATE_GL_ARB_sync

extern bool GLEH_ARB_sync; /**< set if GL_ARB_sync is supported */

#define GL_MAX_SERVER_WAIT_TIMEOUT                                   0x9111
#define GL_OBJECT_TYPE                                               0x9112
#define GL_SYNC_CONDITION                                            0x9113
#define GL_SYNC_STATUS                                               0x9114
#define GL_SYNC_FLAGS                                                0x9115
#define GL_SYNC_FENCE                                                0x9116
#define GL_SYNC_GPU_COMMANDS_COMPLETE                                0x9117
#define GL_UNSIGNALED                                                0x9118
#define GL_SIGNALED                                                  0x9119
#define GL_SYNC_FLUSH_COMMANDS_BIT                                   0x00000001
#define GL_TIMEOUT_IGNORED                                           0xffffffffffffffffull
#define GL_ALREADY_SIGNALED                                          0x911a
#define GL_TIMEOUT_EXPIRED                                           0x911b
#define GL_CONDITION_SATISFIED                                       0x911c
#define GL_WAIT_FAILED                                               0x911d

extern GLsync (GLApi *GLFuncPtrName(glFenceSync))(GLenum, GLbitfield);
extern GLboolean (GLApi *GLFuncPtrName(glIsSync))(GLsync);
extern void (GLApi *GLFuncPtrName(glDeleteSync))(GLsync);
extern GLenum (GLApi *GLFuncPtrName(glClientWaitSync))(GLsync, GLbitfield, GLuint64);
extern void (GLApi *GLFuncPtrName(glWaitSync))(GLsync, GLbitfield, GLuint64);
extern void (GLApi *GLFuncPtrName(glGetInteger64v))(GLenum, GLint64*);
extern void (GLApi *GLFuncPtrName(glGetSynciv))(GLsync, GLenum, GLsizei, GLsizei*, int*);

#define glFenceSync GLFuncPtrName(glFenceSync)
#define glIsSync GLFuncPtrName(glIsSync)
#define glDeleteSync GLFuncPtrName(glDeleteSync)
#define glClientWaitSync GLFuncPtrName(glClientWaitSync)
#define glWaitSync GLFuncPtrName(glWaitSync)
#define glGetInteger64v GLFuncPtrName(glGetInteger64v)
#define glGetSynciv GLFuncPtrName(glGetSynciv)

#endif // GL_ARB_sync

//								--- GL_ARB_texture_border_clamp ---

#ifndef GL_ARB_texture_border_clamp
#define GL_ARB_texture_border_clamp 1

extern bool GLEH_ARB_texture_border_clamp; /**< set if GL_ARB_texture_border_clamp is supported */

#define GL_CLAMP_TO_BORDER_ARB                                       0x812d

// no new procedures or functions

#endif // GL_ARB_texture_border_clamp

//								--- GL_ARB_texture_buffer_object ---

#ifndef GL_ARB_texture_buffer_object
#define GL_ARB_texture_buffer_object 1
#define __GENERATE_GL_ARB_texture_buffer_object

extern bool GLEH_ARB_texture_buffer_object; /**< set if GL_ARB_texture_buffer_object is supported */

#define GL_TEXTURE_BUFFER_ARB                                        0x8c2a
#define GL_MAX_TEXTURE_BUFFER_SIZE_ARB                               0x8c2b
#define GL_TEXTURE_BINDING_BUFFER_ARB                                0x8c2c
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING_ARB                     0x8c2d
#define GL_TEXTURE_BUFFER_FORMAT_ARB                                 0x8c2e

extern void (GLApi *GLFuncPtrName(glTexBufferARB))(GLenum, GLenum, GLuint);

#define glTexBufferARB GLFuncPtrName(glTexBufferARB)

#endif // GL_ARB_texture_buffer_object

//								--- GL_ARB_texture_compression ---

#ifndef GL_ARB_texture_compression
#define GL_ARB_texture_compression 1
#define __GENERATE_GL_ARB_texture_compression

extern bool GLEH_ARB_texture_compression; /**< set if GL_ARB_texture_compression is supported */

#define GL_COMPRESSED_ALPHA_ARB                                      0x84e9
#define GL_COMPRESSED_LUMINANCE_ARB                                  0x84ea
#define GL_COMPRESSED_LUMINANCE_ALPHA_ARB                            0x84eb
#define GL_COMPRESSED_INTENSITY_ARB                                  0x84ec
#define GL_COMPRESSED_RGB_ARB                                        0x84ed
#define GL_COMPRESSED_RGBA_ARB                                       0x84ee
#define GL_TEXTURE_COMPRESSION_HINT_ARB                              0x84ef
#define GL_TEXTURE_COMPRESSED_IMAGE_SIZE_ARB                         0x86a0
#define GL_TEXTURE_COMPRESSED_ARB                                    0x86a1
#define GL_NUM_COMPRESSED_TEXTURE_FORMATS_ARB                        0x86a2
#define GL_COMPRESSED_TEXTURE_FORMATS_ARB                            0x86a3

extern void (GLApi *GLFuncPtrName(glCompressedTexImage3DARB))(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTexImage2DARB))(GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTexImage1DARB))(GLenum, int, GLenum, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage3DARB))(GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage2DARB))(GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTexSubImage1DARB))(GLenum, int, int, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glGetCompressedTexImageARB))(GLenum, int, void*);

#define glCompressedTexImage3DARB GLFuncPtrName(glCompressedTexImage3DARB)
#define glCompressedTexImage2DARB GLFuncPtrName(glCompressedTexImage2DARB)
#define glCompressedTexImage1DARB GLFuncPtrName(glCompressedTexImage1DARB)
#define glCompressedTexSubImage3DARB GLFuncPtrName(glCompressedTexSubImage3DARB)
#define glCompressedTexSubImage2DARB GLFuncPtrName(glCompressedTexSubImage2DARB)
#define glCompressedTexSubImage1DARB GLFuncPtrName(glCompressedTexSubImage1DARB)
#define glGetCompressedTexImageARB GLFuncPtrName(glGetCompressedTexImageARB)

#endif // GL_ARB_texture_compression

//								--- GL_ARB_texture_compression_rgtc ---

#ifndef GL_ARB_texture_compression_rgtc
#define GL_ARB_texture_compression_rgtc 1

extern bool GLEH_ARB_texture_compression_rgtc; /**< set if GL_ARB_texture_compression_rgtc is supported */

#define GL_COMPRESSED_RED_RGTC1                                      0x8dbb
#define GL_COMPRESSED_SIGNED_RED_RGTC1                               0x8dbc
#define GL_COMPRESSED_RG_RGTC2                                       0x8dbd
#define GL_COMPRESSED_SIGNED_RG_RGTC2                                0x8dbe

// no new procedures or functions

#endif // GL_ARB_texture_compression_rgtc

//								--- GL_ARB_texture_cube_map ---

#ifndef GL_ARB_texture_cube_map
#define GL_ARB_texture_cube_map 1

extern bool GLEH_ARB_texture_cube_map; /**< set if GL_ARB_texture_cube_map is supported */

#define GL_NORMAL_MAP_ARB                                            0x8511
#define GL_REFLECTION_MAP_ARB                                        0x8512
#define GL_TEXTURE_CUBE_MAP_ARB                                      0x8513
#define GL_TEXTURE_BINDING_CUBE_MAP_ARB                              0x8514
#define GL_TEXTURE_CUBE_MAP_POSITIVE_X_ARB                           0x8515
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_X_ARB                           0x8516
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Y_ARB                           0x8517
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Y_ARB                           0x8518
#define GL_TEXTURE_CUBE_MAP_POSITIVE_Z_ARB                           0x8519
#define GL_TEXTURE_CUBE_MAP_NEGATIVE_Z_ARB                           0x851a
#define GL_PROXY_TEXTURE_CUBE_MAP_ARB                                0x851b
#define GL_MAX_CUBE_MAP_TEXTURE_SIZE_ARB                             0x851c

// no new procedures or functions

#endif // GL_ARB_texture_cube_map

//								--- GL_ARB_texture_env_add ---

#ifndef GL_ARB_texture_env_add
#define GL_ARB_texture_env_add 1

extern bool GLEH_ARB_texture_env_add; /**< set if GL_ARB_texture_env_add is supported */

// no new tokens
// no new procedures or functions

#endif // GL_ARB_texture_env_add

//								--- GL_ARB_texture_env_combine ---

#ifndef GL_ARB_texture_env_combine
#define GL_ARB_texture_env_combine 1

extern bool GLEH_ARB_texture_env_combine; /**< set if GL_ARB_texture_env_combine is supported */

#define GL_COMBINE_ARB                                               0x8570
#define GL_COMBINE_RGB_ARB                                           0x8571
#define GL_COMBINE_ALPHA_ARB                                         0x8572
#define GL_SOURCE0_RGB_ARB                                           0x8580
#define GL_SOURCE1_RGB_ARB                                           0x8581
#define GL_SOURCE2_RGB_ARB                                           0x8582
#define GL_SOURCE0_ALPHA_ARB                                         0x8588
#define GL_SOURCE1_ALPHA_ARB                                         0x8589
#define GL_SOURCE2_ALPHA_ARB                                         0x858a
#define GL_OPERAND0_RGB_ARB                                          0x8590
#define GL_OPERAND1_RGB_ARB                                          0x8591
#define GL_OPERAND2_RGB_ARB                                          0x8592
#define GL_OPERAND0_ALPHA_ARB                                        0x8598
#define GL_OPERAND1_ALPHA_ARB                                        0x8599
#define GL_OPERAND2_ALPHA_ARB                                        0x859a
#define GL_RGB_SCALE_ARB                                             0x8573
#define GL_ADD_SIGNED_ARB                                            0x8574
#define GL_INTERPOLATE_ARB                                           0x8575
#define GL_SUBTRACT_ARB                                              0x84e7
#define GL_CONSTANT_ARB                                              0x8576
#define GL_PRIMARY_COLOR_ARB                                         0x8577
#define GL_PREVIOUS_ARB                                              0x8578

// no new procedures or functions

#endif // GL_ARB_texture_env_combine

//								--- GL_ARB_texture_env_dot3 ---

#ifndef GL_ARB_texture_env_dot3
#define GL_ARB_texture_env_dot3 1

extern bool GLEH_ARB_texture_env_dot3; /**< set if GL_ARB_texture_env_dot3 is supported */

#define GL_DOT3_RGB_ARB                                              0x86ae
#define GL_DOT3_RGBA_ARB                                             0x86af

// no new procedures or functions

#endif // GL_ARB_texture_env_dot3

//								--- GL_ARB_texture_float ---

#ifndef GL_ARB_texture_float
#define GL_ARB_texture_float 1

extern bool GLEH_ARB_texture_float; /**< set if GL_ARB_texture_float is supported */

#define GL_TEXTURE_RED_TYPE_ARB                                      0x8c10
#define GL_TEXTURE_GREEN_TYPE_ARB                                    0x8c11
#define GL_TEXTURE_BLUE_TYPE_ARB                                     0x8c12
#define GL_TEXTURE_ALPHA_TYPE_ARB                                    0x8c13
#define GL_TEXTURE_LUMINANCE_TYPE_ARB                                0x8c14
#define GL_TEXTURE_INTENSITY_TYPE_ARB                                0x8c15
#define GL_TEXTURE_DEPTH_TYPE_ARB                                    0x8c16
#define GL_UNSIGNED_NORMALIZED_ARB                                   0x8c17
#define GL_RGBA32F_ARB                                               0x8814
#define GL_RGB32F_ARB                                                0x8815
#define GL_ALPHA32F_ARB                                              0x8816
#define GL_INTENSITY32F_ARB                                          0x8817
#define GL_LUMINANCE32F_ARB                                          0x8818
#define GL_LUMINANCE_ALPHA32F_ARB                                    0x8819
#define GL_RGBA16F_ARB                                               0x881a
#define GL_RGB16F_ARB                                                0x881b
#define GL_ALPHA16F_ARB                                              0x881c
#define GL_INTENSITY16F_ARB                                          0x881d
#define GL_LUMINANCE16F_ARB                                          0x881e
#define GL_LUMINANCE_ALPHA16F_ARB                                    0x881f

// no new procedures or functions

#endif // GL_ARB_texture_float

//								--- GL_ARB_texture_mirrored_repeat ---

#ifndef GL_ARB_texture_mirrored_repeat
#define GL_ARB_texture_mirrored_repeat 1

extern bool GLEH_ARB_texture_mirrored_repeat; /**< set if GL_ARB_texture_mirrored_repeat is supported */

#define GL_MIRRORED_REPEAT_ARB                                       0x8370

// no new procedures or functions

#endif // GL_ARB_texture_mirrored_repeat

//								--- GL_ARB_texture_multisample ---

#ifndef GL_ARB_texture_multisample
#define GL_ARB_texture_multisample 1
#define __GENERATE_GL_ARB_texture_multisample

extern bool GLEH_ARB_texture_multisample; /**< set if GL_ARB_texture_multisample is supported */

#define GL_SAMPLE_POSITION                                           0x8e50
#define GL_SAMPLE_MASK                                               0x8e51
#define GL_SAMPLE_MASK_VALUE                                         0x8e52
#define GL_TEXTURE_2D_MULTISAMPLE                                    0x9100
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE                              0x9101
#define GL_TEXTURE_2D_MULTISAMPLE_ARRAY                              0x9102
#define GL_PROXY_TEXTURE_2D_MULTISAMPLE_ARRAY                        0x9103
#define GL_MAX_SAMPLE_MASK_WORDS                                     0x8e59
#define GL_MAX_COLOR_TEXTURE_SAMPLES                                 0x910e
#define GL_MAX_DEPTH_TEXTURE_SAMPLES                                 0x910f
#define GL_MAX_INTEGER_SAMPLES                                       0x9110
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE                            0x9104
#define GL_TEXTURE_BINDING_2D_MULTISAMPLE_ARRAY                      0x9105
#define GL_TEXTURE_SAMPLES                                           0x9106
#define GL_TEXTURE_FIXED_SAMPLE_LOCATIONS                            0x9107
#define GL_SAMPLER_2D_MULTISAMPLE                                    0x9108
#define GL_INT_SAMPLER_2D_MULTISAMPLE                                0x9109
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE                       0x910a
#define GL_SAMPLER_2D_MULTISAMPLE_ARRAY                              0x910b
#define GL_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                          0x910c
#define GL_UNSIGNED_INT_SAMPLER_2D_MULTISAMPLE_ARRAY                 0x910d

extern void (GLApi *GLFuncPtrName(glTexImage2DMultisample))(GLenum, GLsizei, int, GLsizei, GLsizei, GLboolean);
extern void (GLApi *GLFuncPtrName(glTexImage3DMultisample))(GLenum, GLsizei, int, GLsizei, GLsizei, GLsizei, GLboolean);
extern void (GLApi *GLFuncPtrName(glGetMultisamplefv))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glSampleMaski))(GLuint, GLbitfield);

#define glTexImage2DMultisample GLFuncPtrName(glTexImage2DMultisample)
#define glTexImage3DMultisample GLFuncPtrName(glTexImage3DMultisample)
#define glGetMultisamplefv GLFuncPtrName(glGetMultisamplefv)
#define glSampleMaski GLFuncPtrName(glSampleMaski)

#endif // GL_ARB_texture_multisample

//								--- GL_ARB_texture_non_power_of_two ---

#ifndef GL_ARB_texture_non_power_of_two
#define GL_ARB_texture_non_power_of_two 1

extern bool GLEH_ARB_texture_non_power_of_two; /**< set if GL_ARB_texture_non_power_of_two is supported */

// no new tokens
// no new procedures or functions

#endif // GL_ARB_texture_non_power_of_two

//								--- GL_ARB_texture_rectangle ---

#ifndef GL_ARB_texture_rectangle
#define GL_ARB_texture_rectangle 1

extern bool GLEH_ARB_texture_rectangle; /**< set if GL_ARB_texture_rectangle is supported */

#define GL_TEXTURE_RECTANGLE_ARB                                     0x84f5
#define GL_TEXTURE_BINDING_RECTANGLE_ARB                             0x84f6
#define GL_PROXY_TEXTURE_RECTANGLE_ARB                               0x84f7
#define GL_MAX_RECTANGLE_TEXTURE_SIZE_ARB                            0x84f8
#define GL_SAMPLER_2D_RECT_ARB                                       0x8b63
#define GL_SAMPLER_2D_RECT_SHADOW_ARB                                0x8b64

// no new procedures or functions

#endif // GL_ARB_texture_rectangle

//								--- GL_ARB_texture_rg ---

#ifndef GL_ARB_texture_rg
#define GL_ARB_texture_rg 1

extern bool GLEH_ARB_texture_rg; /**< set if GL_ARB_texture_rg is supported */

#define GL_R8                                                        0x8229
#define GL_R16                                                       0x822a
#define GL_RG8                                                       0x822b
#define GL_RG16                                                      0x822c
#define GL_R16F                                                      0x822d
#define GL_R32F                                                      0x822e
#define GL_RG16F                                                     0x822f
#define GL_RG32F                                                     0x8230
#define GL_R8I                                                       0x8231
#define GL_R8UI                                                      0x8232
#define GL_R16I                                                      0x8233
#define GL_R16UI                                                     0x8234
#define GL_R32I                                                      0x8235
#define GL_R32UI                                                     0x8236
#define GL_RG8I                                                      0x8237
#define GL_RG8UI                                                     0x8238
#define GL_RG16I                                                     0x8239
#define GL_RG16UI                                                    0x823a
#define GL_RG32I                                                     0x823b
#define GL_RG32UI                                                    0x823c
#define GL_RED                                                       0x1903
#define GL_RG                                                        0x8227
#define GL_COMPRESSED_RED                                            0x8225
#define GL_COMPRESSED_RG                                             0x8226
#define GL_RG                                                        0x8227
#define GL_RG_INTEGER                                                0x8228
#define GL_RG                                                        0x8227
#define GL_RED                                                       0x1903
#define GL_RG                                                        0x8227
#define GL_RG_INTEGER                                                0x8228

// no new procedures or functions

#endif // GL_ARB_texture_rg

//								--- GL_ARB_transpose_matrix ---

#ifndef GL_ARB_transpose_matrix
#define GL_ARB_transpose_matrix 1
#define __GENERATE_GL_ARB_transpose_matrix

extern bool GLEH_ARB_transpose_matrix; /**< set if GL_ARB_transpose_matrix is supported */

#define GL_TRANSPOSE_MODELVIEW_MATRIX_ARB                            0x84e3
#define GL_TRANSPOSE_PROJECTION_MATRIX_ARB                           0x84e4
#define GL_TRANSPOSE_TEXTURE_MATRIX_ARB                              0x84e5
#define GL_TRANSPOSE_COLOR_MATRIX_ARB                                0x84e6

extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixfARB))(float*);
extern void (GLApi *GLFuncPtrName(glLoadTransposeMatrixdARB))(double*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixfARB))(float*);
extern void (GLApi *GLFuncPtrName(glMultTransposeMatrixdARB))(double*);

#define glLoadTransposeMatrixfARB GLFuncPtrName(glLoadTransposeMatrixfARB)
#define glLoadTransposeMatrixdARB GLFuncPtrName(glLoadTransposeMatrixdARB)
#define glMultTransposeMatrixfARB GLFuncPtrName(glMultTransposeMatrixfARB)
#define glMultTransposeMatrixdARB GLFuncPtrName(glMultTransposeMatrixdARB)

#endif // GL_ARB_transpose_matrix

//								--- GL_ARB_uniform_buffer_object ---

#ifndef GL_ARB_uniform_buffer_object
#define GL_ARB_uniform_buffer_object 1
#define __GENERATE_GL_ARB_uniform_buffer_object

extern bool GLEH_ARB_uniform_buffer_object; /**< set if GL_ARB_uniform_buffer_object is supported */

#define GL_UNIFORM_BUFFER                                            0x8a11
#define GL_UNIFORM_BUFFER_BINDING                                    0x8a28
#define GL_UNIFORM_BUFFER_START                                      0x8a29
#define GL_UNIFORM_BUFFER_SIZE                                       0x8a2a
#define GL_MAX_VERTEX_UNIFORM_BLOCKS                                 0x8a2b
#define GL_MAX_GEOMETRY_UNIFORM_BLOCKS                               0x8a2c
#define GL_MAX_FRAGMENT_UNIFORM_BLOCKS                               0x8a2d
#define GL_MAX_COMBINED_UNIFORM_BLOCKS                               0x8a2e
#define GL_MAX_UNIFORM_BUFFER_BINDINGS                               0x8a2f
#define GL_MAX_UNIFORM_BLOCK_SIZE                                    0x8a30
#define GL_MAX_COMBINED_VERTEX_UNIFORM_COMPONENTS                    0x8a31
#define GL_MAX_COMBINED_GEOMETRY_UNIFORM_COMPONENTS                  0x8a32
#define GL_MAX_COMBINED_FRAGMENT_UNIFORM_COMPONENTS                  0x8a33
#define GL_UNIFORM_BUFFER_OFFSET_ALIGNMENT                           0x8a34
#define GL_ACTIVE_UNIFORM_BLOCK_MAX_NAME_LENGTH                      0x8a35
#define GL_ACTIVE_UNIFORM_BLOCKS                                     0x8a36
#define GL_UNIFORM_TYPE                                              0x8a37
#define GL_UNIFORM_SIZE                                              0x8a38
#define GL_UNIFORM_NAME_LENGTH                                       0x8a39
#define GL_UNIFORM_BLOCK_INDEX                                       0x8a3a
#define GL_UNIFORM_OFFSET                                            0x8a3b
#define GL_UNIFORM_ARRAY_STRIDE                                      0x8a3c
#define GL_UNIFORM_MATRIX_STRIDE                                     0x8a3d
#define GL_UNIFORM_IS_ROW_MAJOR                                      0x8a3e
#define GL_UNIFORM_BLOCK_BINDING                                     0x8a3f
#define GL_UNIFORM_BLOCK_DATA_SIZE                                   0x8a40
#define GL_UNIFORM_BLOCK_NAME_LENGTH                                 0x8a41
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORMS                             0x8a42
#define GL_UNIFORM_BLOCK_ACTIVE_UNIFORM_INDICES                      0x8a43
#define GL_UNIFORM_BLOCK_REFERENCED_BY_VERTEX_SHADER                 0x8a44
#define GL_UNIFORM_BLOCK_REFERENCED_BY_GEOMETRY_SHADER               0x8a45
#define GL_UNIFORM_BLOCK_REFERENCED_BY_FRAGMENT_SHADER               0x8a46
#define GL_INVALID_INDEX                                             0xffffffffu

extern void (GLApi *GLFuncPtrName(glGetUniformIndices))(GLuint, GLsizei, const GLchar**, GLuint*);
extern void (GLApi *GLFuncPtrName(glGetActiveUniformsiv))(GLuint, GLsizei, const GLuint*, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetActiveUniformName))(GLuint, GLuint, GLsizei, GLsizei*, GLchar*);
extern GLuint (GLApi *GLFuncPtrName(glGetUniformBlockIndex))(GLuint, const GLchar*);
extern void (GLApi *GLFuncPtrName(glGetActiveUniformBlockiv))(GLuint, GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetActiveUniformBlockName))(GLuint, GLuint, GLsizei, GLsizei*, GLchar*);
extern void (GLApi *GLFuncPtrName(glBindBufferRange))(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
extern void (GLApi *GLFuncPtrName(glBindBufferBase))(GLenum, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glGetIntegeri_v))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glUniformBlockBinding))(GLuint, GLuint, GLuint);

#define glGetUniformIndices GLFuncPtrName(glGetUniformIndices)
#define glGetActiveUniformsiv GLFuncPtrName(glGetActiveUniformsiv)
#define glGetActiveUniformName GLFuncPtrName(glGetActiveUniformName)
#define glGetUniformBlockIndex GLFuncPtrName(glGetUniformBlockIndex)
#define glGetActiveUniformBlockiv GLFuncPtrName(glGetActiveUniformBlockiv)
#define glGetActiveUniformBlockName GLFuncPtrName(glGetActiveUniformBlockName)
#define glBindBufferRange GLFuncPtrName(glBindBufferRange)
#define glBindBufferBase GLFuncPtrName(glBindBufferBase)
#define glGetIntegeri_v GLFuncPtrName(glGetIntegeri_v)
#define glUniformBlockBinding GLFuncPtrName(glUniformBlockBinding)

#endif // GL_ARB_uniform_buffer_object

//								--- GL_ARB_vertex_array_bgra ---

#ifndef GL_ARB_vertex_array_bgra
#define GL_ARB_vertex_array_bgra 1

extern bool GLEH_ARB_vertex_array_bgra; /**< set if GL_ARB_vertex_array_bgra is supported */

#ifndef GL_BGRA
#define GL_BGRA                                                      0x80e1
#endif // GL_BGRA

// no new procedures or functions

#endif // GL_ARB_vertex_array_bgra

//								--- GL_ARB_vertex_array_object ---

#ifndef GL_ARB_vertex_array_object
#define GL_ARB_vertex_array_object 1
#define __GENERATE_GL_ARB_vertex_array_object

extern bool GLEH_ARB_vertex_array_object; /**< set if GL_ARB_vertex_array_object is supported */

#define GL_VERTEX_ARRAY_BINDING                                      0x85b5

extern void (GLApi *GLFuncPtrName(glBindVertexArray))(GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteVertexArrays))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenVertexArrays))(GLsizei, GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsVertexArray))(GLuint);

#define glBindVertexArray GLFuncPtrName(glBindVertexArray)
#define glDeleteVertexArrays GLFuncPtrName(glDeleteVertexArrays)
#define glGenVertexArrays GLFuncPtrName(glGenVertexArrays)
#define glIsVertexArray GLFuncPtrName(glIsVertexArray)

#endif // GL_ARB_vertex_array_object

//								--- GL_ARB_vertex_buffer_object ---

#ifndef GL_ARB_vertex_buffer_object
#define GL_ARB_vertex_buffer_object 1
#define __GENERATE_GL_ARB_vertex_buffer_object

extern bool GLEH_ARB_vertex_buffer_object; /**< set if GL_ARB_vertex_buffer_object is supported */

#define GL_ARRAY_BUFFER_ARB                                          0x8892
#define GL_ELEMENT_ARRAY_BUFFER_ARB                                  0x8893
#define GL_ARRAY_BUFFER_BINDING_ARB                                  0x8894
#define GL_ELEMENT_ARRAY_BUFFER_BINDING_ARB                          0x8895
#define GL_VERTEX_ARRAY_BUFFER_BINDING_ARB                           0x8896
#define GL_NORMAL_ARRAY_BUFFER_BINDING_ARB                           0x8897
#define GL_COLOR_ARRAY_BUFFER_BINDING_ARB                            0x8898
#define GL_INDEX_ARRAY_BUFFER_BINDING_ARB                            0x8899
#define GL_TEXTURE_COORD_ARRAY_BUFFER_BINDING_ARB                    0x889a
#define GL_EDGE_FLAG_ARRAY_BUFFER_BINDING_ARB                        0x889b
#define GL_SECONDARY_COLOR_ARRAY_BUFFER_BINDING_ARB                  0x889c
#define GL_FOG_COORDINATE_ARRAY_BUFFER_BINDING_ARB                   0x889d
#define GL_WEIGHT_ARRAY_BUFFER_BINDING_ARB                           0x889e
#define GL_VERTEX_ATTRIB_ARRAY_BUFFER_BINDING_ARB                    0x889f
#define GL_STREAM_DRAW_ARB                                           0x88e0
#define GL_STREAM_READ_ARB                                           0x88e1
#define GL_STREAM_COPY_ARB                                           0x88e2
#define GL_STATIC_DRAW_ARB                                           0x88e4
#define GL_STATIC_READ_ARB                                           0x88e5
#define GL_STATIC_COPY_ARB                                           0x88e6
#define GL_DYNAMIC_DRAW_ARB                                          0x88e8
#define GL_DYNAMIC_READ_ARB                                          0x88e9
#define GL_DYNAMIC_COPY_ARB                                          0x88ea
#define GL_READ_ONLY_ARB                                             0x88b8
#define GL_WRITE_ONLY_ARB                                            0x88b9
#define GL_READ_WRITE_ARB                                            0x88ba
#define GL_BUFFER_SIZE_ARB                                           0x8764
#define GL_BUFFER_USAGE_ARB                                          0x8765
#define GL_BUFFER_ACCESS_ARB                                         0x88bb
#define GL_BUFFER_MAPPED_ARB                                         0x88bc
#define GL_BUFFER_MAP_POINTER_ARB                                    0x88bd

extern void (GLApi *GLFuncPtrName(glBindBufferARB))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteBuffersARB))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenBuffersARB))(GLsizei, GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsBufferARB))(GLuint);
extern void (GLApi *GLFuncPtrName(glBufferDataARB))(GLenum, GLsizeiptrARB, const void*, GLenum);
extern void (GLApi *GLFuncPtrName(glBufferSubDataARB))(GLenum, GLintptrARB, GLsizeiptrARB, const void*);
extern void (GLApi *GLFuncPtrName(glGetBufferSubDataARB))(GLenum, GLintptrARB, GLsizeiptrARB, void*);
extern void* (GLApi *GLFuncPtrName(glMapBufferARB))(GLenum, GLenum);
extern GLboolean (GLApi *GLFuncPtrName(glUnmapBufferARB))(GLenum);
extern void (GLApi *GLFuncPtrName(glGetBufferParameterivARB))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetBufferPointervARB))(GLenum, GLenum, void**);

#define glBindBufferARB GLFuncPtrName(glBindBufferARB)
#define glDeleteBuffersARB GLFuncPtrName(glDeleteBuffersARB)
#define glGenBuffersARB GLFuncPtrName(glGenBuffersARB)
#define glIsBufferARB GLFuncPtrName(glIsBufferARB)
#define glBufferDataARB GLFuncPtrName(glBufferDataARB)
#define glBufferSubDataARB GLFuncPtrName(glBufferSubDataARB)
#define glGetBufferSubDataARB GLFuncPtrName(glGetBufferSubDataARB)
#define glMapBufferARB GLFuncPtrName(glMapBufferARB)
#define glUnmapBufferARB GLFuncPtrName(glUnmapBufferARB)
#define glGetBufferParameterivARB GLFuncPtrName(glGetBufferParameterivARB)
#define glGetBufferPointervARB GLFuncPtrName(glGetBufferPointervARB)

#endif // GL_ARB_vertex_buffer_object

//								--- GL_ARB_vertex_program ---

#ifndef GL_ARB_vertex_program
#define GL_ARB_vertex_program 1
#define __GENERATE_GL_ARB_vertex_program

extern bool GLEH_ARB_vertex_program; /**< set if GL_ARB_vertex_program is supported */

#define GL_VERTEX_PROGRAM_ARB                                        0x8620
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                             0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                               0x8643
#define GL_COLOR_SUM_ARB                                             0x8458
#define GL_PROGRAM_FORMAT_ASCII_ARB                                  0x8875
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                           0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                              0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                            0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                              0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                        0x886a
#define GL_CURRENT_VERTEX_ATTRIB_ARB                                 0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                           0x8645
#define GL_PROGRAM_LENGTH_ARB                                        0x8627
#define GL_PROGRAM_FORMAT_ARB                                        0x8876
#define GL_PROGRAM_BINDING_ARB                                       0x8677
#define GL_PROGRAM_INSTRUCTIONS_ARB                                  0x88a0
#define GL_MAX_PROGRAM_INSTRUCTIONS_ARB                              0x88a1
#define GL_PROGRAM_NATIVE_INSTRUCTIONS_ARB                           0x88a2
#define GL_MAX_PROGRAM_NATIVE_INSTRUCTIONS_ARB                       0x88a3
#define GL_PROGRAM_TEMPORARIES_ARB                                   0x88a4
#define GL_MAX_PROGRAM_TEMPORARIES_ARB                               0x88a5
#define GL_PROGRAM_NATIVE_TEMPORARIES_ARB                            0x88a6
#define GL_MAX_PROGRAM_NATIVE_TEMPORARIES_ARB                        0x88a7
#define GL_PROGRAM_PARAMETERS_ARB                                    0x88a8
#define GL_MAX_PROGRAM_PARAMETERS_ARB                                0x88a9
#define GL_PROGRAM_NATIVE_PARAMETERS_ARB                             0x88aa
#define GL_MAX_PROGRAM_NATIVE_PARAMETERS_ARB                         0x88ab
#define GL_PROGRAM_ATTRIBS_ARB                                       0x88ac
#define GL_MAX_PROGRAM_ATTRIBS_ARB                                   0x88ad
#define GL_PROGRAM_NATIVE_ATTRIBS_ARB                                0x88ae
#define GL_MAX_PROGRAM_NATIVE_ATTRIBS_ARB                            0x88af
#define GL_PROGRAM_ADDRESS_REGISTERS_ARB                             0x88b0
#define GL_MAX_PROGRAM_ADDRESS_REGISTERS_ARB                         0x88b1
#define GL_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                      0x88b2
#define GL_MAX_PROGRAM_NATIVE_ADDRESS_REGISTERS_ARB                  0x88b3
#define GL_MAX_PROGRAM_LOCAL_PARAMETERS_ARB                          0x88b4
#define GL_MAX_PROGRAM_ENV_PARAMETERS_ARB                            0x88b5
#define GL_PROGRAM_UNDER_NATIVE_LIMITS_ARB                           0x88b6
#define GL_PROGRAM_STRING_ARB                                        0x8628
#define GL_PROGRAM_ERROR_POSITION_ARB                                0x864b
#define GL_CURRENT_MATRIX_ARB                                        0x8641
#define GL_TRANSPOSE_CURRENT_MATRIX_ARB                              0x88b7
#define GL_CURRENT_MATRIX_STACK_DEPTH_ARB                            0x8640
#define GL_MAX_VERTEX_ATTRIBS_ARB                                    0x8869
#define GL_MAX_PROGRAM_MATRICES_ARB                                  0x862f
#define GL_MAX_PROGRAM_MATRIX_STACK_DEPTH_ARB                        0x862e
#define GL_PROGRAM_ERROR_STRING_ARB                                  0x8874
#define GL_MATRIX0_ARB                                               0x88c0
#define GL_MATRIX1_ARB                                               0x88c1
#define GL_MATRIX2_ARB                                               0x88c2
#define GL_MATRIX3_ARB                                               0x88c3
#define GL_MATRIX4_ARB                                               0x88c4
#define GL_MATRIX5_ARB                                               0x88c5
#define GL_MATRIX6_ARB                                               0x88c6
#define GL_MATRIX7_ARB                                               0x88c7
#define GL_MATRIX8_ARB                                               0x88c8
#define GL_MATRIX9_ARB                                               0x88c9
#define GL_MATRIX10_ARB                                              0x88ca
#define GL_MATRIX11_ARB                                              0x88cb
#define GL_MATRIX12_ARB                                              0x88cc
#define GL_MATRIX13_ARB                                              0x88cd
#define GL_MATRIX14_ARB                                              0x88ce
#define GL_MATRIX15_ARB                                              0x88cf
#define GL_MATRIX16_ARB                                              0x88d0
#define GL_MATRIX17_ARB                                              0x88d1
#define GL_MATRIX18_ARB                                              0x88d2
#define GL_MATRIX19_ARB                                              0x88d3
#define GL_MATRIX20_ARB                                              0x88d4
#define GL_MATRIX21_ARB                                              0x88d5
#define GL_MATRIX22_ARB                                              0x88d6
#define GL_MATRIX23_ARB                                              0x88d7
#define GL_MATRIX24_ARB                                              0x88d8
#define GL_MATRIX25_ARB                                              0x88d9
#define GL_MATRIX26_ARB                                              0x88da
#define GL_MATRIX27_ARB                                              0x88db
#define GL_MATRIX28_ARB                                              0x88dc
#define GL_MATRIX29_ARB                                              0x88dd
#define GL_MATRIX30_ARB                                              0x88de
#define GL_MATRIX31_ARB                                              0x88df

/*extern void (GLApi *GLFuncPtrName(glVertexAttrib1sARB))(GLuint, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fARB))(GLuint, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dARB))(GLuint, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2sARB))(GLuint, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fARB))(GLuint, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dARB))(GLuint, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3sARB))(GLuint, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fARB))(GLuint, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dARB))(GLuint, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4sARB))(GLuint, short, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fARB))(GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dARB))(GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NubARB))(GLuint, GLubyte, GLubyte, GLubyte, GLubyte);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4bvARB))(GLuint, const GLbyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ivARB))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubvARB))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4usvARB))(GLuint, const GLushort*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4uivARB))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NbvARB))(GLuint, const GLbyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NsvARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NivARB))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NubvARB))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NusvARB))(GLuint, const GLushort*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NuivARB))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribPointerARB))(GLuint, int, GLenum, GLboolean, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glEnableVertexAttribArrayARB))(GLuint);
extern void (GLApi *GLFuncPtrName(glDisableVertexAttribArrayARB))(GLuint);*/
extern void (GLApi *GLFuncPtrName(glProgramStringARB))(GLenum, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glBindProgramARB))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteProgramsARB))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenProgramsARB))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4dARB))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4dvARB))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4fARB))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameter4fvARB))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dARB))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dvARB))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fARB))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fvARB))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterdvARB))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterfvARB))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterdvARB))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterfvARB))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramivARB))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetProgramStringARB))(GLenum, GLenum, void*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribdvARB))(GLuint, GLenum, double*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribfvARB))(GLuint, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribivARB))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribPointervARB))(GLuint, GLenum, void**);
extern GLboolean (GLApi *GLFuncPtrName(glIsProgramARB))(GLuint);

#define glVertexAttrib1sARB GLFuncPtrName(glVertexAttrib1sARB)
#define glVertexAttrib1fARB GLFuncPtrName(glVertexAttrib1fARB)
#define glVertexAttrib1dARB GLFuncPtrName(glVertexAttrib1dARB)
#define glVertexAttrib2sARB GLFuncPtrName(glVertexAttrib2sARB)
#define glVertexAttrib2fARB GLFuncPtrName(glVertexAttrib2fARB)
#define glVertexAttrib2dARB GLFuncPtrName(glVertexAttrib2dARB)
#define glVertexAttrib3sARB GLFuncPtrName(glVertexAttrib3sARB)
#define glVertexAttrib3fARB GLFuncPtrName(glVertexAttrib3fARB)
#define glVertexAttrib3dARB GLFuncPtrName(glVertexAttrib3dARB)
#define glVertexAttrib4sARB GLFuncPtrName(glVertexAttrib4sARB)
#define glVertexAttrib4fARB GLFuncPtrName(glVertexAttrib4fARB)
#define glVertexAttrib4dARB GLFuncPtrName(glVertexAttrib4dARB)
#define glVertexAttrib4NubARB GLFuncPtrName(glVertexAttrib4NubARB)
#define glVertexAttrib1svARB GLFuncPtrName(glVertexAttrib1svARB)
#define glVertexAttrib1fvARB GLFuncPtrName(glVertexAttrib1fvARB)
#define glVertexAttrib1dvARB GLFuncPtrName(glVertexAttrib1dvARB)
#define glVertexAttrib2svARB GLFuncPtrName(glVertexAttrib2svARB)
#define glVertexAttrib2fvARB GLFuncPtrName(glVertexAttrib2fvARB)
#define glVertexAttrib2dvARB GLFuncPtrName(glVertexAttrib2dvARB)
#define glVertexAttrib3svARB GLFuncPtrName(glVertexAttrib3svARB)
#define glVertexAttrib3fvARB GLFuncPtrName(glVertexAttrib3fvARB)
#define glVertexAttrib3dvARB GLFuncPtrName(glVertexAttrib3dvARB)
#define glVertexAttrib4bvARB GLFuncPtrName(glVertexAttrib4bvARB)
#define glVertexAttrib4svARB GLFuncPtrName(glVertexAttrib4svARB)
#define glVertexAttrib4ivARB GLFuncPtrName(glVertexAttrib4ivARB)
#define glVertexAttrib4ubvARB GLFuncPtrName(glVertexAttrib4ubvARB)
#define glVertexAttrib4usvARB GLFuncPtrName(glVertexAttrib4usvARB)
#define glVertexAttrib4uivARB GLFuncPtrName(glVertexAttrib4uivARB)
#define glVertexAttrib4fvARB GLFuncPtrName(glVertexAttrib4fvARB)
#define glVertexAttrib4dvARB GLFuncPtrName(glVertexAttrib4dvARB)
#define glVertexAttrib4NbvARB GLFuncPtrName(glVertexAttrib4NbvARB)
#define glVertexAttrib4NsvARB GLFuncPtrName(glVertexAttrib4NsvARB)
#define glVertexAttrib4NivARB GLFuncPtrName(glVertexAttrib4NivARB)
#define glVertexAttrib4NubvARB GLFuncPtrName(glVertexAttrib4NubvARB)
#define glVertexAttrib4NusvARB GLFuncPtrName(glVertexAttrib4NusvARB)
#define glVertexAttrib4NuivARB GLFuncPtrName(glVertexAttrib4NuivARB)
#define glVertexAttribPointerARB GLFuncPtrName(glVertexAttribPointerARB)
#define glEnableVertexAttribArrayARB GLFuncPtrName(glEnableVertexAttribArrayARB)
#define glDisableVertexAttribArrayARB GLFuncPtrName(glDisableVertexAttribArrayARB)
#define glProgramStringARB GLFuncPtrName(glProgramStringARB)
#define glBindProgramARB GLFuncPtrName(glBindProgramARB)
#define glDeleteProgramsARB GLFuncPtrName(glDeleteProgramsARB)
#define glGenProgramsARB GLFuncPtrName(glGenProgramsARB)
#define glProgramEnvParameter4dARB GLFuncPtrName(glProgramEnvParameter4dARB)
#define glProgramEnvParameter4dvARB GLFuncPtrName(glProgramEnvParameter4dvARB)
#define glProgramEnvParameter4fARB GLFuncPtrName(glProgramEnvParameter4fARB)
#define glProgramEnvParameter4fvARB GLFuncPtrName(glProgramEnvParameter4fvARB)
#define glProgramLocalParameter4dARB GLFuncPtrName(glProgramLocalParameter4dARB)
#define glProgramLocalParameter4dvARB GLFuncPtrName(glProgramLocalParameter4dvARB)
#define glProgramLocalParameter4fARB GLFuncPtrName(glProgramLocalParameter4fARB)
#define glProgramLocalParameter4fvARB GLFuncPtrName(glProgramLocalParameter4fvARB)
#define glGetProgramEnvParameterdvARB GLFuncPtrName(glGetProgramEnvParameterdvARB)
#define glGetProgramEnvParameterfvARB GLFuncPtrName(glGetProgramEnvParameterfvARB)
#define glGetProgramLocalParameterdvARB GLFuncPtrName(glGetProgramLocalParameterdvARB)
#define glGetProgramLocalParameterfvARB GLFuncPtrName(glGetProgramLocalParameterfvARB)
#define glGetProgramivARB GLFuncPtrName(glGetProgramivARB)
#define glGetProgramStringARB GLFuncPtrName(glGetProgramStringARB)
#define glGetVertexAttribdvARB GLFuncPtrName(glGetVertexAttribdvARB)
#define glGetVertexAttribfvARB GLFuncPtrName(glGetVertexAttribfvARB)
#define glGetVertexAttribivARB GLFuncPtrName(glGetVertexAttribivARB)
#define glGetVertexAttribPointervARB GLFuncPtrName(glGetVertexAttribPointervARB)
#define glIsProgramARB GLFuncPtrName(glIsProgramARB)

#endif // GL_ARB_vertex_program

//								--- GL_ARB_vertex_shader ---

#ifndef GL_ARB_vertex_shader
#define GL_ARB_vertex_shader 1
#define __GENERATE_GL_ARB_vertex_shader

extern bool GLEH_ARB_vertex_shader; /**< set if GL_ARB_vertex_shader is supported */

#define GL_VERTEX_SHADER_ARB                                         0x8b31
#define GL_MAX_VERTEX_UNIFORM_COMPONENTS_ARB                         0x8b4a
#define GL_MAX_VARYING_FLOATS_ARB                                    0x8b4b
#define GL_MAX_VERTEX_ATTRIBS_ARB                                    0x8869
#define GL_MAX_TEXTURE_IMAGE_UNITS_ARB                               0x8872
#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB                        0x8b4c
#define GL_MAX_COMBINED_TEXTURE_IMAGE_UNITS_ARB                      0x8b4d
#define GL_MAX_TEXTURE_COORDS_ARB                                    0x8871
#define GL_VERTEX_PROGRAM_POINT_SIZE_ARB                             0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_ARB                               0x8643
#define GL_OBJECT_ACTIVE_ATTRIBUTES_ARB                              0x8b89
#define GL_OBJECT_ACTIVE_ATTRIBUTE_MAX_LENGTH_ARB                    0x8b8a
#define GL_VERTEX_ATTRIB_ARRAY_ENABLED_ARB                           0x8622
#define GL_VERTEX_ATTRIB_ARRAY_SIZE_ARB                              0x8623
#define GL_VERTEX_ATTRIB_ARRAY_STRIDE_ARB                            0x8624
#define GL_VERTEX_ATTRIB_ARRAY_TYPE_ARB                              0x8625
#define GL_VERTEX_ATTRIB_ARRAY_NORMALIZED_ARB                        0x886a
#define GL_CURRENT_VERTEX_ATTRIB_ARB                                 0x8626
#define GL_VERTEX_ATTRIB_ARRAY_POINTER_ARB                           0x8645
#define GL_FLOAT                                                     0x1406
#define GL_FLOAT_VEC2_ARB                                            0x8b50
#define GL_FLOAT_VEC3_ARB                                            0x8b51
#define GL_FLOAT_VEC4_ARB                                            0x8b52
#define GL_FLOAT_MAT2_ARB                                            0x8b5a
#define GL_FLOAT_MAT3_ARB                                            0x8b5b
#define GL_FLOAT_MAT4_ARB                                            0x8b5c

extern void (GLApi *GLFuncPtrName(glVertexAttrib1fARB))(GLuint, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1sARB))(GLuint, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dARB))(GLuint, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fARB))(GLuint, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2sARB))(GLuint, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dARB))(GLuint, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fARB))(GLuint, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3sARB))(GLuint, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dARB))(GLuint, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fARB))(GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4sARB))(GLuint, short, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dARB))(GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NubARB))(GLuint, GLubyte, GLubyte, GLubyte, GLubyte);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fvARB))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4svARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dvARB))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ivARB))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4bvARB))(GLuint, const GLbyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubvARB))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4usvARB))(GLuint, const GLushort*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4uivARB))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NbvARB))(GLuint, const GLbyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NsvARB))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NivARB))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NubvARB))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NusvARB))(GLuint, const GLushort*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4NuivARB))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribPointerARB))(GLuint, int, GLenum, GLboolean, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glEnableVertexAttribArrayARB))(GLuint);
extern void (GLApi *GLFuncPtrName(glDisableVertexAttribArrayARB))(GLuint);
extern void (GLApi *GLFuncPtrName(glBindAttribLocationARB))(GLhandleARB, GLuint, const GLcharARB*);
extern void (GLApi *GLFuncPtrName(glGetActiveAttribARB))(GLhandleARB, GLuint, GLsizei, GLsizei*, int*, GLenum*, GLcharARB*);
extern int (GLApi *GLFuncPtrName(glGetAttribLocationARB))(GLhandleARB, const GLcharARB*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribdvARB))(GLuint, GLenum, double*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribfvARB))(GLuint, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribivARB))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribPointervARB))(GLuint, GLenum, void**);

#define glVertexAttrib1fARB GLFuncPtrName(glVertexAttrib1fARB)
#define glVertexAttrib1sARB GLFuncPtrName(glVertexAttrib1sARB)
#define glVertexAttrib1dARB GLFuncPtrName(glVertexAttrib1dARB)
#define glVertexAttrib2fARB GLFuncPtrName(glVertexAttrib2fARB)
#define glVertexAttrib2sARB GLFuncPtrName(glVertexAttrib2sARB)
#define glVertexAttrib2dARB GLFuncPtrName(glVertexAttrib2dARB)
#define glVertexAttrib3fARB GLFuncPtrName(glVertexAttrib3fARB)
#define glVertexAttrib3sARB GLFuncPtrName(glVertexAttrib3sARB)
#define glVertexAttrib3dARB GLFuncPtrName(glVertexAttrib3dARB)
#define glVertexAttrib4fARB GLFuncPtrName(glVertexAttrib4fARB)
#define glVertexAttrib4sARB GLFuncPtrName(glVertexAttrib4sARB)
#define glVertexAttrib4dARB GLFuncPtrName(glVertexAttrib4dARB)
#define glVertexAttrib4NubARB GLFuncPtrName(glVertexAttrib4NubARB)
#define glVertexAttrib1fvARB GLFuncPtrName(glVertexAttrib1fvARB)
#define glVertexAttrib1svARB GLFuncPtrName(glVertexAttrib1svARB)
#define glVertexAttrib1dvARB GLFuncPtrName(glVertexAttrib1dvARB)
#define glVertexAttrib2fvARB GLFuncPtrName(glVertexAttrib2fvARB)
#define glVertexAttrib2svARB GLFuncPtrName(glVertexAttrib2svARB)
#define glVertexAttrib2dvARB GLFuncPtrName(glVertexAttrib2dvARB)
#define glVertexAttrib3fvARB GLFuncPtrName(glVertexAttrib3fvARB)
#define glVertexAttrib3svARB GLFuncPtrName(glVertexAttrib3svARB)
#define glVertexAttrib3dvARB GLFuncPtrName(glVertexAttrib3dvARB)
#define glVertexAttrib4fvARB GLFuncPtrName(glVertexAttrib4fvARB)
#define glVertexAttrib4svARB GLFuncPtrName(glVertexAttrib4svARB)
#define glVertexAttrib4dvARB GLFuncPtrName(glVertexAttrib4dvARB)
#define glVertexAttrib4ivARB GLFuncPtrName(glVertexAttrib4ivARB)
#define glVertexAttrib4bvARB GLFuncPtrName(glVertexAttrib4bvARB)
#define glVertexAttrib4ubvARB GLFuncPtrName(glVertexAttrib4ubvARB)
#define glVertexAttrib4usvARB GLFuncPtrName(glVertexAttrib4usvARB)
#define glVertexAttrib4uivARB GLFuncPtrName(glVertexAttrib4uivARB)
#define glVertexAttrib4NbvARB GLFuncPtrName(glVertexAttrib4NbvARB)
#define glVertexAttrib4NsvARB GLFuncPtrName(glVertexAttrib4NsvARB)
#define glVertexAttrib4NivARB GLFuncPtrName(glVertexAttrib4NivARB)
#define glVertexAttrib4NubvARB GLFuncPtrName(glVertexAttrib4NubvARB)
#define glVertexAttrib4NusvARB GLFuncPtrName(glVertexAttrib4NusvARB)
#define glVertexAttrib4NuivARB GLFuncPtrName(glVertexAttrib4NuivARB)
#define glVertexAttribPointerARB GLFuncPtrName(glVertexAttribPointerARB)
#define glEnableVertexAttribArrayARB GLFuncPtrName(glEnableVertexAttribArrayARB)
#define glDisableVertexAttribArrayARB GLFuncPtrName(glDisableVertexAttribArrayARB)
#define glBindAttribLocationARB GLFuncPtrName(glBindAttribLocationARB)
#define glGetActiveAttribARB GLFuncPtrName(glGetActiveAttribARB)
#define glGetAttribLocationARB GLFuncPtrName(glGetAttribLocationARB)
#define glGetVertexAttribdvARB GLFuncPtrName(glGetVertexAttribdvARB)
#define glGetVertexAttribfvARB GLFuncPtrName(glGetVertexAttribfvARB)
#define glGetVertexAttribivARB GLFuncPtrName(glGetVertexAttribivARB)
#define glGetVertexAttribPointervARB GLFuncPtrName(glGetVertexAttribPointervARB)

#endif // GL_ARB_vertex_shader

//								--- GL_ARB_window_pos ---

#ifndef GL_ARB_window_pos
#define GL_ARB_window_pos 1
#define __GENERATE_GL_ARB_window_pos

extern bool GLEH_ARB_window_pos; /**< set if GL_ARB_window_pos is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glWindowPos2dARB))(double, double);
extern void (GLApi *GLFuncPtrName(glWindowPos2fARB))(float, float);
extern void (GLApi *GLFuncPtrName(glWindowPos2iARB))(int, int);
extern void (GLApi *GLFuncPtrName(glWindowPos2sARB))(short, short);
extern void (GLApi *GLFuncPtrName(glWindowPos2dvARB))(const double*);
extern void (GLApi *GLFuncPtrName(glWindowPos2fvARB))(const float*);
extern void (GLApi *GLFuncPtrName(glWindowPos2ivARB))(const int*);
extern void (GLApi *GLFuncPtrName(glWindowPos2svARB))(const short*);
extern void (GLApi *GLFuncPtrName(glWindowPos3dARB))(double, double, double);
extern void (GLApi *GLFuncPtrName(glWindowPos3fARB))(float, float, float);
extern void (GLApi *GLFuncPtrName(glWindowPos3iARB))(int, int, int);
extern void (GLApi *GLFuncPtrName(glWindowPos3sARB))(short, short, short);
extern void (GLApi *GLFuncPtrName(glWindowPos3dvARB))(const double*);
extern void (GLApi *GLFuncPtrName(glWindowPos3fvARB))(const float*);
extern void (GLApi *GLFuncPtrName(glWindowPos3ivARB))(const int*);
extern void (GLApi *GLFuncPtrName(glWindowPos3svARB))(const short*);

#define glWindowPos2dARB GLFuncPtrName(glWindowPos2dARB)
#define glWindowPos2fARB GLFuncPtrName(glWindowPos2fARB)
#define glWindowPos2iARB GLFuncPtrName(glWindowPos2iARB)
#define glWindowPos2sARB GLFuncPtrName(glWindowPos2sARB)
#define glWindowPos2dvARB GLFuncPtrName(glWindowPos2dvARB)
#define glWindowPos2fvARB GLFuncPtrName(glWindowPos2fvARB)
#define glWindowPos2ivARB GLFuncPtrName(glWindowPos2ivARB)
#define glWindowPos2svARB GLFuncPtrName(glWindowPos2svARB)
#define glWindowPos3dARB GLFuncPtrName(glWindowPos3dARB)
#define glWindowPos3fARB GLFuncPtrName(glWindowPos3fARB)
#define glWindowPos3iARB GLFuncPtrName(glWindowPos3iARB)
#define glWindowPos3sARB GLFuncPtrName(glWindowPos3sARB)
#define glWindowPos3dvARB GLFuncPtrName(glWindowPos3dvARB)
#define glWindowPos3fvARB GLFuncPtrName(glWindowPos3fvARB)
#define glWindowPos3ivARB GLFuncPtrName(glWindowPos3ivARB)
#define glWindowPos3svARB GLFuncPtrName(glWindowPos3svARB)

#endif // GL_ARB_window_pos

//								--- GL_ATI_draw_buffers ---

#ifndef GL_ATI_draw_buffers
#define GL_ATI_draw_buffers 1
#define __GENERATE_GL_ATI_draw_buffers

extern bool GLEH_ATI_draw_buffers; /**< set if GL_ATI_draw_buffers is supported */

#define GL_MAX_DRAW_BUFFERS_ATI                                      0x8824
#define GL_DRAW_BUFFER0_ATI                                          0x8825
#define GL_DRAW_BUFFER1_ATI                                          0x8826
#define GL_DRAW_BUFFER2_ATI                                          0x8827
#define GL_DRAW_BUFFER3_ATI                                          0x8828
#define GL_DRAW_BUFFER4_ATI                                          0x8829
#define GL_DRAW_BUFFER5_ATI                                          0x882a
#define GL_DRAW_BUFFER6_ATI                                          0x882b
#define GL_DRAW_BUFFER7_ATI                                          0x882c
#define GL_DRAW_BUFFER8_ATI                                          0x882d
#define GL_DRAW_BUFFER9_ATI                                          0x882e
#define GL_DRAW_BUFFER10_ATI                                         0x882f
#define GL_DRAW_BUFFER11_ATI                                         0x8830
#define GL_DRAW_BUFFER12_ATI                                         0x8831
#define GL_DRAW_BUFFER13_ATI                                         0x8832
#define GL_DRAW_BUFFER14_ATI                                         0x8833
#define GL_DRAW_BUFFER15_ATI                                         0x8834

extern void (GLApi *GLFuncPtrName(glDrawBuffersATI))(GLsizei, const GLenum*);

#define glDrawBuffersATI GLFuncPtrName(glDrawBuffersATI)

#endif // GL_ATI_draw_buffers

//								--- GL_ATI_texture_float ---

#ifndef GL_ATI_texture_float
#define GL_ATI_texture_float 1

extern bool GLEH_ATI_texture_float; /**< set if GL_ATI_texture_float is supported */

#define GL_RGBA_FLOAT32_ATI                                          0x8814
#define GL_RGB_FLOAT32_ATI                                           0x8815
#define GL_ALPHA_FLOAT32_ATI                                         0x8816
#define GL_INTENSITY_FLOAT32_ATI                                     0x8817
#define GL_LUMINANCE_FLOAT32_ATI                                     0x8818
#define GL_LUMINANCE_ALPHA_FLOAT32_ATI                               0x8819
#define GL_RGBA_FLOAT16_ATI                                          0x881a
#define GL_RGB_FLOAT16_ATI                                           0x881b
#define GL_ALPHA_FLOAT16_ATI                                         0x881c
#define GL_INTENSITY_FLOAT16_ATI                                     0x881d
#define GL_LUMINANCE_FLOAT16_ATI                                     0x881e
#define GL_LUMINANCE_ALPHA_FLOAT16_ATI                               0x881f

// no new procedures or functions

#endif // GL_ATI_texture_float

//								--- GL_ATI_texture_mirror_once ---

#ifndef GL_ATI_texture_mirror_once
#define GL_ATI_texture_mirror_once 1

extern bool GLEH_ATI_texture_mirror_once; /**< set if GL_ATI_texture_mirror_once is supported */

#define GL_MIRROR_CLAMP_ATI                                          0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_ATI                                  0x8743

// no new procedures or functions

#endif // GL_ATI_texture_mirror_once

//								--- GL_S3_s3tc ---

#ifndef GL_S3_s3tc
#define GL_S3_s3tc 1

extern bool GLEH_S3_s3tc; /**< set if GL_S3_s3tc is supported */

#define GL_RGB_S3TC                                                  0x83a0
#define GL_RGB4_S3TC                                                 0x83a1
#define GL_RGBA_S3TC                                                 0x83a2
#define GL_RGBA4_S3TC                                                0x83a3
#define GL_RGBA_DXT5_S3TC                                            0x83a4
#define GL_RGBA4_DXT5_S3TC                                           0x83a5

// no new procedures or functions

#endif // GL_S3_s3tc

//								--- GL_EXT_texture_env_add ---

#ifndef GL_EXT_texture_env_add
#define GL_EXT_texture_env_add 1

extern bool GLEH_EXT_texture_env_add; /**< set if GL_EXT_texture_env_add is supported */

// no new tokens
// no new procedures or functions

#endif // GL_EXT_texture_env_add

//								--- GL_EXT_abgr ---

#ifndef GL_EXT_abgr
#define GL_EXT_abgr 1

extern bool GLEH_EXT_abgr; /**< set if GL_EXT_abgr is supported */

#define GL_ABGR_EXT                                                  0x8000

// no new procedures or functions

#endif // GL_EXT_abgr

//								--- GL_EXT_bgra ---

#ifndef GL_EXT_bgra
#define GL_EXT_bgra 1

extern bool GLEH_EXT_bgra; /**< set if GL_EXT_bgra is supported */

#define GL_BGR_EXT                                                   0x80e0
#define GL_BGRA_EXT                                                  0x80e1

// no new procedures or functions

#endif // GL_EXT_bgra

//								--- GL_EXT_bindable_uniform ---

#ifndef GL_EXT_bindable_uniform
#define GL_EXT_bindable_uniform 1
#define __GENERATE_GL_EXT_bindable_uniform

extern bool GLEH_EXT_bindable_uniform; /**< set if GL_EXT_bindable_uniform is supported */

#define GL_MAX_VERTEX_BINDABLE_UNIFORMS_EXT                          0x8de2
#define GL_MAX_FRAGMENT_BINDABLE_UNIFORMS_EXT                        0x8de3
#define GL_MAX_GEOMETRY_BINDABLE_UNIFORMS_EXT                        0x8de4
#define GL_MAX_BINDABLE_UNIFORM_SIZE_EXT                             0x8ded
#define GL_UNIFORM_BUFFER_BINDING_EXT                                0x8def
#define GL_UNIFORM_BUFFER_EXT                                        0x8dee

extern void (GLApi *GLFuncPtrName(glUniformBufferEXT))(GLuint, int, GLuint);
extern int (GLApi *GLFuncPtrName(glGetUniformBufferSizeEXT))(GLuint, int);
extern GLintptr (GLApi *GLFuncPtrName(glGetUniformOffsetEXT))(GLuint, int);

#define glUniformBufferEXT GLFuncPtrName(glUniformBufferEXT)
#define glGetUniformBufferSizeEXT GLFuncPtrName(glGetUniformBufferSizeEXT)
#define glGetUniformOffsetEXT GLFuncPtrName(glGetUniformOffsetEXT)

#endif // GL_EXT_bindable_uniform

//								--- GL_EXT_blend_color ---

#ifndef GL_EXT_blend_color
#define GL_EXT_blend_color 1
#define __GENERATE_GL_EXT_blend_color

extern bool GLEH_EXT_blend_color; /**< set if GL_EXT_blend_color is supported */

#define GL_CONSTANT_COLOR_EXT                                        0x8001
#define GL_ONE_MINUS_CONSTANT_COLOR_EXT                              0x8002
#define GL_CONSTANT_ALPHA_EXT                                        0x8003
#define GL_ONE_MINUS_CONSTANT_ALPHA_EXT                              0x8004
#define GL_BLEND_COLOR_EXT                                           0x8005

extern void (GLApi *GLFuncPtrName(glBlendColorEXT))(GLclampf, GLclampf, GLclampf, GLclampf);

#define glBlendColorEXT GLFuncPtrName(glBlendColorEXT)

#endif // GL_EXT_blend_color

//								--- GL_EXT_blend_equation_separate ---

#ifndef GL_EXT_blend_equation_separate
#define GL_EXT_blend_equation_separate 1
#define __GENERATE_GL_EXT_blend_equation_separate

extern bool GLEH_EXT_blend_equation_separate; /**< set if GL_EXT_blend_equation_separate is supported */

#define GL_BLEND_EQUATION_RGB_EXT                                    0x8009
#define GL_BLEND_EQUATION_ALPHA_EXT                                  0x883d

extern void (GLApi *GLFuncPtrName(glBlendEquationSeparateEXT))(GLenum, GLenum);

#define glBlendEquationSeparateEXT GLFuncPtrName(glBlendEquationSeparateEXT)

#endif // GL_EXT_blend_equation_separate

//								--- GL_EXT_blend_func_separate ---

#ifndef GL_EXT_blend_func_separate
#define GL_EXT_blend_func_separate 1
#define __GENERATE_GL_EXT_blend_func_separate

extern bool GLEH_EXT_blend_func_separate; /**< set if GL_EXT_blend_func_separate is supported */

#define GL_BLEND_DST_RGB_EXT                                         0x80c8
#define GL_BLEND_SRC_RGB_EXT                                         0x80c9
#define GL_BLEND_DST_ALPHA_EXT                                       0x80ca
#define GL_BLEND_SRC_ALPHA_EXT                                       0x80cb

extern void (GLApi *GLFuncPtrName(glBlendFuncSeparateEXT))(GLenum, GLenum, GLenum, GLenum);

#define glBlendFuncSeparateEXT GLFuncPtrName(glBlendFuncSeparateEXT)

#endif // GL_EXT_blend_func_separate

//								--- GL_EXT_blend_minmax ---

#ifndef GL_EXT_blend_minmax
#define GL_EXT_blend_minmax 1
#define __GENERATE_GL_EXT_blend_minmax

extern bool GLEH_EXT_blend_minmax; /**< set if GL_EXT_blend_minmax is supported */

#define GL_FUNC_ADD_EXT                                              0x8006
#define GL_MIN_EXT                                                   0x8007
#define GL_MAX_EXT                                                   0x8008
#define GL_BLEND_EQUATION_EXT                                        0x8009

extern void (GLApi *GLFuncPtrName(glBlendEquationEXT))(GLenum);

#define glBlendEquationEXT GLFuncPtrName(glBlendEquationEXT)

#endif // GL_EXT_blend_minmax

//								--- GL_EXT_blend_subtract ---

#ifndef GL_EXT_blend_subtract
#define GL_EXT_blend_subtract 1

extern bool GLEH_EXT_blend_subtract; /**< set if GL_EXT_blend_subtract is supported */

#define GL_FUNC_SUBTRACT_EXT                                         0x800a
#define GL_FUNC_REVERSE_SUBTRACT_EXT                                 0x800b

// no new procedures or functions

#endif // GL_EXT_blend_subtract

//								--- GL_EXT_depth_bounds_test ---

#ifndef GL_EXT_depth_bounds_test
#define GL_EXT_depth_bounds_test 1
#define __GENERATE_GL_EXT_depth_bounds_test

extern bool GLEH_EXT_depth_bounds_test; /**< set if GL_EXT_depth_bounds_test is supported */

#define GL_DEPTH_BOUNDS_TEST_EXT                                     0x8890
#define GL_DEPTH_BOUNDS_EXT                                          0x8891

extern void (GLApi *GLFuncPtrName(glDepthBoundsEXT))(GLclampd, GLclampd);

#define glDepthBoundsEXT GLFuncPtrName(glDepthBoundsEXT)

#endif // GL_EXT_depth_bounds_test

//								--- GL_EXT_direct_state_access ---

#ifndef GL_EXT_direct_state_access
#define GL_EXT_direct_state_access 1
#define __GENERATE_GL_EXT_direct_state_access

extern bool GLEH_EXT_direct_state_access; /**< set if GL_EXT_direct_state_access is supported */

#define GL_PROGRAM_MATRIX_EXT                                        0x8e2d
#define GL_TRANSPOSE_PROGRAM_MATRIX_EXT                              0x8e2e
#define GL_PROGRAM_MATRIX_STACK_DEPTH_EXT                            0x8e2f

extern void (GLApi *GLFuncPtrName(glClientAttribDefaultEXT))(GLbitfield);
extern void (GLApi *GLFuncPtrName(glPushClientAttribDefaultEXT))(GLbitfield);
extern void (GLApi *GLFuncPtrName(glMatrixLoadfEXT))(GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMatrixLoaddEXT))(GLenum, const double*);
extern void (GLApi *GLFuncPtrName(glMatrixMultfEXT))(GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMatrixMultdEXT))(GLenum, const double*);
extern void (GLApi *GLFuncPtrName(glMatrixLoadIdentityEXT))(GLenum);
extern void (GLApi *GLFuncPtrName(glMatrixRotatefEXT))(GLenum, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glMatrixRotatedEXT))(GLenum, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glMatrixScalefEXT))(GLenum, float, float, float);
extern void (GLApi *GLFuncPtrName(glMatrixScaledEXT))(GLenum, double, double, double);
extern void (GLApi *GLFuncPtrName(glMatrixTranslatefEXT))(GLenum, float, float, float);
extern void (GLApi *GLFuncPtrName(glMatrixTranslatedEXT))(GLenum, double, double, double);
extern void (GLApi *GLFuncPtrName(glMatrixOrthoEXT))(GLenum, double, double, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glMatrixFrustumEXT))(GLenum, double, double, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glMatrixPushEXT))(GLenum);
extern void (GLApi *GLFuncPtrName(glMatrixPopEXT))(GLenum);
extern void (GLApi *GLFuncPtrName(glTextureParameteriEXT))(GLuint, GLenum, GLenum, int);
extern void (GLApi *GLFuncPtrName(glTextureParameterivEXT))(GLuint, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glTextureParameterfEXT))(GLuint, GLenum, GLenum, float);
extern void (GLApi *GLFuncPtrName(glTextureParameterfvEXT))(GLuint, GLenum, GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glTextureImage1DEXT))(GLuint, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glTextureImage2DEXT))(GLuint, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glTextureSubImage1DEXT))(GLuint, GLenum, int, int, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glTextureSubImage2DEXT))(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glCopyTextureImage1DEXT))(GLuint, GLenum, int, GLenum, int, int, GLsizei, int);
extern void (GLApi *GLFuncPtrName(glCopyTextureImage2DEXT))(GLuint, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int);
extern void (GLApi *GLFuncPtrName(glCopyTextureSubImage1DEXT))(GLuint, GLenum, int, int, int, int, GLsizei);
extern void (GLApi *GLFuncPtrName(glCopyTextureSubImage2DEXT))(GLuint, GLenum, int, int, int, int, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetTextureImageEXT))(GLuint, GLenum, int, GLenum, GLenum, void*);
extern void (GLApi *GLFuncPtrName(glGetTextureParameterfvEXT))(GLuint, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetTextureParameterivEXT))(GLuint, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetTextureLevelParameterfvEXT))(GLuint, GLenum, int, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetTextureLevelParameterivEXT))(GLuint, GLenum, int, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glTextureImage3DEXT))(GLuint, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glTextureSubImage3DEXT))(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glCopyTextureSubImage3DEXT))(GLuint, GLenum, int, int, int, int, int, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glBindMultiTextureEXT))(GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glMultiTexCoordPointerEXT))(GLenum, int, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glMultiTexEnvfEXT))(GLenum, GLenum, GLenum, float);
extern void (GLApi *GLFuncPtrName(glMultiTexEnvfvEXT))(GLenum, GLenum, GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMultiTexEnviEXT))(GLenum, GLenum, GLenum, int);
extern void (GLApi *GLFuncPtrName(glMultiTexEnvivEXT))(GLenum, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glMultiTexGendEXT))(GLenum, GLenum, GLenum, double);
extern void (GLApi *GLFuncPtrName(glMultiTexGendvEXT))(GLenum, GLenum, GLenum, const double*);
extern void (GLApi *GLFuncPtrName(glMultiTexGenfEXT))(GLenum, GLenum, GLenum, float);
extern void (GLApi *GLFuncPtrName(glMultiTexGenfvEXT))(GLenum, GLenum, GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMultiTexGeniEXT))(GLenum, GLenum, GLenum, int);
extern void (GLApi *GLFuncPtrName(glMultiTexGenivEXT))(GLenum, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexEnvfvEXT))(GLenum, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexEnvivEXT))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexGendvEXT))(GLenum, GLenum, GLenum, double*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexGenfvEXT))(GLenum, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexGenivEXT))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glMultiTexParameteriEXT))(GLenum, GLenum, GLenum, int);
extern void (GLApi *GLFuncPtrName(glMultiTexParameterivEXT))(GLenum, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glMultiTexParameterfEXT))(GLenum, GLenum, GLenum, float);
extern void (GLApi *GLFuncPtrName(glMultiTexParameterfvEXT))(GLenum, GLenum, GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMultiTexImage1DEXT))(GLenum, GLenum, int, int, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glMultiTexImage2DEXT))(GLenum, GLenum, int, int, GLsizei, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glMultiTexSubImage1DEXT))(GLenum, GLenum, int, int, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glMultiTexSubImage2DEXT))(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glCopyMultiTexImage1DEXT))(GLenum, GLenum, int, GLenum, int, int, GLsizei, int);
extern void (GLApi *GLFuncPtrName(glCopyMultiTexImage2DEXT))(GLenum, GLenum, int, GLenum, int, int, GLsizei, GLsizei, int);
extern void (GLApi *GLFuncPtrName(glCopyMultiTexSubImage1DEXT))(GLenum, GLenum, int, int, int, int, GLsizei);
extern void (GLApi *GLFuncPtrName(glCopyMultiTexSubImage2DEXT))(GLenum, GLenum, int, int, int, int, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetMultiTexImageEXT))(GLenum, GLenum, int, GLenum, GLenum, void*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexParameterfvEXT))(GLenum, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexParameterivEXT))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexLevelParameterfvEXT))(GLenum, GLenum, int, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexLevelParameterivEXT))(GLenum, GLenum, int, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glMultiTexImage3DEXT))(GLenum, GLenum, int, int, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glMultiTexSubImage3DEXT))(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLenum, const void*);
extern void (GLApi *GLFuncPtrName(glCopyMultiTexSubImage3DEXT))(GLenum, GLenum, int, int, int, int, int, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glEnableClientStateIndexedEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDisableClientStateIndexedEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glEnableClientStateiEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDisableClientStateiEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glGetFloatIndexedvEXT))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetDoubleIndexedvEXT))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetPointerIndexedvEXT))(GLenum, GLuint, void**);
extern void (GLApi *GLFuncPtrName(glGetFloati_vEXT))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetDoublei_vEXT))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetPointeri_vEXT))(GLenum, GLuint, void**);
extern void (GLApi *GLFuncPtrName(glEnableIndexedEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDisableIndexedEXT))(GLenum, GLuint);
extern GLboolean (GLApi *GLFuncPtrName(glIsEnabledIndexedEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexedvEXT))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetBooleanIndexedvEXT))(GLenum, GLuint, GLboolean*);
extern void (GLApi *GLFuncPtrName(glNamedProgramStringEXT))(GLuint, GLenum, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameter4dEXT))(GLuint, GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameter4dvEXT))(GLuint, GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameter4fEXT))(GLuint, GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameter4fvEXT))(GLuint, GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramLocalParameterdvEXT))(GLuint, GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramLocalParameterfvEXT))(GLuint, GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramivEXT))(GLuint, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramStringEXT))(GLuint, GLenum, GLenum, void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureImage3DEXT))(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureImage2DEXT))(GLuint, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureImage1DEXT))(GLuint, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureSubImage3DEXT))(GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureSubImage2DEXT))(GLuint, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedTextureSubImage1DEXT))(GLuint, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glGetCompressedTextureImageEXT))(GLuint, GLenum, int, void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexImage3DEXT))(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexImage2DEXT))(GLenum, GLenum, int, GLenum, GLsizei, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexImage1DEXT))(GLenum, GLenum, int, GLenum, GLsizei, int, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexSubImage3DEXT))(GLenum, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexSubImage2DEXT))(GLenum, GLenum, int, int, int, GLsizei, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glCompressedMultiTexSubImage1DEXT))(GLenum, GLenum, int, int, GLsizei, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glGetCompressedMultiTexImageEXT))(GLenum, GLenum, int, void*);
extern void (GLApi *GLFuncPtrName(glMatrixLoadTransposefEXT))(GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMatrixLoadTransposedEXT))(GLenum, const double*);
extern void (GLApi *GLFuncPtrName(glMatrixMultTransposefEXT))(GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glMatrixMultTransposedEXT))(GLenum, const double*);
extern void (GLApi *GLFuncPtrName(glNamedBufferDataEXT))(GLuint, GLsizeiptr, const void*, GLenum);
extern void (GLApi *GLFuncPtrName(glNamedBufferSubDataEXT))(GLuint, GLintptr, GLsizeiptr, const void*);
extern void* (GLApi *GLFuncPtrName(glMapNamedBufferEXT))(GLuint, GLenum);
extern GLboolean (GLApi *GLFuncPtrName(glUnmapNamedBufferEXT))(GLuint);
extern void (GLApi *GLFuncPtrName(glGetNamedBufferParameterivEXT))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetNamedBufferPointervEXT))(GLuint, GLenum, void**);
extern void (GLApi *GLFuncPtrName(glGetNamedBufferSubDataEXT))(GLuint, GLintptr, GLsizeiptr, void*);
extern void (GLApi *GLFuncPtrName(glProgramUniform1fEXT))(GLuint, int, float);
extern void (GLApi *GLFuncPtrName(glProgramUniform2fEXT))(GLuint, int, float, float);
extern void (GLApi *GLFuncPtrName(glProgramUniform3fEXT))(GLuint, int, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramUniform4fEXT))(GLuint, int, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramUniform1iEXT))(GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glProgramUniform2iEXT))(GLuint, int, int, int);
extern void (GLApi *GLFuncPtrName(glProgramUniform3iEXT))(GLuint, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glProgramUniform4iEXT))(GLuint, int, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glProgramUniform1fvEXT))(GLuint, int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniform2fvEXT))(GLuint, int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniform3fvEXT))(GLuint, int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniform4fvEXT))(GLuint, int, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniform1ivEXT))(GLuint, int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramUniform2ivEXT))(GLuint, int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramUniform3ivEXT))(GLuint, int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramUniform4ivEXT))(GLuint, int, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x3fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x2fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix2x4fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x2fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix3x4fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glProgramUniformMatrix4x3fvEXT))(GLuint, int, GLsizei, GLboolean, const float*);
extern void (GLApi *GLFuncPtrName(glTextureBufferEXT))(GLuint, GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glMultiTexBufferEXT))(GLenum, GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glTextureParameterIivEXT))(GLuint, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glTextureParameterIuivEXT))(GLuint, GLenum, GLenum, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetTextureParameterIivEXT))(GLuint, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetTextureParameterIuivEXT))(GLuint, GLenum, GLenum, GLuint*);
extern void (GLApi *GLFuncPtrName(glMultiTexParameterIivEXT))(GLenum, GLenum, GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glMultiTexParameterIuivEXT))(GLenum, GLenum, GLenum, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexParameterIivEXT))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetMultiTexParameterIuivEXT))(GLenum, GLenum, GLenum, GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramUniform1uiEXT))(GLuint, int, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramUniform2uiEXT))(GLuint, int, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramUniform3uiEXT))(GLuint, int, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramUniform4uiEXT))(GLuint, int, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramUniform1uivEXT))(GLuint, int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramUniform2uivEXT))(GLuint, int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramUniform3uivEXT))(GLuint, int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramUniform4uivEXT))(GLuint, int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameters4fvEXT))(GLuint, GLenum, GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameterI4iEXT))(GLuint, GLenum, GLuint, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameterI4ivEXT))(GLuint, GLenum, GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParametersI4ivEXT))(GLuint, GLenum, GLuint, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameterI4uiEXT))(GLuint, GLenum, GLuint, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParameterI4uivEXT))(GLuint, GLenum, GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glNamedProgramLocalParametersI4uivEXT))(GLuint, GLenum, GLuint, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramLocalParameterIivEXT))(GLuint, GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetNamedProgramLocalParameterIuivEXT))(GLuint, GLenum, GLuint, GLuint*);
extern void (GLApi *GLFuncPtrName(glNamedRenderbufferStorageEXT))(GLuint, GLenum, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetNamedRenderbufferParameterivEXT))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glNamedRenderbufferStorageMultisampleEXT))(GLuint, GLsizei, GLenum, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glNamedRenderbufferStorageMultisampleCoverageEXT))(GLuint, GLsizei, GLsizei, GLenum, GLsizei, GLsizei);
extern GLenum (GLApi *GLFuncPtrName(glCheckNamedFramebufferStatusEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTexture1DEXT))(GLuint, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTexture2DEXT))(GLuint, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTexture3DEXT))(GLuint, GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferRenderbufferEXT))(GLuint, GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glGetNamedFramebufferAttachmentParameterivEXT))(GLuint, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGenerateTextureMipmapEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glGenerateMultiTexMipmapEXT))(GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glFramebufferDrawBufferEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glFramebufferDrawBuffersEXT))(GLuint, GLsizei, const GLenum*);
extern void (GLApi *GLFuncPtrName(glFramebufferReadBufferEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glGetFramebufferParameterivEXT))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glNamedCopyBufferSubDataEXT))(GLuint, GLuint, GLintptr, GLintptr, GLsizeiptr);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTextureEXT))(GLuint, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTextureLayerEXT))(GLuint, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glNamedFramebufferTextureFaceEXT))(GLuint, GLenum, GLuint, int, GLenum);
extern void (GLApi *GLFuncPtrName(glTextureRenderbufferEXT))(GLuint, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glMultiTexRenderbufferEXT))(GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glVertexArrayVertexOffsetEXT))(GLuint, GLuint, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayColorOffsetEXT))(GLuint, GLuint, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayEdgeFlagOffsetEXT))(GLuint, GLuint, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayIndexOffsetEXT))(GLuint, GLuint, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayNormalOffsetEXT))(GLuint, GLuint, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayTexCoordOffsetEXT))(GLuint, GLuint, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayMultiTexCoordOffsetEXT))(GLuint, GLuint, GLenum, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayFogCoordOffsetEXT))(GLuint, GLuint, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArraySecondaryColorOffsetEXT))(GLuint, GLuint, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayVertexAttribOffsetEXT))(GLuint, GLuint, GLuint, int, GLenum, GLboolean, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glVertexArrayVertexAttribIOffsetEXT))(GLuint, GLuint, GLuint, int, GLenum, GLsizei, GLintptr);
extern void (GLApi *GLFuncPtrName(glEnableVertexArrayEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glDisableVertexArrayEXT))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glEnableVertexArrayAttribEXT))(GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glDisableVertexArrayAttribEXT))(GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glGetVertexArrayIntegervEXT))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexArrayPointervEXT))(GLuint, GLenum, void**);
extern void (GLApi *GLFuncPtrName(glGetVertexArrayIntegeri_vEXT))(GLuint, GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexArrayPointeri_vEXT))(GLuint, GLuint, GLenum, void**);
extern void* (GLApi *GLFuncPtrName(glMapNamedBufferRangeEXT))(GLuint, GLintptr, GLsizeiptr, GLbitfield);
extern void (GLApi *GLFuncPtrName(glFlushMappedNamedBufferRangeEXT))(GLuint, GLintptr, GLsizeiptr);

#define glClientAttribDefaultEXT GLFuncPtrName(glClientAttribDefaultEXT)
#define glPushClientAttribDefaultEXT GLFuncPtrName(glPushClientAttribDefaultEXT)
#define glMatrixLoadfEXT GLFuncPtrName(glMatrixLoadfEXT)
#define glMatrixLoaddEXT GLFuncPtrName(glMatrixLoaddEXT)
#define glMatrixMultfEXT GLFuncPtrName(glMatrixMultfEXT)
#define glMatrixMultdEXT GLFuncPtrName(glMatrixMultdEXT)
#define glMatrixLoadIdentityEXT GLFuncPtrName(glMatrixLoadIdentityEXT)
#define glMatrixRotatefEXT GLFuncPtrName(glMatrixRotatefEXT)
#define glMatrixRotatedEXT GLFuncPtrName(glMatrixRotatedEXT)
#define glMatrixScalefEXT GLFuncPtrName(glMatrixScalefEXT)
#define glMatrixScaledEXT GLFuncPtrName(glMatrixScaledEXT)
#define glMatrixTranslatefEXT GLFuncPtrName(glMatrixTranslatefEXT)
#define glMatrixTranslatedEXT GLFuncPtrName(glMatrixTranslatedEXT)
#define glMatrixOrthoEXT GLFuncPtrName(glMatrixOrthoEXT)
#define glMatrixFrustumEXT GLFuncPtrName(glMatrixFrustumEXT)
#define glMatrixPushEXT GLFuncPtrName(glMatrixPushEXT)
#define glMatrixPopEXT GLFuncPtrName(glMatrixPopEXT)
#define glTextureParameteriEXT GLFuncPtrName(glTextureParameteriEXT)
#define glTextureParameterivEXT GLFuncPtrName(glTextureParameterivEXT)
#define glTextureParameterfEXT GLFuncPtrName(glTextureParameterfEXT)
#define glTextureParameterfvEXT GLFuncPtrName(glTextureParameterfvEXT)
#define glTextureImage1DEXT GLFuncPtrName(glTextureImage1DEXT)
#define glTextureImage2DEXT GLFuncPtrName(glTextureImage2DEXT)
#define glTextureSubImage1DEXT GLFuncPtrName(glTextureSubImage1DEXT)
#define glTextureSubImage2DEXT GLFuncPtrName(glTextureSubImage2DEXT)
#define glCopyTextureImage1DEXT GLFuncPtrName(glCopyTextureImage1DEXT)
#define glCopyTextureImage2DEXT GLFuncPtrName(glCopyTextureImage2DEXT)
#define glCopyTextureSubImage1DEXT GLFuncPtrName(glCopyTextureSubImage1DEXT)
#define glCopyTextureSubImage2DEXT GLFuncPtrName(glCopyTextureSubImage2DEXT)
#define glGetTextureImageEXT GLFuncPtrName(glGetTextureImageEXT)
#define glGetTextureParameterfvEXT GLFuncPtrName(glGetTextureParameterfvEXT)
#define glGetTextureParameterivEXT GLFuncPtrName(glGetTextureParameterivEXT)
#define glGetTextureLevelParameterfvEXT GLFuncPtrName(glGetTextureLevelParameterfvEXT)
#define glGetTextureLevelParameterivEXT GLFuncPtrName(glGetTextureLevelParameterivEXT)
#define glTextureImage3DEXT GLFuncPtrName(glTextureImage3DEXT)
#define glTextureSubImage3DEXT GLFuncPtrName(glTextureSubImage3DEXT)
#define glCopyTextureSubImage3DEXT GLFuncPtrName(glCopyTextureSubImage3DEXT)
#define glBindMultiTextureEXT GLFuncPtrName(glBindMultiTextureEXT)
#define glMultiTexCoordPointerEXT GLFuncPtrName(glMultiTexCoordPointerEXT)
#define glMultiTexEnvfEXT GLFuncPtrName(glMultiTexEnvfEXT)
#define glMultiTexEnvfvEXT GLFuncPtrName(glMultiTexEnvfvEXT)
#define glMultiTexEnviEXT GLFuncPtrName(glMultiTexEnviEXT)
#define glMultiTexEnvivEXT GLFuncPtrName(glMultiTexEnvivEXT)
#define glMultiTexGendEXT GLFuncPtrName(glMultiTexGendEXT)
#define glMultiTexGendvEXT GLFuncPtrName(glMultiTexGendvEXT)
#define glMultiTexGenfEXT GLFuncPtrName(glMultiTexGenfEXT)
#define glMultiTexGenfvEXT GLFuncPtrName(glMultiTexGenfvEXT)
#define glMultiTexGeniEXT GLFuncPtrName(glMultiTexGeniEXT)
#define glMultiTexGenivEXT GLFuncPtrName(glMultiTexGenivEXT)
#define glGetMultiTexEnvfvEXT GLFuncPtrName(glGetMultiTexEnvfvEXT)
#define glGetMultiTexEnvivEXT GLFuncPtrName(glGetMultiTexEnvivEXT)
#define glGetMultiTexGendvEXT GLFuncPtrName(glGetMultiTexGendvEXT)
#define glGetMultiTexGenfvEXT GLFuncPtrName(glGetMultiTexGenfvEXT)
#define glGetMultiTexGenivEXT GLFuncPtrName(glGetMultiTexGenivEXT)
#define glMultiTexParameteriEXT GLFuncPtrName(glMultiTexParameteriEXT)
#define glMultiTexParameterivEXT GLFuncPtrName(glMultiTexParameterivEXT)
#define glMultiTexParameterfEXT GLFuncPtrName(glMultiTexParameterfEXT)
#define glMultiTexParameterfvEXT GLFuncPtrName(glMultiTexParameterfvEXT)
#define glMultiTexImage1DEXT GLFuncPtrName(glMultiTexImage1DEXT)
#define glMultiTexImage2DEXT GLFuncPtrName(glMultiTexImage2DEXT)
#define glMultiTexSubImage1DEXT GLFuncPtrName(glMultiTexSubImage1DEXT)
#define glMultiTexSubImage2DEXT GLFuncPtrName(glMultiTexSubImage2DEXT)
#define glCopyMultiTexImage1DEXT GLFuncPtrName(glCopyMultiTexImage1DEXT)
#define glCopyMultiTexImage2DEXT GLFuncPtrName(glCopyMultiTexImage2DEXT)
#define glCopyMultiTexSubImage1DEXT GLFuncPtrName(glCopyMultiTexSubImage1DEXT)
#define glCopyMultiTexSubImage2DEXT GLFuncPtrName(glCopyMultiTexSubImage2DEXT)
#define glGetMultiTexImageEXT GLFuncPtrName(glGetMultiTexImageEXT)
#define glGetMultiTexParameterfvEXT GLFuncPtrName(glGetMultiTexParameterfvEXT)
#define glGetMultiTexParameterivEXT GLFuncPtrName(glGetMultiTexParameterivEXT)
#define glGetMultiTexLevelParameterfvEXT GLFuncPtrName(glGetMultiTexLevelParameterfvEXT)
#define glGetMultiTexLevelParameterivEXT GLFuncPtrName(glGetMultiTexLevelParameterivEXT)
#define glMultiTexImage3DEXT GLFuncPtrName(glMultiTexImage3DEXT)
#define glMultiTexSubImage3DEXT GLFuncPtrName(glMultiTexSubImage3DEXT)
#define glCopyMultiTexSubImage3DEXT GLFuncPtrName(glCopyMultiTexSubImage3DEXT)
#define glEnableClientStateIndexedEXT GLFuncPtrName(glEnableClientStateIndexedEXT)
#define glDisableClientStateIndexedEXT GLFuncPtrName(glDisableClientStateIndexedEXT)
#define glEnableClientStateiEXT GLFuncPtrName(glEnableClientStateiEXT)
#define glDisableClientStateiEXT GLFuncPtrName(glDisableClientStateiEXT)
#define glGetFloatIndexedvEXT GLFuncPtrName(glGetFloatIndexedvEXT)
#define glGetDoubleIndexedvEXT GLFuncPtrName(glGetDoubleIndexedvEXT)
#define glGetPointerIndexedvEXT GLFuncPtrName(glGetPointerIndexedvEXT)
#define glGetFloati_vEXT GLFuncPtrName(glGetFloati_vEXT)
#define glGetDoublei_vEXT GLFuncPtrName(glGetDoublei_vEXT)
#define glGetPointeri_vEXT GLFuncPtrName(glGetPointeri_vEXT)
#define glEnableIndexedEXT GLFuncPtrName(glEnableIndexedEXT)
#define glDisableIndexedEXT GLFuncPtrName(glDisableIndexedEXT)
#define glIsEnabledIndexedEXT GLFuncPtrName(glIsEnabledIndexedEXT)
#define glGetIntegerIndexedvEXT GLFuncPtrName(glGetIntegerIndexedvEXT)
#define glGetBooleanIndexedvEXT GLFuncPtrName(glGetBooleanIndexedvEXT)
#define glNamedProgramStringEXT GLFuncPtrName(glNamedProgramStringEXT)
#define glNamedProgramLocalParameter4dEXT GLFuncPtrName(glNamedProgramLocalParameter4dEXT)
#define glNamedProgramLocalParameter4dvEXT GLFuncPtrName(glNamedProgramLocalParameter4dvEXT)
#define glNamedProgramLocalParameter4fEXT GLFuncPtrName(glNamedProgramLocalParameter4fEXT)
#define glNamedProgramLocalParameter4fvEXT GLFuncPtrName(glNamedProgramLocalParameter4fvEXT)
#define glGetNamedProgramLocalParameterdvEXT GLFuncPtrName(glGetNamedProgramLocalParameterdvEXT)
#define glGetNamedProgramLocalParameterfvEXT GLFuncPtrName(glGetNamedProgramLocalParameterfvEXT)
#define glGetNamedProgramivEXT GLFuncPtrName(glGetNamedProgramivEXT)
#define glGetNamedProgramStringEXT GLFuncPtrName(glGetNamedProgramStringEXT)
#define glCompressedTextureImage3DEXT GLFuncPtrName(glCompressedTextureImage3DEXT)
#define glCompressedTextureImage2DEXT GLFuncPtrName(glCompressedTextureImage2DEXT)
#define glCompressedTextureImage1DEXT GLFuncPtrName(glCompressedTextureImage1DEXT)
#define glCompressedTextureSubImage3DEXT GLFuncPtrName(glCompressedTextureSubImage3DEXT)
#define glCompressedTextureSubImage2DEXT GLFuncPtrName(glCompressedTextureSubImage2DEXT)
#define glCompressedTextureSubImage1DEXT GLFuncPtrName(glCompressedTextureSubImage1DEXT)
#define glGetCompressedTextureImageEXT GLFuncPtrName(glGetCompressedTextureImageEXT)
#define glCompressedMultiTexImage3DEXT GLFuncPtrName(glCompressedMultiTexImage3DEXT)
#define glCompressedMultiTexImage2DEXT GLFuncPtrName(glCompressedMultiTexImage2DEXT)
#define glCompressedMultiTexImage1DEXT GLFuncPtrName(glCompressedMultiTexImage1DEXT)
#define glCompressedMultiTexSubImage3DEXT GLFuncPtrName(glCompressedMultiTexSubImage3DEXT)
#define glCompressedMultiTexSubImage2DEXT GLFuncPtrName(glCompressedMultiTexSubImage2DEXT)
#define glCompressedMultiTexSubImage1DEXT GLFuncPtrName(glCompressedMultiTexSubImage1DEXT)
#define glGetCompressedMultiTexImageEXT GLFuncPtrName(glGetCompressedMultiTexImageEXT)
#define glMatrixLoadTransposefEXT GLFuncPtrName(glMatrixLoadTransposefEXT)
#define glMatrixLoadTransposedEXT GLFuncPtrName(glMatrixLoadTransposedEXT)
#define glMatrixMultTransposefEXT GLFuncPtrName(glMatrixMultTransposefEXT)
#define glMatrixMultTransposedEXT GLFuncPtrName(glMatrixMultTransposedEXT)
#define glNamedBufferDataEXT GLFuncPtrName(glNamedBufferDataEXT)
#define glNamedBufferSubDataEXT GLFuncPtrName(glNamedBufferSubDataEXT)
#define glMapNamedBufferEXT GLFuncPtrName(glMapNamedBufferEXT)
#define glUnmapNamedBufferEXT GLFuncPtrName(glUnmapNamedBufferEXT)
#define glGetNamedBufferParameterivEXT GLFuncPtrName(glGetNamedBufferParameterivEXT)
#define glGetNamedBufferPointervEXT GLFuncPtrName(glGetNamedBufferPointervEXT)
#define glGetNamedBufferSubDataEXT GLFuncPtrName(glGetNamedBufferSubDataEXT)
#define glProgramUniform1fEXT GLFuncPtrName(glProgramUniform1fEXT)
#define glProgramUniform2fEXT GLFuncPtrName(glProgramUniform2fEXT)
#define glProgramUniform3fEXT GLFuncPtrName(glProgramUniform3fEXT)
#define glProgramUniform4fEXT GLFuncPtrName(glProgramUniform4fEXT)
#define glProgramUniform1iEXT GLFuncPtrName(glProgramUniform1iEXT)
#define glProgramUniform2iEXT GLFuncPtrName(glProgramUniform2iEXT)
#define glProgramUniform3iEXT GLFuncPtrName(glProgramUniform3iEXT)
#define glProgramUniform4iEXT GLFuncPtrName(glProgramUniform4iEXT)
#define glProgramUniform1fvEXT GLFuncPtrName(glProgramUniform1fvEXT)
#define glProgramUniform2fvEXT GLFuncPtrName(glProgramUniform2fvEXT)
#define glProgramUniform3fvEXT GLFuncPtrName(glProgramUniform3fvEXT)
#define glProgramUniform4fvEXT GLFuncPtrName(glProgramUniform4fvEXT)
#define glProgramUniform1ivEXT GLFuncPtrName(glProgramUniform1ivEXT)
#define glProgramUniform2ivEXT GLFuncPtrName(glProgramUniform2ivEXT)
#define glProgramUniform3ivEXT GLFuncPtrName(glProgramUniform3ivEXT)
#define glProgramUniform4ivEXT GLFuncPtrName(glProgramUniform4ivEXT)
#define glProgramUniformMatrix2fvEXT GLFuncPtrName(glProgramUniformMatrix2fvEXT)
#define glProgramUniformMatrix3fvEXT GLFuncPtrName(glProgramUniformMatrix3fvEXT)
#define glProgramUniformMatrix4fvEXT GLFuncPtrName(glProgramUniformMatrix4fvEXT)
#define glProgramUniformMatrix2x3fvEXT GLFuncPtrName(glProgramUniformMatrix2x3fvEXT)
#define glProgramUniformMatrix3x2fvEXT GLFuncPtrName(glProgramUniformMatrix3x2fvEXT)
#define glProgramUniformMatrix2x4fvEXT GLFuncPtrName(glProgramUniformMatrix2x4fvEXT)
#define glProgramUniformMatrix4x2fvEXT GLFuncPtrName(glProgramUniformMatrix4x2fvEXT)
#define glProgramUniformMatrix3x4fvEXT GLFuncPtrName(glProgramUniformMatrix3x4fvEXT)
#define glProgramUniformMatrix4x3fvEXT GLFuncPtrName(glProgramUniformMatrix4x3fvEXT)
#define glTextureBufferEXT GLFuncPtrName(glTextureBufferEXT)
#define glMultiTexBufferEXT GLFuncPtrName(glMultiTexBufferEXT)
#define glTextureParameterIivEXT GLFuncPtrName(glTextureParameterIivEXT)
#define glTextureParameterIuivEXT GLFuncPtrName(glTextureParameterIuivEXT)
#define glGetTextureParameterIivEXT GLFuncPtrName(glGetTextureParameterIivEXT)
#define glGetTextureParameterIuivEXT GLFuncPtrName(glGetTextureParameterIuivEXT)
#define glMultiTexParameterIivEXT GLFuncPtrName(glMultiTexParameterIivEXT)
#define glMultiTexParameterIuivEXT GLFuncPtrName(glMultiTexParameterIuivEXT)
#define glGetMultiTexParameterIivEXT GLFuncPtrName(glGetMultiTexParameterIivEXT)
#define glGetMultiTexParameterIuivEXT GLFuncPtrName(glGetMultiTexParameterIuivEXT)
#define glProgramUniform1uiEXT GLFuncPtrName(glProgramUniform1uiEXT)
#define glProgramUniform2uiEXT GLFuncPtrName(glProgramUniform2uiEXT)
#define glProgramUniform3uiEXT GLFuncPtrName(glProgramUniform3uiEXT)
#define glProgramUniform4uiEXT GLFuncPtrName(glProgramUniform4uiEXT)
#define glProgramUniform1uivEXT GLFuncPtrName(glProgramUniform1uivEXT)
#define glProgramUniform2uivEXT GLFuncPtrName(glProgramUniform2uivEXT)
#define glProgramUniform3uivEXT GLFuncPtrName(glProgramUniform3uivEXT)
#define glProgramUniform4uivEXT GLFuncPtrName(glProgramUniform4uivEXT)
#define glNamedProgramLocalParameters4fvEXT GLFuncPtrName(glNamedProgramLocalParameters4fvEXT)
#define glNamedProgramLocalParameterI4iEXT GLFuncPtrName(glNamedProgramLocalParameterI4iEXT)
#define glNamedProgramLocalParameterI4ivEXT GLFuncPtrName(glNamedProgramLocalParameterI4ivEXT)
#define glNamedProgramLocalParametersI4ivEXT GLFuncPtrName(glNamedProgramLocalParametersI4ivEXT)
#define glNamedProgramLocalParameterI4uiEXT GLFuncPtrName(glNamedProgramLocalParameterI4uiEXT)
#define glNamedProgramLocalParameterI4uivEXT GLFuncPtrName(glNamedProgramLocalParameterI4uivEXT)
#define glNamedProgramLocalParametersI4uivEXT GLFuncPtrName(glNamedProgramLocalParametersI4uivEXT)
#define glGetNamedProgramLocalParameterIivEXT GLFuncPtrName(glGetNamedProgramLocalParameterIivEXT)
#define glGetNamedProgramLocalParameterIuivEXT GLFuncPtrName(glGetNamedProgramLocalParameterIuivEXT)
#define glNamedRenderbufferStorageEXT GLFuncPtrName(glNamedRenderbufferStorageEXT)
#define glGetNamedRenderbufferParameterivEXT GLFuncPtrName(glGetNamedRenderbufferParameterivEXT)
#define glNamedRenderbufferStorageMultisampleEXT GLFuncPtrName(glNamedRenderbufferStorageMultisampleEXT)
#define glNamedRenderbufferStorageMultisampleCoverageEXT GLFuncPtrName(glNamedRenderbufferStorageMultisampleCoverageEXT)
#define glCheckNamedFramebufferStatusEXT GLFuncPtrName(glCheckNamedFramebufferStatusEXT)
#define glNamedFramebufferTexture1DEXT GLFuncPtrName(glNamedFramebufferTexture1DEXT)
#define glNamedFramebufferTexture2DEXT GLFuncPtrName(glNamedFramebufferTexture2DEXT)
#define glNamedFramebufferTexture3DEXT GLFuncPtrName(glNamedFramebufferTexture3DEXT)
#define glNamedFramebufferRenderbufferEXT GLFuncPtrName(glNamedFramebufferRenderbufferEXT)
#define glGetNamedFramebufferAttachmentParameterivEXT GLFuncPtrName(glGetNamedFramebufferAttachmentParameterivEXT)
#define glGenerateTextureMipmapEXT GLFuncPtrName(glGenerateTextureMipmapEXT)
#define glGenerateMultiTexMipmapEXT GLFuncPtrName(glGenerateMultiTexMipmapEXT)
#define glFramebufferDrawBufferEXT GLFuncPtrName(glFramebufferDrawBufferEXT)
#define glFramebufferDrawBuffersEXT GLFuncPtrName(glFramebufferDrawBuffersEXT)
#define glFramebufferReadBufferEXT GLFuncPtrName(glFramebufferReadBufferEXT)
#define glGetFramebufferParameterivEXT GLFuncPtrName(glGetFramebufferParameterivEXT)
#define glNamedCopyBufferSubDataEXT GLFuncPtrName(glNamedCopyBufferSubDataEXT)
#define glNamedFramebufferTextureEXT GLFuncPtrName(glNamedFramebufferTextureEXT)
#define glNamedFramebufferTextureLayerEXT GLFuncPtrName(glNamedFramebufferTextureLayerEXT)
#define glNamedFramebufferTextureFaceEXT GLFuncPtrName(glNamedFramebufferTextureFaceEXT)
#define glTextureRenderbufferEXT GLFuncPtrName(glTextureRenderbufferEXT)
#define glMultiTexRenderbufferEXT GLFuncPtrName(glMultiTexRenderbufferEXT)
#define glVertexArrayVertexOffsetEXT GLFuncPtrName(glVertexArrayVertexOffsetEXT)
#define glVertexArrayColorOffsetEXT GLFuncPtrName(glVertexArrayColorOffsetEXT)
#define glVertexArrayEdgeFlagOffsetEXT GLFuncPtrName(glVertexArrayEdgeFlagOffsetEXT)
#define glVertexArrayIndexOffsetEXT GLFuncPtrName(glVertexArrayIndexOffsetEXT)
#define glVertexArrayNormalOffsetEXT GLFuncPtrName(glVertexArrayNormalOffsetEXT)
#define glVertexArrayTexCoordOffsetEXT GLFuncPtrName(glVertexArrayTexCoordOffsetEXT)
#define glVertexArrayMultiTexCoordOffsetEXT GLFuncPtrName(glVertexArrayMultiTexCoordOffsetEXT)
#define glVertexArrayFogCoordOffsetEXT GLFuncPtrName(glVertexArrayFogCoordOffsetEXT)
#define glVertexArraySecondaryColorOffsetEXT GLFuncPtrName(glVertexArraySecondaryColorOffsetEXT)
#define glVertexArrayVertexAttribOffsetEXT GLFuncPtrName(glVertexArrayVertexAttribOffsetEXT)
#define glVertexArrayVertexAttribIOffsetEXT GLFuncPtrName(glVertexArrayVertexAttribIOffsetEXT)
#define glEnableVertexArrayEXT GLFuncPtrName(glEnableVertexArrayEXT)
#define glDisableVertexArrayEXT GLFuncPtrName(glDisableVertexArrayEXT)
#define glEnableVertexArrayAttribEXT GLFuncPtrName(glEnableVertexArrayAttribEXT)
#define glDisableVertexArrayAttribEXT GLFuncPtrName(glDisableVertexArrayAttribEXT)
#define glGetVertexArrayIntegervEXT GLFuncPtrName(glGetVertexArrayIntegervEXT)
#define glGetVertexArrayPointervEXT GLFuncPtrName(glGetVertexArrayPointervEXT)
#define glGetVertexArrayIntegeri_vEXT GLFuncPtrName(glGetVertexArrayIntegeri_vEXT)
#define glGetVertexArrayPointeri_vEXT GLFuncPtrName(glGetVertexArrayPointeri_vEXT)
#define glMapNamedBufferRangeEXT GLFuncPtrName(glMapNamedBufferRangeEXT)
#define glFlushMappedNamedBufferRangeEXT GLFuncPtrName(glFlushMappedNamedBufferRangeEXT)

#endif // GL_EXT_direct_state_access

//								--- GL_EXT_draw_buffers2 ---

#ifndef GL_EXT_draw_buffers2
#define GL_EXT_draw_buffers2 1
#define __GENERATE_GL_EXT_draw_buffers2

extern bool GLEH_EXT_draw_buffers2; /**< set if GL_EXT_draw_buffers2 is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glColorMaskIndexedEXT))(GLuint, GLboolean, GLboolean, GLboolean, GLboolean);
extern void (GLApi *GLFuncPtrName(glGetBooleanIndexedvEXT))(GLenum, GLuint, GLboolean*);
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexedvEXT))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glEnableIndexedEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDisableIndexedEXT))(GLenum, GLuint);
extern GLboolean (GLApi *GLFuncPtrName(glIsEnabledIndexedEXT))(GLenum, GLuint);

#define glColorMaskIndexedEXT GLFuncPtrName(glColorMaskIndexedEXT)
#define glGetBooleanIndexedvEXT GLFuncPtrName(glGetBooleanIndexedvEXT)
#define glGetIntegerIndexedvEXT GLFuncPtrName(glGetIntegerIndexedvEXT)
#define glEnableIndexedEXT GLFuncPtrName(glEnableIndexedEXT)
#define glDisableIndexedEXT GLFuncPtrName(glDisableIndexedEXT)
#define glIsEnabledIndexedEXT GLFuncPtrName(glIsEnabledIndexedEXT)

#endif // GL_EXT_draw_buffers2

//								--- GL_EXT_draw_instanced ---

#ifndef GL_EXT_draw_instanced
#define GL_EXT_draw_instanced 1
#define __GENERATE_GL_EXT_draw_instanced

extern bool GLEH_EXT_draw_instanced; /**< set if GL_EXT_draw_instanced is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glDrawArraysInstancedEXT))(GLenum, int, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glDrawElementsInstancedEXT))(GLenum, GLsizei, GLenum, const void*, GLsizei);

#define glDrawArraysInstancedEXT GLFuncPtrName(glDrawArraysInstancedEXT)
#define glDrawElementsInstancedEXT GLFuncPtrName(glDrawElementsInstancedEXT)

#endif // GL_EXT_draw_instanced

//								--- GL_EXT_fog_coord ---

#ifndef GL_EXT_fog_coord
#define GL_EXT_fog_coord 1
#define __GENERATE_GL_EXT_fog_coord

extern bool GLEH_EXT_fog_coord; /**< set if GL_EXT_fog_coord is supported */

#define GL_FOG_COORDINATE_SOURCE_EXT                                 0x8450
#define GL_FOG_COORDINATE_EXT                                        0x8451
#define GL_FRAGMENT_DEPTH_EXT                                        0x8452
#define GL_CURRENT_FOG_COORDINATE_EXT                                0x8453
#define GL_FOG_COORDINATE_ARRAY_TYPE_EXT                             0x8454
#define GL_FOG_COORDINATE_ARRAY_STRIDE_EXT                           0x8455
#define GL_FOG_COORDINATE_ARRAY_POINTER_EXT                          0x8456
#define GL_FOG_COORDINATE_ARRAY_EXT                                  0x8457

extern void (GLApi *GLFuncPtrName(glFogCoordfEXT))(float);
extern void (GLApi *GLFuncPtrName(glFogCoorddEXT))(double);
extern void (GLApi *GLFuncPtrName(glFogCoordfvEXT))(float);
extern void (GLApi *GLFuncPtrName(glFogCoorddvEXT))(double);
extern void (GLApi *GLFuncPtrName(glFogCoordPointerEXT))(GLenum, GLsizei, void*);

#define glFogCoordfEXT GLFuncPtrName(glFogCoordfEXT)
#define glFogCoorddEXT GLFuncPtrName(glFogCoorddEXT)
#define glFogCoordfvEXT GLFuncPtrName(glFogCoordfvEXT)
#define glFogCoorddvEXT GLFuncPtrName(glFogCoorddvEXT)
#define glFogCoordPointerEXT GLFuncPtrName(glFogCoordPointerEXT)

#endif // GL_EXT_fog_coord

//								--- GL_EXT_framebuffer_blit ---

#ifndef GL_EXT_framebuffer_blit
#define GL_EXT_framebuffer_blit 1
#define __GENERATE_GL_EXT_framebuffer_blit

extern bool GLEH_EXT_framebuffer_blit; /**< set if GL_EXT_framebuffer_blit is supported */

#define GL_READ_FRAMEBUFFER_EXT                                      0x8ca8
#define GL_DRAW_FRAMEBUFFER_EXT                                      0x8ca9
#define GL_DRAW_FRAMEBUFFER_BINDING_EXT                              0x8ca6
#define GL_READ_FRAMEBUFFER_BINDING_EXT                              0x8caa

extern void (GLApi *GLFuncPtrName(glBlitFramebufferEXT))(int, int, int, int, int, int, int, int, GLbitfield, GLenum);

#define glBlitFramebufferEXT GLFuncPtrName(glBlitFramebufferEXT)

#endif // GL_EXT_framebuffer_blit

//								--- GL_EXT_framebuffer_multisample ---

#ifndef GL_EXT_framebuffer_multisample
#define GL_EXT_framebuffer_multisample 1
#define __GENERATE_GL_EXT_framebuffer_multisample

extern bool GLEH_EXT_framebuffer_multisample; /**< set if GL_EXT_framebuffer_multisample is supported */

#define GL_RENDERBUFFER_SAMPLES_EXT                                  0x8cab
#define GL_FRAMEBUFFER_INCOMPLETE_MULTISAMPLE_EXT                    0x8d56
#define GL_MAX_SAMPLES_EXT                                           0x8d57

extern void (GLApi *GLFuncPtrName(glRenderbufferStorageMultisampleEXT))(GLenum, GLsizei, GLenum, GLsizei, GLsizei);

#define glRenderbufferStorageMultisampleEXT GLFuncPtrName(glRenderbufferStorageMultisampleEXT)

#endif // GL_EXT_framebuffer_multisample

//								--- GL_EXT_framebuffer_object ---

#ifndef GL_EXT_framebuffer_object
#define GL_EXT_framebuffer_object 1
#define __GENERATE_GL_EXT_framebuffer_object

extern bool GLEH_EXT_framebuffer_object; /**< set if GL_EXT_framebuffer_object is supported */

#define GL_FRAMEBUFFER_EXT                                           0x8d40
#define GL_RENDERBUFFER_EXT                                          0x8d41
#define GL_STENCIL_INDEX1_EXT                                        0x8d46
#define GL_STENCIL_INDEX4_EXT                                        0x8d47
#define GL_STENCIL_INDEX8_EXT                                        0x8d48
#define GL_STENCIL_INDEX16_EXT                                       0x8d49
#define GL_RENDERBUFFER_WIDTH_EXT                                    0x8d42
#define GL_RENDERBUFFER_HEIGHT_EXT                                   0x8d43
#define GL_RENDERBUFFER_INTERNAL_FORMAT_EXT                          0x8d44
#define GL_RENDERBUFFER_RED_SIZE_EXT                                 0x8d50
#define GL_RENDERBUFFER_GREEN_SIZE_EXT                               0x8d51
#define GL_RENDERBUFFER_BLUE_SIZE_EXT                                0x8d52
#define GL_RENDERBUFFER_ALPHA_SIZE_EXT                               0x8d53
#define GL_RENDERBUFFER_DEPTH_SIZE_EXT                               0x8d54
#define GL_RENDERBUFFER_STENCIL_SIZE_EXT                             0x8d55
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_TYPE_EXT                    0x8cd0
#define GL_FRAMEBUFFER_ATTACHMENT_OBJECT_NAME_EXT                    0x8cd1
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LEVEL_EXT                  0x8cd2
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_CUBE_MAP_FACE_EXT          0x8cd3
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_3D_ZOFFSET_EXT             0x8cd4
#define GL_COLOR_ATTACHMENT0_EXT                                     0x8ce0
#define GL_COLOR_ATTACHMENT1_EXT                                     0x8ce1
#define GL_COLOR_ATTACHMENT2_EXT                                     0x8ce2
#define GL_COLOR_ATTACHMENT3_EXT                                     0x8ce3
#define GL_COLOR_ATTACHMENT4_EXT                                     0x8ce4
#define GL_COLOR_ATTACHMENT5_EXT                                     0x8ce5
#define GL_COLOR_ATTACHMENT6_EXT                                     0x8ce6
#define GL_COLOR_ATTACHMENT7_EXT                                     0x8ce7
#define GL_COLOR_ATTACHMENT8_EXT                                     0x8ce8
#define GL_COLOR_ATTACHMENT9_EXT                                     0x8ce9
#define GL_COLOR_ATTACHMENT10_EXT                                    0x8cea
#define GL_COLOR_ATTACHMENT11_EXT                                    0x8ceb
#define GL_COLOR_ATTACHMENT12_EXT                                    0x8cec
#define GL_COLOR_ATTACHMENT13_EXT                                    0x8ced
#define GL_COLOR_ATTACHMENT14_EXT                                    0x8cee
#define GL_COLOR_ATTACHMENT15_EXT                                    0x8cef
#define GL_DEPTH_ATTACHMENT_EXT                                      0x8d00
#define GL_STENCIL_ATTACHMENT_EXT                                    0x8d20
#define GL_FRAMEBUFFER_COMPLETE_EXT                                  0x8cd5
#define GL_FRAMEBUFFER_INCOMPLETE_ATTACHMENT_EXT                     0x8cd6
#define GL_FRAMEBUFFER_INCOMPLETE_MISSING_ATTACHMENT_EXT             0x8cd7
#define GL_FRAMEBUFFER_INCOMPLETE_DIMENSIONS_EXT                     0x8cd9
#define GL_FRAMEBUFFER_INCOMPLETE_FORMATS_EXT                        0x8cda
#define GL_FRAMEBUFFER_INCOMPLETE_DRAW_BUFFER_EXT                    0x8cdb
#define GL_FRAMEBUFFER_INCOMPLETE_READ_BUFFER_EXT                    0x8cdc
#define GL_FRAMEBUFFER_UNSUPPORTED_EXT                               0x8cdd
#define GL_FRAMEBUFFER_BINDING_EXT                                   0x8ca6
#define GL_RENDERBUFFER_BINDING_EXT                                  0x8ca7
#define GL_MAX_COLOR_ATTACHMENTS_EXT                                 0x8cdf
#define GL_MAX_RENDERBUFFER_SIZE_EXT                                 0x84e8
#define GL_INVALID_FRAMEBUFFER_OPERATION_EXT                         0x0506

extern GLboolean (GLApi *GLFuncPtrName(glIsRenderbufferEXT))(GLuint);
extern void (GLApi *GLFuncPtrName(glBindRenderbufferEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteRenderbuffersEXT))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenRenderbuffersEXT))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glRenderbufferStorageEXT))(GLenum, GLenum, GLsizei, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetRenderbufferParameterivEXT))(GLenum, GLenum, int*);
extern GLboolean (GLApi *GLFuncPtrName(glIsFramebufferEXT))(GLuint);
extern void (GLApi *GLFuncPtrName(glBindFramebufferEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteFramebuffersEXT))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenFramebuffersEXT))(GLsizei, GLuint*);
extern GLenum (GLApi *GLFuncPtrName(glCheckFramebufferStatusEXT))(GLenum);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture1DEXT))(GLenum, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture2DEXT))(GLenum, GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTexture3DEXT))(GLenum, GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glFramebufferRenderbufferEXT))(GLenum, GLenum, GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glGetFramebufferAttachmentParameterivEXT))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGenerateMipmapEXT))(GLenum);

#define glIsRenderbufferEXT GLFuncPtrName(glIsRenderbufferEXT)
#define glBindRenderbufferEXT GLFuncPtrName(glBindRenderbufferEXT)
#define glDeleteRenderbuffersEXT GLFuncPtrName(glDeleteRenderbuffersEXT)
#define glGenRenderbuffersEXT GLFuncPtrName(glGenRenderbuffersEXT)
#define glRenderbufferStorageEXT GLFuncPtrName(glRenderbufferStorageEXT)
#define glGetRenderbufferParameterivEXT GLFuncPtrName(glGetRenderbufferParameterivEXT)
#define glIsFramebufferEXT GLFuncPtrName(glIsFramebufferEXT)
#define glBindFramebufferEXT GLFuncPtrName(glBindFramebufferEXT)
#define glDeleteFramebuffersEXT GLFuncPtrName(glDeleteFramebuffersEXT)
#define glGenFramebuffersEXT GLFuncPtrName(glGenFramebuffersEXT)
#define glCheckFramebufferStatusEXT GLFuncPtrName(glCheckFramebufferStatusEXT)
#define glFramebufferTexture1DEXT GLFuncPtrName(glFramebufferTexture1DEXT)
#define glFramebufferTexture2DEXT GLFuncPtrName(glFramebufferTexture2DEXT)
#define glFramebufferTexture3DEXT GLFuncPtrName(glFramebufferTexture3DEXT)
#define glFramebufferRenderbufferEXT GLFuncPtrName(glFramebufferRenderbufferEXT)
#define glGetFramebufferAttachmentParameterivEXT GLFuncPtrName(glGetFramebufferAttachmentParameterivEXT)
#define glGenerateMipmapEXT GLFuncPtrName(glGenerateMipmapEXT)

#endif // GL_EXT_framebuffer_object

//								--- GL_EXT_framebuffer_sRGB ---

#ifndef GL_EXT_framebuffer_sRGB
#define GL_EXT_framebuffer_sRGB 1

extern bool GLEH_EXT_framebuffer_sRGB; /**< set if GL_EXT_framebuffer_sRGB is supported */

#define GL_GLX_FRAMEBUFFER_SRGB_CAPABLE_EXT                          0x20b2
#define GL_WGL_FRAMEBUFFER_SRGB_CAPABLE_EXT                          0x20a9
#define GL_FRAMEBUFFER_SRGB_EXT                                      0x8db9
#define GL_FRAMEBUFFER_SRGB_CAPABLE_EXT                              0x8dba

// no new procedures or functions

#endif // GL_EXT_framebuffer_sRGB

//								--- GL_EXT_geometry_shader4 ---

#ifndef GL_EXT_geometry_shader4
#define GL_EXT_geometry_shader4 1
#define __GENERATE_GL_EXT_geometry_shader4

#define GL_NV_geometry_program4 // avoid redefinitions in glext.h

extern bool GLEH_EXT_geometry_shader4; /**< set if GL_EXT_geometry_shader4 is supported */

#define GL_GEOMETRY_SHADER_EXT                                       0x8dd9
#define GL_GEOMETRY_VERTICES_OUT_EXT                                 0x8dda
#define GL_GEOMETRY_INPUT_TYPE_EXT                                   0x8ddb
#define GL_GEOMETRY_OUTPUT_TYPE_EXT                                  0x8ddc
#define GL_MAX_GEOMETRY_TEXTURE_IMAGE_UNITS_EXT                      0x8c29
#define GL_MAX_GEOMETRY_VARYING_COMPONENTS_EXT                       0x8ddd
#define GL_MAX_VERTEX_VARYING_COMPONENTS_EXT                         0x8dde
#define GL_MAX_VARYING_COMPONENTS_EXT                                0x8b4b
#define GL_MAX_GEOMETRY_UNIFORM_COMPONENTS_EXT                       0x8ddf
#define GL_MAX_GEOMETRY_OUTPUT_VERTICES_EXT                          0x8de0
#define GL_MAX_GEOMETRY_TOTAL_OUTPUT_COMPONENTS_EXT                  0x8de1
#define GL_LINES_ADJACENCY_EXT                                       0x000a
#define GL_LINE_STRIP_ADJACENCY_EXT                                  0x000b
#define GL_TRIANGLES_ADJACENCY_EXT                                   0x000c
#define GL_TRIANGLE_STRIP_ADJACENCY_EXT                              0x000d
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_TARGETS_EXT                  0x8da8
#define GL_FRAMEBUFFER_INCOMPLETE_LAYER_COUNT_EXT                    0x8da9
#define GL_FRAMEBUFFER_ATTACHMENT_LAYERED_EXT                        0x8da7
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT                  0x8cd4
#define GL_PROGRAM_POINT_SIZE_EXT                                    0x8642

extern void (GLApi *GLFuncPtrName(glProgramParameteriEXT))(GLuint, GLenum, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureEXT))(GLenum, GLenum, GLuint, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureLayerEXT))(GLenum, GLenum, GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glFramebufferTextureFaceEXT))(GLenum, GLenum, GLuint, int, GLenum);

#define glProgramParameteriEXT GLFuncPtrName(glProgramParameteriEXT)
#define glFramebufferTextureEXT GLFuncPtrName(glFramebufferTextureEXT)
#define glFramebufferTextureLayerEXT GLFuncPtrName(glFramebufferTextureLayerEXT)
#define glFramebufferTextureFaceEXT GLFuncPtrName(glFramebufferTextureFaceEXT)

#endif // GL_EXT_geometry_shader4

//								--- GL_EXT_gpu_program_parameters ---

#ifndef GL_EXT_gpu_program_parameters
#define GL_EXT_gpu_program_parameters 1
#define __GENERATE_GL_EXT_gpu_program_parameters

extern bool GLEH_EXT_gpu_program_parameters; /**< set if GL_EXT_gpu_program_parameters is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glProgramEnvParameters4fvEXT))(GLenum, GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameters4fvEXT))(GLenum, GLuint, GLsizei, const float*);

#define glProgramEnvParameters4fvEXT GLFuncPtrName(glProgramEnvParameters4fvEXT)
#define glProgramLocalParameters4fvEXT GLFuncPtrName(glProgramLocalParameters4fvEXT)

#endif // GL_EXT_gpu_program_parameters

//								--- GL_EXT_gpu_shader4 ---

#ifndef GL_EXT_gpu_shader4
#define GL_EXT_gpu_shader4 1
#define __GENERATE_GL_EXT_gpu_shader4

extern bool GLEH_EXT_gpu_shader4; /**< set if GL_EXT_gpu_shader4 is supported */

#define GL_VERTEX_ATTRIB_ARRAY_INTEGER_EXT                           0x88fd
#define GL_SAMPLER_1D_ARRAY_EXT                                      0x8dc0
#define GL_SAMPLER_2D_ARRAY_EXT                                      0x8dc1
#define GL_SAMPLER_BUFFER_EXT                                        0x8dc2
#define GL_SAMPLER_1D_ARRAY_SHADOW_EXT                               0x8dc3
#define GL_SAMPLER_2D_ARRAY_SHADOW_EXT                               0x8dc4
#define GL_SAMPLER_CUBE_SHADOW_EXT                                   0x8dc5
#define GL_UNSIGNED_INT                                              0x1405
#define GL_UNSIGNED_INT_VEC2_EXT                                     0x8dc6
#define GL_UNSIGNED_INT_VEC3_EXT                                     0x8dc7
#define GL_UNSIGNED_INT_VEC4_EXT                                     0x8dc8
#define GL_INT_SAMPLER_1D_EXT                                        0x8dc9
#define GL_INT_SAMPLER_2D_EXT                                        0x8dca
#define GL_INT_SAMPLER_3D_EXT                                        0x8dcb
#define GL_INT_SAMPLER_CUBE_EXT                                      0x8dcc
#define GL_INT_SAMPLER_2D_RECT_EXT                                   0x8dcd
#define GL_INT_SAMPLER_1D_ARRAY_EXT                                  0x8dce
#define GL_INT_SAMPLER_2D_ARRAY_EXT                                  0x8dcf
#define GL_INT_SAMPLER_BUFFER_EXT                                    0x8dd0
#define GL_UNSIGNED_INT_SAMPLER_1D_EXT                               0x8dd1
#define GL_UNSIGNED_INT_SAMPLER_2D_EXT                               0x8dd2
#define GL_UNSIGNED_INT_SAMPLER_3D_EXT                               0x8dd3
#define GL_UNSIGNED_INT_SAMPLER_CUBE_EXT                             0x8dd4
#define GL_UNSIGNED_INT_SAMPLER_2D_RECT_EXT                          0x8dd5
#define GL_UNSIGNED_INT_SAMPLER_1D_ARRAY_EXT                         0x8dd6
#define GL_UNSIGNED_INT_SAMPLER_2D_ARRAY_EXT                         0x8dd7
#define GL_UNSIGNED_INT_SAMPLER_BUFFER_EXT                           0x8dd8
#define GL_MIN_PROGRAM_TEXEL_OFFSET_EXT                              0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET_EXT                              0x8905

extern void (GLApi *GLFuncPtrName(glVertexAttribI1iEXT))(GLuint, int);
extern void (GLApi *GLFuncPtrName(glVertexAttribI2iEXT))(GLuint, int, int);
extern void (GLApi *GLFuncPtrName(glVertexAttribI3iEXT))(GLuint, int, int, int);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4iEXT))(GLuint, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glVertexAttribI1uiEXT))(GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glVertexAttribI2uiEXT))(GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glVertexAttribI3uiEXT))(GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4uiEXT))(GLuint, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glVertexAttribI1ivEXT))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI2ivEXT))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI3ivEXT))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4ivEXT))(GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI1uivEXT))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI2uivEXT))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI3uivEXT))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4uivEXT))(GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4bvEXT))(GLuint, const GLbyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4svEXT))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4ubvEXT))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttribI4usvEXT))(GLuint, const GLushort*);
extern void (GLApi *GLFuncPtrName(glVertexAttribIPointerEXT))(GLuint, int, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribIivEXT))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribIuivEXT))(GLuint, GLenum, GLuint*);
extern void (GLApi *GLFuncPtrName(glUniform1uiEXT))(int, GLuint);
extern void (GLApi *GLFuncPtrName(glUniform2uiEXT))(int, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glUniform3uiEXT))(int, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glUniform4uiEXT))(int, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glUniform1uivEXT))(int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glUniform2uivEXT))(int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glUniform3uivEXT))(int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glUniform4uivEXT))(int, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetUniformuivEXT))(GLuint, int, GLuint*);
extern void (GLApi *GLFuncPtrName(glBindFragDataLocationEXT))(GLuint, GLuint, const GLchar*);
extern int (GLApi *GLFuncPtrName(glGetFragDataLocationEXT))(GLuint, const GLchar*);

#define glVertexAttribI1iEXT GLFuncPtrName(glVertexAttribI1iEXT)
#define glVertexAttribI2iEXT GLFuncPtrName(glVertexAttribI2iEXT)
#define glVertexAttribI3iEXT GLFuncPtrName(glVertexAttribI3iEXT)
#define glVertexAttribI4iEXT GLFuncPtrName(glVertexAttribI4iEXT)
#define glVertexAttribI1uiEXT GLFuncPtrName(glVertexAttribI1uiEXT)
#define glVertexAttribI2uiEXT GLFuncPtrName(glVertexAttribI2uiEXT)
#define glVertexAttribI3uiEXT GLFuncPtrName(glVertexAttribI3uiEXT)
#define glVertexAttribI4uiEXT GLFuncPtrName(glVertexAttribI4uiEXT)
#define glVertexAttribI1ivEXT GLFuncPtrName(glVertexAttribI1ivEXT)
#define glVertexAttribI2ivEXT GLFuncPtrName(glVertexAttribI2ivEXT)
#define glVertexAttribI3ivEXT GLFuncPtrName(glVertexAttribI3ivEXT)
#define glVertexAttribI4ivEXT GLFuncPtrName(glVertexAttribI4ivEXT)
#define glVertexAttribI1uivEXT GLFuncPtrName(glVertexAttribI1uivEXT)
#define glVertexAttribI2uivEXT GLFuncPtrName(glVertexAttribI2uivEXT)
#define glVertexAttribI3uivEXT GLFuncPtrName(glVertexAttribI3uivEXT)
#define glVertexAttribI4uivEXT GLFuncPtrName(glVertexAttribI4uivEXT)
#define glVertexAttribI4bvEXT GLFuncPtrName(glVertexAttribI4bvEXT)
#define glVertexAttribI4svEXT GLFuncPtrName(glVertexAttribI4svEXT)
#define glVertexAttribI4ubvEXT GLFuncPtrName(glVertexAttribI4ubvEXT)
#define glVertexAttribI4usvEXT GLFuncPtrName(glVertexAttribI4usvEXT)
#define glVertexAttribIPointerEXT GLFuncPtrName(glVertexAttribIPointerEXT)
#define glGetVertexAttribIivEXT GLFuncPtrName(glGetVertexAttribIivEXT)
#define glGetVertexAttribIuivEXT GLFuncPtrName(glGetVertexAttribIuivEXT)
#define glUniform1uiEXT GLFuncPtrName(glUniform1uiEXT)
#define glUniform2uiEXT GLFuncPtrName(glUniform2uiEXT)
#define glUniform3uiEXT GLFuncPtrName(glUniform3uiEXT)
#define glUniform4uiEXT GLFuncPtrName(glUniform4uiEXT)
#define glUniform1uivEXT GLFuncPtrName(glUniform1uivEXT)
#define glUniform2uivEXT GLFuncPtrName(glUniform2uivEXT)
#define glUniform3uivEXT GLFuncPtrName(glUniform3uivEXT)
#define glUniform4uivEXT GLFuncPtrName(glUniform4uivEXT)
#define glGetUniformuivEXT GLFuncPtrName(glGetUniformuivEXT)
#define glBindFragDataLocationEXT GLFuncPtrName(glBindFragDataLocationEXT)
#define glGetFragDataLocationEXT GLFuncPtrName(glGetFragDataLocationEXT)

#endif // GL_EXT_gpu_shader4

//								--- GL_EXT_multi_draw_arrays ---

#ifndef GL_EXT_multi_draw_arrays
#define GL_EXT_multi_draw_arrays 1
#define __GENERATE_GL_EXT_multi_draw_arrays

extern bool GLEH_EXT_multi_draw_arrays; /**< set if GL_EXT_multi_draw_arrays is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glglMultiDrawArraysEXT))(GLenum, int*, GLsizei*, GLsizei);
extern void (GLApi *GLFuncPtrName(glglMultiDrawElementsEXT))(GLenum, GLsizei*, GLenum, const void**, GLsizei);

#define glglMultiDrawArraysEXT GLFuncPtrName(glglMultiDrawArraysEXT)
#define glglMultiDrawElementsEXT GLFuncPtrName(glglMultiDrawElementsEXT)

#endif // GL_EXT_multi_draw_arrays

//								--- GL_EXT_packed_depth_stencil ---

#ifndef GL_EXT_packed_depth_stencil
#define GL_EXT_packed_depth_stencil 1

extern bool GLEH_EXT_packed_depth_stencil; /**< set if GL_EXT_packed_depth_stencil is supported */

#define GL_DEPTH_STENCIL_EXT                                         0x84f9
#define GL_UNSIGNED_INT_24_8_EXT                                     0x84fa
#define GL_DEPTH24_STENCIL8_EXT                                      0x88f0
#define GL_TEXTURE_STENCIL_SIZE_EXT                                  0x88f1

// no new procedures or functions

#endif // GL_EXT_packed_depth_stencil

//								--- GL_EXT_packed_float ---

#ifndef GL_EXT_packed_float
#define GL_EXT_packed_float 1

extern bool GLEH_EXT_packed_float; /**< set if GL_EXT_packed_float is supported */

#define GL_R11F_G11F_B10F_EXT                                        0x8c3a
#define GL_UNSIGNED_INT_10F_11F_11F_REV_EXT                          0x8c3b
#define GL_RGBA_SIGNED_COMPONENTS_EXT                                0x8c3c
#define GL_WGL_TYPE_RGBA_UNSIGNED_FLOAT_EXT                          0x20a8
#define GL_GLX_RGBA_UNSIGNED_FLOAT_TYPE_EXT                          0x20b1
#define GL_GLX_RGBA_UNSIGNED_FLOAT_BIT_EXT                           0x00000008

// no new procedures or functions

#endif // GL_EXT_packed_float

//								--- GL_EXT_packed_pixels ---

#ifndef GL_EXT_packed_pixels
#define GL_EXT_packed_pixels 1

extern bool GLEH_EXT_packed_pixels; /**< set if GL_EXT_packed_pixels is supported */

#define GL_UNSIGNED_BYTE_3_3_2_EXT                                   0x8032
#define GL_UNSIGNED_SHORT_4_4_4_4_EXT                                0x8033
#define GL_UNSIGNED_SHORT_5_5_5_1_EXT                                0x8034
#define GL_UNSIGNED_INT_8_8_8_8_EXT                                  0x8035
#define GL_UNSIGNED_INT_10_10_10_2_EXT                               0x8036

// no new procedures or functions

#endif // GL_EXT_packed_pixels

//								--- GL_EXT_pixel_buffer_object ---

#ifndef GL_EXT_pixel_buffer_object
#define GL_EXT_pixel_buffer_object 1

extern bool GLEH_EXT_pixel_buffer_object; /**< set if GL_EXT_pixel_buffer_object is supported */

#define GL_PIXEL_PACK_BUFFER_EXT                                     0x88eb
#define GL_PIXEL_UNPACK_BUFFER_EXT                                   0x88ec
#define GL_PIXEL_PACK_BUFFER_BINDING_EXT                             0x88ed
#define GL_PIXEL_UNPACK_BUFFER_BINDING_EXT                           0x88ef

// no new procedures or functions

#endif // GL_EXT_pixel_buffer_object

//								--- GL_EXT_point_parameters ---

#ifndef GL_EXT_point_parameters
#define GL_EXT_point_parameters 1
#define __GENERATE_GL_EXT_point_parameters

extern bool GLEH_EXT_point_parameters; /**< set if GL_EXT_point_parameters is supported */

#define GL_POINT_SIZE_MIN_EXT                                        0x8126
#define GL_POINT_SIZE_MAX_EXT                                        0x8127
#define GL_POINT_FADE_THRESHOLD_SIZE_EXT                             0x8128
#define GL_DISTANCE_ATTENUATION_EXT                                  0x8129

extern void (GLApi *GLFuncPtrName(glglPointParameterfEXT))(GLenum, float);
extern void (GLApi *GLFuncPtrName(glglPointParameterfvEXT))(GLenum, float*);

#define glglPointParameterfEXT GLFuncPtrName(glglPointParameterfEXT)
#define glglPointParameterfvEXT GLFuncPtrName(glglPointParameterfvEXT)

#endif // GL_EXT_point_parameters

//								--- GL_EXT_provoking_vertex ---

#ifndef GL_EXT_provoking_vertex
#define GL_EXT_provoking_vertex 1
#define __GENERATE_GL_EXT_provoking_vertex

extern bool GLEH_EXT_provoking_vertex; /**< set if GL_EXT_provoking_vertex is supported */

#define GL_FIRST_VERTEX_CONVENTION_EXT                               0x8e4d
#define GL_LAST_VERTEX_CONVENTION_EXT                                0x8e4e
#define GL_PROVOKING_VERTEX_EXT                                      0x8e4f
#define GL_QUADS_FOLLOW_PROVOKING_VERTEX_CONVENTION_EXT              0x8e4c

extern void (GLApi *GLFuncPtrName(glProvokingVertexEXT))(GLenum);

#define glProvokingVertexEXT GLFuncPtrName(glProvokingVertexEXT)

#endif // GL_EXT_provoking_vertex

//								--- GL_EXT_rescale_normal ---

#ifndef GL_EXT_rescale_normal
#define GL_EXT_rescale_normal 1

extern bool GLEH_EXT_rescale_normal; /**< set if GL_EXT_rescale_normal is supported */

#define GL_RESCALE_NORMAL_EXT                                        0x803a

// no new procedures or functions

#endif // GL_EXT_rescale_normal

//								--- GL_EXT_secondary_color ---

#ifndef GL_EXT_secondary_color
#define GL_EXT_secondary_color 1
#define __GENERATE_GL_EXT_secondary_color

extern bool GLEH_EXT_secondary_color; /**< set if GL_EXT_secondary_color is supported */

#define GL_COLOR_SUM_EXT                                             0x8458
#define GL_CURRENT_SECONDARY_COLOR_EXT                               0x8459
#define GL_SECONDARY_COLOR_ARRAY_SIZE_EXT                            0x845a
#define GL_SECONDARY_COLOR_ARRAY_TYPE_EXT                            0x845b
#define GL_SECONDARY_COLOR_ARRAY_STRIDE_EXT                          0x845c
#define GL_SECONDARY_COLOR_ARRAY_POINTER_EXT                         0x845d
#define GL_SECONDARY_COLOR_ARRAY_EXT                                 0x845e

extern void (GLApi *GLFuncPtrName(glSecondaryColor3bEXT))(GLbyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3sEXT))(short);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3iEXT))(int);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3fEXT))(float);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3dEXT))(double);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ubEXT))(GLubyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3usEXT))(GLushort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3uiEXT))(GLuint);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3bvEXT))(GLbyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3svEXT))(short);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ivEXT))(int);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3fvEXT))(float);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3dvEXT))(double);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3ubvEXT))(GLubyte);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3usvEXT))(GLushort);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3uivEXT))(GLuint);
extern void (GLApi *GLFuncPtrName(glSecondaryColorPointerEXT))(int, GLenum, GLsizei, void*);

#define glSecondaryColor3bEXT GLFuncPtrName(glSecondaryColor3bEXT)
#define glSecondaryColor3sEXT GLFuncPtrName(glSecondaryColor3sEXT)
#define glSecondaryColor3iEXT GLFuncPtrName(glSecondaryColor3iEXT)
#define glSecondaryColor3fEXT GLFuncPtrName(glSecondaryColor3fEXT)
#define glSecondaryColor3dEXT GLFuncPtrName(glSecondaryColor3dEXT)
#define glSecondaryColor3ubEXT GLFuncPtrName(glSecondaryColor3ubEXT)
#define glSecondaryColor3usEXT GLFuncPtrName(glSecondaryColor3usEXT)
#define glSecondaryColor3uiEXT GLFuncPtrName(glSecondaryColor3uiEXT)
#define glSecondaryColor3bvEXT GLFuncPtrName(glSecondaryColor3bvEXT)
#define glSecondaryColor3svEXT GLFuncPtrName(glSecondaryColor3svEXT)
#define glSecondaryColor3ivEXT GLFuncPtrName(glSecondaryColor3ivEXT)
#define glSecondaryColor3fvEXT GLFuncPtrName(glSecondaryColor3fvEXT)
#define glSecondaryColor3dvEXT GLFuncPtrName(glSecondaryColor3dvEXT)
#define glSecondaryColor3ubvEXT GLFuncPtrName(glSecondaryColor3ubvEXT)
#define glSecondaryColor3usvEXT GLFuncPtrName(glSecondaryColor3usvEXT)
#define glSecondaryColor3uivEXT GLFuncPtrName(glSecondaryColor3uivEXT)
#define glSecondaryColorPointerEXT GLFuncPtrName(glSecondaryColorPointerEXT)

#endif // GL_EXT_secondary_color

//								--- GL_EXT_separate_shader_objects ---

#ifndef GL_EXT_separate_shader_objects
#define GL_EXT_separate_shader_objects 1
#define __GENERATE_GL_EXT_separate_shader_objects

extern bool GLEH_EXT_separate_shader_objects; /**< set if GL_EXT_separate_shader_objects is supported */

#define GL_ACTIVE_PROGRAM_EXT                                        0x8b8d

extern void (GLApi *GLFuncPtrName(glUseShaderProgramEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glActiveProgramEXT))(GLuint);
extern GLuint (GLApi *GLFuncPtrName(glCreateShaderProgramEXT))(GLenum, const GLchar*);

#define glUseShaderProgramEXT GLFuncPtrName(glUseShaderProgramEXT)
#define glActiveProgramEXT GLFuncPtrName(glActiveProgramEXT)
#define glCreateShaderProgramEXT GLFuncPtrName(glCreateShaderProgramEXT)

#endif // GL_EXT_separate_shader_objects

//								--- GL_EXT_separate_specular_color ---

#ifndef GL_EXT_separate_specular_color
#define GL_EXT_separate_specular_color 1

extern bool GLEH_EXT_separate_specular_color; /**< set if GL_EXT_separate_specular_color is supported */

#define GL_LIGHT_MODEL_COLOR_CONTROL_EXT                             0x81f8
#define GL_SINGLE_COLOR_EXT                                          0x81f9
#define GL_SEPARATE_SPECULAR_COLOR_EXT                               0x81fa

// no new procedures or functions

#endif // GL_EXT_separate_specular_color

//								--- GL_EXT_shadow_funcs ---

#ifndef GL_EXT_shadow_funcs
#define GL_EXT_shadow_funcs 1

extern bool GLEH_EXT_shadow_funcs; /**< set if GL_EXT_shadow_funcs is supported */

// no new tokens
// no new procedures or functions

#endif // GL_EXT_shadow_funcs

//								--- GL_EXT_stencil_two_side ---

#ifndef GL_EXT_stencil_two_side
#define GL_EXT_stencil_two_side 1
#define __GENERATE_GL_EXT_stencil_two_side

extern bool GLEH_EXT_stencil_two_side; /**< set if GL_EXT_stencil_two_side is supported */

#define GL_STENCIL_TEST_TWO_SIDE_EXT                                 0x8910
#define GL_ACTIVE_STENCIL_FACE_EXT                                   0x8911

extern void (GLApi *GLFuncPtrName(glActiveStencilFaceEXT))(GLenum);

#define glActiveStencilFaceEXT GLFuncPtrName(glActiveStencilFaceEXT)

#endif // GL_EXT_stencil_two_side

//								--- GL_EXT_stencil_wrap ---

#ifndef GL_EXT_stencil_wrap
#define GL_EXT_stencil_wrap 1

extern bool GLEH_EXT_stencil_wrap; /**< set if GL_EXT_stencil_wrap is supported */

#define GL_INCR_WRAP_EXT                                             0x8507
#define GL_DECR_WRAP_EXT                                             0x8508

// no new procedures or functions

#endif // GL_EXT_stencil_wrap

//								--- GL_EXT_texture3D ---

#ifndef GL_EXT_texture3D
#define GL_EXT_texture3D 1
#define __GENERATE_GL_EXT_texture3D

extern bool GLEH_EXT_texture3D; /**< set if GL_EXT_texture3D is supported */

#define GL_PACK_SKIP_IMAGES_EXT                                      0x806b
#define GL_PACK_IMAGE_HEIGHT_EXT                                     0x806c
#define GL_UNPACK_SKIP_IMAGES_EXT                                    0x806d
#define GL_UNPACK_IMAGE_HEIGHT_EXT                                   0x806e
#define GL_TEXTURE_3D_EXT                                            0x806f
#define GL_PROXY_TEXTURE_3D_EXT                                      0x8070
#define GL_TEXTURE_DEPTH_EXT                                         0x8071
#define GL_TEXTURE_WRAP_R_EXT                                        0x8072
#define GL_MAX_3D_TEXTURE_SIZE_EXT                                   0x8073

extern void (GLApi *GLFuncPtrName(glTexImage3DEXT))(GLenum, int, GLenum, GLsizei, GLsizei, GLsizei, int, GLenum, GLenum, const void*);

#define glTexImage3DEXT GLFuncPtrName(glTexImage3DEXT)

#endif // GL_EXT_texture3D

//								--- GL_EXT_texture_array ---

#ifndef GL_EXT_texture_array
#define GL_EXT_texture_array 1
#define __GENERATE_GL_EXT_texture_array

extern bool GLEH_EXT_texture_array; /**< set if GL_EXT_texture_array is supported */

#define GL_TEXTURE_1D_ARRAY_EXT                                      0x8c18
#define GL_TEXTURE_2D_ARRAY_EXT                                      0x8c1a
#define GL_PROXY_TEXTURE_2D_ARRAY_EXT                                0x8c1b
#define GL_PROXY_TEXTURE_1D_ARRAY_EXT                                0x8c19
#define GL_TEXTURE_BINDING_1D_ARRAY_EXT                              0x8c1c
#define GL_TEXTURE_BINDING_2D_ARRAY_EXT                              0x8c1d
#define GL_MAX_ARRAY_TEXTURE_LAYERS_EXT                              0x88ff
#define GL_COMPARE_REF_DEPTH_TO_TEXTURE_EXT                          0x884e
#define GL_FRAMEBUFFER_ATTACHMENT_TEXTURE_LAYER_EXT                  0x8cd4
#define GL_SAMPLER_1D_ARRAY_EXT                                      0x8dc0
#define GL_SAMPLER_2D_ARRAY_EXT                                      0x8dc1
#define GL_SAMPLER_1D_ARRAY_SHADOW_EXT                               0x8dc3
#define GL_SAMPLER_2D_ARRAY_SHADOW_EXT                               0x8dc4

extern void (GLApi *GLFuncPtrName(glFramebufferTextureLayerEXT))(GLenum, GLenum, GLuint, int, int);

#define glFramebufferTextureLayerEXT GLFuncPtrName(glFramebufferTextureLayerEXT)

#endif // GL_EXT_texture_array

//								--- GL_EXT_texture_buffer_object ---

#ifndef GL_EXT_texture_buffer_object
#define GL_EXT_texture_buffer_object 1
#define __GENERATE_GL_EXT_texture_buffer_object

extern bool GLEH_EXT_texture_buffer_object; /**< set if GL_EXT_texture_buffer_object is supported */

#define GL_TEXTURE_BUFFER_EXT                                        0x8c2a
#define GL_MAX_TEXTURE_BUFFER_SIZE_EXT                               0x8c2b
#define GL_TEXTURE_BINDING_BUFFER_EXT                                0x8c2c
#define GL_TEXTURE_BUFFER_DATA_STORE_BINDING_EXT                     0x8c2d
#define GL_TEXTURE_BUFFER_FORMAT_EXT                                 0x8c2e

extern void (GLApi *GLFuncPtrName(glTexBufferEXT))(GLenum, GLenum, GLuint);

#define glTexBufferEXT GLFuncPtrName(glTexBufferEXT)

#endif // GL_EXT_texture_buffer_object

//								--- GL_EXT_texture_compression_latc ---

#ifndef GL_EXT_texture_compression_latc
#define GL_EXT_texture_compression_latc 1

extern bool GLEH_EXT_texture_compression_latc; /**< set if GL_EXT_texture_compression_latc is supported */

#define GL_COMPRESSED_LUMINANCE_LATC1_EXT                            0x8c70
#define GL_COMPRESSED_SIGNED_LUMINANCE_LATC1_EXT                     0x8c71
#define GL_COMPRESSED_LUMINANCE_ALPHA_LATC2_EXT                      0x8c72
#define GL_COMPRESSED_SIGNED_LUMINANCE_ALPHA_LATC2_EXT               0x8c73

// no new procedures or functions

#endif // GL_EXT_texture_compression_latc

//								--- GL_EXT_texture_compression_rgtc ---

#ifndef GL_EXT_texture_compression_rgtc
#define GL_EXT_texture_compression_rgtc 1

extern bool GLEH_EXT_texture_compression_rgtc; /**< set if GL_EXT_texture_compression_rgtc is supported */

#define GL_COMPRESSED_RED_RGTC1_EXT                                  0x8dbb
#define GL_COMPRESSED_SIGNED_RED_RGTC1_EXT                           0x8dbc
#define GL_COMPRESSED_RED_GREEN_RGTC2_EXT                            0x8dbd
#define GL_COMPRESSED_SIGNED_RED_GREEN_RGTC2_EXT                     0x8dbe

// no new procedures or functions

#endif // GL_EXT_texture_compression_rgtc

//								--- GL_EXT_texture_compression_s3tc ---

#ifndef GL_EXT_texture_compression_s3tc
#define GL_EXT_texture_compression_s3tc 1

extern bool GLEH_EXT_texture_compression_s3tc; /**< set if GL_EXT_texture_compression_s3tc is supported */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT                              0x83f0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                             0x83f1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                             0x83f2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                             0x83f3

// no new procedures or functions

#endif // GL_EXT_texture_compression_s3tc

//								--- GL_EXT_texture_env_combine ---

#ifndef GL_EXT_texture_env_combine
#define GL_EXT_texture_env_combine 1

extern bool GLEH_EXT_texture_env_combine; /**< set if GL_EXT_texture_env_combine is supported */

#define GL_COMBINE_EXT                                               0x8570
#define GL_COMBINE_RGB_EXT                                           0x8571
#define GL_COMBINE_ALPHA_EXT                                         0x8572
#define GL_SOURCE0_RGB_EXT                                           0x8580
#define GL_SOURCE1_RGB_EXT                                           0x8581
#define GL_SOURCE2_RGB_EXT                                           0x8582
#define GL_SOURCE0_ALPHA_EXT                                         0x8588
#define GL_SOURCE1_ALPHA_EXT                                         0x8589
#define GL_SOURCE2_ALPHA_EXT                                         0x858a
#define GL_OPERAND0_RGB_EXT                                          0x8590
#define GL_OPERAND1_RGB_EXT                                          0x8591
#define GL_OPERAND2_RGB_EXT                                          0x8592
#define GL_OPERAND0_ALPHA_EXT                                        0x8598
#define GL_OPERAND1_ALPHA_EXT                                        0x8599
#define GL_OPERAND2_ALPHA_EXT                                        0x859a
#define GL_RGB_SCALE_EXT                                             0x8573
#define GL_ADD_SIGNED_EXT                                            0x8574
#define GL_INTERPOLATE_EXT                                           0x8575
#define GL_CONSTANT_EXT                                              0x8576
#define GL_PRIMARY_COLOR_EXT                                         0x8577
#define GL_PREVIOUS_EXT                                              0x8578

// no new procedures or functions

#endif // GL_EXT_texture_env_combine

//								--- GL_EXT_texture_env_dot3 ---

#ifndef GL_EXT_texture_env_dot3
#define GL_EXT_texture_env_dot3 1

extern bool GLEH_EXT_texture_env_dot3; /**< set if GL_EXT_texture_env_dot3 is supported */

#define GL_DOT3_RGB_EXT                                              0x8740
#define GL_DOT3_RGBA_EXT                                             0x8741

// no new procedures or functions

#endif // GL_EXT_texture_env_dot3

//								--- GL_EXT_texture_filter_anisotropic ---

#ifndef GL_EXT_texture_filter_anisotropic
#define GL_EXT_texture_filter_anisotropic 1

extern bool GLEH_EXT_texture_filter_anisotropic; /**< set if GL_EXT_texture_filter_anisotropic is supported */

#define GL_TEXTURE_MAX_ANISOTROPY_EXT                                0x84fe
#define GL_MAX_TEXTURE_MAX_ANISOTROPY_EXT                            0x84ff

// no new procedures or functions

#endif // GL_EXT_texture_filter_anisotropic

//								--- GL_EXT_texture_integer ---

#ifndef GL_EXT_texture_integer
#define GL_EXT_texture_integer 1
#define __GENERATE_GL_EXT_texture_integer

extern bool GLEH_EXT_texture_integer; /**< set if GL_EXT_texture_integer is supported */

#define GL_RGBA_INTEGER_MODE_EXT                                     0x8d9e
#define GL_RGBA32UI_EXT                                              0x8d70
#define GL_RGB32UI_EXT                                               0x8d71
#define GL_ALPHA32UI_EXT                                             0x8d72
#define GL_INTENSITY32UI_EXT                                         0x8d73
#define GL_LUMINANCE32UI_EXT                                         0x8d74
#define GL_LUMINANCE_ALPHA32UI_EXT                                   0x8d75
#define GL_RGBA16UI_EXT                                              0x8d76
#define GL_RGB16UI_EXT                                               0x8d77
#define GL_ALPHA16UI_EXT                                             0x8d78
#define GL_INTENSITY16UI_EXT                                         0x8d79
#define GL_LUMINANCE16UI_EXT                                         0x8d7a
#define GL_LUMINANCE_ALPHA16UI_EXT                                   0x8d7b
#define GL_RGBA8UI_EXT                                               0x8d7c
#define GL_RGB8UI_EXT                                                0x8d7d
#define GL_ALPHA8UI_EXT                                              0x8d7e
#define GL_INTENSITY8UI_EXT                                          0x8d7f
#define GL_LUMINANCE8UI_EXT                                          0x8d80
#define GL_LUMINANCE_ALPHA8UI_EXT                                    0x8d81
#define GL_RGBA32I_EXT                                               0x8d82
#define GL_RGB32I_EXT                                                0x8d83
#define GL_ALPHA32I_EXT                                              0x8d84
#define GL_INTENSITY32I_EXT                                          0x8d85
#define GL_LUMINANCE32I_EXT                                          0x8d86
#define GL_LUMINANCE_ALPHA32I_EXT                                    0x8d87
#define GL_RGBA16I_EXT                                               0x8d88
#define GL_RGB16I_EXT                                                0x8d89
#define GL_ALPHA16I_EXT                                              0x8d8a
#define GL_INTENSITY16I_EXT                                          0x8d8b
#define GL_LUMINANCE16I_EXT                                          0x8d8c
#define GL_LUMINANCE_ALPHA16I_EXT                                    0x8d8d
#define GL_RGBA8I_EXT                                                0x8d8e
#define GL_RGB8I_EXT                                                 0x8d8f
#define GL_ALPHA8I_EXT                                               0x8d90
#define GL_INTENSITY8I_EXT                                           0x8d91
#define GL_LUMINANCE8I_EXT                                           0x8d92
#define GL_LUMINANCE_ALPHA8I_EXT                                     0x8d93
#define GL_RED_INTEGER_EXT                                           0x8d94
#define GL_GREEN_INTEGER_EXT                                         0x8d95
#define GL_BLUE_INTEGER_EXT                                          0x8d96
#define GL_ALPHA_INTEGER_EXT                                         0x8d97
#define GL_RGB_INTEGER_EXT                                           0x8d98
#define GL_RGBA_INTEGER_EXT                                          0x8d99
#define GL_BGR_INTEGER_EXT                                           0x8d9a
#define GL_BGRA_INTEGER_EXT                                          0x8d9b
#define GL_LUMINANCE_INTEGER_EXT                                     0x8d9c
#define GL_LUMINANCE_ALPHA_INTEGER_EXT                               0x8d9d

extern void (GLApi *GLFuncPtrName(glClearColorIiEXT))(int, int, int, int);
extern void (GLApi *GLFuncPtrName(glClearColorIuiEXT))(GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glTexParameterIivEXT))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glTexParameterIuivEXT))(GLenum, GLenum, GLuint*);
extern void (GLApi *GLFuncPtrName(glGetTexParameterIivEXT))(GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetTexParameterIuivEXT))(GLenum, GLenum, GLuint*);

#define glClearColorIiEXT GLFuncPtrName(glClearColorIiEXT)
#define glClearColorIuiEXT GLFuncPtrName(glClearColorIuiEXT)
#define glTexParameterIivEXT GLFuncPtrName(glTexParameterIivEXT)
#define glTexParameterIuivEXT GLFuncPtrName(glTexParameterIuivEXT)
#define glGetTexParameterIivEXT GLFuncPtrName(glGetTexParameterIivEXT)
#define glGetTexParameterIuivEXT GLFuncPtrName(glGetTexParameterIuivEXT)

#endif // GL_EXT_texture_integer

//								--- GL_EXT_texture_lod_bias ---

#ifndef GL_EXT_texture_lod_bias
#define GL_EXT_texture_lod_bias 1

extern bool GLEH_EXT_texture_lod_bias; /**< set if GL_EXT_texture_lod_bias is supported */

#define GL_TEXTURE_FILTER_CONTROL_EXT                                0x8500
#define GL_TEXTURE_LOD_BIAS_EXT                                      0x8501
#define GL_MAX_TEXTURE_LOD_BIAS_EXT                                  0x84fd

// no new procedures or functions

#endif // GL_EXT_texture_lod_bias

//								--- GL_EXT_texture_mirror_clamp ---

#ifndef GL_EXT_texture_mirror_clamp
#define GL_EXT_texture_mirror_clamp 1

extern bool GLEH_EXT_texture_mirror_clamp; /**< set if GL_EXT_texture_mirror_clamp is supported */

#define GL_MIRROR_CLAMP_EXT                                          0x8742
#define GL_MIRROR_CLAMP_TO_EDGE_EXT                                  0x8743
#define GL_MIRROR_CLAMP_TO_BORDER_EXT                                0x8912

// no new procedures or functions

#endif // GL_EXT_texture_mirror_clamp

//								--- GL_EXT_texture_object ---

#ifndef GL_EXT_texture_object
#define GL_EXT_texture_object 1
#define __GENERATE_GL_EXT_texture_object

extern bool GLEH_EXT_texture_object; /**< set if GL_EXT_texture_object is supported */

#define GL_TEXTURE_PRIORITY_EXT                                      0x8066
#define GL_TEXTURE_RESIDENT_EXT                                      0x8067
#define GL_TEXTURE_1D_BINDING_EXT                                    0x8068
#define GL_TEXTURE_2D_BINDING_EXT                                    0x8069
#define GL_TEXTURE_3D_BINDING_EXT                                    0x806a

extern void (GLApi *GLFuncPtrName(glGenTexturesEXT))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glDeleteTexturesEXT))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glBindTextureEXT))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glPrioritizeTexturesEXT))(GLsizei, const GLuint*, const GLclampf*);
extern GLboolean (GLApi *GLFuncPtrName(glAreTexturesResidentEXT))(GLsizei, const GLuint*, GLboolean*);
extern GLboolean (GLApi *GLFuncPtrName(glIsTextureEXT))(GLuint);

#define glGenTexturesEXT GLFuncPtrName(glGenTexturesEXT)
#define glDeleteTexturesEXT GLFuncPtrName(glDeleteTexturesEXT)
#define glBindTextureEXT GLFuncPtrName(glBindTextureEXT)
#define glPrioritizeTexturesEXT GLFuncPtrName(glPrioritizeTexturesEXT)
#define glAreTexturesResidentEXT GLFuncPtrName(glAreTexturesResidentEXT)
#define glIsTextureEXT GLFuncPtrName(glIsTextureEXT)

#endif // GL_EXT_texture_object

//								--- GL_EXT_texture_shared_exponent ---

#ifndef GL_EXT_texture_shared_exponent
#define GL_EXT_texture_shared_exponent 1

extern bool GLEH_EXT_texture_shared_exponent; /**< set if GL_EXT_texture_shared_exponent is supported */

#define GL_RGB9_E5_EXT                                               0x8c3d
#define GL_UNSIGNED_INT_5_9_9_9_REV_EXT                              0x8c3e
#define GL_TEXTURE_SHARED_SIZE_EXT                                   0x8c3f

// no new procedures or functions

#endif // GL_EXT_texture_shared_exponent

//								--- GL_EXT_texture_sRGB ---

#ifndef GL_EXT_texture_sRGB
#define GL_EXT_texture_sRGB 1

extern bool GLEH_EXT_texture_sRGB; /**< set if GL_EXT_texture_sRGB is supported */

#define GL_SRGB_EXT                                                  0x8c40
#define GL_SRGB8_EXT                                                 0x8c41
#define GL_SRGB_ALPHA_EXT                                            0x8c42
#define GL_SRGB8_ALPHA8_EXT                                          0x8c43
#define GL_SLUMINANCE_ALPHA_EXT                                      0x8c44
#define GL_SLUMINANCE8_ALPHA8_EXT                                    0x8c45
#define GL_SLUMINANCE_EXT                                            0x8c46
#define GL_SLUMINANCE8_EXT                                           0x8c47
#define GL_COMPRESSED_SRGB_EXT                                       0x8c48
#define GL_COMPRESSED_SRGB_ALPHA_EXT                                 0x8c49
#define GL_COMPRESSED_SLUMINANCE_EXT                                 0x8c4a
#define GL_COMPRESSED_SLUMINANCE_ALPHA_EXT                           0x8c4b
#define GL_COMPRESSED_SRGB_S3TC_DXT1_EXT                             0x8c4c
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT1_EXT                       0x8c4d
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT3_EXT                       0x8c4e
#define GL_COMPRESSED_SRGB_ALPHA_S3TC_DXT5_EXT                       0x8c4f

// no new procedures or functions

#endif // GL_EXT_texture_sRGB

//								--- GL_EXT_texture_swizzle ---

#ifndef GL_EXT_texture_swizzle
#define GL_EXT_texture_swizzle 1

extern bool GLEH_EXT_texture_swizzle; /**< set if GL_EXT_texture_swizzle is supported */

#define GL_TEXTURE_SWIZZLE_R_EXT                                     0x8e42
#define GL_TEXTURE_SWIZZLE_G_EXT                                     0x8e43
#define GL_TEXTURE_SWIZZLE_B_EXT                                     0x8e44
#define GL_TEXTURE_SWIZZLE_A_EXT                                     0x8e45
#define GL_TEXTURE_SWIZZLE_RGBA_EXT                                  0x8e46

// no new procedures or functions

#endif // GL_EXT_texture_swizzle

//								--- GL_EXT_timer_query ---

#ifndef GL_EXT_timer_query
#define GL_EXT_timer_query 1
#define __GENERATE_GL_EXT_timer_query

extern bool GLEH_EXT_timer_query; /**< set if GL_EXT_timer_query is supported */

#define GL_TIME_ELAPSED_EXT                                          0x88bf

extern void (GLApi *GLFuncPtrName(glGetQueryObjecti64vEXT))(GLuint, GLenum, GLint64EXT*);
extern void (GLApi *GLFuncPtrName(glGetQueryObjectui64vEXT))(GLuint, GLenum, GLuint64EXT*);

#define glGetQueryObjecti64vEXT GLFuncPtrName(glGetQueryObjecti64vEXT)
#define glGetQueryObjectui64vEXT GLFuncPtrName(glGetQueryObjectui64vEXT)

#endif // GL_EXT_timer_query

//								--- GL_EXT_vertex_array ---

#ifndef GL_EXT_vertex_array
#define GL_EXT_vertex_array 1
#define __GENERATE_GL_EXT_vertex_array

extern bool GLEH_EXT_vertex_array; /**< set if GL_EXT_vertex_array is supported */

#define GL_VERTEX_ARRAY_EXT                                          0x8074
#define GL_NORMAL_ARRAY_EXT                                          0x8075
#define GL_COLOR_ARRAY_EXT                                           0x8076
#define GL_INDEX_ARRAY_EXT                                           0x8077
#define GL_TEXTURE_COORD_ARRAY_EXT                                   0x8078
#define GL_EDGE_FLAG_ARRAY_EXT                                       0x8079
#define GL_DOUBLE_EXT                                                0x140a
#define GL_VERTEX_ARRAY_SIZE_EXT                                     0x807a
#define GL_VERTEX_ARRAY_TYPE_EXT                                     0x807b
#define GL_VERTEX_ARRAY_STRIDE_EXT                                   0x807c
#define GL_VERTEX_ARRAY_COUNT_EXT                                    0x807d
#define GL_NORMAL_ARRAY_TYPE_EXT                                     0x807e
#define GL_NORMAL_ARRAY_STRIDE_EXT                                   0x807f
#define GL_NORMAL_ARRAY_COUNT_EXT                                    0x8080
#define GL_COLOR_ARRAY_SIZE_EXT                                      0x8081
#define GL_COLOR_ARRAY_TYPE_EXT                                      0x8082
#define GL_COLOR_ARRAY_STRIDE_EXT                                    0x8083
#define GL_COLOR_ARRAY_COUNT_EXT                                     0x8084
#define GL_INDEX_ARRAY_TYPE_EXT                                      0x8085
#define GL_INDEX_ARRAY_STRIDE_EXT                                    0x8086
#define GL_INDEX_ARRAY_COUNT_EXT                                     0x8087
#define GL_TEXTURE_COORD_ARRAY_SIZE_EXT                              0x8088
#define GL_TEXTURE_COORD_ARRAY_TYPE_EXT                              0x8089
#define GL_TEXTURE_COORD_ARRAY_STRIDE_EXT                            0x808a
#define GL_TEXTURE_COORD_ARRAY_COUNT_EXT                             0x808b
#define GL_EDGE_FLAG_ARRAY_STRIDE_EXT                                0x808c
#define GL_EDGE_FLAG_ARRAY_COUNT_EXT                                 0x808d
#define GL_VERTEX_ARRAY_POINTER_EXT                                  0x808e
#define GL_NORMAL_ARRAY_POINTER_EXT                                  0x808f
#define GL_COLOR_ARRAY_POINTER_EXT                                   0x8090
#define GL_INDEX_ARRAY_POINTER_EXT                                   0x8091
#define GL_TEXTURE_COORD_ARRAY_POINTER_EXT                           0x8092
#define GL_EDGE_FLAG_ARRAY_POINTER_EXT                               0x8093

extern void (GLApi *GLFuncPtrName(glArrayElementEXT))(int);
extern void (GLApi *GLFuncPtrName(glDrawArraysEXT))(GLenum, int, GLsizei);
extern void (GLApi *GLFuncPtrName(glVertexPointerEXT))(int, GLenum, GLsizei, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glNormalPointerEXT))(GLenum, GLsizei, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glColorPointerEXT))(int, GLenum, GLsizei, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glIndexPointerEXT))(GLenum, GLsizei, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glTexCoordPointerEXT))(int, GLenum, GLsizei, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glEdgeFlagPointerEXT))(GLsizei, GLsizei, const GLboolean*);
extern void (GLApi *GLFuncPtrName(glGetPointervEXT))(GLenum, void**);

#define glArrayElementEXT GLFuncPtrName(glArrayElementEXT)
#define glDrawArraysEXT GLFuncPtrName(glDrawArraysEXT)
#define glVertexPointerEXT GLFuncPtrName(glVertexPointerEXT)
#define glNormalPointerEXT GLFuncPtrName(glNormalPointerEXT)
#define glColorPointerEXT GLFuncPtrName(glColorPointerEXT)
#define glIndexPointerEXT GLFuncPtrName(glIndexPointerEXT)
#define glTexCoordPointerEXT GLFuncPtrName(glTexCoordPointerEXT)
#define glEdgeFlagPointerEXT GLFuncPtrName(glEdgeFlagPointerEXT)
#define glGetPointervEXT GLFuncPtrName(glGetPointervEXT)

#endif // GL_EXT_vertex_array

//								--- GL_EXT_vertex_array_bgra ---

#ifndef GL_EXT_vertex_array_bgra
#define GL_EXT_vertex_array_bgra 1

extern bool GLEH_EXT_vertex_array_bgra; /**< set if GL_EXT_vertex_array_bgra is supported */

#ifndef GL_BGRA
#define GL_BGRA                                                      0x80e1
#endif // GL_BGRA

// no new procedures or functions

#endif // GL_EXT_vertex_array_bgra

//								--- GL_IBM_rasterpos_clip ---

#ifndef GL_IBM_rasterpos_clip
#define GL_IBM_rasterpos_clip 1

extern bool GLEH_IBM_rasterpos_clip; /**< set if GL_IBM_rasterpos_clip is supported */

#define GL_RASTER_POSITION_UNCLIPPED_IBM 103010

// no new procedures or functions

#endif // GL_IBM_rasterpos_clip

//								--- GL_IBM_texture_mirrored_repeat ---

#ifndef GL_IBM_texture_mirrored_repeat
#define GL_IBM_texture_mirrored_repeat 1

extern bool GLEH_IBM_texture_mirrored_repeat; /**< set if GL_IBM_texture_mirrored_repeat is supported */

#define GL_MIRRORED_REPEAT_IBM                                       0x8370

// no new procedures or functions

#endif // GL_IBM_texture_mirrored_repeat

//								--- GL_NV_blend_square ---

#ifndef GL_NV_blend_square
#define GL_NV_blend_square 1

extern bool GLEH_NV_blend_square; /**< set if GL_NV_blend_square is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_blend_square

//								--- GL_NV_conditional_render ---

#ifndef GL_NV_conditional_render
#define GL_NV_conditional_render 1
#define __GENERATE_GL_NV_conditional_render

extern bool GLEH_NV_conditional_render; /**< set if GL_NV_conditional_render is supported */

#define GL_QUERY_WAIT_NV                                             0x8e13
#define GL_QUERY_NO_WAIT_NV                                          0x8e14
#define GL_QUERY_BY_REGION_WAIT_NV                                   0x8e15
#define GL_QUERY_BY_REGION_NO_WAIT_NV                                0x8e16

extern void (GLApi *GLFuncPtrName(glBeginConditionalRenderNV))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glEndConditionalRenderNV))();

#define glBeginConditionalRenderNV GLFuncPtrName(glBeginConditionalRenderNV)
#define glEndConditionalRenderNV GLFuncPtrName(glEndConditionalRenderNV)

#endif // GL_NV_conditional_render

//								--- GL_NV_copy_depth_to_color ---

#ifndef GL_NV_copy_depth_to_color
#define GL_NV_copy_depth_to_color 1

extern bool GLEH_NV_copy_depth_to_color; /**< set if GL_NV_copy_depth_to_color is supported */

#define GL_DEPTH_STENCIL_TO_RGBA_NV                                  0x886e
#define GL_DEPTH_STENCIL_TO_BGRA_NV                                  0x886f

// no new procedures or functions

#endif // GL_NV_copy_depth_to_color

//								--- GL_NV_copy_image ---

#ifndef GL_NV_copy_image
#define GL_NV_copy_image 1
#define __GENERATE_GL_NV_copy_image

extern bool GLEH_NV_copy_image; /**< set if GL_NV_copy_image is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glCopyImageSubDataNV))(GLuint, GLenum, int, int, int, int, GLuint, GLenum, int, int, int, int, GLsizei, GLsizei, GLsizei);

#define glCopyImageSubDataNV GLFuncPtrName(glCopyImageSubDataNV)

#endif // GL_NV_copy_image

//								--- GL_NV_depth_buffer_float ---

#ifndef GL_NV_depth_buffer_float
#define GL_NV_depth_buffer_float 1
#define __GENERATE_GL_NV_depth_buffer_float

extern bool GLEH_NV_depth_buffer_float; /**< set if GL_NV_depth_buffer_float is supported */

#define GL_DEPTH_COMPONENT32F_NV                                     0x8dab
#define GL_DEPTH32F_STENCIL8_NV                                      0x8dac
#define GL_FLOAT_32_UNSIGNED_INT_24_8_REV_NV                         0x8dad
#define GL_DEPTH_BUFFER_FLOAT_MODE_NV                                0x8daf

extern void (GLApi *GLFuncPtrName(glDepthRangedNV))(double, double);
extern void (GLApi *GLFuncPtrName(glClearDepthdNV))(double);
extern void (GLApi *GLFuncPtrName(glDepthBoundsdNV))(double, double);

#define glDepthRangedNV GLFuncPtrName(glDepthRangedNV)
#define glClearDepthdNV GLFuncPtrName(glClearDepthdNV)
#define glDepthBoundsdNV GLFuncPtrName(glDepthBoundsdNV)

#endif // GL_NV_depth_buffer_float

//								--- GL_NV_depth_clamp ---

#ifndef GL_NV_depth_clamp
#define GL_NV_depth_clamp 1

extern bool GLEH_NV_depth_clamp; /**< set if GL_NV_depth_clamp is supported */

#define GL_DEPTH_CLAMP_NV                                            0x864f

// no new procedures or functions

#endif // GL_NV_depth_clamp

//								--- GL_NV_explicit_multisample ---

#ifndef GL_NV_explicit_multisample
#define GL_NV_explicit_multisample 1
#define __GENERATE_GL_NV_explicit_multisample

extern bool GLEH_NV_explicit_multisample; /**< set if GL_NV_explicit_multisample is supported */

#define GL_SAMPLE_POSITION_NV                                        0x8e50
#define GL_SAMPLE_MASK_NV                                            0x8e51
#define GL_SAMPLE_MASK_VALUE_NV                                      0x8e52
#define GL_TEXTURE_BINDING_RENDERBUFFER_NV                           0x8e53
#define GL_TEXTURE_RENDERBUFFER_DATA_STORE_BINDING_NV                0x8e54
#define GL_MAX_SAMPLE_MASK_WORDS_NV                                  0x8e59
#define GL_TEXTURE_RENDERBUFFER_NV                                   0x8e55
#define GL_SAMPLER_RENDERBUFFER_NV                                   0x8e56
#define GL_INT_SAMPLER_RENDERBUFFER_NV                               0x8e57
#define GL_UNSIGNED_INT_SAMPLER_RENDERBUFFER_NV                      0x8e58

extern void (GLApi *GLFuncPtrName(glGetBooleanIndexedvEXT))(GLenum, GLuint, GLboolean*);
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexedvEXT))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetMultisamplefvNV))(GLenum, GLuint, float*);
extern void (GLApi *GLFuncPtrName(glSampleMaskIndexedNV))(GLuint, GLbitfield);
extern void (GLApi *GLFuncPtrName(glTexRenderbufferNV))(GLenum, GLuint);

#define glGetBooleanIndexedvEXT GLFuncPtrName(glGetBooleanIndexedvEXT)
#define glGetIntegerIndexedvEXT GLFuncPtrName(glGetIntegerIndexedvEXT)
#define glGetMultisamplefvNV GLFuncPtrName(glGetMultisamplefvNV)
#define glSampleMaskIndexedNV GLFuncPtrName(glSampleMaskIndexedNV)
#define glTexRenderbufferNV GLFuncPtrName(glTexRenderbufferNV)

#endif // GL_NV_explicit_multisample

//								--- GL_NV_fence ---

#ifndef GL_NV_fence
#define GL_NV_fence 1
#define __GENERATE_GL_NV_fence

extern bool GLEH_NV_fence; /**< set if GL_NV_fence is supported */

#define GL_ALL_COMPLETED_NV                                          0x84f2
#define GL_FENCE_STATUS_NV                                           0x84f3
#define GL_FENCE_CONDITION_NV                                        0x84f4

extern void (GLApi *GLFuncPtrName(glGenFencesNV))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glDeleteFencesNV))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glSetFenceNV))(GLuint, GLenum);
extern GLboolean (GLApi *GLFuncPtrName(glTestFenceNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glFinishFenceNV))(GLuint);
extern GLboolean (GLApi *GLFuncPtrName(glIsFenceNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glGetFenceivNV))(GLuint, GLenum, int*);

#define glGenFencesNV GLFuncPtrName(glGenFencesNV)
#define glDeleteFencesNV GLFuncPtrName(glDeleteFencesNV)
#define glSetFenceNV GLFuncPtrName(glSetFenceNV)
#define glTestFenceNV GLFuncPtrName(glTestFenceNV)
#define glFinishFenceNV GLFuncPtrName(glFinishFenceNV)
#define glIsFenceNV GLFuncPtrName(glIsFenceNV)
#define glGetFenceivNV GLFuncPtrName(glGetFenceivNV)

#endif // GL_NV_fence

//								--- GL_NV_float_buffer ---

#ifndef GL_NV_float_buffer
#define GL_NV_float_buffer 1

extern bool GLEH_NV_float_buffer; /**< set if GL_NV_float_buffer is supported */

#define GL_FLOAT_R_NV                                                0x8880
#define GL_FLOAT_RG_NV                                               0x8881
#define GL_FLOAT_RGB_NV                                              0x8882
#define GL_FLOAT_RGBA_NV                                             0x8883
#define GL_FLOAT_R16_NV                                              0x8884
#define GL_FLOAT_R32_NV                                              0x8885
#define GL_FLOAT_RG16_NV                                             0x8886
#define GL_FLOAT_RG32_NV                                             0x8887
#define GL_FLOAT_RGB16_NV                                            0x8888
#define GL_FLOAT_RGB32_NV                                            0x8889
#define GL_FLOAT_RGBA16_NV                                           0x888a
#define GL_FLOAT_RGBA32_NV                                           0x888b
#define GL_TEXTURE_FLOAT_COMPONENTS_NV                               0x888c
#define GL_FLOAT_CLEAR_COLOR_VALUE_NV                                0x888d
#define GL_FLOAT_RGBA_MODE_NV                                        0x888e
#define GL_WGL_FLOAT_COMPONENTS_NV                                   0x20b0
#define GL_WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_R_NV                  0x20b1
#define GL_WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RG_NV                 0x20b2
#define GL_WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGB_NV                0x20b3
#define GL_WGL_BIND_TO_TEXTURE_RECTANGLE_FLOAT_RGBA_NV               0x20b4
#define GL_WGL_TEXTURE_FLOAT_R_NV                                    0x20b5
#define GL_WGL_TEXTURE_FLOAT_RG_NV                                   0x20b6
#define GL_WGL_TEXTURE_FLOAT_RGB_NV                                  0x20b7
#define GL_WGL_TEXTURE_FLOAT_RGBA_NV                                 0x20b8
#define GL_GLX_FLOAT_COMPONENTS_NV                                   0x20b0

// no new procedures or functions

#endif // GL_NV_float_buffer

//								--- GL_NV_fog_distance ---

#ifndef GL_NV_fog_distance
#define GL_NV_fog_distance 1

extern bool GLEH_NV_fog_distance; /**< set if GL_NV_fog_distance is supported */

#define GL_FOG_DISTANCE_MODE_NV                                      0x855a
#define GL_EYE_RADIAL_NV                                             0x855b
#define GL_EYE_PLANE_ABSOLUTE_NV                                     0x855c

// no new procedures or functions

#endif // GL_NV_fog_distance

//								--- GL_NV_fragment_program ---

#ifndef GL_NV_fragment_program
#define GL_NV_fragment_program 1
#define __GENERATE_GL_NV_fragment_program

extern bool GLEH_NV_fragment_program; /**< set if GL_NV_fragment_program is supported */

#define GL_FRAGMENT_PROGRAM_NV                                       0x8870
#define GL_MAX_TEXTURE_COORDS_NV                                     0x8871
#define GL_MAX_TEXTURE_IMAGE_UNITS_NV                                0x8872
#define GL_FRAGMENT_PROGRAM_BINDING_NV                               0x8873
#define GL_MAX_FRAGMENT_PROGRAM_LOCAL_PARAMETERS_NV                  0x8868
#define GL_PROGRAM_ERROR_STRING_NV                                   0x8874

extern void (GLApi *GLFuncPtrName(glProgramNamedParameter4fNV))(GLuint, GLsizei, const GLubyte*, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramNamedParameter4dNV))(GLuint, GLsizei, const GLubyte*, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramNamedParameter4fvNV))(GLuint, GLsizei, const GLubyte*, const float*);
extern void (GLApi *GLFuncPtrName(glProgramNamedParameter4dvNV))(GLuint, GLsizei, const GLubyte*, const double*);
extern void (GLApi *GLFuncPtrName(glGetProgramNamedParameterfvNV))(GLuint, GLsizei, const GLubyte*, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramNamedParameterdvNV))(GLuint, GLsizei, const GLubyte*, double*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dARB))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4dvARB))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fARB))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameter4fvARB))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterdvARB))(GLenum, GLuint, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterfvARB))(GLenum, GLuint, float*);

#define glProgramNamedParameter4fNV GLFuncPtrName(glProgramNamedParameter4fNV)
#define glProgramNamedParameter4dNV GLFuncPtrName(glProgramNamedParameter4dNV)
#define glProgramNamedParameter4fvNV GLFuncPtrName(glProgramNamedParameter4fvNV)
#define glProgramNamedParameter4dvNV GLFuncPtrName(glProgramNamedParameter4dvNV)
#define glGetProgramNamedParameterfvNV GLFuncPtrName(glGetProgramNamedParameterfvNV)
#define glGetProgramNamedParameterdvNV GLFuncPtrName(glGetProgramNamedParameterdvNV)
#define glProgramLocalParameter4dARB GLFuncPtrName(glProgramLocalParameter4dARB)
#define glProgramLocalParameter4dvARB GLFuncPtrName(glProgramLocalParameter4dvARB)
#define glProgramLocalParameter4fARB GLFuncPtrName(glProgramLocalParameter4fARB)
#define glProgramLocalParameter4fvARB GLFuncPtrName(glProgramLocalParameter4fvARB)
#define glGetProgramLocalParameterdvARB GLFuncPtrName(glGetProgramLocalParameterdvARB)
#define glGetProgramLocalParameterfvARB GLFuncPtrName(glGetProgramLocalParameterfvARB)

#endif // GL_NV_fragment_program

//								--- GL_NV_fragment_program_option ---

#ifndef GL_NV_fragment_program_option
#define GL_NV_fragment_program_option 1

extern bool GLEH_NV_fragment_program_option; /**< set if GL_NV_fragment_program_option is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_fragment_program_option

//								--- GL_NV_fragment_program2 ---

#ifndef GL_NV_fragment_program2
#define GL_NV_fragment_program2 1

extern bool GLEH_NV_fragment_program2; /**< set if GL_NV_fragment_program2 is supported */

#define GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV                          0x88f4
#define GL_MAX_PROGRAM_CALL_DEPTH_NV                                 0x88f5
#define GL_MAX_PROGRAM_IF_DEPTH_NV                                   0x88f6
#define GL_MAX_PROGRAM_LOOP_DEPTH_NV                                 0x88f7
#define GL_MAX_PROGRAM_LOOP_COUNT_NV                                 0x88f8

// no new procedures or functions

#endif // GL_NV_fragment_program2

//								--- GL_NV_framebuffer_multisample_coverage ---

#ifndef GL_NV_framebuffer_multisample_coverage
#define GL_NV_framebuffer_multisample_coverage 1
#define __GENERATE_GL_NV_framebuffer_multisample_coverage

extern bool GLEH_NV_framebuffer_multisample_coverage; /**< set if GL_NV_framebuffer_multisample_coverage is supported */

#define GL_RENDERBUFFER_COVERAGE_SAMPLES_NV                          0x8cab
#define GL_RENDERBUFFER_COLOR_SAMPLES_NV                             0x8e10
#define GL_MAX_MULTISAMPLE_COVERAGE_MODES_NV                         0x8e11
#define GL_MULTISAMPLE_COVERAGE_MODES_NV                             0x8e12

extern void (GLApi *GLFuncPtrName(glRenderbufferStorageMultisampleCoverageNV))(GLenum, GLsizei, GLsizei, GLenum, GLsizei, GLsizei);

#define glRenderbufferStorageMultisampleCoverageNV GLFuncPtrName(glRenderbufferStorageMultisampleCoverageNV)

#endif // GL_NV_framebuffer_multisample_coverage

//								--- GL_NV_geometry_shader4 ---

#ifndef GL_NV_geometry_shader4
#define GL_NV_geometry_shader4 1

extern bool GLEH_NV_geometry_shader4; /**< set if GL_NV_geometry_shader4 is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_geometry_shader4

//								--- GL_NV_gpu_program4 ---

#ifndef GL_NV_gpu_program4
#define GL_NV_gpu_program4 1
#define __GENERATE_GL_NV_gpu_program4

extern bool GLEH_NV_gpu_program4; /**< set if GL_NV_gpu_program4 is supported */

#define GL_MIN_PROGRAM_TEXEL_OFFSET_EXT                              0x8904
#define GL_MAX_PROGRAM_TEXEL_OFFSET_EXT                              0x8905
#define GL_PROGRAM_ATTRIB_COMPONENTS_NV                              0x8906
#define GL_PROGRAM_RESULT_COMPONENTS_NV                              0x8907
#define GL_MAX_PROGRAM_ATTRIB_COMPONENTS_NV                          0x8908
#define GL_MAX_PROGRAM_RESULT_COMPONENTS_NV                          0x8909
#define GL_MAX_PROGRAM_GENERIC_ATTRIBS_NV                            0x8da5
#define GL_MAX_PROGRAM_GENERIC_RESULTS_NV                            0x8da6

extern void (GLApi *GLFuncPtrName(glProgramLocalParameterI4iNV))(GLenum, GLuint, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameterI4ivNV))(GLenum, GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParametersI4ivNV))(GLenum, GLuint, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameterI4uiNV))(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramLocalParameterI4uivNV))(GLenum, GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramLocalParametersI4uivNV))(GLenum, GLuint, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameterI4iNV))(GLenum, GLuint, int, int, int, int);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameterI4ivNV))(GLenum, GLuint, const int*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParametersI4ivNV))(GLenum, GLuint, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameterI4uiNV))(GLenum, GLuint, GLuint, GLuint, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramEnvParameterI4uivNV))(GLenum, GLuint, const GLuint*);
extern void (GLApi *GLFuncPtrName(glProgramEnvParametersI4uivNV))(GLenum, GLuint, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterIivNV))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetProgramLocalParameterIuivNV))(GLenum, GLuint, GLuint*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterIivNV))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetProgramEnvParameterIuivNV))(GLenum, GLuint, GLuint*);

#define glProgramLocalParameterI4iNV GLFuncPtrName(glProgramLocalParameterI4iNV)
#define glProgramLocalParameterI4ivNV GLFuncPtrName(glProgramLocalParameterI4ivNV)
#define glProgramLocalParametersI4ivNV GLFuncPtrName(glProgramLocalParametersI4ivNV)
#define glProgramLocalParameterI4uiNV GLFuncPtrName(glProgramLocalParameterI4uiNV)
#define glProgramLocalParameterI4uivNV GLFuncPtrName(glProgramLocalParameterI4uivNV)
#define glProgramLocalParametersI4uivNV GLFuncPtrName(glProgramLocalParametersI4uivNV)
#define glProgramEnvParameterI4iNV GLFuncPtrName(glProgramEnvParameterI4iNV)
#define glProgramEnvParameterI4ivNV GLFuncPtrName(glProgramEnvParameterI4ivNV)
#define glProgramEnvParametersI4ivNV GLFuncPtrName(glProgramEnvParametersI4ivNV)
#define glProgramEnvParameterI4uiNV GLFuncPtrName(glProgramEnvParameterI4uiNV)
#define glProgramEnvParameterI4uivNV GLFuncPtrName(glProgramEnvParameterI4uivNV)
#define glProgramEnvParametersI4uivNV GLFuncPtrName(glProgramEnvParametersI4uivNV)
#define glGetProgramLocalParameterIivNV GLFuncPtrName(glGetProgramLocalParameterIivNV)
#define glGetProgramLocalParameterIuivNV GLFuncPtrName(glGetProgramLocalParameterIuivNV)
#define glGetProgramEnvParameterIivNV GLFuncPtrName(glGetProgramEnvParameterIivNV)
#define glGetProgramEnvParameterIuivNV GLFuncPtrName(glGetProgramEnvParameterIuivNV)

#endif // GL_NV_gpu_program4

//								--- GL_NV_half_float ---

#ifndef GL_NV_half_float
#define GL_NV_half_float 1
#define __GENERATE_GL_NV_half_float

extern bool GLEH_NV_half_float; /**< set if GL_NV_half_float is supported */

#define GL_HALF_FLOAT_NV                                             0x140b

extern void (GLApi *GLFuncPtrName(glVertex2hNV))(GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertex2hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertex3hNV))(GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertex3hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertex4hNV))(GLhalf, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertex4hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glNormal3hNV))(GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glNormal3hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glColor3hNV))(GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glColor3hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glColor4hNV))(GLhalf, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glColor4hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glTexCoord1hNV))(GLhalf);
extern void (GLApi *GLFuncPtrName(glTexCoord1hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glTexCoord2hNV))(GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glTexCoord2hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glTexCoord3hNV))(GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glTexCoord3hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glTexCoord4hNV))(GLhalf, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glTexCoord4hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1hNV))(GLenum, GLhalf);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord1hvNV))(GLenum, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2hNV))(GLenum, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord2hvNV))(GLenum, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3hNV))(GLenum, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord3hvNV))(GLenum, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4hNV))(GLenum, GLhalf, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glMultiTexCoord4hvNV))(GLenum, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glFogCoordhNV))(GLhalf);
extern void (GLApi *GLFuncPtrName(glFogCoordhvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3hNV))(GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glSecondaryColor3hvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexWeighthNV))(GLhalf);
extern void (GLApi *GLFuncPtrName(glVertexWeighthvNV))(const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1hNV))(GLuint, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1hvNV))(GLuint, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2hNV))(GLuint, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2hvNV))(GLuint, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3hNV))(GLuint, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3hvNV))(GLuint, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4hNV))(GLuint, GLhalf, GLhalf, GLhalf, GLhalf);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4hvNV))(GLuint, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs1hvNV))(GLuint, GLsizei, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs2hvNV))(GLuint, GLsizei, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs3hvNV))(GLuint, GLsizei, const GLhalf*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs4hvNV))(GLuint, GLsizei, const GLhalf*);

#define glVertex2hNV GLFuncPtrName(glVertex2hNV)
#define glVertex2hvNV GLFuncPtrName(glVertex2hvNV)
#define glVertex3hNV GLFuncPtrName(glVertex3hNV)
#define glVertex3hvNV GLFuncPtrName(glVertex3hvNV)
#define glVertex4hNV GLFuncPtrName(glVertex4hNV)
#define glVertex4hvNV GLFuncPtrName(glVertex4hvNV)
#define glNormal3hNV GLFuncPtrName(glNormal3hNV)
#define glNormal3hvNV GLFuncPtrName(glNormal3hvNV)
#define glColor3hNV GLFuncPtrName(glColor3hNV)
#define glColor3hvNV GLFuncPtrName(glColor3hvNV)
#define glColor4hNV GLFuncPtrName(glColor4hNV)
#define glColor4hvNV GLFuncPtrName(glColor4hvNV)
#define glTexCoord1hNV GLFuncPtrName(glTexCoord1hNV)
#define glTexCoord1hvNV GLFuncPtrName(glTexCoord1hvNV)
#define glTexCoord2hNV GLFuncPtrName(glTexCoord2hNV)
#define glTexCoord2hvNV GLFuncPtrName(glTexCoord2hvNV)
#define glTexCoord3hNV GLFuncPtrName(glTexCoord3hNV)
#define glTexCoord3hvNV GLFuncPtrName(glTexCoord3hvNV)
#define glTexCoord4hNV GLFuncPtrName(glTexCoord4hNV)
#define glTexCoord4hvNV GLFuncPtrName(glTexCoord4hvNV)
#define glMultiTexCoord1hNV GLFuncPtrName(glMultiTexCoord1hNV)
#define glMultiTexCoord1hvNV GLFuncPtrName(glMultiTexCoord1hvNV)
#define glMultiTexCoord2hNV GLFuncPtrName(glMultiTexCoord2hNV)
#define glMultiTexCoord2hvNV GLFuncPtrName(glMultiTexCoord2hvNV)
#define glMultiTexCoord3hNV GLFuncPtrName(glMultiTexCoord3hNV)
#define glMultiTexCoord3hvNV GLFuncPtrName(glMultiTexCoord3hvNV)
#define glMultiTexCoord4hNV GLFuncPtrName(glMultiTexCoord4hNV)
#define glMultiTexCoord4hvNV GLFuncPtrName(glMultiTexCoord4hvNV)
#define glFogCoordhNV GLFuncPtrName(glFogCoordhNV)
#define glFogCoordhvNV GLFuncPtrName(glFogCoordhvNV)
#define glSecondaryColor3hNV GLFuncPtrName(glSecondaryColor3hNV)
#define glSecondaryColor3hvNV GLFuncPtrName(glSecondaryColor3hvNV)
#define glVertexWeighthNV GLFuncPtrName(glVertexWeighthNV)
#define glVertexWeighthvNV GLFuncPtrName(glVertexWeighthvNV)
#define glVertexAttrib1hNV GLFuncPtrName(glVertexAttrib1hNV)
#define glVertexAttrib1hvNV GLFuncPtrName(glVertexAttrib1hvNV)
#define glVertexAttrib2hNV GLFuncPtrName(glVertexAttrib2hNV)
#define glVertexAttrib2hvNV GLFuncPtrName(glVertexAttrib2hvNV)
#define glVertexAttrib3hNV GLFuncPtrName(glVertexAttrib3hNV)
#define glVertexAttrib3hvNV GLFuncPtrName(glVertexAttrib3hvNV)
#define glVertexAttrib4hNV GLFuncPtrName(glVertexAttrib4hNV)
#define glVertexAttrib4hvNV GLFuncPtrName(glVertexAttrib4hvNV)
#define glVertexAttribs1hvNV GLFuncPtrName(glVertexAttribs1hvNV)
#define glVertexAttribs2hvNV GLFuncPtrName(glVertexAttribs2hvNV)
#define glVertexAttribs3hvNV GLFuncPtrName(glVertexAttribs3hvNV)
#define glVertexAttribs4hvNV GLFuncPtrName(glVertexAttribs4hvNV)

#endif // GL_NV_half_float

//								--- GL_NV_light_max_exponent ---

#ifndef GL_NV_light_max_exponent
#define GL_NV_light_max_exponent 1

extern bool GLEH_NV_light_max_exponent; /**< set if GL_NV_light_max_exponent is supported */

#define GL_MAX_SHININESS_NV                                          0x8504
#define GL_MAX_SPOT_EXPONENT_NV                                      0x8505

// no new procedures or functions

#endif // GL_NV_light_max_exponent

//								--- GL_NV_multisample_filter_hint ---

#ifndef GL_NV_multisample_filter_hint
#define GL_NV_multisample_filter_hint 1

extern bool GLEH_NV_multisample_filter_hint; /**< set if GL_NV_multisample_filter_hint is supported */

#define GL_MULTISAMPLE_FILTER_HINT_NV                                0x8534

// no new procedures or functions

#endif // GL_NV_multisample_filter_hint

//								--- GL_NV_occlusion_query ---

#ifndef GL_NV_occlusion_query
#define GL_NV_occlusion_query 1
#define __GENERATE_GL_NV_occlusion_query

extern bool GLEH_NV_occlusion_query; /**< set if GL_NV_occlusion_query is supported */

#define GL_OCCLUSION_TEST_HP                                         0x8165
#define GL_OCCLUSION_TEST_RESULT_HP                                  0x8166
#define GL_PIXEL_COUNTER_BITS_NV                                     0x8864
#define GL_CURRENT_OCCLUSION_QUERY_ID_NV                             0x8865
#define GL_PIXEL_COUNT_NV                                            0x8866
#define GL_PIXEL_COUNT_AVAILABLE_NV                                  0x8867

extern void (GLApi *GLFuncPtrName(glGenOcclusionQueriesNV))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glDeleteOcclusionQueriesNV))(GLsizei, const GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsOcclusionQueryNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glBeginOcclusionQueryNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glEndOcclusionQueryNV))();
extern void (GLApi *GLFuncPtrName(glGetOcclusionQueryivNV))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetOcclusionQueryuivNV))(GLuint, GLenum, GLuint*);

#define glGenOcclusionQueriesNV GLFuncPtrName(glGenOcclusionQueriesNV)
#define glDeleteOcclusionQueriesNV GLFuncPtrName(glDeleteOcclusionQueriesNV)
#define glIsOcclusionQueryNV GLFuncPtrName(glIsOcclusionQueryNV)
#define glBeginOcclusionQueryNV GLFuncPtrName(glBeginOcclusionQueryNV)
#define glEndOcclusionQueryNV GLFuncPtrName(glEndOcclusionQueryNV)
#define glGetOcclusionQueryivNV GLFuncPtrName(glGetOcclusionQueryivNV)
#define glGetOcclusionQueryuivNV GLFuncPtrName(glGetOcclusionQueryuivNV)

#endif // GL_NV_occlusion_query

//								--- GL_NV_packed_depth_stencil ---

#ifndef GL_NV_packed_depth_stencil
#define GL_NV_packed_depth_stencil 1

extern bool GLEH_NV_packed_depth_stencil; /**< set if GL_NV_packed_depth_stencil is supported */

#define GL_DEPTH_STENCIL_NV                                          0x84f9
#define GL_UNSIGNED_INT_24_8_NV                                      0x84fa

// no new procedures or functions

#endif // GL_NV_packed_depth_stencil

//								--- GL_NV_parameter_buffer_object ---

#ifndef GL_NV_parameter_buffer_object
#define GL_NV_parameter_buffer_object 1
#define __GENERATE_GL_NV_parameter_buffer_object

extern bool GLEH_NV_parameter_buffer_object; /**< set if GL_NV_parameter_buffer_object is supported */

#define GL_MAX_PROGRAM_PARAMETER_BUFFER_BINDINGS_NV                  0x8da0
#define GL_MAX_PROGRAM_PARAMETER_BUFFER_SIZE_NV                      0x8da1
#define GL_VERTEX_PROGRAM_PARAMETER_BUFFER_NV                        0x8da2
#define GL_GEOMETRY_PROGRAM_PARAMETER_BUFFER_NV                      0x8da3
#define GL_FRAGMENT_PROGRAM_PARAMETER_BUFFER_NV                      0x8da4

extern void (GLApi *GLFuncPtrName(glBindBufferRangeNV))(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
extern void (GLApi *GLFuncPtrName(glBindBufferOffsetNV))(GLenum, GLuint, GLuint, GLintptr);
extern void (GLApi *GLFuncPtrName(glBindBufferBaseNV))(GLenum, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glProgramBufferParametersfvNV))(GLenum, GLuint, GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glProgramBufferParametersIivNV))(GLenum, GLuint, GLuint, GLsizei, const int*);
extern void (GLApi *GLFuncPtrName(glProgramBufferParametersIuivNV))(GLenum, GLuint, GLuint, GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexedvNV))(GLenum, GLuint, GLboolean*);

#define glBindBufferRangeNV GLFuncPtrName(glBindBufferRangeNV)
#define glBindBufferOffsetNV GLFuncPtrName(glBindBufferOffsetNV)
#define glBindBufferBaseNV GLFuncPtrName(glBindBufferBaseNV)
#define glProgramBufferParametersfvNV GLFuncPtrName(glProgramBufferParametersfvNV)
#define glProgramBufferParametersIivNV GLFuncPtrName(glProgramBufferParametersIivNV)
#define glProgramBufferParametersIuivNV GLFuncPtrName(glProgramBufferParametersIuivNV)
#define glGetIntegerIndexedvEXT GLFuncPtrName(glGetIntegerIndexedvEXT)

#endif // GL_NV_parameter_buffer_object

//								--- GL_NV_parameter_buffer_object2 ---

#ifndef GL_NV_parameter_buffer_object2
#define GL_NV_parameter_buffer_object2 1

extern bool GLEH_NV_parameter_buffer_object2; /**< set if GL_NV_parameter_buffer_object2 is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_parameter_buffer_object2

//								--- GL_NV_pixel_data_range ---

#ifndef GL_NV_pixel_data_range
#define GL_NV_pixel_data_range 1
#define __GENERATE_GL_NV_pixel_data_range

extern bool GLEH_NV_pixel_data_range; /**< set if GL_NV_pixel_data_range is supported */

#define GL_WRITE_PIXEL_DATA_RANGE_NV                                 0x8878
#define GL_READ_PIXEL_DATA_RANGE_NV                                  0x8879
#define GL_WRITE_PIXEL_DATA_RANGE_LENGTH_NV                          0x887a
#define GL_READ_PIXEL_DATA_RANGE_LENGTH_NV                           0x887b
#define GL_WRITE_PIXEL_DATA_RANGE_POINTER_NV                         0x887c
#define GL_READ_PIXEL_DATA_RANGE_POINTER_NV                          0x887d

extern void (GLApi *GLFuncPtrName(glPixelDataRangeNV))(GLenum, GLsizei, void*);
extern void (GLApi *GLFuncPtrName(glFlushPixelDataRangeNV))(GLenum);

#define glPixelDataRangeNV GLFuncPtrName(glPixelDataRangeNV)
#define glFlushPixelDataRangeNV GLFuncPtrName(glFlushPixelDataRangeNV)

#endif // GL_NV_pixel_data_range

//								--- GL_NV_point_sprite ---

#ifndef GL_NV_point_sprite
#define GL_NV_point_sprite 1
#define __GENERATE_GL_NV_point_sprite

extern bool GLEH_NV_point_sprite; /**< set if GL_NV_point_sprite is supported */

#define GL_POINT_SPRITE_NV                                           0x8861
#define GL_COORD_REPLACE_NV                                          0x8862
#define GL_POINT_SPRITE_R_MODE_NV                                    0x8863

extern void (GLApi *GLFuncPtrName(glPointParameteriNV))(GLenum, int);
extern void (GLApi *GLFuncPtrName(glPointParameterivNV))(GLenum, const int*);

#define glPointParameteriNV GLFuncPtrName(glPointParameteriNV)
#define glPointParameterivNV GLFuncPtrName(glPointParameterivNV)

#endif // GL_NV_point_sprite

//								--- GL_NV_primitive_restart ---

#ifndef GL_NV_primitive_restart
#define GL_NV_primitive_restart 1
#define __GENERATE_GL_NV_primitive_restart

extern bool GLEH_NV_primitive_restart; /**< set if GL_NV_primitive_restart is supported */

#define GL_PRIMITIVE_RESTART_NV                                      0x8558
#define GL_PRIMITIVE_RESTART_INDEX_NV                                0x8559

extern void (GLApi *GLFuncPtrName(glPrimitiveRestartNV))();
extern void (GLApi *GLFuncPtrName(glPrimitiveRestartIndexNV))(GLuint);

#define glPrimitiveRestartNV GLFuncPtrName(glPrimitiveRestartNV)
#define glPrimitiveRestartIndexNV GLFuncPtrName(glPrimitiveRestartIndexNV)

#endif // GL_NV_primitive_restart

//								--- GL_NV_register_combiners ---

#ifndef GL_NV_register_combiners
#define GL_NV_register_combiners 1
#define __GENERATE_GL_NV_register_combiners

extern bool GLEH_NV_register_combiners; /**< set if GL_NV_register_combiners is supported */

#define GL_REGISTER_COMBINERS_NV                                     0x8522
#define GL_COMBINER0_NV                                              0x8550
#define GL_COMBINER1_NV                                              0x8551
#define GL_COMBINER2_NV                                              0x8552
#define GL_COMBINER3_NV                                              0x8553
#define GL_COMBINER4_NV                                              0x8554
#define GL_COMBINER5_NV                                              0x8555
#define GL_COMBINER6_NV                                              0x8556
#define GL_COMBINER7_NV                                              0x8557
#define GL_VARIABLE_A_NV                                             0x8523
#define GL_VARIABLE_B_NV                                             0x8524
#define GL_VARIABLE_C_NV                                             0x8525
#define GL_VARIABLE_D_NV                                             0x8526
#define GL_VARIABLE_E_NV                                             0x8527
#define GL_VARIABLE_F_NV                                             0x8528
#define GL_VARIABLE_G_NV                                             0x8529
#define GL_CONSTANT_COLOR0_NV                                        0x852a
#define GL_CONSTANT_COLOR1_NV                                        0x852b
#define GL_PRIMARY_COLOR_NV                                          0x852c
#define GL_SECONDARY_COLOR_NV                                        0x852d
#define GL_SPARE0_NV                                                 0x852e
#define GL_SPARE1_NV                                                 0x852f
#define GL_UNSIGNED_IDENTITY_NV                                      0x8536
#define GL_UNSIGNED_INVERT_NV                                        0x8537
#define GL_EXPAND_NORMAL_NV                                          0x8538
#define GL_EXPAND_NEGATE_NV                                          0x8539
#define GL_HALF_BIAS_NORMAL_NV                                       0x853a
#define GL_HALF_BIAS_NEGATE_NV                                       0x853b
#define GL_SIGNED_IDENTITY_NV                                        0x853c
#define GL_SIGNED_NEGATE_NV                                          0x853d
#define GL_E_TIMES_F_NV                                              0x8531
#define GL_SPARE0_PLUS_SECONDARY_COLOR_NV                            0x8532
#define GL_SCALE_BY_TWO_NV                                           0x853e
#define GL_SCALE_BY_FOUR_NV                                          0x853f
#define GL_SCALE_BY_ONE_HALF_NV                                      0x8540
#define GL_BIAS_BY_NEGATIVE_ONE_HALF_NV                              0x8541
#define GL_DISCARD_NV                                                0x8530
#define GL_COMBINER_INPUT_NV                                         0x8542
#define GL_COMBINER_MAPPING_NV                                       0x8543
#define GL_COMBINER_COMPONENT_USAGE_NV                               0x8544
#define GL_COMBINER_AB_DOT_PRODUCT_NV                                0x8545
#define GL_COMBINER_CD_DOT_PRODUCT_NV                                0x8546
#define GL_COMBINER_MUX_SUM_NV                                       0x8547
#define GL_COMBINER_SCALE_NV                                         0x8548
#define GL_COMBINER_BIAS_NV                                          0x8549
#define GL_COMBINER_AB_OUTPUT_NV                                     0x854a
#define GL_COMBINER_CD_OUTPUT_NV                                     0x854b
#define GL_COMBINER_SUM_OUTPUT_NV                                    0x854c
#define GL_NUM_GENERAL_COMBINERS_NV                                  0x854e
#define GL_COLOR_SUM_CLAMP_NV                                        0x854f
#define GL_MAX_GENERAL_COMBINERS_NV                                  0x854d

extern void (GLApi *GLFuncPtrName(glCombinerParameterfvNV))(GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glCombinerParameterivNV))(GLenum, const int*);
extern void (GLApi *GLFuncPtrName(glCombinerParameterfNV))(GLenum, float);
extern void (GLApi *GLFuncPtrName(glCombinerParameteriNV))(GLenum, int);
extern void (GLApi *GLFuncPtrName(glCombinerInputNV))(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glCombinerOutputNV))(GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLenum, GLboolean, GLboolean, GLboolean);
extern void (GLApi *GLFuncPtrName(glFinalCombinerInputNV))(GLenum, GLenum, GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glGetCombinerInputParameterfvNV))(GLenum, GLenum, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetCombinerInputParameterivNV))(GLenum, GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetCombinerOutputParameterfvNV))(GLenum, GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetCombinerOutputParameterivNV))(GLenum, GLenum, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetFinalCombinerInputParameterfvNV))(GLenum, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetFinalCombinerInputParameterivNV))(GLenum, GLenum, int*);

#define glCombinerParameterfvNV GLFuncPtrName(glCombinerParameterfvNV)
#define glCombinerParameterivNV GLFuncPtrName(glCombinerParameterivNV)
#define glCombinerParameterfNV GLFuncPtrName(glCombinerParameterfNV)
#define glCombinerParameteriNV GLFuncPtrName(glCombinerParameteriNV)
#define glCombinerInputNV GLFuncPtrName(glCombinerInputNV)
#define glCombinerOutputNV GLFuncPtrName(glCombinerOutputNV)
#define glFinalCombinerInputNV GLFuncPtrName(glFinalCombinerInputNV)
#define glGetCombinerInputParameterfvNV GLFuncPtrName(glGetCombinerInputParameterfvNV)
#define glGetCombinerInputParameterivNV GLFuncPtrName(glGetCombinerInputParameterivNV)
#define glGetCombinerOutputParameterfvNV GLFuncPtrName(glGetCombinerOutputParameterfvNV)
#define glGetCombinerOutputParameterivNV GLFuncPtrName(glGetCombinerOutputParameterivNV)
#define glGetFinalCombinerInputParameterfvNV GLFuncPtrName(glGetFinalCombinerInputParameterfvNV)
#define glGetFinalCombinerInputParameterivNV GLFuncPtrName(glGetFinalCombinerInputParameterivNV)

#endif // GL_NV_register_combiners

//								--- GL_NV_register_combiners2 ---

#ifndef GL_NV_register_combiners2
#define GL_NV_register_combiners2 1
#define __GENERATE_GL_NV_register_combiners2

extern bool GLEH_NV_register_combiners2; /**< set if GL_NV_register_combiners2 is supported */

#define GL_PER_STAGE_CONSTANTS_NV                                    0x8535

extern void (GLApi *GLFuncPtrName(glCombinerStageParameterfvNV))(GLenum, GLenum, const float*);
extern void (GLApi *GLFuncPtrName(glGetCombinerStageParameterfvNV))(GLenum, GLenum, float*);

#define glCombinerStageParameterfvNV GLFuncPtrName(glCombinerStageParameterfvNV)
#define glGetCombinerStageParameterfvNV GLFuncPtrName(glGetCombinerStageParameterfvNV)

#endif // GL_NV_register_combiners2

//								--- GL_NV_shader_buffer_load ---

#ifndef GL_NV_shader_buffer_load
#define GL_NV_shader_buffer_load 1
#define __GENERATE_GL_NV_shader_buffer_load

extern bool GLEH_NV_shader_buffer_load; /**< set if GL_NV_shader_buffer_load is supported */

#define GL_BUFFER_GPU_ADDRESS_NV                                     0x8f1d
#define GL_GPU_ADDRESS_NV                                            0x8f34
#define GL_MAX_SHADER_BUFFER_ADDRESS_NV                              0x8f35

extern void (GLApi *GLFuncPtrName(glMakeBufferResidentNV))(GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glMakeBufferNonResidentNV))(GLenum);
extern GLboolean (GLApi *GLFuncPtrName(glIsBufferResidentNV))(GLenum);
extern void (GLApi *GLFuncPtrName(glMakeNamedBufferResidentNV))(GLuint, GLenum);
extern void (GLApi *GLFuncPtrName(glMakeNamedBufferNonResidentNV))(GLuint);
extern GLboolean (GLApi *GLFuncPtrName(glIsNamedBufferResidentNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glGetBufferParameterui64vNV))(GLenum, GLenum, GLuint64EXT*);
extern void (GLApi *GLFuncPtrName(glGetNamedBufferParameterui64vNV))(GLuint, GLenum, GLuint64EXT*);
extern void (GLApi *GLFuncPtrName(glGetIntegerui64vNV))(GLenum, GLuint64EXT*);
extern void (GLApi *GLFuncPtrName(glUniformui64NV))(int, GLuint64EXT);
extern void (GLApi *GLFuncPtrName(glUniformui64vNV))(int, GLsizei, const GLuint64EXT*);
extern void (GLApi *GLFuncPtrName(glGetUniformui64vNV))(GLuint, int, GLuint64EXT*);
extern void (GLApi *GLFuncPtrName(glProgramUniformui64NV))(GLuint, int, GLuint64EXT);
extern void (GLApi *GLFuncPtrName(glProgramUniformui64vNV))(GLuint, int, GLsizei, const GLuint64EXT*);

#define glMakeBufferResidentNV GLFuncPtrName(glMakeBufferResidentNV)
#define glMakeBufferNonResidentNV GLFuncPtrName(glMakeBufferNonResidentNV)
#define glIsBufferResidentNV GLFuncPtrName(glIsBufferResidentNV)
#define glMakeNamedBufferResidentNV GLFuncPtrName(glMakeNamedBufferResidentNV)
#define glMakeNamedBufferNonResidentNV GLFuncPtrName(glMakeNamedBufferNonResidentNV)
#define glIsNamedBufferResidentNV GLFuncPtrName(glIsNamedBufferResidentNV)
#define glGetBufferParameterui64vNV GLFuncPtrName(glGetBufferParameterui64vNV)
#define glGetNamedBufferParameterui64vNV GLFuncPtrName(glGetNamedBufferParameterui64vNV)
#define glGetIntegerui64vNV GLFuncPtrName(glGetIntegerui64vNV)
#define glUniformui64NV GLFuncPtrName(glUniformui64NV)
#define glUniformui64vNV GLFuncPtrName(glUniformui64vNV)
#define glGetUniformui64vNV GLFuncPtrName(glGetUniformui64vNV)
#define glProgramUniformui64NV GLFuncPtrName(glProgramUniformui64NV)
#define glProgramUniformui64vNV GLFuncPtrName(glProgramUniformui64vNV)

#endif // GL_NV_shader_buffer_load

//								--- GL_NV_texgen_reflection ---

#ifndef GL_NV_texgen_reflection
#define GL_NV_texgen_reflection 1

extern bool GLEH_NV_texgen_reflection; /**< set if GL_NV_texgen_reflection is supported */

#define GL_NORMAL_MAP_NV                                             0x8511
#define GL_REFLECTION_MAP_NV                                         0x8512

// no new procedures or functions

#endif // GL_NV_texgen_reflection

//								--- GL_NV_texture_barrier ---

#ifndef GL_NV_texture_barrier
#define GL_NV_texture_barrier 1
#define __GENERATE_GL_NV_texture_barrier

extern bool GLEH_NV_texture_barrier; /**< set if GL_NV_texture_barrier is supported */

// no new tokens

extern void (GLApi *GLFuncPtrName(glTextureBarrierNV))();

#define glTextureBarrierNV GLFuncPtrName(glTextureBarrierNV)

#endif // GL_NV_texture_barrier

//								--- GL_NV_texture_compression_vtc ---

#ifndef GL_NV_texture_compression_vtc
#define GL_NV_texture_compression_vtc 1

extern bool GLEH_NV_texture_compression_vtc; /**< set if GL_NV_texture_compression_vtc is supported */

#define GL_COMPRESSED_RGB_S3TC_DXT1_EXT                              0x83f0
#define GL_COMPRESSED_RGBA_S3TC_DXT1_EXT                             0x83f1
#define GL_COMPRESSED_RGBA_S3TC_DXT3_EXT                             0x83f2
#define GL_COMPRESSED_RGBA_S3TC_DXT5_EXT                             0x83f3

// no new procedures or functions

#endif // GL_NV_texture_compression_vtc

//								--- GL_NV_texture_env_combine4 ---

#ifndef GL_NV_texture_env_combine4
#define GL_NV_texture_env_combine4 1

extern bool GLEH_NV_texture_env_combine4; /**< set if GL_NV_texture_env_combine4 is supported */

#define GL_COMBINE4_NV                                               0x8503
#define GL_SOURCE3_RGB_NV                                            0x8583
#define GL_SOURCE3_ALPHA_NV                                          0x858b
#define GL_OPERAND3_RGB_NV                                           0x8593
#define GL_OPERAND3_ALPHA_NV                                         0x859b

// no new procedures or functions

#endif // GL_NV_texture_env_combine4

//								--- GL_NV_texture_expand_normal ---

#ifndef GL_NV_texture_expand_normal
#define GL_NV_texture_expand_normal 1

extern bool GLEH_NV_texture_expand_normal; /**< set if GL_NV_texture_expand_normal is supported */

#define GL_TEXTURE_UNSIGNED_REMAP_MODE_NV                            0x888f

// no new procedures or functions

#endif // GL_NV_texture_expand_normal

//								--- GL_NV_texture_rectangle ---

#ifndef GL_NV_texture_rectangle
#define GL_NV_texture_rectangle 1

extern bool GLEH_NV_texture_rectangle; /**< set if GL_NV_texture_rectangle is supported */

#define GL_TEXTURE_RECTANGLE_NV                                      0x84f5
#define GL_TEXTURE_BINDING_RECTANGLE_NV                              0x84f6
#define GL_PROXY_TEXTURE_RECTANGLE_NV                                0x84f7
#define GL_MAX_RECTANGLE_TEXTURE_SIZE_NV                             0x84f8

// no new procedures or functions

#endif // GL_NV_texture_rectangle

//								--- GL_NV_texture_shader ---

#ifndef GL_NV_texture_shader
#define GL_NV_texture_shader 1

extern bool GLEH_NV_texture_shader; /**< set if GL_NV_texture_shader is supported */

#define GL_TEXTURE_SHADER_NV                                         0x86de
#define GL_RGBA_UNSIGNED_DOT_PRODUCT_MAPPING_NV                      0x86d9
#define GL_SHADER_OPERATION_NV                                       0x86df
#define GL_OFFSET_TEXTURE_SCALE_NV                                   0x86e2
#define GL_OFFSET_TEXTURE_BIAS_NV                                    0x86e3
#define GL_PREVIOUS_TEXTURE_INPUT_NV                                 0x86e4
#define GL_CULL_MODES_NV                                             0x86e0
#define GL_OFFSET_TEXTURE_MATRIX_NV                                  0x86e1
#define GL_CONST_EYE_NV                                              0x86e5
#define GL_SHADER_CONSISTENT_NV                                      0x86dd
#define GL_PASS_THROUGH_NV                                           0x86e6
#define GL_CULL_FRAGMENT_NV                                          0x86e7
#define GL_OFFSET_TEXTURE_2D_NV                                      0x86e8
#define GL_OFFSET_TEXTURE_RECTANGLE_NV                               0x864c
#define GL_OFFSET_TEXTURE_RECTANGLE_SCALE_NV                         0x864d
#define GL_DEPENDENT_AR_TEXTURE_2D_NV                                0x86e9
#define GL_DEPENDENT_GB_TEXTURE_2D_NV                                0x86ea
#define GL_DOT_PRODUCT_NV                                            0x86ec
#define GL_DOT_PRODUCT_DEPTH_REPLACE_NV                              0x86ed
#define GL_DOT_PRODUCT_TEXTURE_2D_NV                                 0x86ee
#define GL_DOT_PRODUCT_TEXTURE_RECTANGLE_NV                          0x864e
#define GL_DOT_PRODUCT_TEXTURE_CUBE_MAP_NV                           0x86f0
#define GL_DOT_PRODUCT_DIFFUSE_CUBE_MAP_NV                           0x86f1
#define GL_DOT_PRODUCT_REFLECT_CUBE_MAP_NV                           0x86f2
#define GL_DOT_PRODUCT_CONST_EYE_REFLECT_CUBE_MAP_NV                 0x86f3
#define GL_HILO_NV                                                   0x86f4
#define GL_DSDT_NV                                                   0x86f5
#define GL_DSDT_MAG_NV                                               0x86f6
#define GL_DSDT_MAG_VIB_NV                                           0x86f7
#define GL_UNSIGNED_INT_S8_S8_8_8_NV                                 0x86da
#define GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                             0x86db
#define GL_SIGNED_RGBA_NV                                            0x86fb
#define GL_SIGNED_RGBA8_NV                                           0x86fc
#define GL_SIGNED_RGB_NV                                             0x86fe
#define GL_SIGNED_RGB8_NV                                            0x86ff
#define GL_SIGNED_LUMINANCE_NV                                       0x8701
#define GL_SIGNED_LUMINANCE8_NV                                      0x8702
#define GL_SIGNED_LUMINANCE_ALPHA_NV                                 0x8703
#define GL_SIGNED_LUMINANCE8_ALPHA8_NV                               0x8704
#define GL_SIGNED_ALPHA_NV                                           0x8705
#define GL_SIGNED_ALPHA8_NV                                          0x8706
#define GL_SIGNED_INTENSITY_NV                                       0x8707
#define GL_SIGNED_INTENSITY8_NV                                      0x8708
#define GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                              0x870c
#define GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                            0x870d
#define GL_HILO16_NV                                                 0x86f8
#define GL_SIGNED_HILO_NV                                            0x86f9
#define GL_SIGNED_HILO16_NV                                          0x86fa
#define GL_DSDT8_NV                                                  0x8709
#define GL_DSDT8_MAG8_NV                                             0x870a
#define GL_DSDT_MAG_INTENSITY_NV                                     0x86dc
#define GL_DSDT8_MAG8_INTENSITY8_NV                                  0x870b
#define GL_HI_SCALE_NV                                               0x870e
#define GL_LO_SCALE_NV                                               0x870f
#define GL_DS_SCALE_NV                                               0x8710
#define GL_DT_SCALE_NV                                               0x8711
#define GL_MAGNITUDE_SCALE_NV                                        0x8712
#define GL_VIBRANCE_SCALE_NV                                         0x8713
#define GL_HI_BIAS_NV                                                0x8714
#define GL_LO_BIAS_NV                                                0x8715
#define GL_DS_BIAS_NV                                                0x8716
#define GL_DT_BIAS_NV                                                0x8717
#define GL_MAGNITUDE_BIAS_NV                                         0x8718
#define GL_VIBRANCE_BIAS_NV                                          0x8719
#define GL_TEXTURE_BORDER_VALUES_NV                                  0x871a
#define GL_TEXTURE_HI_SIZE_NV                                        0x871b
#define GL_TEXTURE_LO_SIZE_NV                                        0x871c
#define GL_TEXTURE_DS_SIZE_NV                                        0x871d
#define GL_TEXTURE_DT_SIZE_NV                                        0x871e
#define GL_TEXTURE_MAG_SIZE_NV                                       0x871f

// no new procedures or functions

#endif // GL_NV_texture_shader

//								--- GL_NV_texture_shader2 ---

#ifndef GL_NV_texture_shader2
#define GL_NV_texture_shader2 1

extern bool GLEH_NV_texture_shader2; /**< set if GL_NV_texture_shader2 is supported */

#define GL_DOT_PRODUCT_TEXTURE_3D_NV                                 0x86ef
#define GL_HILO_NV                                                   0x86f4
#define GL_DSDT_NV                                                   0x86f5
#define GL_DSDT_MAG_NV                                               0x86f6
#define GL_DSDT_MAG_VIB_NV                                           0x86f7
#define GL_UNSIGNED_INT_S8_S8_8_8_NV                                 0x86da
#define GL_UNSIGNED_INT_8_8_S8_S8_REV_NV                             0x86db
#define GL_SIGNED_RGBA_NV                                            0x86fb
#define GL_SIGNED_RGBA8_NV                                           0x86fc
#define GL_SIGNED_RGB_NV                                             0x86fe
#define GL_SIGNED_RGB8_NV                                            0x86ff
#define GL_SIGNED_LUMINANCE_NV                                       0x8701
#define GL_SIGNED_LUMINANCE8_NV                                      0x8702
#define GL_SIGNED_LUMINANCE_ALPHA_NV                                 0x8703
#define GL_SIGNED_LUMINANCE8_ALPHA8_NV                               0x8704
#define GL_SIGNED_ALPHA_NV                                           0x8705
#define GL_SIGNED_ALPHA8_NV                                          0x8706
#define GL_SIGNED_INTENSITY_NV                                       0x8707
#define GL_SIGNED_INTENSITY8_NV                                      0x8708
#define GL_SIGNED_RGB_UNSIGNED_ALPHA_NV                              0x870c
#define GL_SIGNED_RGB8_UNSIGNED_ALPHA8_NV                            0x870d
#define GL_HILO16_NV                                                 0x86f8
#define GL_SIGNED_HILO_NV                                            0x86f9
#define GL_SIGNED_HILO16_NV                                          0x86fa
#define GL_DSDT8_NV                                                  0x8709
#define GL_DSDT8_MAG8_NV                                             0x870a
#define GL_DSDT_MAG_INTENSITY_NV                                     0x86dc
#define GL_DSDT8_MAG8_INTENSITY8_NV                                  0x870b

// no new procedures or functions

#endif // GL_NV_texture_shader2

//								--- GL_NV_texture_shader3 ---

#ifndef GL_NV_texture_shader3
#define GL_NV_texture_shader3 1

extern bool GLEH_NV_texture_shader3; /**< set if GL_NV_texture_shader3 is supported */

#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_NV                           0x8850
#define GL_OFFSET_PROJECTIVE_TEXTURE_2D_SCALE_NV                     0x8851
#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_NV                    0x8852
#define GL_OFFSET_PROJECTIVE_TEXTURE_RECTANGLE_SCALE_NV              0x8853
#define GL_OFFSET_HILO_TEXTURE_2D_NV                                 0x8854
#define GL_OFFSET_HILO_TEXTURE_RECTANGLE_NV                          0x8855
#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_2D_NV                      0x8856
#define GL_OFFSET_HILO_PROJECTIVE_TEXTURE_RECTANGLE_NV               0x8857
#define GL_DEPENDENT_HILO_TEXTURE_2D_NV                              0x8858
#define GL_DEPENDENT_RGB_TEXTURE_3D_NV                               0x8859
#define GL_DEPENDENT_RGB_TEXTURE_CUBE_MAP_NV                         0x885a
#define GL_DOT_PRODUCT_PASS_THROUGH_NV                               0x885b
#define GL_DOT_PRODUCT_TEXTURE_1D_NV                                 0x885c
#define GL_DOT_PRODUCT_AFFINE_DEPTH_REPLACE_NV                       0x885d
#define GL_HILO8_NV                                                  0x885e
#define GL_SIGNED_HILO8_NV                                           0x885f
#define GL_FORCE_BLUE_TO_ONE_NV                                      0x8860

// no new procedures or functions

#endif // GL_NV_texture_shader3

//								--- GL_NV_transform_feedback ---

#ifndef GL_NV_transform_feedback
#define GL_NV_transform_feedback 1
#define __GENERATE_GL_NV_transform_feedback

extern bool GLEH_NV_transform_feedback; /**< set if GL_NV_transform_feedback is supported */

#define GL_TRANSFORM_FEEDBACK_BUFFER_NV                              0x8c8e
#define GL_TRANSFORM_FEEDBACK_BUFFER_START_NV                        0x8c84
#define GL_TRANSFORM_FEEDBACK_BUFFER_SIZE_NV                         0x8c85
#define GL_TRANSFORM_FEEDBACK_RECORD_NV                              0x8c86
#define GL_TRANSFORM_FEEDBACK_BUFFER_BINDING_NV                      0x8c8f
#define GL_INTERLEAVED_ATTRIBS_NV                                    0x8c8c
#define GL_SEPARATE_ATTRIBS_NV                                       0x8c8d
#define GL_PRIMITIVES_GENERATED_NV                                   0x8c87
#define GL_TRANSFORM_FEEDBACK_PRIMITIVES_WRITTEN_NV                  0x8c88
#define GL_RASTERIZER_DISCARD_NV                                     0x8c89
#define GL_MAX_TRANSFORM_FEEDBACK_INTERLEAVED_COMPONENTS_NV          0x8c8a
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_ATTRIBS_NV                0x8c8b
#define GL_MAX_TRANSFORM_FEEDBACK_SEPARATE_COMPONENTS_NV             0x8c80
#define GL_TRANSFORM_FEEDBACK_ATTRIBS_NV                             0x8c7e
#define GL_ACTIVE_VARYINGS_NV                                        0x8c81
#define GL_ACTIVE_VARYING_MAX_LENGTH_NV                              0x8c82
#define GL_TRANSFORM_FEEDBACK_VARYINGS_NV                            0x8c83
#define GL_TRANSFORM_FEEDBACK_BUFFER_MODE_NV                         0x8c7f
#define GL_BACK_PRIMARY_COLOR_NV                                     0x8c77
#define GL_BACK_SECONDARY_COLOR_NV                                   0x8c78
#define GL_TEXTURE_COORD_NV                                          0x8c79
#define GL_CLIP_DISTANCE_NV                                          0x8c7a
#define GL_VERTEX_ID_NV                                              0x8c7b
#define GL_PRIMITIVE_ID_NV                                           0x8c7c
#define GL_GENERIC_ATTRIB_NV                                         0x8c7d
#define GL_POINT_SIZE_NV                                             0x0b11
#define GL_FOG_COORDINATE                                            0x8451
#define GL_SECONDARY_COLOR_NV                                        0x852d
#define GL_PRIMARY_COLOR                                             0x8577
#define GL_POSITION                                                  0x1203
#define GL_LAYER_NV                                                  0x8daa
#define GL_UNSIGNED_INT_VEC2_EXT                                     0x8dc6
#define GL_UNSIGNED_INT_VEC3_EXT                                     0x8dc7
#define GL_UNSIGNED_INT_VEC4_EXT                                     0x8dc8

extern void (GLApi *GLFuncPtrName(glBindBufferRangeNV))(GLenum, GLuint, GLuint, GLintptr, GLsizeiptr);
extern void (GLApi *GLFuncPtrName(glBindBufferOffsetNV))(GLenum, GLuint, GLuint, GLintptr);
extern void (GLApi *GLFuncPtrName(glBindBufferBaseNV))(GLenum, GLuint, GLuint);
extern void (GLApi *GLFuncPtrName(glTransformFeedbackAttribsNV))(GLsizei, const int*, GLenum);
extern void (GLApi *GLFuncPtrName(glTransformFeedbackVaryingsNV))(GLuint, GLsizei, const int*, GLenum);
extern void (GLApi *GLFuncPtrName(glBeginTransformFeedbackNV))(GLenum);
extern void (GLApi *GLFuncPtrName(glEndTransformFeedbackNV))();
extern int (GLApi *GLFuncPtrName(glGetVaryingLocationNV))(GLuint, const GLchar*);
extern void (GLApi *GLFuncPtrName(glGetActiveVaryingNV))(GLuint, GLuint, GLsizei, GLsizei*, GLsizei*, GLenum*, GLchar*);
extern void (GLApi *GLFuncPtrName(glActiveVaryingNV))(GLuint, const GLchar*);
extern void (GLApi *GLFuncPtrName(glGetTransformFeedbackVaryingNV))(GLuint, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetIntegerIndexedvEXT))(GLenum, GLuint, int*);
extern void (GLApi *GLFuncPtrName(glGetBooleanIndexedvEXT))(GLenum, GLuint, GLboolean*);

#define glBindBufferRangeNV GLFuncPtrName(glBindBufferRangeNV)
#define glBindBufferOffsetNV GLFuncPtrName(glBindBufferOffsetNV)
#define glBindBufferBaseNV GLFuncPtrName(glBindBufferBaseNV)
#define glTransformFeedbackAttribsNV GLFuncPtrName(glTransformFeedbackAttribsNV)
#define glTransformFeedbackVaryingsNV GLFuncPtrName(glTransformFeedbackVaryingsNV)
#define glBeginTransformFeedbackNV GLFuncPtrName(glBeginTransformFeedbackNV)
#define glEndTransformFeedbackNV GLFuncPtrName(glEndTransformFeedbackNV)
#define glGetVaryingLocationNV GLFuncPtrName(glGetVaryingLocationNV)
#define glGetActiveVaryingNV GLFuncPtrName(glGetActiveVaryingNV)
#define glActiveVaryingNV GLFuncPtrName(glActiveVaryingNV)
#define glGetTransformFeedbackVaryingNV GLFuncPtrName(glGetTransformFeedbackVaryingNV)
#define glGetIntegerIndexedvEXT GLFuncPtrName(glGetIntegerIndexedvEXT)
#define glGetBooleanIndexedvEXT GLFuncPtrName(glGetBooleanIndexedvEXT)

#endif // GL_NV_transform_feedback

//								--- GL_NV_transform_feedback2 ---

#ifndef GL_NV_transform_feedback2
#define GL_NV_transform_feedback2 1
#define __GENERATE_GL_NV_transform_feedback2

extern bool GLEH_NV_transform_feedback2; /**< set if GL_NV_transform_feedback2 is supported */

#define GL_TRANSFORM_FEEDBACK_NV                                     0x8e22
#define GL_TRANSFORM_FEEDBACK_BUFFER_PAUSED_NV                       0x8e23
#define GL_TRANSFORM_FEEDBACK_BUFFER_ACTIVE_NV                       0x8e24
#define GL_TRANSFORM_FEEDBACK_BINDING_NV                             0x8e25

extern void (GLApi *GLFuncPtrName(glBindTransformFeedbackNV))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteTransformFeedbacksNV))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glGenTransformFeedbacksNV))(GLsizei, GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glIsTransformFeedbackNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glPauseTransformFeedbackNV))();
extern void (GLApi *GLFuncPtrName(glResumeTransformFeedbackNV))();
extern void (GLApi *GLFuncPtrName(glDrawTransformFeedbackNV))(GLenum, GLuint);

#define glBindTransformFeedbackNV GLFuncPtrName(glBindTransformFeedbackNV)
#define glDeleteTransformFeedbacksNV GLFuncPtrName(glDeleteTransformFeedbacksNV)
#define glGenTransformFeedbacksNV GLFuncPtrName(glGenTransformFeedbacksNV)
#define glIsTransformFeedbackNV GLFuncPtrName(glIsTransformFeedbackNV)
#define glPauseTransformFeedbackNV GLFuncPtrName(glPauseTransformFeedbackNV)
#define glResumeTransformFeedbackNV GLFuncPtrName(glResumeTransformFeedbackNV)
#define glDrawTransformFeedbackNV GLFuncPtrName(glDrawTransformFeedbackNV)

#endif // GL_NV_transform_feedback2

//								--- GL_NV_vertex_array_range ---

#ifndef GL_NV_vertex_array_range
#define GL_NV_vertex_array_range 1
#define __GENERATE_GL_NV_vertex_array_range

extern bool GLEH_NV_vertex_array_range; /**< set if GL_NV_vertex_array_range is supported */

#define GL_VERTEX_ARRAY_RANGE_NV                                     0x851d
#define GL_VERTEX_ARRAY_RANGE_LENGTH_NV                              0x851e
#define GL_VERTEX_ARRAY_RANGE_VALID_NV                               0x851f
#define GL_MAX_VERTEX_ARRAY_RANGE_ELEMENT_NV                         0x8520
#define GL_VERTEX_ARRAY_RANGE_POINTER_NV                             0x8521

extern void (GLApi *GLFuncPtrName(glVertexArrayRangeNV))(GLsizei, void*);
extern void (GLApi *GLFuncPtrName(glFlushVertexArrayRangeNV))();

#define glVertexArrayRangeNV GLFuncPtrName(glVertexArrayRangeNV)
#define glFlushVertexArrayRangeNV GLFuncPtrName(glFlushVertexArrayRangeNV)

#endif // GL_NV_vertex_array_range

//								--- GL_NV_vertex_array_range2 ---

#ifndef GL_NV_vertex_array_range2
#define GL_NV_vertex_array_range2 1

extern bool GLEH_NV_vertex_array_range2; /**< set if GL_NV_vertex_array_range2 is supported */

#define GL_VERTEX_ARRAY_RANGE_WITHOUT_FLUSH_NV                       0x8533

// no new procedures or functions

#endif // GL_NV_vertex_array_range2

//								--- GL_NV_vertex_buffer_unified_memory ---

#ifndef GL_NV_vertex_buffer_unified_memory
#define GL_NV_vertex_buffer_unified_memory 1
#define __GENERATE_GL_NV_vertex_buffer_unified_memory

extern bool GLEH_NV_vertex_buffer_unified_memory; /**< set if GL_NV_vertex_buffer_unified_memory is supported */

#define GL_VERTEX_ATTRIB_ARRAY_UNIFIED_NV                            0x8f1e
#define GL_ELEMENT_ARRAY_UNIFIED_NV                                  0x8f1f
#define GL_VERTEX_ATTRIB_ARRAY_ADDRESS_NV                            0x8f20
#define GL_TEXTURE_COORD_ARRAY_ADDRESS_NV                            0x8f25
#define GL_VERTEX_ARRAY_ADDRESS_NV                                   0x8f21
#define GL_NORMAL_ARRAY_ADDRESS_NV                                   0x8f22
#define GL_COLOR_ARRAY_ADDRESS_NV                                    0x8f23
#define GL_INDEX_ARRAY_ADDRESS_NV                                    0x8f24
#define GL_EDGE_FLAG_ARRAY_ADDRESS_NV                                0x8f26
#define GL_SECONDARY_COLOR_ARRAY_ADDRESS_NV                          0x8f27
#define GL_FOG_COORD_ARRAY_ADDRESS_NV                                0x8f28
#define GL_ELEMENT_ARRAY_ADDRESS_NV                                  0x8f29
#define GL_VERTEX_ATTRIB_ARRAY_LENGTH_NV                             0x8f2a
#define GL_TEXTURE_COORD_ARRAY_LENGTH_NV                             0x8f2f
#define GL_VERTEX_ARRAY_LENGTH_NV                                    0x8f2b
#define GL_NORMAL_ARRAY_LENGTH_NV                                    0x8f2c
#define GL_COLOR_ARRAY_LENGTH_NV                                     0x8f2d
#define GL_INDEX_ARRAY_LENGTH_NV                                     0x8f2e
#define GL_EDGE_FLAG_ARRAY_LENGTH_NV                                 0x8f30
#define GL_SECONDARY_COLOR_ARRAY_LENGTH_NV                           0x8f31
#define GL_FOG_COORD_ARRAY_LENGTH_NV                                 0x8f32
#define GL_ELEMENT_ARRAY_LENGTH_NV                                   0x8f33

extern void (GLApi *GLFuncPtrName(glBufferAddressRangeNV))(GLenum, GLuint, GLuint64EXT, GLsizeiptr);
extern void (GLApi *GLFuncPtrName(glVertexFormatNV))(int, GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glNormalFormatNV))(GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glColorFormatNV))(int, GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glIndexFormatNV))(GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glTexCoordFormatNV))(int, GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glEdgeFlagFormatNV))(GLsizei);
extern void (GLApi *GLFuncPtrName(glSecondaryColorFormatNV))(int, GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glFogCoordFormatNV))(GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glVertexAttribFormatNV))(GLuint, int, GLenum, GLboolean, GLsizei);
extern void (GLApi *GLFuncPtrName(glVertexAttribIFormatNV))(GLuint, int, GLenum, GLsizei);
extern void (GLApi *GLFuncPtrName(glGetIntegerui64i_vNV))(GLenum, GLuint, GLuint64EXT*);

#define glBufferAddressRangeNV GLFuncPtrName(glBufferAddressRangeNV)
#define glVertexFormatNV GLFuncPtrName(glVertexFormatNV)
#define glNormalFormatNV GLFuncPtrName(glNormalFormatNV)
#define glColorFormatNV GLFuncPtrName(glColorFormatNV)
#define glIndexFormatNV GLFuncPtrName(glIndexFormatNV)
#define glTexCoordFormatNV GLFuncPtrName(glTexCoordFormatNV)
#define glEdgeFlagFormatNV GLFuncPtrName(glEdgeFlagFormatNV)
#define glSecondaryColorFormatNV GLFuncPtrName(glSecondaryColorFormatNV)
#define glFogCoordFormatNV GLFuncPtrName(glFogCoordFormatNV)
#define glVertexAttribFormatNV GLFuncPtrName(glVertexAttribFormatNV)
#define glVertexAttribIFormatNV GLFuncPtrName(glVertexAttribIFormatNV)
#define glGetIntegerui64i_vNV GLFuncPtrName(glGetIntegerui64i_vNV)

#endif // GL_NV_vertex_buffer_unified_memory

//								--- GL_NV_vertex_program ---

#ifndef GL_NV_vertex_program
#define GL_NV_vertex_program 1
#define __GENERATE_GL_NV_vertex_program

extern bool GLEH_NV_vertex_program; /**< set if GL_NV_vertex_program is supported */

#define GL_VERTEX_PROGRAM_NV                                         0x8620
#define GL_VERTEX_PROGRAM_POINT_SIZE_NV                              0x8642
#define GL_VERTEX_PROGRAM_TWO_SIDE_NV                                0x8643
#define GL_VERTEX_STATE_PROGRAM_NV                                   0x8621
#define GL_ATTRIB_ARRAY_SIZE_NV                                      0x8623
#define GL_ATTRIB_ARRAY_STRIDE_NV                                    0x8624
#define GL_ATTRIB_ARRAY_TYPE_NV                                      0x8625
#define GL_CURRENT_ATTRIB_NV                                         0x8626
#define GL_PROGRAM_PARAMETER_NV                                      0x8644
#define GL_ATTRIB_ARRAY_POINTER_NV                                   0x8645
#define GL_PROGRAM_TARGET_NV                                         0x8646
#define GL_PROGRAM_LENGTH_NV                                         0x8627
#define GL_PROGRAM_RESIDENT_NV                                       0x8647
#define GL_PROGRAM_STRING_NV                                         0x8628
#define GL_TRACK_MATRIX_NV                                           0x8648
#define GL_TRACK_MATRIX_TRANSFORM_NV                                 0x8649
#define GL_MAX_TRACK_MATRIX_STACK_DEPTH_NV                           0x862e
#define GL_MAX_TRACK_MATRICES_NV                                     0x862f
#define GL_CURRENT_MATRIX_STACK_DEPTH_NV                             0x8640
#define GL_CURRENT_MATRIX_NV                                         0x8641
#define GL_VERTEX_PROGRAM_BINDING_NV                                 0x864a
#define GL_PROGRAM_ERROR_POSITION_NV                                 0x864b
#define GL_MODELVIEW_PROJECTION_NV                                   0x8629
#define GL_MATRIX0_NV                                                0x8630
#define GL_MATRIX1_NV                                                0x8631
#define GL_MATRIX2_NV                                                0x8632
#define GL_MATRIX3_NV                                                0x8633
#define GL_MATRIX4_NV                                                0x8634
#define GL_MATRIX5_NV                                                0x8635
#define GL_MATRIX6_NV                                                0x8636
#define GL_MATRIX7_NV                                                0x8637
#define GL_IDENTITY_NV                                               0x862a
#define GL_INVERSE_NV                                                0x862b
#define GL_TRANSPOSE_NV                                              0x862c
#define GL_INVERSE_TRANSPOSE_NV                                      0x862d
#define GL_VERTEX_ATTRIB_ARRAY0_NV                                   0x8650
#define GL_VERTEX_ATTRIB_ARRAY1_NV                                   0x8651
#define GL_VERTEX_ATTRIB_ARRAY2_NV                                   0x8652
#define GL_VERTEX_ATTRIB_ARRAY3_NV                                   0x8653
#define GL_VERTEX_ATTRIB_ARRAY4_NV                                   0x8654
#define GL_VERTEX_ATTRIB_ARRAY5_NV                                   0x8655
#define GL_VERTEX_ATTRIB_ARRAY6_NV                                   0x8656
#define GL_VERTEX_ATTRIB_ARRAY7_NV                                   0x8657
#define GL_VERTEX_ATTRIB_ARRAY8_NV                                   0x8658
#define GL_VERTEX_ATTRIB_ARRAY9_NV                                   0x8659
#define GL_VERTEX_ATTRIB_ARRAY10_NV                                  0x865a
#define GL_VERTEX_ATTRIB_ARRAY11_NV                                  0x865b
#define GL_VERTEX_ATTRIB_ARRAY12_NV                                  0x865c
#define GL_VERTEX_ATTRIB_ARRAY13_NV                                  0x865d
#define GL_VERTEX_ATTRIB_ARRAY14_NV                                  0x865e
#define GL_VERTEX_ATTRIB_ARRAY15_NV                                  0x865f
#define GL_MAP1_VERTEX_ATTRIB0_4_NV                                  0x8660
#define GL_MAP1_VERTEX_ATTRIB1_4_NV                                  0x8661
#define GL_MAP1_VERTEX_ATTRIB2_4_NV                                  0x8662
#define GL_MAP1_VERTEX_ATTRIB3_4_NV                                  0x8663
#define GL_MAP1_VERTEX_ATTRIB4_4_NV                                  0x8664
#define GL_MAP1_VERTEX_ATTRIB5_4_NV                                  0x8665
#define GL_MAP1_VERTEX_ATTRIB6_4_NV                                  0x8666
#define GL_MAP1_VERTEX_ATTRIB7_4_NV                                  0x8667
#define GL_MAP1_VERTEX_ATTRIB8_4_NV                                  0x8668
#define GL_MAP1_VERTEX_ATTRIB9_4_NV                                  0x8669
#define GL_MAP1_VERTEX_ATTRIB10_4_NV                                 0x866a
#define GL_MAP1_VERTEX_ATTRIB11_4_NV                                 0x866b
#define GL_MAP1_VERTEX_ATTRIB12_4_NV                                 0x866c
#define GL_MAP1_VERTEX_ATTRIB13_4_NV                                 0x866d
#define GL_MAP1_VERTEX_ATTRIB14_4_NV                                 0x866e
#define GL_MAP1_VERTEX_ATTRIB15_4_NV                                 0x866f
#define GL_MAP2_VERTEX_ATTRIB0_4_NV                                  0x8670
#define GL_MAP2_VERTEX_ATTRIB1_4_NV                                  0x8671
#define GL_MAP2_VERTEX_ATTRIB2_4_NV                                  0x8672
#define GL_MAP2_VERTEX_ATTRIB3_4_NV                                  0x8673
#define GL_MAP2_VERTEX_ATTRIB4_4_NV                                  0x8674
#define GL_MAP2_VERTEX_ATTRIB5_4_NV                                  0x8675
#define GL_MAP2_VERTEX_ATTRIB6_4_NV                                  0x8676
#define GL_MAP2_VERTEX_ATTRIB7_4_NV                                  0x8677
#define GL_MAP2_VERTEX_ATTRIB8_4_NV                                  0x8678
#define GL_MAP2_VERTEX_ATTRIB9_4_NV                                  0x8679
#define GL_MAP2_VERTEX_ATTRIB10_4_NV                                 0x867a
#define GL_MAP2_VERTEX_ATTRIB11_4_NV                                 0x867b
#define GL_MAP2_VERTEX_ATTRIB12_4_NV                                 0x867c
#define GL_MAP2_VERTEX_ATTRIB13_4_NV                                 0x867d
#define GL_MAP2_VERTEX_ATTRIB14_4_NV                                 0x867e
#define GL_MAP2_VERTEX_ATTRIB15_4_NV                                 0x867f

extern void (GLApi *GLFuncPtrName(glBindProgramNV))(GLenum, GLuint);
extern void (GLApi *GLFuncPtrName(glDeleteProgramsNV))(GLsizei, const GLuint*);
extern void (GLApi *GLFuncPtrName(glExecuteProgramNV))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glGenProgramsNV))(GLsizei, GLuint*);
extern GLboolean (GLApi *GLFuncPtrName(glAreProgramsResidentNV))(GLsizei, const GLuint*, GLboolean*);
extern void (GLApi *GLFuncPtrName(glRequestResidentProgramsNV))(GLsizei, GLuint*);
extern void (GLApi *GLFuncPtrName(glGetProgramParameterfvNV))(GLenum, GLuint, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetProgramParameterdvNV))(GLenum, GLuint, GLenum, double*);
extern void (GLApi *GLFuncPtrName(glGetProgramivNV))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetProgramStringNV))(GLuint, GLenum, GLubyte*);
extern void (GLApi *GLFuncPtrName(glGetTrackMatrixivNV))(GLenum, GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribdvNV))(GLuint, GLenum, double*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribfvNV))(GLuint, GLenum, float*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribivNV))(GLuint, GLenum, int*);
extern void (GLApi *GLFuncPtrName(glGetVertexAttribPointervNV))(GLuint, GLenum, void**);
extern GLboolean (GLApi *GLFuncPtrName(glIsProgramNV))(GLuint);
extern void (GLApi *GLFuncPtrName(glLoadProgramNV))(GLenum, GLuint, GLsizei, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glProgramParameter4fNV))(GLenum, GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glProgramParameter4dNV))(GLenum, GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glProgramParameter4dvNV))(GLenum, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramParameter4fvNV))(GLenum, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glProgramParameters4dvNV))(GLenum, GLuint, GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glProgramParameters4fvNV))(GLenum, GLuint, GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glTrackMatrixNV))(GLenum, GLuint, GLenum, GLenum);
extern void (GLApi *GLFuncPtrName(glVertexAttribPointerNV))(GLuint, int, GLenum, GLsizei, const void*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1sNV))(GLuint, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fNV))(GLuint, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dNV))(GLuint, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2sNV))(GLuint, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fNV))(GLuint, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dNV))(GLuint, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3sNV))(GLuint, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fNV))(GLuint, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dNV))(GLuint, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4sNV))(GLuint, short, short, short, short);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fNV))(GLuint, float, float, float, float);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dNV))(GLuint, double, double, double, double);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubNV))(GLuint, GLubyte, GLubyte, GLubyte, GLubyte);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1svNV))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1fvNV))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib1dvNV))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2svNV))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2fvNV))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib2dvNV))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3svNV))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3fvNV))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib3dvNV))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4svNV))(GLuint, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4fvNV))(GLuint, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4dvNV))(GLuint, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttrib4ubvNV))(GLuint, const GLubyte*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs1svNV))(GLuint, GLsizei, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs1fvNV))(GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs1dvNV))(GLuint, GLsizei, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs2svNV))(GLuint, GLsizei, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs2fvNV))(GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs2dvNV))(GLuint, GLsizei, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs3svNV))(GLuint, GLsizei, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs3fvNV))(GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs3dvNV))(GLuint, GLsizei, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs4svNV))(GLuint, GLsizei, const short*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs4fvNV))(GLuint, GLsizei, const float*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs4dvNV))(GLuint, GLsizei, const double*);
extern void (GLApi *GLFuncPtrName(glVertexAttribs4ubvNV))(GLuint, GLsizei, const GLubyte*);

#define glBindProgramNV GLFuncPtrName(glBindProgramNV)
#define glDeleteProgramsNV GLFuncPtrName(glDeleteProgramsNV)
#define glExecuteProgramNV GLFuncPtrName(glExecuteProgramNV)
#define glGenProgramsNV GLFuncPtrName(glGenProgramsNV)
#define glAreProgramsResidentNV GLFuncPtrName(glAreProgramsResidentNV)
#define glRequestResidentProgramsNV GLFuncPtrName(glRequestResidentProgramsNV)
#define glGetProgramParameterfvNV GLFuncPtrName(glGetProgramParameterfvNV)
#define glGetProgramParameterdvNV GLFuncPtrName(glGetProgramParameterdvNV)
#define glGetProgramivNV GLFuncPtrName(glGetProgramivNV)
#define glGetProgramStringNV GLFuncPtrName(glGetProgramStringNV)
#define glGetTrackMatrixivNV GLFuncPtrName(glGetTrackMatrixivNV)
#define glGetVertexAttribdvNV GLFuncPtrName(glGetVertexAttribdvNV)
#define glGetVertexAttribfvNV GLFuncPtrName(glGetVertexAttribfvNV)
#define glGetVertexAttribivNV GLFuncPtrName(glGetVertexAttribivNV)
#define glGetVertexAttribPointervNV GLFuncPtrName(glGetVertexAttribPointervNV)
#define glIsProgramNV GLFuncPtrName(glIsProgramNV)
#define glLoadProgramNV GLFuncPtrName(glLoadProgramNV)
#define glProgramParameter4fNV GLFuncPtrName(glProgramParameter4fNV)
#define glProgramParameter4dNV GLFuncPtrName(glProgramParameter4dNV)
#define glProgramParameter4dvNV GLFuncPtrName(glProgramParameter4dvNV)
#define glProgramParameter4fvNV GLFuncPtrName(glProgramParameter4fvNV)
#define glProgramParameters4dvNV GLFuncPtrName(glProgramParameters4dvNV)
#define glProgramParameters4fvNV GLFuncPtrName(glProgramParameters4fvNV)
#define glTrackMatrixNV GLFuncPtrName(glTrackMatrixNV)
#define glVertexAttribPointerNV GLFuncPtrName(glVertexAttribPointerNV)
#define glVertexAttrib1sNV GLFuncPtrName(glVertexAttrib1sNV)
#define glVertexAttrib1fNV GLFuncPtrName(glVertexAttrib1fNV)
#define glVertexAttrib1dNV GLFuncPtrName(glVertexAttrib1dNV)
#define glVertexAttrib2sNV GLFuncPtrName(glVertexAttrib2sNV)
#define glVertexAttrib2fNV GLFuncPtrName(glVertexAttrib2fNV)
#define glVertexAttrib2dNV GLFuncPtrName(glVertexAttrib2dNV)
#define glVertexAttrib3sNV GLFuncPtrName(glVertexAttrib3sNV)
#define glVertexAttrib3fNV GLFuncPtrName(glVertexAttrib3fNV)
#define glVertexAttrib3dNV GLFuncPtrName(glVertexAttrib3dNV)
#define glVertexAttrib4sNV GLFuncPtrName(glVertexAttrib4sNV)
#define glVertexAttrib4fNV GLFuncPtrName(glVertexAttrib4fNV)
#define glVertexAttrib4dNV GLFuncPtrName(glVertexAttrib4dNV)
#define glVertexAttrib4ubNV GLFuncPtrName(glVertexAttrib4ubNV)
#define glVertexAttrib1svNV GLFuncPtrName(glVertexAttrib1svNV)
#define glVertexAttrib1fvNV GLFuncPtrName(glVertexAttrib1fvNV)
#define glVertexAttrib1dvNV GLFuncPtrName(glVertexAttrib1dvNV)
#define glVertexAttrib2svNV GLFuncPtrName(glVertexAttrib2svNV)
#define glVertexAttrib2fvNV GLFuncPtrName(glVertexAttrib2fvNV)
#define glVertexAttrib2dvNV GLFuncPtrName(glVertexAttrib2dvNV)
#define glVertexAttrib3svNV GLFuncPtrName(glVertexAttrib3svNV)
#define glVertexAttrib3fvNV GLFuncPtrName(glVertexAttrib3fvNV)
#define glVertexAttrib3dvNV GLFuncPtrName(glVertexAttrib3dvNV)
#define glVertexAttrib4svNV GLFuncPtrName(glVertexAttrib4svNV)
#define glVertexAttrib4fvNV GLFuncPtrName(glVertexAttrib4fvNV)
#define glVertexAttrib4dvNV GLFuncPtrName(glVertexAttrib4dvNV)
#define glVertexAttrib4ubvNV GLFuncPtrName(glVertexAttrib4ubvNV)
#define glVertexAttribs1svNV GLFuncPtrName(glVertexAttribs1svNV)
#define glVertexAttribs1fvNV GLFuncPtrName(glVertexAttribs1fvNV)
#define glVertexAttribs1dvNV GLFuncPtrName(glVertexAttribs1dvNV)
#define glVertexAttribs2svNV GLFuncPtrName(glVertexAttribs2svNV)
#define glVertexAttribs2fvNV GLFuncPtrName(glVertexAttribs2fvNV)
#define glVertexAttribs2dvNV GLFuncPtrName(glVertexAttribs2dvNV)
#define glVertexAttribs3svNV GLFuncPtrName(glVertexAttribs3svNV)
#define glVertexAttribs3fvNV GLFuncPtrName(glVertexAttribs3fvNV)
#define glVertexAttribs3dvNV GLFuncPtrName(glVertexAttribs3dvNV)
#define glVertexAttribs4svNV GLFuncPtrName(glVertexAttribs4svNV)
#define glVertexAttribs4fvNV GLFuncPtrName(glVertexAttribs4fvNV)
#define glVertexAttribs4dvNV GLFuncPtrName(glVertexAttribs4dvNV)
#define glVertexAttribs4ubvNV GLFuncPtrName(glVertexAttribs4ubvNV)

#endif // GL_NV_vertex_program

//								--- GL_NV_vertex_program1_1 ---

#ifndef GL_NV_vertex_program1_1
#define GL_NV_vertex_program1_1 1

extern bool GLEH_NV_vertex_program1_1; /**< set if GL_NV_vertex_program1_1 is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_vertex_program1_1

//								--- GL_NV_vertex_program2 ---

#ifndef GL_NV_vertex_program2
#define GL_NV_vertex_program2 1

extern bool GLEH_NV_vertex_program2; /**< set if GL_NV_vertex_program2 is supported */

// no new tokens
// no new procedures or functions

#endif // GL_NV_vertex_program2

//								--- GL_NV_vertex_program2_option ---

#ifndef GL_NV_vertex_program2_option
#define GL_NV_vertex_program2_option 1

extern bool GLEH_NV_vertex_program2_option; /**< set if GL_NV_vertex_program2_option is supported */

#define GL_MAX_PROGRAM_EXEC_INSTRUCTIONS_NV                          0x88f4
#define GL_MAX_PROGRAM_CALL_DEPTH_NV                                 0x88f5

// no new procedures or functions

#endif // GL_NV_vertex_program2_option

//								--- GL_NV_vertex_program3 ---

#ifndef GL_NV_vertex_program3
#define GL_NV_vertex_program3 1

extern bool GLEH_NV_vertex_program3; /**< set if GL_NV_vertex_program3 is supported */

#define GL_MAX_VERTEX_TEXTURE_IMAGE_UNITS_ARB                        0x8b4c

// no new procedures or functions

#endif // GL_NV_vertex_program3

//								--- GL_SGIS_generate_mipmap ---

#ifndef GL_SGIS_generate_mipmap
#define GL_SGIS_generate_mipmap 1

extern bool GLEH_SGIS_generate_mipmap; /**< set if GL_SGIS_generate_mipmap is supported */

#define GL_GENERATE_MIPMAP_SGIS                                      0x8191
#define GL_GENERATE_MIPMAP_HINT_SGIS                                 0x8192

// no new procedures or functions

#endif // GL_SGIS_generate_mipmap

//								--- GL_SGIS_texture_lod ---

#ifndef GL_SGIS_texture_lod
#define GL_SGIS_texture_lod 1

extern bool GLEH_SGIS_texture_lod; /**< set if GL_SGIS_texture_lod is supported */

#define GL_TEXTURE_MIN_LOD_SGIS                                      0x813a
#define GL_TEXTURE_MAX_LOD_SGIS                                      0x813b
#define GL_TEXTURE_BASE_LEVEL_SGIS                                   0x813c
#define GL_TEXTURE_MAX_LEVEL_SGIS                                    0x813d

// no new procedures or functions

#endif // GL_SGIS_texture_lod

//								--- GL_SGIX_depth_texture ---

#ifndef GL_SGIX_depth_texture
#define GL_SGIX_depth_texture 1

extern bool GLEH_SGIX_depth_texture; /**< set if GL_SGIX_depth_texture is supported */

#define GL_DEPTH_COMPONENT16_SGIX                                    0x81a5
#define GL_DEPTH_COMPONENT24_SGIX                                    0x81a6
#define GL_DEPTH_COMPONENT32_SGIX                                    0x81a7

// no new procedures or functions

#endif // GL_SGIX_depth_texture

//								--- GL_SGIX_shadow ---

#ifndef GL_SGIX_shadow
#define GL_SGIX_shadow 1

extern bool GLEH_SGIX_shadow; /**< set if GL_SGIX_shadow is supported */

// no new tokens
// no new procedures or functions

#endif // GL_SGIX_shadow

//								--- GL_SUN_slice_accum ---

#ifndef GL_SUN_slice_accum
#define GL_SUN_slice_accum 1

extern bool GLEH_SUN_slice_accum; /**< set if GL_SUN_slice_accum is supported */

#define GL_SLICE_ACCUM_SUN                                           0x85cc

// no new procedures or functions

#endif // GL_SUN_slice_accum

//								--- GL_ARB_vertex_blend ---

#ifndef GL_ARB_vertex_blend
#define GL_ARB_vertex_blend 1
#define __GENERATE_GL_ARB_vertex_blend

extern bool GLEH_ARB_vertex_blend; /**< set if GL_ARB_vertex_blend is supported */

#define GL_MAX_VERTEX_UNITS_ARB                                      0x86a4
#define GL_ACTIVE_VERTEX_UNITS_ARB                                   0x86a5
#define GL_WEIGHT_SUM_UNITY_ARB                                      0x86a6
#define GL_VERTEX_BLEND_ARB                                          0x86a7
#define GL_MODELVIEW0_ARB                                            0x1700
#define GL_MODELVIEW1_ARB                                            0x850a
#define GL_MODELVIEW2_ARB                                            0x8722
#define GL_MODELVIEW3_ARB                                            0x8723
#define GL_MODELVIEW4_ARB                                            0x8724
#define GL_MODELVIEW5_ARB                                            0x8725
#define GL_MODELVIEW6_ARB                                            0x8726
#define GL_MODELVIEW7_ARB                                            0x8727
#define GL_MODELVIEW8_ARB                                            0x8728
#define GL_MODELVIEW9_ARB                                            0x8729
#define GL_MODELVIEW10_ARB                                           0x872a
#define GL_MODELVIEW11_ARB                                           0x872b
#define GL_MODELVIEW12_ARB                                           0x872c
#define GL_MODELVIEW13_ARB                                           0x872d
#define GL_MODELVIEW14_ARB                                           0x872e
#define GL_MODELVIEW15_ARB                                           0x872f
#define GL_MODELVIEW16_ARB                                           0x8730
#define GL_MODELVIEW17_ARB                                           0x8731
#define GL_MODELVIEW18_ARB                                           0x8732
#define GL_MODELVIEW19_ARB                                           0x8733
#define GL_MODELVIEW20_ARB                                           0x8734
#define GL_MODELVIEW21_ARB                                           0x8735
#define GL_MODELVIEW22_ARB                                           0x8736
#define GL_MODELVIEW23_ARB                                           0x8737
#define GL_MODELVIEW24_ARB                                           0x8738
#define GL_MODELVIEW25_ARB                                           0x8739
#define GL_MODELVIEW26_ARB                                           0x873a
#define GL_MODELVIEW27_ARB                                           0x873b
#define GL_MODELVIEW28_ARB                                           0x873c
#define GL_MODELVIEW29_ARB                                           0x873d
#define GL_MODELVIEW30_ARB                                           0x873e
#define GL_MODELVIEW31_ARB                                           0x873f
#define GL_CURRENT_WEIGHT_ARB                                        0x86a8
#define GL_WEIGHT_ARRAY_TYPE_ARB                                     0x86a9
#define GL_WEIGHT_ARRAY_STRIDE_ARB                                   0x86aa
#define GL_WEIGHT_ARRAY_SIZE_ARB                                     0x86ab
#define GL_WEIGHT_ARRAY_POINTER_ARB                                  0x86ac
#define GL_WEIGHT_ARRAY_ARB                                          0x86ad

extern void (GLApi *GLFuncPtrName(glWeightbvARB))(int, GLbyte*);
extern void (GLApi *GLFuncPtrName(glWeightsvARB))(int, short*);
extern void (GLApi *GLFuncPtrName(glWeightivARB))(int, int*);
extern void (GLApi *GLFuncPtrName(glWeightfvARB))(int, float*);
extern void (GLApi *GLFuncPtrName(glWeightdvARB))(int, double*);
extern void (GLApi *GLFuncPtrName(glWeightubvARB))(int, GLubyte*);
extern void (GLApi *GLFuncPtrName(glWeightusvARB))(int, GLushort*);
extern void (GLApi *GLFuncPtrName(glWeightuivARB))(int, GLuint*);
extern void (GLApi *GLFuncPtrName(glWeightPointerARB))(int, GLenum, GLsizei, void*);
extern void (GLApi *GLFuncPtrName(glVertexBlendARB))(int);

#define glWeightbvARB GLFuncPtrName(glWeightbvARB)
#define glWeightsvARB GLFuncPtrName(glWeightsvARB)
#define glWeightivARB GLFuncPtrName(glWeightivARB)
#define glWeightfvARB GLFuncPtrName(glWeightfvARB)
#define glWeightdvARB GLFuncPtrName(glWeightdvARB)
#define glWeightubvARB GLFuncPtrName(glWeightubvARB)
#define glWeightusvARB GLFuncPtrName(glWeightusvARB)
#define glWeightuivARB GLFuncPtrName(glWeightuivARB)
#define glWeightPointerARB GLFuncPtrName(glWeightPointerARB)
#define glVertexBlendARB GLFuncPtrName(glVertexBlendARB)

#endif // GL_ARB_vertex_blend

//								--- GL_ARB_matrix_palette ---

#ifndef GL_ARB_matrix_palette
#define GL_ARB_matrix_palette 1
#define __GENERATE_GL_ARB_matrix_palette

extern bool GLEH_ARB_matrix_palette; /**< set if GL_ARB_matrix_palette is supported */

#define GL_MATRIX_PALETTE_ARB                                        0x8840
#define GL_MAX_MATRIX_PALETTE_STACK_DEPTH_ARB                        0x8841
#define GL_MAX_PALETTE_MATRICES_ARB                                  0x8842
#define GL_CURRENT_PALETTE_MATRIX_ARB                                0x8843
#define GL_MATRIX_INDEX_ARRAY_ARB                                    0x8844
#define GL_CURRENT_MATRIX_INDEX_ARB                                  0x8845
#define GL_MATRIX_INDEX_ARRAY_SIZE_ARB                               0x8846
#define GL_MATRIX_INDEX_ARRAY_TYPE_ARB                               0x8847
#define GL_MATRIX_INDEX_ARRAY_STRIDE_ARB                             0x8848
#define GL_MATRIX_INDEX_ARRAY_POINTER_ARB                            0x8849

extern void (GLApi *GLFuncPtrName(glCurrentPaletteMatrixARB))(int);
extern void (GLApi *GLFuncPtrName(glMatrixIndexubvARB))(int, GLubyte*);
extern void (GLApi *GLFuncPtrName(glMatrixIndexusvARB))(int, GLushort*);
extern void (GLApi *GLFuncPtrName(glMatrixIndexuivARB))(int, GLuint*);
extern void (GLApi *GLFuncPtrName(glMatrixIndexPointerARB))(int, GLenum, GLsizei, void*);

#define glCurrentPaletteMatrixARB GLFuncPtrName(glCurrentPaletteMatrixARB)
#define glMatrixIndexubvARB GLFuncPtrName(glMatrixIndexubvARB)
#define glMatrixIndexusvARB GLFuncPtrName(glMatrixIndexusvARB)
#define glMatrixIndexuivARB GLFuncPtrName(glMatrixIndexuivARB)
#define glMatrixIndexPointerARB GLFuncPtrName(glMatrixIndexPointerARB)

#endif // GL_ARB_matrix_palette

#include <GL/glext.h>

#endif // __OPENGL20_TOOL_INCLUDED
