/*
								+----------------------------------+
								|                                  |
								|      ***  Perlin noise  ***      |
								|                                  |
								|   Copyright  -tHE SWINe- 2007   |
								|                                  |
								|             Noise.h              |
								|                                  |
								+----------------------------------+
*/

#pragma once
#ifndef __PERLIN_NOISE_INCLUDED
#define __PERLIN_NOISE_INCLUDED

/**
 *	@file dev/Noise.h
 *	@date 2007
 *	@author -tHE SWINe-
 *	@brief Perlin noise
 *
 *	@date 2012-06-19
 *
 *	Moved multiple inclusion guard before file documentation comment.
 *
 *	@deprecated This file is deprecated in favor of gl3/GLNoise.h
 *
 */

/*
 *	class CPerlinNoise
 *		- very simple perlin noise implementation
 */
class CPerlinNoise {
protected:
	static const int m_p_perm_table[512];

public:
	/*
	 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z)
	 *		- returns noise function value at f_x, f_y, f_z
	 */
	static float f_Noise(float f_x, float f_y, float f_z);

	/*
	 *	static float CPerlinNoise::f_Noise(float f_x, float f_y, float f_z, float f_w)
	 *		- returns noise function value at f_x, f_y, f_z, f_w
	 */
	static float f_Noise(float f_x, float f_y, float f_z, float f_w);

protected:
	static float f_Fade(float f_t);
	static inline float f_Lerp(float f_t, float f_a, float f_b);
	static float f_Grad(int n_hash, float f_x, float f_y, float f_z);
	static float f_Grad(int n_hash, float f_x, float f_y, float f_z, float f_w);
};

#endif // __PERLIN_NOISE_INCLUDED
