/** @file errors.cpp
* zdrojovy soubor s implemenaci vypisu chybovych zprav a napovedy
* @author Radek Hranicky
*/

/*
LIS Noise Cleaner - Tento nastroj slouzi k filtraci sumu vytvoreneho programem LDP
Copyright (C) 2012 Radek Hranicky

Tento program je svobodny software: muzete jej sirit a upravovat podle ustanoveni Obecne verejne licence GNU (GNU General Public License),
vydavane Free Software Foundation a to bud podle 3. verze teto Licence, nebo (podle vaseho uvazeni) kterekoli pozdejsi verze.

Tento program je rozsirovan v nadeji, ze bude uzitecny, avas BEZ JAKEKOLIV ZARUKY. Neposkytuji se ani odvozene zaruky PRODEJNOSTI
anebo VHODNOSTI PRO URCITY UCEL. Dalsi podrobnosti hledejte v Obecne verejne licenci GNU.

Kopii Obecne verejne licence GNU jste meli obdrzet spolu s timto programem. Pokud se tak nestalo, najdete ji zde: <http://www.gnu.org/licenses/>.
*/

#include <iostream>

using namespace std;

const char *Error_msg[] =
{
  "",	// OK
  "Spatne zadane parametry!",
  "Nepodarilo se otevrit vstupni soubor!",
  "Nepodarilo se vytvorit vystupni soubor!"
};

/**
 * Vypise zpravu o chybe na chybovy vystup
 * @param errNum kod chyby
 */
void printError(int errNum) {
  cerr << Error_msg[errNum] << endl;
  return;
}

/**
 * Vypis napovedy
 */
void printHelp() {
  cout << "== LI Noise Cleaner ==" << endl;
  cout << "Tento nastroj slouzi pro redukci sumu zachyceneho LI" << endl;
  cout << "pouziti:" << endl;
  cout << "./ldp <vstupni pcap soubor> <vystupni pcap soubor>" << endl;
  return;
}
