//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/10/25                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Module description:
 * - Module loads a file from input channel
 * - Then, smooths it according to input arguments
 * - Result is written into output channel
 */

#ifndef _OM_SMOOTH_MESH_H_
#define _OM_SMOOTH_MESH_H_

#include <MDSTk/Module/mdsModule.h>

/**
 * Module smooths input model and writes it into output channel
 * There is 2 options of smoothing - Laplace and Jacobi Laplace smoothing
 */
class OMSmoothMesh : public mds::mod::CModule
{
	public:
		/**
		 * Smart pointer type
		 */
		MDS_SHAREDPTR(OMSmoothMesh);

		/**
		 * Constructor
		 * @param sDescription Description of the module
		 */
		OMSmoothMesh(const std::string& sDescription);

		/**
		 * Virtual destructor
		 */
		virtual ~OMSmoothMesh();

	protected:
		/**
		 * Virtual method called on startup
		 * @returns True if startup was successful
		 */
		virtual bool startup();

		/**
		 * Virtual method called by the processing thread
		 * @returns True if main loop continues
		 */
		virtual bool main();

		/**
		 * Called on console shutdown
		 */
		virtual void shutdown();

		/**
		 * Called on writing a usage statement
		 * @param Stream Output stream
		 */
		virtual void writeExtendedUsage(std::ostream& Stream);

		/**
		 * Continuity setting
		 */
		std::string m_continuity;

		/**
		 * Smooth (tangential or normal)
		 */
		std::string m_smooth;

		/**
		 * Smoothing method
		 */
		std::string m_method;

		/**
		 * Number of iterations
		 */
		int m_iterations;
		double m_alpha;
		double m_gauss;
};

/**
 * Smart pointer to console application
 */
typedef OMSmoothMesh::tSmartPtr    OMSmoothMeshPtr;

#endif // _OM_SMOOTH_MESH_H_