//==============================================================================
/*! \file
 * OpenMesh Toolkit for mesh analysis    \n
 * Copyright (c) 2010 by Rostislav Hulik     \n
 *
 * Author:  Rostislav Hulik, rosta.hulik@gmail.com  \n
 * Date:    2010/3/2                          \n
 *
 * This file is part of software developed for support of Rostislav Hulik's dissertation thesis at dcgm-robotics@FIT group.
 *
 * This file is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 * 
 * This file is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public License
 * along with this file.  If not, see <http://www.gnu.org/licenses/>.
 * 
 * Description:
 * - Class representing AABB in R-tree structure
 */

#ifndef OM_BSP_TREE_AABB_H
#define OM_BSP_TREE_AABB_H

#include <OMToolkit\OMTypes.h>
#include <OMToolkit\OMTriBSPTreeRay.h>
#include <OMToolkit\OMTriBSPTreeTriangle.h>
#include <stdlib.h>


namespace OMToolkit
{
/**
	 * Tree element class
	 */
	class TreeElement
	{
		public:
			/**
			 * Constructor - initializes children to NULL
			 */
			TreeElement(int id);

			/**
			 * Mesh type
			 */
			typedef OMToolkit::Types::ModuleMeshd MeshT;

			/**
			 * Point type
			 */
			typedef MeshT::Point PointT;
			int _id;
			/**
			 * Face handle type
			 */
			typedef MeshT::FaceHandle FaceHT;

			typedef MeshT::Scalar ScalarT;

#ifndef USE_MULTIPLE_IN_ONE
#else
			std::vector<FaceHT> faces;
#endif
			/**
			 * AABB (0 == min, 1 == max)
			 */
			PointT aabb[2];

			/**
			 * Division axis in BSP tree
			 */
			int axis;

			/**
			 * Left child
			 */
			TreeElement *left;

			/**
			 * Right child
			 */
			TreeElement *right;

			TriCenter triangle;

			/**
			 * Tests intersection between ray and aabb
			 * @param origin Ray origin - intersection is computed also in inverse direction
			 * @param vector Ray direction
			 * @param cube Tree element (aabb)
			 * @return True if aabb is hit
			 */
			bool intersects(OMRay &ray);
	};
}
#endif