-------------------------------------------------------
--! @file 
--! @brief Interrupt address dmx unit for the intMAN hardware
--! @details After it is enabled it activates the interrupt buffer identified by int_addr in order to perform further operation over it such as config update. 
--! @author Josef Strnadel, Brno University of Technology, Faculty of Information Technology
--! @email strnadel@fit.vutbr.cz
--! @date 2013-04-17
-------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
use work.intMAN_package.all;

--
--
--
--! Entity of the interrupt address dmx unit for the intMAN hardware (interface)          
--
entity ipri_update_dmx is
	port (
			sel           : in  std_logic;                           --! unit enable 
			int_addr      : in  STD_LOGIC_VECTOR(t_int_width_range); --! selected interrupt address
			ipri_load_sel : out STD_LOGIC_VECTOR(t_int_range)        --! address dmx output with no more than one interrupt selected  
	);
end entity ipri_update_dmx;

--
--
--
--! Architecture of the interrupt address dmx unit for the intMAN hardware (inner structure)     
--
architecture arch of ipri_update_dmx is
begin
  --! selection signal generation process
	process(sel, int_addr) is
	variable idx : integer; 
	variable j : STD_LOGIC_VECTOR(t_int_range); 
	begin
		idx := TO_INTEGER(UNSIGNED(int_addr));
    j := (OTHERS => '0');
		if (sel = '1') then
			if(idx <= INT_NMAX-1) then                               -- put '1' into the position determined by int_addr 
          j(idx) := '1';
			end if;
		end if;
    ipri_load_sel <= j;
	end process;
end architecture arch;
