-------------------------------------------------------
--! @file 
--! @brief Slack-condition check for the intMAN hardware
--! @author Josef Strnadel, Brno University of Technology, Faculty of Information Technology
--! @email strnadel@fit.vutbr.cz
--! @date 2013-04-17
-------------------------------------------------------

library IEEE;
use IEEE.STD_LOGIC_1164.ALL;
use IEEE.NUMERIC_STD.ALL;
-- use IEEE.STD_LOGIC_ARITH.ALL;
use work.intMAN_package.all;

--
--
--
--! Entity of the slack-condition check unit for the intMAN hardware (interface)          
--
entity c_slack is
	port(
		monpri   : in  STD_LOGIC_VECTOR(t_pri_width_range);   --! priority of the running task (being monitored) 
		monslack : in  STD_LOGIC;                             --! slack signal (being monitored)
		valid    : out STD_LOGIC                              --! priority-condition result
  );
end c_slack;

--
--
--
--! Architecture of the slack-condition check unit for the intMAN hardware (inner structure)     
--
architecture arch of c_slack is
begin
  --! Slack-condition check process being sensitive to the change of monitored priority and slack line 
	p_cslack : process(monpri, monslack)
	begin
		if((TO_INTEGER(UNSIGNED(monpri)) > PRI_HARD_LAST) or (monslack = '1')) then
			valid <= '1';
		else 
			valid <= '0';
		end if;
	end process;
end arch;
